package example1;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Random;
import org.apache.struts.util.MessageResources;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;



public final class WelcomeAction extends Action {
    private Random random = new Random();

    public Random getRandom() {
	return random;
    }

    public void setRandom(Random random) {
	this.random = random;
    }

    public ActionForward execute(
        ActionMapping mapping,
        ActionForm form,
        HttpServletRequest request,
        HttpServletResponse response)
        throws Exception {

        // Setup message array in case there are errors
        ArrayList messages = new ArrayList();

        // Confirm message resources loaded
        MessageResources resources = getResources(request);
        if (resources==null) {
            messages.add(Constants.ERROR_MESSAGES_NOT_LOADED);
        }

	if (random.nextInt(10) < 10)
	    messages.add(Constants.ERROR_RANDOM);

        // If there were errors, forward to our failure page
        if (messages.size()>0) {
            request.setAttribute(Constants.ERROR_KEY,messages);
            return mapping.findForward(Constants.FAILURE);
        }

        // Forward to our success page
        return mapping.findForward(Constants.SUCCESS);

    }
}
