package components;

import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.webapp.UIComponentTag;

import java.util.Map;

/* Tag Handler dla kombinacji MyImageComponent i MyImageRenderer */
public class MyImageTag extends UIComponentTag {

    private Integer height = null;
    private Integer width = null;
    private String imageName = null;
    private String onClick = null; 
 

    public void setHeight(Integer height) {
        this.height = height;
    }

    public void setWidth(Integer width) {   // string?
        this.width = width;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }


    public void setOnClick(String newOnClick) {
        onClick = newOnClick;
    }


    /* typy komponentu i renderera */
    public String getComponentType() {
        return ("components.MyImage");
    }


    public String getRendererType() {
        return ("components.MyImage");
    }


    public void release() {
        super.release();
        this.height = null;
        this.width = null;
        this.imageName = null;
        this.onClick = null;
    }


    /* ustawienie wlasnosci w komponencie */
    protected void setProperties(UIComponent component) {

        super.setProperties(component);
        MyImageComponent myImage = (MyImageComponent) component;

        if (height != null) 
          myImage.setHeight(height);

	if (width != null)
	  myImage.setWidth(width);

        if (imageName != null) 
          myImage.setImageName(imageName);

        if (onClick != null) {
	  Map attr = myImage.getAttributes();
	  attr.put("onClick", onClick);
	}

    }
}
