package components;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;

/* Renderer wyswietlajacy komponent typu MyImageComponent*/
public class MyImageRenderer extends Renderer {

   /* do wykorzystania jako czesci identyfikatorow komponentow */
   private static final String HEIGHT = ".height";
   private static final String WIDTH = ".width";
   private static final String MORE = ".more";
   private static final String LESS = ".less";

   /* o ile bedziemy zmiejszac/zwiekszac szerokosc badz wysokosc */
   private static final int INCR = 20;

   /* wspolrzedne wyswietlania JavaScriptowego okna */
   private static final int LEFT = 200;
   private static final int TOP = 200;

   /* Poczatek kodowania wyswietlania komponentu. Jako ze nie jest 
      przewidziane, by komponent mogl miec zagniezdzone podkomponenty,
      nie implementuje metody encodeChildren, jak rowniez encodeEnd -
      ponizsza metoda implementuje wiec calosc wyswietlania */
   public void encodeBegin(FacesContext context, UIComponent myImage) 
         throws IOException {

      ResponseWriter writer = context.getResponseWriter();
      String clientId = myImage.getClientId(context);

      writer.startElement("table", null);
      writer.startElement("tr", null);

      /* wyrysowanie obrazka */
      writer.startElement("td", null);
      encodeImage(myImage, writer, clientId);
      writer.endElement("td");

      /* i przeciskow do zmiany wysokosci i szerokosci */
      writer.startElement("td", null);
      encodeDecrementButton(myImage, writer, clientId + HEIGHT);
      writer.writeText("height", null);
      encodeIncrementButton(myImage, writer, clientId + HEIGHT);
      writer.endElement("td");
      writer.endElement("tr");

      writer.startElement("tr", null);
      writer.startElement("td", null);
      encodeDecrementButton(myImage, writer, clientId + WIDTH);
      writer.writeText("width", null); // "width"???
      encodeIncrementButton(myImage, writer, clientId + WIDTH);
      writer.endElement("td");
      writer.endElement("tr");
      writer.endElement("table");

   }


   /* reakcja na zadanie - odkodowanie zmian wysokosci i szerokosci
      i zapisanie ich w komponencie */
   public void decode(FacesContext context, UIComponent component) {

      MyImageComponent myImage = (MyImageComponent) component;
      Map requestMap = context.getExternalContext().getRequestParameterMap();
      String clientId = component.getClientId(context);

      int heightIncrement, widthIncrement;
      int minimum = MyImageComponent.MINIMUM;
      int maximum = MyImageComponent.MAXIMUM;

      /* czy byla zmiana wysokosci */
      if (requestMap.containsKey(clientId + HEIGHT + MORE)) 
	heightIncrement = INCR;
      else if (requestMap.containsKey(clientId + HEIGHT + LESS)) 
	heightIncrement = -INCR;
      else 
	heightIncrement = 0;

      int newHeight = myImage.getHeight().intValue() + heightIncrement;
      if (newHeight <= minimum || newHeight >= maximum)
	newHeight = myImage.getHeight().intValue();

      /* zapamietanie nowej wartosci w komponencie */
      myImage.setHeight(new Integer(newHeight));

      /* czy byla zmiana szerokosci */
      if (requestMap.containsKey(clientId + WIDTH + MORE)) 
	widthIncrement = INCR;
      else if (requestMap.containsKey(clientId + WIDTH + LESS)) 
	widthIncrement = -INCR;
      else 
	widthIncrement = 0;

      int newWidth = myImage.getWidth().intValue() + widthIncrement;
      if (newWidth <= minimum || newWidth >= maximum)
	newWidth = myImage.getWidth().intValue();

      myImage.setWidth(new Integer(newWidth));

   }
   

   /* pomocnicze do wyswietlania - wyswietlenie obrazka */
   private void encodeImage(UIComponent myImage, 
      ResponseWriter writer, String clientId) throws IOException {

      /* uzywamy html-owego znacznika img */
      writer.startElement("img", myImage);

      /* dajac mu jako atrybuty nazwe pliku... */
      String imageName = (String)myImage.getAttributes().get("imageName");
      if(imageName != null)
         writer.writeAttribute("src", imageName, "imageName");

      /* wysokosc, szerokosc */
      Integer height = (Integer) myImage.getAttributes().get("height");
      if (height != null)
         writer.writeAttribute("height", height, "height");

      Integer width = ((MyImageComponent)myImage).getWidth();
      if(width != null)
         writer.writeAttribute("width", width, "width");

      /* dodanie JavaScriptu: jesli podano obrazek do wyswietlenia 
         przy kliknieciu w obrazek "podstawowy", to wypisujemy tez 
         atrybut onclick: */
      String onClick = (String)myImage.getAttributes().get("onClick");
      if(onClick != null) {

        StringBuffer sb = null;
                                                                                
        sb = new StringBuffer();
        sb.append("window.open('");
        sb.append(onClick);  // plik z obrazkiem do wyswietlenia
        sb.append("', 'MyPopUp', 'width=");
        sb.append(MyImageComponent.MAXIMUM);
        sb.append(",height=");
        sb.append(MyImageComponent.MAXIMUM);
        sb.append(",toolbar=0,scrollbars=0,left=");
        sb.append(LEFT);
        sb.append(",top=");
        sb.append(TOP);
        sb.append("')");
        writer.writeAttribute("onclick", sb.toString(), null);
      }                                                                     

      writer.endElement("img"); // koniec html-owego znacznika img
   }


   /* pomocnicze dla wyswietlania: wyswietlenia przycisku do zmniejszania */
   private void encodeDecrementButton(UIComponent myImage, 
         ResponseWriter writer, String buttonId) throws IOException {
      writer.startElement("input", myImage);
      writer.writeAttribute("type", "submit", null);
      writer.writeAttribute("name", buttonId + LESS, null);
      writer.writeAttribute("value", "<<", "value");
      writer.endElement("input");
   }


   /* pomocnicze dla wyswietlania: wyswietlenia przycisku do zwiekszania */
   private void encodeIncrementButton(UIComponent myImage, 
         ResponseWriter writer, String buttonId) throws IOException {
      writer.startElement("input", myImage);
      writer.writeAttribute("type", "submit", null);
      writer.writeAttribute("name", buttonId + MORE, null);
      writer.writeAttribute("value", ">>", "value");
      writer.endElement("input");
   }

}
