package components;

import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;

import java.io.IOException;

/* komponent reprezetujacy obrazek o zmienialnych wymiarach */
public class MyImageComponent extends UIComponentBase {

    /* Minimalna i maksymalna wysokosc i szerokosc */
    public static final int MINIMUM = 20;
    public static final int MAXIMUM = 500;

    /* atrybuty obrazka: wysokosc, szerokosc i plik go zawierajacy */
    private Integer height = null;
    private Integer width = null;
    private String imageName = null;


    /* ustawianie i odczyt wlasnosci */

    public Integer getHeight() {
        return (this.height);
    }


    public void setHeight(Integer height) {
        this.height = height;
    }


    public Integer getWidth() {
        return (this.width);
    }


    public void setWidth(Integer width) {
        this.width = width;
    }


    public String getImageName() {
        return imageName;
    }


    public void setImageName(String imageName) {
        this.imageName = imageName;
    }


    /* do jakiej rodziny komponent nalezy - tu podajemy nowa wlasna */
    public String getFamily() {
        return ("MyImage");
    }


    /* zachowanie stanu */
    public Object saveState(FacesContext context) {
        Object values[] = new Object[4];
        values[0] = super.saveState(context);
        values[1] = height;
        values[2] = width;
        values[3] = imageName;
        return (values);
    }

    
    /* i odczyt atrybutow ze stanu */
    public void restoreState(FacesContext context, Object state) {
        Object values[] = (Object[]) state;
        super.restoreState(context, values[0]);
        height = (Integer)values[1];
        width = (Integer) values[2];
        imageName = (String) values[3];
    }

}
