package jsfapp;


import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class QuestionBean {
  private String answer;
  private int correct = 0;
  private int wrong = 0;
  
  public String getAnswer() { 
    return answer; 
  }
  public void setAnswer(String answer) {
    this.answer = answer;
  }

  public int getCorrect() {
    return correct;
  }
  public int getWrong() {
    return wrong;
  }

  public String checkAnswer() {
    String ca = getCorrectAnswer();
    if (answer.equals(ca)) {
      correct++;
      return JSFConst.FORWARD_CORRECT;
    } else {
      wrong++;
      return JSFConst.FORWARD_WRONG;
    }
    
  }

  private String getCorrectAnswer() {
    FacesContext context = FacesContext.getCurrentInstance();
    Application app = context.getApplication();
    String appBundle = app.getMessageBundle();
    Locale locale = getLocale(context);
    ClassLoader loader = getClassLoader();

    String resource = null;
    ResourceBundle bundle;

    bundle = ResourceBundle.getBundle("jsfapp.messages", locale, loader);
    if (bundle != null) {
      try {
        resource = bundle.getString("yesno_answer");
      } catch (MissingResourceException ex) {
	return "";
      }
    }
    if (resource == null) return "";
    return resource;	      
  }

  private Locale getLocale(FacesContext context) {
    Locale locale = null;
    UIViewRoot viewRoot = context.getViewRoot();
    if (viewRoot != null) locale = viewRoot.getLocale();
    if (locale == null) locale = Locale.getDefault();
    return locale;
  }

  private ClassLoader getClassLoader() {
    ClassLoader loader = Thread.currentThread().getContextClassLoader();
    if (loader == null) loader = ClassLoader.getSystemClassLoader();
    return loader;
  }


  
}
