<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>
<%@ taglib uri="http://java.sun.com/jstl/core" prefix="c" %>

<f:loadBundle basename="jsfapp.messages" var="msgs" />

<html>

<f:view>
<head>               
  <title><h:outputText value="#{msgs.title}" /></title>
</head>
<body>

<h:outputText value="#{msgs.logged}" />: <b><h:outputText value="#{user.login}"/></b>
<br><br>
<h:outputLink value="welcome.faces"><h:outputText value="#{msgs.reload}"/></h:outputLink><br>

<br><br>

<h:form>
<h:outputText value="#{msgs.yesno}"/>:&nbsp;<h:inputText value="#{question.answer}" required="true" id="yesno"/>&nbsp;
<h:commandButton value="#{msgs.check}" action="#{question.checkAnswer}"/>&nbsp;
<h:message for="yesno"/>
</h:form>

<br><br>
<h:outputText value="#{msgs.number_correct}" />: <b><h:outputText value="#{question.correct}"/></b><br>	
<h:outputText value="#{msgs.number_wrong}" />: <b><h:outputText value="#{question.wrong}"/></b>

<br><br>

<h:form>
<h:outputText value="#{msgs.enterdate}"/>:&nbsp;
<h:inputText id="date" value="#{date.curdate}">
  <f:convertDateTime pattern="yyyy-MM-dd"/>
</h:inputText>
&nbsp;
<h:commandButton value="#{msgs.check}" action="checkDate"/>&nbsp;
<h:message for="date" />
</h:form>


<br><br>

<h:form>
<h:commandButton value="#{msgs.lang_polish}" action="#{localeChanger.polishAction}"/>
<h:commandButton value="#{msgs.lang_english}" action="#{localeChanger.englishAction}"/>
</h:form>													     

<br>


<c:import url="footer.jsp"/>


</body>      
</f:view>

</html>
