
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>

#include "openglheader.h"

#include "utilities.h"
#include "meshes.h"
#include "meshespriv.h"

static GLuint progid = 0;
static GLuint nvbuf, nvbbp;
static GLint  uvofs[9];

/* ////////////////////////////////////////////////////////////////////////// */
void LoadMeshNormalVectorProgram ( void )
{
  const GLchar *filename[] =
    { "mnv.comp.glsl" };
  const GLchar *uvnames[] =
    { "MeshNV", "innsattr", "pdim", "inpofs", "inv", "inhe", "infac",
      "outnsattr", "outpofs", "outnvofs" };
  GLuint shader_id;
  GLint  size;

  shader_id = CompileShaderFiles ( GL_COMPUTE_SHADER, 1, &filename[0] );
  progid = LinkShaderProgram ( 1, &shader_id, "meshes normal" );
  GetAccessToUniformBlock ( progid, 9, uvnames, &size, uvofs, &nvbbp );
  glGenBuffers ( 1, &nvbuf );
  glBindBufferBase ( GL_UNIFORM_BUFFER, nvbbp, nvbuf );
  glBufferData ( GL_UNIFORM_BUFFER, size, NULL, GL_DYNAMIC_DRAW );
  glDeleteShader ( shader_id );
  ExitIfGLError ( "LoadMeshNormalVectorProgram" );
} /*LoadMeshNormalVectorProgram*/

void DeleteMeshNormalVectorProgram ( void )
{
  glUseProgram ( 0 );
  glDeleteProgram ( progid );
  glDeleteBuffers ( 1, &nvbuf );
  ExitIfGLError ( "DeleteMeshNormalVectorProgram" );
} /*DeleteMeshNormalVectorProgram*/

/* ////////////////////////////////////////////////////////////////////////// */
void ComputeMeshNormalVectors ( GPUmesh *mesh, int nsattr, GLint nvofs )
{
  GLuint vcbuf;

  glBindBufferBase ( SSB, 0, mesh->MVFBUF );
  glBindBufferBase ( SSB, 1, mesh->MHEBUF );
  glBindBufferBase ( SSB, 2, mesh->VCBUF );
  glGenBuffers ( 1, &vcbuf );
  glBindBufferBase ( SSB, 3, vcbuf );
  glBufferData ( SSB, mesh->nv*nsattr*sizeof(GLfloat), NULL, GL_DYNAMIC_DRAW );
  ExitIfGLError ( "ComputeMeshNormalVectors 0" );
  glUseProgram ( progid );
  glBindBufferBase ( GL_UNIFORM_BUFFER, nvbbp, nvbuf );
  SETUVAR ( 0, GLint, mesh->nsattr );
  SETUVAR ( 1, GLint, mesh->pdim );
  SETUVAR ( 2, GLint, mesh->pofs );
  SETUVAR ( 3, GLint, mesh->nv );
  SETUVAR ( 4, GLint, mesh->nhe );
  SETUVAR ( 5, GLint, mesh->nfac );
  SETUVAR ( 6, GLint, nsattr );
  SETUVAR ( 7, GLint, mesh->pofs );
  mesh->nvofs = nvofs;  SETUVAR ( 8, GLint, nvofs );
  glDispatchCompute ( mesh->nv, 1, 1 );
  glMemoryBarrier ( GL_SHADER_STORAGE_BARRIER_BIT );
  ExitIfGLError ( "ComputeMeshNormalVectors 1" );
  glDeleteBuffers ( 1, &mesh->VCBUF );
  mesh->VCBUF = vcbuf;
  mesh->nsattr = nsattr;
  UploadMeshParams ( mesh );
  ExitIfGLError ( "ComputeMeshNormalVectors" );
} /*ComputeMeshNormalVectors*/

