#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include "../utilities/openglheader.h"

#include "../utilities/utilities.h"
#include "../utilities/initwglctx.h"
#include "myheader.h"

#define MAJOR 4
#define MINOR 6

char redraw;

void MyResizeFunc ( HWND window, int width, int height )
{
 /*  printf ( "width = %d, height = %d\n", width, height );*/
  glViewport(0,0,width,height);
  redraw = 1;
} /*MyResizeFunc*/

void MyMouseFunc ( HWND window, UINT msg, int x, int y )
{
/*  printf ( "button: msg = %d, x = %d, y = %d\n", msg, x, y );*/
} /*MyMouseFunc*/

void MyScrollFunc ( HWND window, int ticks )
{
  printf ( "scroll: %d\n", ticks );
} /*MyScrollFunc*/

void MyMotionFunc ( HWND window, int x, int y )
{
/*  printf ( "motion: x = %d, y = %d\n", x, y );*/
} /*MyMotionFunc*/

void MyKeyboardFunc ( HWND window, int msg, int wParam, int lParam )
{
/*  printf ( "key: msg = %d, wParam = %d, lParam = %d\n", msg, wParam, lParam );*/
} /*MyKeyboardFunc*/

void MyCharFunc ( HWND window, int charcode )
{
/*  printf ( "char: %d (%c)\n", charcode, charcode );*/
  if ( charcode == 27 )
    PostQuitMessage ( 0 );
} /*MyCharFunc*/

static LRESULT CALLBACK window_callback ( HWND window, UINT msg, WPARAM wParam, LPARAM lParam )
{
  LRESULT result = 0;

  /*printf ( "msg = %d, wParam = %d, lParam = %lld\n", msg, (int)wParam, lParam ); */
  switch ( msg ) {
  case WM_CLOSE:
  case WM_DESTROY:
      PostQuitMessage ( 0 );
      break;
  case WM_PAINT:
      result = DefWindowProcA ( window, msg, wParam, lParam );
      redraw = true;
      break;
  case WM_SIZE:
      if ( wParam != SIZE_MINIMIZED )
        MyResizeFunc ( window, LOWORD(lParam), HIWORD(lParam) );
      break;
  case WM_MOUSEMOVE:
      MyMotionFunc ( window, LOWORD(lParam), HIWORD(lParam) );
      break;
  case WM_LBUTTONDOWN:
  case WM_MBUTTONDOWN:
  case WM_RBUTTONDOWN:
  case WM_LBUTTONUP:
  case WM_MBUTTONUP:
  case WM_RBUTTONUP:
      MyMouseFunc ( window, msg, LOWORD(lParam), HIWORD(lParam) );
      break;
  case WM_MOUSEWHEEL:
      MyScrollFunc ( window, HIWORD(wParam) );
      break;
  case WM_CHAR:
      MyCharFunc ( window, (int)wParam );
      break;
  case WM_KEYFIRST:
      MyKeyboardFunc ( window, msg, (int)wParam, (int)lParam );
      break;
  default:
      result = DefWindowProcA ( window, msg, wParam, lParam );
      break;
  }
  return result;
} /*window_callback*/

static HWND create_window ( HINSTANCE inst, int width, int height )
{
  WNDCLASSA wclass;
  RECT      rect;
  DWORD     wstyle;
  HWND      window;

  memset ( &wclass, 0, sizeof(WNDCLASSA) );
  wclass.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
  wclass.lpfnWndProc = window_callback;
  wclass.hInstance = inst;
  wclass.hCursor = LoadCursor ( 0, IDC_ARROW );
  wclass.hbrBackground = 0;
  wclass.lpszClassName = "WGL_window";

  if ( !RegisterClassA ( &wclass) )
    ExitOnError ( "Failed to register window." );
  memset(&rect, 0, sizeof(RECT));
  rect.right = width;
  rect.bottom = height;
  wstyle = WS_OVERLAPPEDWINDOW;
  AdjustWindowRect ( &rect, wstyle, 0 );
  window = CreateWindowExA ( 0, wclass.lpszClassName, "OpenGL", wstyle,
      CW_USEDEFAULT, CW_USEDEFAULT, rect.right - rect.left, rect.bottom - rect.top,
      0, 0, inst, 0 );
  if ( !window )
    ExitOnError ( "Failed to create window." );
  return window;
} /*create_window*/

HWND  window;
HDC   gldc;
HGLRC glcontext;

void Initialise ( HINSTANCE inst, int show, int argc, char *argv[] )
{
  InitWGLExtensions ( MAJOR, MINOR );
  window = create_window ( inst, 480, 360 );
  gldc = GetDC ( window );
  glcontext = InitWGLContext ( gldc, MAJOR, MINOR, 0, NULL );
  ShowWindow ( window, show );
  InitMyWorld ( argc, argv, 480, 360 );
  UpdateWindow ( window );
} /*Initialise*/

void (*IdleFunc)(void) = NULL;

void MessageLoop ( void )
{
  char terminate;
  MSG  msg;

  redraw = 1;
  for ( terminate = 0; !terminate; ) {
    if ( !IdleFunc )
      WaitMessage ();
    while ( PeekMessageA ( &msg, 0, 0, 0, PM_REMOVE ) ) {
      if ( msg.message == WM_QUIT )
        terminate = 1; 
      else {
        TranslateMessage ( &msg );
        DispatchMessage ( &msg );
      }
    }
    if ( IdleFunc )
      IdleFunc();
    if ( redraw ) {
      RedrawMyWorld ();
      SwapBuffers ( gldc );
      redraw = false;
    }
  }
} /*MessageLoop*/

void Cleanup ( void )
{
  DeleteMyWorld ();
  wglMakeCurrent ( gldc, 0 );
  wglDeleteContext ( glcontext );
  DestroyWindow ( window );
} /*Cleanup*/

int main ( int argc, char* argv[] )
{
  Initialise ( GetModuleHandle ( 0 ), 1, argc, argv );
  MessageLoop ();
  Cleanup ();
  exit ( 0 );
} /*main*/
