#include <stdlib.h>
#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "../utilities/openglheader.h"
#include <GL/glx.h>

#include "../utilities/utilities.h"
#include "../utilities/initglxctx.h"
#include "myheader.h"

Window      xmywin;
GLXContext  glxcontext;
XEvent      xevent;
char        terminate;

void InitMyGLXWindow ( int argc, char **argv,
                       int major, int minor, int width, int height )
{
  XSetWindowAttributes swa;
  Colormap             xcolormap;
  XVisualInfo          *xvii;

  InitGLXContext ( major, minor, 0, NULL, &xvii, &glxcontext );
  if ( !(xcolormap = XCreateColormap ( xdisplay, xrootwin,  
                                       xvii->visual, AllocNone )) )  
    ExitOnError ( "InitMyGLXWindow 0" );
  swa.colormap = xcolormap;
  swa.event_mask = ExposureMask | StructureNotifyMask| ButtonPressMask |
                   ButtonReleaseMask | PointerMotionMask | KeyPressMask ;
  xmywin = XCreateWindow ( xdisplay, xrootwin, 0, 0, width, height,
                           0, xvii->depth, InputOutput, xvii->visual,
                           CWColormap | CWEventMask, &swa );
  XFreeColormap ( xdisplay, xcolormap );
  XFree ( xvii );
  XSetWMProtocols ( xdisplay, xmywin, &DeleteWindow, 1 );
  XMapWindow ( xdisplay, xmywin );
  if ( !glXMakeCurrent ( xdisplay, xmywin, glxcontext ) )
    ExitOnError ( "InitMyGLXWindow 1" );
  GetGLProcAddresses ( major, minor );
} /*InitMyGLXWindow*/

void DeleteMyGLXWindow ( void )
{
  XDestroyWindow ( xdisplay, xmywin );
  glXDestroyContext ( xdisplay, glxcontext );
} /*DeleteMyGLXWindow*/

void Initialise ( int argc, char **argv )
{
  InitXServerConnection ( argc, argv, false );
  InitMyGLXWindow ( argc, argv, 4, 2, 480, 360 );
  InitMyWorld ( argc, argv, 480, 360 );
} /*Initialise*/

void MyWinExpose ( void )
{
  RedrawMyWorld ();
  glXSwapBuffers ( xdisplay, xmywin );
} /*MyWinExpose*/

void MyWinConfigureNotify ( int width, int height )
{
  ResizeMyWorld ( width, height );
  PostExposeEvent ( xmywin, width, height );
} /*MyWinConfigureNotify*/

void MyWinButtonPress ( int button, int x, int y )
{
} /*MyWinButtonPress*/

void MyWinButtonRelease ( int button, int x, int y )
{
} /*MyWinButtonRelease*/

void MyWinMotionNotify ( int x, int y )
{
} /*MyWinMotionNotify*/

void MyWinKeyPress ( unsigned int state, unsigned int key )
{
} /*MyWinKeyPress*/

void MyWinChar ( char charcode )
{
  switch ( charcode ) {
case 0x1B:  /* <Esc> */
    terminate = true;
    break;
default:
    break;
  }
} /*MyWinChar*/

void MyWinClientMessage ( XClientMessageEvent *xclient )
{
  if ( xclient->message_type == WMProtocols &&
       (Atom)xclient->data.l[0] == DeleteWindow ) {
    terminate = true;
    return;
  }
} /*MyWinClientMessage*/

void MyWinMessageProc ( void )
{
  char   charcode;
  KeySym ks;

  switch ( xevent.xany.type ) {
case Expose:
    if ( xevent.xexpose.count == 0 )
      MyWinExpose ();
    break;
case ConfigureNotify:
    MyWinConfigureNotify ( xevent.xconfigure.width, xevent.xconfigure.height );
    break;
case ButtonPress:
    MyWinButtonPress ( xevent.xbutton.button,
                       xevent.xbutton.x, xevent.xbutton.y );
    break;
case ButtonRelease:
    MyWinButtonRelease ( xevent.xbutton.button,  
                         xevent.xbutton.x, xevent.xbutton.y );
    break;
case MotionNotify:
    MyWinMotionNotify ( xevent.xmotion.x, xevent.xmotion.y );
    break;
case KeyPress:
    MyWinKeyPress ( xevent.xkey.state, xevent.xkey.keycode );
    XLookupString ( &xevent.xkey, &charcode, 1, &ks, NULL );
    MyWinChar ( charcode );
    break;
case ClientMessage:
    MyWinClientMessage ( &xevent.xclient );
    break;
default:
    break;
  }
} /*MyWinMessageProc*/

void MessageLoop ( void )
{
  terminate = 0;
  do {
    XNextEvent ( xdisplay, &xevent );
    if ( xevent.xany.window == xmywin )
      MyWinMessageProc ();
  } while ( !terminate );
} /*MessageLoop*/

void Cleanup ( void )
{
  DeleteMyWorld ();
  DeleteMyGLXWindow ();
  XCloseDisplay ( xdisplay );
} /*Cleanup*/

int main ( int argc, char **argv )
{
  Initialise ( argc, argv );
  MessageLoop ();
  Cleanup ();
  exit ( 0 );
} /*main*/
