
function ( AddGLLibs targetName )
  target_link_libraries ( ${targetName} PUBLIC ${CMAKE_DL_LIBS} )

  find_library ( MATH_LIBRARY m )
  if ( MATH_LIBRARY )
    target_link_libraries ( ${targetName} PUBLIC ${MATH_LIBRARY} )
  endif ()

  if ( WIN32 )
    find_library ( WINMM_LIBRARY winmm REQUIRED )
    target_link_libraries ( ${targetName} PUBLIC ${WINMM_LIBRARY} )
  endif ()

  # See https://cmake.org/cmake/help/latest/module/FindTIFF.html
  find_library ( TIFF_LIBRARY tiff )
  if ( TIFF_LIBRARY )
    target_link_libraries ( ${targetName} PUBLIC ${TIFF_LIBRARY} )
  else ()
    find_package ( TIFF REQUIRED )
    if ( TARGET TIFF::TIFF )
      target_link_libraries ( ${targetName} PUBLIC TIFF::TIFF )
    else ()  # For CMake <= 3.4
      target_link_libraries ( ${targetName} PUBLIC ${TIFF_LIBRARIES} )
      target_link_libraries ( ${targetName} PUBLIC ${TIFF_INCLUDE_DIR} )
    endif()
  endif ()
endfunction ()


function ( AddGLUTLibs targetName )
  AddGLLibs ( ${targetName} )

  # See https://cmake.org/cmake/help/latest/module/FindGLUT.html
  # Works with CMake >= 3.1.
  find_package ( GLUT REQUIRED )
  target_link_libraries ( ${targetName} PUBLIC GLUT::GLUT )
endfunction ()


function ( AddGLFWLibs targetName )
  AddGLLibs ( ${targetName} )

  # See https://www.glfw.org/docs/latest/build_guide.html#build_link_cmake_package
  # On many older systems, the glfw3Config.cmake is mistakenly installed in a 'glfw' directory,
  # so we add some additional paths to look for it.
  find_package ( glfw3 3 PATHS "/usr/lib64/cmake/glfw/" "/usr/lib/cmake/glfw/" REQUIRED )
  if ( TARGET glfw )
    target_link_libraries ( ${targetName} PUBLIC glfw )
  else ()
    target_link_libraries( ${targetName} PUBLIC ${GLFW3_LIBRARY})
    target_include_directories( ${targetName} PUBLIC ${GLFW3_INCLUDE_DIR} )
  endif ()
endfunction ()


function ( AddGLXWLibs targetName )
  AddGLLibs ( ${targetName} )

  # See: https://cmake.org/cmake/help/latest/module/FindOpenGL.html
  # In particular for EGL you might need to change this.
  set ( OpenGL_GL_PREFERENCE "GLVND" )
  find_package ( OpenGL REQUIRED )
  if ( TARGET OpenGL::GL )
    target_link_libraries ( ${targetName} PUBLIC OpenGL::GL )
  else ()  # For CMake <= 3.7.
    target_link_libraries ( ${targetName} PUBLIC ${OPENGL_LIBRARIES} )
    target_include_directories( ${targetName} PUBLIC ${OPENGL_INCLUDE_DIR} )
  endif ()

  if ( UNIX )
    # See: https://cmake.org/cmake/help/latest/module/FindX11.html
    find_package ( X11 )
    if ( TARGET X11::X11 )
      target_link_libraries ( ${targetName} PUBLIC X11::X11 )
    elseif ( X11_FOUND )  # For CMake <= 3.13.
      target_link_libraries ( ${targetName} PUBLIC ${X11_LIBRARIES} )
      target_include_directories ( ${targetName} PUBLIC ${X11_INCLUDE_DIR} )
    else ()
      message ( WARNING "Library package X11 not found." )
    endif ()
  endif ()
endfunction ()


function ( SetOutputDir targetName )
#  if ( UNIX )
    set ( BUILD_DIR ${CMAKE_CURRENT_SOURCE_DIR} )
#  endif ()
#  if ( WIN32 )
#    set ( BUILD_DIR ${CMAKE_CURRENT_SOURCE_DIR}/x64/Debug )
#    set ( SHADER_DIR ${BUILD_DIR} )
#    file ( GLOB SHADER_SOURCES "${CMAKE_CURRENT_SOURCE_DIR}/*.glsl" ) 
#    file ( COPY ${SHADER_SOURCES} DESTINATION ${SHADER_DIR} )
#  endif ()
  set_target_properties ( ${targetName} PROPERTIES
      RUNTIME_OUTPUT_DIRECTORY ${BUILD_DIR}
      RUNTIME_OUTPUT_DIRECTORY_RELEASE ${BUILD_DIR}
      RUNTIME_OUTPUT_DIRECTORY_DEBUG ${BUILD_DIR} )
endfunction ()

