#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <tiffio.h>
#include "../utilities/openglheader.h"

#include "../utilities/utilities.h"
#include "../utilities/bezpatches.h"
#include "trans.h"
#include "lights.h"
#include "balance.h"
#include "texture.h"

GLuint CreateMyTexture ( int wh )
{
  GLuint tex;
  int    w, l;

  glGenTextures ( 1, &tex );
  glBindTexture ( GL_TEXTURE_2D, tex );
  for ( w = wh, l = 1;  w > 2/*!(w & 0x01)*/;  l++ )
    w >>= 1;
  glTexStorage2D ( GL_TEXTURE_2D, l, GL_RGB8, wh, wh );
  glTexParameteri ( GL_TEXTURE_2D, GL_TEXTURE_MAX_LEVEL, l );
  glBindTexture ( GL_TEXTURE_2D, 0 );
  ExitIfGLError ( "CreateMyTexture" );
  return tex;
} /*CreateMyTexture*/

GLubyte *ReadTiffImage ( const char *fn, int *width, int *height )
{
  TIFF    *tif;
  int     w, h, npix;
  GLubyte *image;

  image = NULL;
  if ( fn[0] ) {
    printf ( "%s\n", fn );
    tif = TIFFOpen ( fn, "r" );
    if ( tif ) {
      TIFFGetField ( tif, TIFFTAG_IMAGEWIDTH, &w );
      TIFFGetField ( tif, TIFFTAG_IMAGELENGTH, &h );
      npix = w*h;
      image = malloc ( 4*npix );
      if ( !image )
        goto failure;
      memset ( image, 0, npix*sizeof(uint32_t) );
      if ( !TIFFReadRGBAImage ( tif, w, h, (uint32_t*)image, 0 ) )
        goto failure;
      TIFFClose ( tif );
      *width = w;
      *height = h;
      return image;
    }
    else
      return NULL;

failure:
    if ( image )
      free ( image );
    TIFFClose ( tif );
    return NULL;
  }
  else
    return NULL;
} /*ReadTiffImage*/

char LoadMyTextureImage ( GLuint tex, int txwidth, int txheight,
                          int x, int y, const char *filename )
{
  int     w, h;
  GLubyte *image;

  if ( !(image = ReadTiffImage ( filename, &w, &h )) )
    return false;
  if ( x+w <= txwidth && y+w <= txheight ) {
    glBindTexture ( GL_TEXTURE_2D, tex );
    glTexSubImage2D ( GL_TEXTURE_2D, 0, x, y, w, h, GL_RGBA, GL_UNSIGNED_BYTE,
                      image );
    free ( image );
    glBindTexture ( GL_TEXTURE_2D, 0 );
    ExitIfGLError ( "LoadMyTextureImage" );
    return true;
  }
  else {
    free ( image );
    return false;
  }
} /*LoadMyTextureImage*/

char SetupMyTextureMipmaps ( GLuint tex )
{
  glGenerateTextureMipmap ( tex );
  glBindTexture ( GL_TEXTURE_2D, tex );
  glTexParameteri ( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
  glTexParameteri ( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR );
  glBindTexture ( GL_TEXTURE_2D, 0 );
  ExitIfGLError ( "SetupMyTextureMipmaps" );
  return true;
} /*SetupMyTextureMipmaps*/

