#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>

#include "../utilities/openglheader.h"
#include "../utilities/utilities.h"
#include "trans.h"
#include "lights.h"
#include "balance.h"
#include "myscene.h"
#include "table.h"

#define X0 (-0.7)
#define X1 (-0.62)
#define X2 (-0.54)
#define X3 0.54
#define X4 0.62
#define X5 0.7
#define Y0 (-0.4)
#define Y1 (-0.34)
#define Y2 (-0.28)
#define Y3 0.28
#define Y4 0.34
#define Y5 0.4
#define Z0 0.0
#define Z1 (TABLE_HEIGHT-0.12)
#define Z2 (TABLE_HEIGHT-0.03)
#define Z3 TABLE_HEIGHT

#define NVERT   44
#define NTRIANG 64

static GLfloat vertpos[NVERT][3] = {
  {X0,Y0,Z3},{X5,Y0,Z3},{X5,Y5,Z3},{X0,Y5,Z3},
  {X0,Y0,Z2},{X5,Y0,Z2},{X5,Y5,Z2},{X0,Y5,Z2},
  {X1,Y1,Z2},{X4,Y1,Z2},{X4,Y4,Z2},{X1,Y4,Z2},
  {X1,Y1,Z1},{X4,Y1,Z1},{X4,Y4,Z1},{X1,Y4,Z1},
  /* 16 */
  {X1,Y2,Z1},{X2,Y2,Z1},{X2,Y1,Z1},{X4,Y2,Z1},{X3,Y2,Z1},{X3,Y1,Z1},
  {X1,Y3,Z1},{X2,Y3,Z1},{X2,Y4,Z1},{X4,Y3,Z1},{X3,Y3,Z1},{X3,Y4,Z1},
  /* 28 */
  {X1,Y2,Z0},{X2,Y2,Z0},{X2,Y1,Z0},{X4,Y2,Z0},{X3,Y2,Z0},{X3,Y1,Z0},
  {X1,Y3,Z0},{X2,Y3,Z0},{X2,Y4,Z0},{X4,Y3,Z0},{X3,Y3,Z0},{X3,Y4,Z0},
  /* 40 */
  {X1,Y1,Z0},{X4,Y1,Z0},{X4,Y4,Z0},{X1,Y4,Z0}};
static GLubyte tindex[3*NTRIANG] = {
  0,2,3,  0,1,2,  8,5,4,  8,9,5,  4,1,0,  4,5,1,  3,6,7,  3,2,6,
  7,10,11,  7,6,10,  8,7,11,  8,4,7,  4,3,7,  4,0,3,
  1,6,2,  1,5,6,  5,10,6,  5,9,10,  12,9,8,  12,13,9,
  11,14,15,  11,10,14,  12,11,15,  12,8,11,  9,14,10,  9,13,14,
  22,17,16,  22,23,17,  24,21,18,  24,27,21,  26,19,20,  26,25,19,  /* blat */
  /* 26 */
  40,18,12,  40,30,18,  30,17,18,  30,29,17,
  29,16,17,  29,28,16,  28,12,16,  28,40,12,
  41,19,13,  41,31,19,  31,20,19,  31,32,20,
  32,21,20,  32,33,21,  33,13,21,  33,41,13,
  42,27,14,  42,39,27,  39,26,27,  39,38,26,
  38,25,26,  38,37,25,  37,14,25,  37,42,14,
  43,22,15,  43,34,22,  34,23,22,  34,35,23,
  35,24,23,  35,36,24,  36,15,24,  36,43,15  /*nogi*/
  };

static const GLfloat diffr[4] = { 0.68, 0.52, 0.28, 1.0 };
static const GLfloat specr[4] = { 0.2, 0.2, 0.2, 1.0 };

void EnterTable ( BalanceElements *belem, SceneObject *obj, MatBl *matbl )
{
  strcpy ( obj->name, "table" );
  obj->mat0 = SetupMaterial ( matbl, -1, diffr, specr,
                              10.0, 1.0, 1.0, GL_INVALID_INDEX );
  glGenVertexArrays ( 1, &obj->vao );
  glBindVertexArray ( obj->vao );
  glGenBuffers ( 2, obj->vbo );
  glBindBuffer ( GL_ARRAY_BUFFER, obj->vbo[0] );
  glBufferData ( GL_ARRAY_BUFFER, NVERT*3*sizeof(GLfloat),
                 vertpos, GL_STATIC_DRAW );
  glEnableVertexAttribArray ( 0 );
  glVertexAttribPointer ( 0, 3, GL_FLOAT, GL_FALSE,
                          3*sizeof(GLfloat),(GLvoid*)0 );
  glBindBuffer ( GL_ELEMENT_ARRAY_BUFFER, obj->vbo[1] );
  glBufferData ( GL_ELEMENT_ARRAY_BUFFER, NTRIANG*3*sizeof(GLubyte),
                 tindex, GL_STATIC_DRAW );
  glDisableVertexAttribArray ( 1 );
  glDisableVertexAttribArray ( 2 );
  glBindVertexArray ( 0 );
  obj->redraw = DrawTable;
  obj->destroy = DestroySceneObject;
  obj->active = true;
  obj->nvert = NVERT;  obj->ntr = NTRIANG;
  BeginEnteringObjTriangles ( belem, obj, 0, NVERT, NTRIANG, TABLE_ELD );
  EnterTriangles ( belem, GL_TRIANGLES, NVERT, vertpos, NULL,
                   3*NTRIANG, GL_UNSIGNED_BYTE, tindex, obj->mat0, false );
  EndEnteringObjTriangles ( belem );
  M4x4Translatef ( obj->mm, 0.0, 0.0, FLOOR_Z );
  ExitIfGLError ( "EnterTable" );
} /*EnterTable*/

void DrawTable ( GLuint prog_id, SceneObject *obj, TransBl *trans, MatBl *mat )
{
  LoadMMatrix ( trans, obj->mm );
  glUseProgram ( prog_id );
  glVertexAttrib2f ( 1, 0.0, 0.0 );
  ChooseMaterial ( mat, obj->mat0 );
  glBindVertexArray ( obj->vao );
  glDrawElements ( GL_TRIANGLES, NTRIANG*3, GL_UNSIGNED_BYTE, (GLvoid*)0 );
  glBindVertexArray ( 0 );
} /*DrawTable*/

