
/*#define SHADOW_MAP_SIZE 1024*/
/*#define SHADOW_MAP_SIZE 2048*/
#define SHADOW_MAP_SIZE 4096

#define NLSUOFFS      13
#define NMATUOFFS     10
#define MAX_NLIGHTS    8
#define MAX_MATERIALS 20
#define MAX_TEXTURES   4

typedef struct LSPar {
          GLfloat ambient[4];
          GLfloat diffuse[4];
          GLfloat position[4];
          GLfloat attenuation[3];
          GLuint  shadow_fbo, shadow_txt;
          GLfloat shadow_view[16], shadow_proj[16];
        } LSPar;

typedef struct LightBl {
          GLuint  lsbuf;
          GLuint  nls, mask, slmask, shmask, cshmask;
          GLfloat max_depth;
          LSPar   ls[MAX_NLIGHTS];
        } LightBl;

typedef struct Material {
          GLfloat emission0[4], emission1[4];
          GLfloat diffref[4];
          GLfloat specref[4];
          GLfloat shininess, wa, we;
          GLuint  txtid, txtbp;
        } Material;

typedef struct MatBl {
          GLuint   matbuf;
          int      nmat, ntex;
          Material mat[MAX_MATERIALS];
        } MatBl;


GLuint GetAccessToLightBlockUniform ( GLuint program_id );
GLuint NewUniformLightBlock ( void );
void AttachUniformLightBlockToBP ( GLuint program_id );

void SetVPMatrix ( GLfloat vm[16], GLfloat pm[16], GLfloat ep[4] ); /* app2g.h */

void SetLightSurfBit ( LightBl *light, int l, char bit );
void SetLightAmbient ( LightBl *light, int l, GLfloat amb[4] );
void SetLightDiffuse ( LightBl *light, int l, GLfloat dif[4] );
void SetLightPosition ( LightBl *light, int l, GLfloat pos[4] );
void SetLightAttenuation ( LightBl *light, int l, GLfloat at3[3] );
void SetLightMaxDepth ( LightBl *light, GLfloat max_depth );
void SetLightOnOff ( LightBl *light, int l, char on );

void ConstructShadowTxtFBO ( LightBl *light, int l, char cubesh );
void UpdateShadowMatrix ( LightBl *light, int l );
void SetupShadowTxtTransformations ( LightBl *light, int l, float sc[3], float R );
void BindShadowTxtFBO ( LightBl *light, TransBl *trans,  int l );
void DestroyShadowFBO ( LightBl *light );


GLuint GetAccessToMatBlockUniform ( GLuint program_id );
GLuint NewUniformMatBlock ( void );
void AttachUniformMatBlockToBP ( GLuint program_id );
int SetupMaterial ( MatBl *matbl, int m,
                    const GLfloat diffr[4], const GLfloat specr[4],
                    GLfloat shn, GLfloat wa, GLfloat we,
                    GLuint textid );
void SetMaterialEmission ( MatBl *matbl, int m, const GLfloat em0[4],
                           const GLfloat em1[4] );
void BindMaterialTextures ( MatBl *matbl );
void ChooseMaterial ( MatBl *matbl, GLint m );
void DeleteMaterials ( MatBl *matbl );

