#version 440

layout(triangles) in;
layout(triangle_strip,max_vertices=3) out;

in GVertex {
  vec3 Position;
  vec3 Normal;
  vec2 TxtCoord;
} In[];

out FVertex {
  vec3      Position;
  vec2      TxtCoord;
  vec3      Normal;
  flat vec3 TNormal;
} Out;

const vec2 txtc[3] = {vec2(1.0,0.0),vec2(0.0,1.0),vec2(0.0,0.0)};

void main ( void )
{
  int i;
  vec3 v1, v2, nv;

  v1 = In[1].Position - In[0].Position;
  v2 = In[2].Position - In[0].Position;
  nv = normalize ( cross ( v1, v2 ) );
  for ( i = 0; i < 3; i++ ) {
    gl_Position = gl_in[i].gl_Position;
    Out.Position = In[i].Position;
    Out.TxtCoord = txtc[i];
    Out.Normal = In[i].Normal;
    Out.TNormal = nv;
    EmitVertex ();
  }
  EndPrimitive ();
} /*main*/
