
#version 450 core

#define MAX_NLIGHTS 8

layout(invocations=6,triangles) in;
layout(triangle_strip,max_vertices=3) out;

out float Depth;

uniform TransBlock {
    mat4 mm, mmti, vm, pm, vpm, vpmi;
    vec4 eyepos;
    vec4 viewport;
  } trb;

struct LSPar {
    vec4 ambient;
    vec4 direct;
    vec4 position;
    vec3 attenuation;
    mat4 shadow_vpm;
  };

uniform LSBlock {
    uint  nls;              /* liczba zrodel swiatla */
    uint  mask, slmask;     /* maska wlaczonych zrodel i maska zrodel powierzchniowych */
    uint  shmask, cshmask;
    float max_depth;
    int   lightn;
    LSPar ls[MAX_NLIGHTS];  /* poszczegolne zrodla swiatla */
  } light;

const mat4 cubtr[6] =
  {mat4( 0, 0,-1, 0,  0,-1, 0, 0, -1, 0, 0, 0,  0, 0, 0, 1),
   mat4( 0, 0, 1, 0,  0,-1, 0, 0,  1, 0, 0, 0,  0, 0, 0, 1),
   mat4( 1, 0, 0, 0,  0, 0,-1, 0,  0, 1, 0, 0,  0, 0, 0, 1),
   mat4( 1, 0, 0, 0,  0, 0, 1, 0,  0,-1, 0, 0,  0, 0, 0, 1),
   mat4( 1, 0, 0, 0,  0,-1, 0, 0,  0, 0,-1, 0,  0, 0, 0, 1),
   mat4(-1, 0, 0, 0,  0,-1, 0, 0,  0, 0, 1, 0,  0, 0, 0, 1)};

#define FCT 1.00001
void main ( void )
{
  int  i, k;
  vec3 lpos;
  vec4 p;

  gl_Layer = k = gl_InvocationID;
  lpos = light.ls[light.lightn].position.xyz;
  for ( i = 0; i < 3; i++ ) {
    p = gl_in[i].gl_Position;
    p = cubtr[k] * vec4 ( p.xyz/p.w-lpos, 1.0 );
    Depth = -FCT * p.z / light.max_depth;
    gl_Position = trb.pm * p;
    EmitVertex ();
  }
  EndPrimitive ();
} /*main*/

