#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>

#include "../utilities/openglheader.h"
#include "../utilities/utilities.h"
#include "trans.h"
#include "lights.h"
#include "balance.h"
#include "myscene.h"
#include "bookcase.h"

#define X0  0.0
#define X1  0.35
#define X2  0.01
#define X3  0.33
#define Y0  0.4
#define Y1  0.38
#define Y2  0.28
#define Z0  0.001
#define Z1  0.08
#define Z2  0.1
#define Z3  0.4
#define Z4  0.418
#define Z5  0.72
#define Z6  0.738
#define Z7  1.04
#define Z8  1.058
#define Z9  1.34
#define Z10 1.358
#define Z11 1.66
#define Z12 1.678
#define Z13 1.98
#define Z14 2.0
#define Z15 0.04

#define NVERT   72
#define NTRIANG 88

static GLfloat vertpos[NVERT][3] = {
  {X0,-Y1,Z0},{X3,-Y1,Z0},{X3,Y1,Z0},{X0,Y1,Z0},
  {X0,-Y2,Z0},{X3,-Y2,Z0},{X3,Y2,Z0},{X0,Y2,Z0},
  {X0,-Y1,Z1},{X3,-Y1,Z1},{X3,Y1,Z1},{X0,Y1,Z1},
  {X0,-Y2,Z15},{X3,-Y2,Z15},{X3,Y2,Z15},{X0,Y2,Z15},
  /* 16 */
  {X0,-Y0,Z1},{X1,-Y0,Z1},{X1,Y0,Z1},{X0,Y0,Z1},
  {X0,-Y0,Z14},{X1,-Y0,Z14},{X1,Y0,Z14},{X0,Y0,Z14},
  /* 24 */
  {X2,-Y1,Z2},{X1,-Y1,Z2},{X1,Y1,Z2},{X2,Y1,Z2},
  {X2,-Y1,Z13},{X1,-Y1,Z13},{X1,Y1,Z13},{X2,Y1,Z13},
  /* 32 */
  {X2,-Y1,Z3},{X3,-Y1,Z3},{X3,Y1,Z3},{X2,Y1,Z3},
  {X2,-Y1,Z4},{X3,-Y1,Z4},{X3,Y1,Z4},{X2,Y1,Z4},
  {X2,-Y1,Z5},{X3,-Y1,Z5},{X3,Y1,Z5},{X2,Y1,Z5},
  {X2,-Y1,Z6},{X3,-Y1,Z6},{X3,Y1,Z6},{X2,Y1,Z6},
  {X2,-Y1,Z7},{X3,-Y1,Z7},{X3,Y1,Z7},{X2,Y1,Z7},
  {X2,-Y1,Z8},{X3,-Y1,Z8},{X3,Y1,Z8},{X2,Y1,Z8},
  {X2,-Y1,Z9},{X3,-Y1,Z9},{X3,Y1,Z9},{X2,Y1,Z9},
  {X2,-Y1,Z10},{X3,-Y1,Z10},{X3,Y1,Z10},{X2,Y1,Z10},
  {X2,-Y1,Z11},{X3,-Y1,Z11},{X3,Y1,Z11},{X2,Y1,Z11},
  {X2,-Y1,Z12},{X3,-Y1,Z12},{X3,Y1,Z12},{X2,Y1,Z12}
  /* 72 */
  };
static GLubyte bcindex[3*NTRIANG] = {
  9,8,0,  9,0,1,  1,0,4,  1,4,5,  5,4,12,  5,12,13,  13,12,15,  13,15,14,
  14,15,7,  14,7,6,  6,7,3,  6,3,2,  2,3,11,  2,11,10,
  /* 14 */
  1,5,13,  1,13,9,  9,13,10,  10,13,14,  14,2,10,  14,6,2,
  12,4,0,  12,0,8,  12,8,11,  12,11,15,  15,11,3,  15,3,7,
  /* 26 */
  16,8,17,  17,8,9,  17,9,10,  17,10,18,  10,19,18,  10,11,19,
  /* 32 */
  17,29,21,  17,25,29,  17,26,25,  17,18,26,
  22,21,29,  22,29,30,  22,30,26,  22,26,18,
  /* 40 */
  17,21,20,  17,20,16,  16,20,23,  16,23,19,  19,23,22,  19,22,18,
  20,21,22,  20,22,23,
  /* 48 */
  28,29,25,  28,25,24,  31,28,24,  31,24,27,  30,31,27,  30,27,26,
  30,29,28,  30,28,31,  27,24,25,  27,25,26,
  /* 58 */
  32,35,34,  32,34,33,  33,34,38,  33,38,37,  37,38,39,  37,39,36,
  40,43,42,  40,42,41,  41,42,46,  41,46,45,  45,46,47,  45,47,44,
  48,51,50,  48,50,49,  49,50,54,  49,54,53,  53,54,55,  53,55,52,
  56,59,58,  56,58,57,  57,58,62,  57,62,61,  61,62,63,  61,63,60,
  64,67,66,  64,66,65,  65,66,70,  65,70,69,  69,70,71,  69,71,68
  };

static const GLfloat diffr[4] = { 0.68, 0.52, 0.28, 1.0 };
static const GLfloat specr[4] = { 0.2, 0.2, 0.2, 1.0 };

void EnterBookcase ( BalanceElements *belem, SceneObject *obj, MatBl *matbl )
{
  strcpy ( obj->name, "bookcase" );
  obj->mat0 = SetupMaterial ( matbl, -1, diffr, specr,
                              10.0, 1.0, 1.0, GL_INVALID_INDEX );
  glGenVertexArrays ( 1, &obj->vao );
  glBindVertexArray ( obj->vao );
  glGenBuffers ( 2, obj->vbo );
  glBindBuffer ( GL_ARRAY_BUFFER, obj->vbo[0] );
  glBufferData ( GL_ARRAY_BUFFER, NVERT*3*sizeof(GLfloat),
                 vertpos, GL_STATIC_DRAW );
  glEnableVertexAttribArray ( 0 );
  glVertexAttribPointer ( 0, 3, GL_FLOAT, GL_FALSE,
                          3*sizeof(GLfloat),(GLvoid*)0 );
  glBindBuffer ( GL_ELEMENT_ARRAY_BUFFER, obj->vbo[1] );
  glBufferData ( GL_ELEMENT_ARRAY_BUFFER, NTRIANG*3*sizeof(GLubyte),
                 bcindex, GL_STATIC_DRAW );
  glDisableVertexAttribArray ( 1 );
  glDisableVertexAttribArray ( 2 );
  glBindVertexArray ( 0 );
  obj->redraw = DrawBookcase;
  obj->destroy = DestroySceneObject;
  obj->active = true;
  obj->nvert = NVERT;  obj->ntr = NTRIANG;
  BeginEnteringObjTriangles ( belem, obj, 0, NVERT, NTRIANG, BOOKCASE_ELD );
  EnterTriangles ( belem, GL_TRIANGLES, NVERT, vertpos, NULL,
                   3*NTRIANG, GL_UNSIGNED_BYTE, bcindex, obj->mat0, false );
  EndEnteringObjTriangles ( belem );
  M4x4Translatef ( obj->mm, 0.0, 0.0, FLOOR_Z );
  ExitIfGLError ( "EnterBookcase" );
} /*EnterBookcase*/

void SetBookcasePosition ( SceneObject *obj, float x, float y, double alpha )
{
  M4x4RotateZf ( obj->mm, alpha );
  M4x4TranslateMf ( obj->mm, x, y, FLOOR_Z );
} /*SetBookcasePosition*/

void DrawBookcase ( GLuint prog_id, SceneObject *obj, TransBl *trans, MatBl *mat )
{
  LoadMMatrix ( trans, obj->mm );
  glUseProgram ( prog_id );
  glVertexAttrib2f ( 1, 0.0, 0.0 );
  ChooseMaterial ( mat, obj->mat0 );
  glBindVertexArray ( obj->vao );
  glDrawElements ( GL_TRIANGLES, NTRIANG*3, GL_UNSIGNED_BYTE, (GLvoid*)0 );
  glBindVertexArray ( 0 );
} /*DrawBookcase*/

