#version 450 core

#define VTXT_MAG 4

layout(local_size_x=1) in;

layout(std430,binding=0) buffer VarBuf { uvec4 tvar[]; } vbuf;
layout(std430,binding=1) buffer LeBuf { vec4 le[]; } lebuf;

layout(rgba32f,binding=0) uniform image2D emission;

void main ( void )
{
  uint v, x, y, i, j, k, l;
  vec4 s;

  v = gl_GlobalInvocationID.x;
  x = VTXT_MAG*(vbuf.tvar[v].w & 0xFFFF);
  y = VTXT_MAG*(vbuf.tvar[v].w >> 16);
  for ( i = 0, k = x, s = vec4(0.0);  i < VTXT_MAG;  i++, k++ )
    for ( j = 0, l = y;  j < VTXT_MAG;  j++, l++ )
      s += imageLoad ( emission, ivec2 ( k, l ) );
  s = vec4 ( s.a > 0.0 ? s.rgb/s.a : vec3(0.0), 1.0 );
  lebuf.le[v] = s;
} /*main*/

