#version 450 core

layout(local_size_x=1) in;

layout(std430,binding=0) buffer VarBuf { uvec4 tvar[]; } vbuf;
layout(std430,binding=4) buffer CPointBuf { vec4 cp[]; } cpbuf;
layout(std430,binding=5) buffer VCPointBuf { vec4 cp[]; } vcpbuf;
layout(std430,binding=6) buffer AlBuf { vec4 a[]; } abuf;
layout(std430,binding=7) buffer AlbMat { vec4 a[]; } albm;
layout(std430,binding=9) buffer VMap { uvec2 px[]; } vmap;

uniform CtlBlock {
    int   stage, step, width, height, N, H, nrows, ncols, first, txts;
    uint  nelem, p0, mi, nnz;
    bool  reverse;
    float C;
    vec3  colour;
  } ctl;

void main ( void )
{
  int x, y, z;
  uvec4 tv;

  z = int(gl_GlobalInvocationID.x);
  tv = vbuf.tvar[z];  x = int(tv.w & 0xFFFF);  y = int(tv.w >> 16);
  x = y*ctl.width + x;
  vmap.px[x] = uvec2 ( z, tv.y );
  albm.a[z] = abuf.a[x];
  vcpbuf.cp[z] = cpbuf.cp[x];
} /*main*/

