#version 450 core

flat in int patchID;

uniform CtlBlock {
    int   stage, step, width, height, N, H, nrows, ncols, first, txts;
    uint  nelem, p0, mi, nnz;
    bool  reverse;
    float C;
    vec3  colour;
  } ctl;

struct PatchRect {
    float w, h, x0, y0;
    int   melw, melh;
    int   objID;
  };

layout(std430,binding=0) buffer VarBuf { uvec4 tvar[]; } vbuf;
layout(std430,binding=3) buffer Pr { PatchRect pr[]; } pr;
layout(std430,binding=8) buffer ObjIdBuf { int id[]; } objid;

void main ( void )
{
  int x, y, z, a, b, c;

  x = int(gl_FragCoord.x);  y = int(gl_FragCoord.y);
  z = y*ctl.width + x;
  if ( vbuf.tvar[z].x == 1 ) {
    a = (x-int(pr.pr[patchID].x0)-1) / pr.pr[patchID].melw;
    b = (int(pr.pr[patchID].w)-2) / pr.pr[patchID].melw;
    c = (y-int(pr.pr[patchID].y0)-1) / pr.pr[patchID].melh;
    vbuf.tvar[z].z = (patchID << 16) + ((a + b*c) << 1) + ((a^c) & 0x01 );
    vbuf.tvar[z].w = (y << 16) + x;
    objid.id[z] = pr.pr[patchID].objID;
  }
  discard;
} /*main*/

