#version 450 core

layout(local_size_x=1) in;

layout(std430,binding=0) buffer VarBuf { uvec4 tvar[]; } vbuf;
layout(std430,binding=4) buffer CPointBuf { vec4 cp[]; } cpbuf;
layout(std430,binding=5) buffer RowsCols { uint rc[];} rc;
layout(std430,binding=6) buffer Coeff { float a[]; } a;

uniform CtlBlock {
    int   stage, step, width, height, N, H, nrows, ncols, first, txts;
    uint  nelem, p0, mi, nnz;
    bool  reverse;
    float C;
    vec3  colour;
  } ctl;

void main ( void )
{
  uint  i, j, x, y;
  uvec4 tv;
  float s;

  i = gl_GlobalInvocationID.x;
  switch ( ctl.stage ) {
case 0:
        /* zapisz numer poczatku indeksow kolumn calego wiersza */
    if ( i == 0 )
      rc.rc[0] = 0;
    else if ( i == ctl.nrows )
      rc.rc[ctl.nrows] = uint(ctl.ncols);
    else if ( vbuf.tvar[i].x > vbuf.tvar[i-1].x )
        rc.rc[vbuf.tvar[i].x] = i;
        /* zapisz numer kolumny */
    rc.rc[ctl.nrows+1+i] = i;
        /* skopiuj wspolczynnik */
    a.a[i] = cpbuf.cp[i].w;
    return;
case 1:
        /* oblicz sume wspolczynnikow w wierszu (sekwencyjnie) */
    s = a.a[rc.rc[i]];
    for ( j = rc.rc[i]+1; j < rc.rc[i+1]; j++ )
      s += a.a[j];
        /* podziel wspolczynniki w wierszu przez ich sume (sekwencyjnie) */
    for ( j = rc.rc[i]; j < rc.rc[i+1]; j++ )
      a.a[j] /= s;
    return;
  }
} /*main*/

