#version 450 core

layout(location=1) in vec2 TxtCoord;
layout(location=2) in vec2 in_Position;

out vec2 TexCoord;

uniform CtlBlock {
    int   stage, step, width, height, N, H, nrows, ncols, first, txts;
    uint  nelem, p0, mi, nnz;
    bool  reverse;
    float C;
    vec3  colour;
  } ctl;

void main ( void )
{
  TexCoord = TxtCoord;
  gl_Position = vec4 ( 2.0*in_Position.x/ctl.width-1.0,
                       2.0*in_Position.y/ctl.height-1.0, 0.0, 1.0 );
} /*main*/

