
#define NOBJECTS       13

#define NPROGRAMS      10

#define ROPT_DIRECT     0
#define ROPT_DEFERRED   1
#define ROPT_DEFERRED1  1
#define ROPT_DEFERRED2  2
#define ROPT_DEFERRED3  3
#define ROPT_SHADOW     4
#define ROPT_CUBESHADOW 5
#define ROPT_TRCLASS1   6
#define ROPT_TRCLASS2   7
#define ROPT_TRCLASS3   8
#define ROPT_ELEMCP     9
#define ROPT_MACROEL   10
#define ROPT_RADIANCE  11

#define DFB_TEXTURES    9

#define FFNEAR  0.0025
#define FFFAR  10.24

typedef struct {
    int     win_width, win_height;
    float   left, right, bottom, top, near, far;
    double  zoom;
    int     zoomexp;
    float   viewer_rvec[3];
    double  viewer_rangle;
  } Camera;

typedef struct {
    int    width, height;
    GLuint dfbo[2], dtxt[DFB_TEXTURES];
  } DeferredFB;

typedef struct {
    Camera          camera;
    char            vertical;
    char            mainlamp_on;
    char            shadows_ok, radiance_ok;
    char            render_option;
    char            debug;
    TransBl         trans;
    LightBl         light;
    MatBl           mat;
    DeferredFB      dfb;
    GLuint          program_id[NPROGRAMS];
    GLint           prog7glowfctloc, prog7obscglloc;
    GLint           prog8passloc, prog8ngfloc;
    GLint           prog9glowfctloc, prog9obscglloc,
                    prog9ssaorloc, prog9debugloc, prog9stageloc,
                    prog10colourloc, prog11colourloc, prog11optloc;
    GLfloat         glowfct, ssao_radius;
    GLint           ngf, obscgl;
    int             nobjects;
    SceneObject     obj[MAX_OBJECTS];
    int             niter;
    BalanceElements belem;
/* DEBUG */
/*    int             debug_t, debug_t1;*/
    char            debug_ff;
  } AppData;

void LoadMyShaders ( AppData *ad );
void SetupDFBO ( DeferredFB *dfb, int w, int h );
void ResizeDFBO ( DeferredFB *dfb, int w, int h );
void DeleteDFBO ( DeferredFB *dfb );

void DrawSceneToShadows ( AppData *ad );
void _RedrawMyWorld ( AppData *ad );

void DumpCubeShadowTexture ( GLuint txt );
void DumpBlurredLightTextures ( GLuint txt0, GLuint txt1, int w, int h );

