#version 450 core

#define MAX_NLIGHTS 8
#define FHEMASK     0x01FFFFFF

#define V0   x
#define FACN z

layout(location=0) in vec4 in_Position;

out GVertex {
    vec4 Normal;
    vec4 ShadowPos[MAX_NLIGHTS];
  } Out;

layout(std430,binding=0) buffer Mvf { int   mvf[]; } mmvf;
layout(std430,binding=1) buffer Mhe { ivec4 mhe[]; } mmhe;
layout(std430,binding=2) buffer Mvc { float vc[];  } mmvc;
layout(std430,binding=3) buffer meshsurf {
    int  nv, nhe, nfac, nsattr, pdim, pofs, nvofs;
    bool MeshNormals;
    vec3 Colour;
  };

uniform TransBlock {
    mat4 mm, mmti, vm, pm, vpm;
    vec4 eyepos;
  } trb;

struct LSPar {
    vec4 position;
    vec3 ambient;
    vec3 direct;
    vec3 attenuation;
    mat4 shadow_vpm;
  };

uniform LSBlock {
    uint  nls;              /* liczba zrodel swiatla */
    uint  mask;             /* maska wlaczonych zrodel */
    uint  shmask;           /* maska tekstur cienia */
    LSPar ls[MAX_NLIGHTS];  /* poszczegolne zrodla swiatla */
  } light;

#define mfac(I)  mmvf.mvf[nv+(I)]
#define mfhei(I) mmvf.mvf[nv+nfac+nhe+(I)]
#define mhe(I)   mmhe.mhe[I]   
#define mvc(I)   mmvc.vc[I]

void main ( void )
{
  vec4 pos, wpos;
  uint i, j, l, mask;

  i = mhe(mfhei((mfac(gl_InstanceID) & FHEMASK) + gl_VertexID)).V0;
  j = nsattr*i + pofs;
  switch ( pdim ) {
case 2:
    pos = vec4( mvc(j), mvc(j+1), 0.0, 1.0 );
    Out.Normal = vec4 ( 0.0, 0.0, 1.0, 0.0 );
    return;
case 3:
    pos = vec4( mvc(j), mvc(j+1), mvc(j+2), 1.0 );
    break;
default:
    pos = vec4( mvc(j), mvc(j+1), mvc(j+2), mvc(j+3) );
    break;
  }
  gl_Position = pos;
  if ( nvofs >= 0 ) {
    j = nsattr*i + nvofs;
    Out.Normal = vec4 ( mvc(j), mvc(j+1), mvc(j+2), 0.0 );
  }
  else
    Out.Normal = vec4 ( 0.0 );
  wpos = trb.mm * pos;
  for ( l = 0, mask = 0x00000001;  l < light.nls;  l++, mask <<= 1 )
    if ( (light.mask & mask) != 0 )
      Out.ShadowPos[l] = light.ls[l].shadow_vpm * wpos;
} /*main*/

