#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include "../utilities/openglheader.h"

#include "../utilities/utilities.h"
#include "../utilities/initwglctx.h"
#include "../utilities/xwidgets.h"
#include "app3b.h"
#include "app3bproc.h"

#define WIN0_WIDTH   480
#define WIN0_HEIGHT  360
#define MENU_WIDTH   120

#define WDGSTATE_VIEW_TURNING 1

typedef struct {
    int  last_x, last_y;
    char opti;
  } widget3d;

static HWND       window[3];
static HDC        gldc;
static HGLRC      wglcontext;
static MSG        msg;
static char       redraw;
/*static Atom       aAnimate;*/

static int        window0_width, window0_height;
static xwinmenu   *wm1 = NULL, *wm2 = NULL;
static xwidget    *mywdg = NULL;
static AppWidgets *appwdg = NULL;

static char str_EXIT[] = "Exit";

static void (*idlefunc)(void) = NULL;

void Win1Callback ( struct xwidget *wdg, int msg, int key, int x, int y )
{
  switch ( msg ) {
case WDGMSG_BUTTON_PRESS:
    switch ( wdg->id ) {
  case BTN_ID_EXIT:
      PostQuitMessage (0);
      break;
  default:
      break;
    }
    break;

case WDGMSG_SWITCH_CHANGE:
    if ( ProcessSwitchCommand ( wdg->id ) )
      goto redraw_win2;

case WDGMSG_SLIDEBAR_CHANGE:
    ProcessSlidebarCommand ( wdg->id );
redraw_win2:
    wm2->changed = true;
    PostMenuExposeEvent ( wm2 );
    break;

case XWMSG_KEY_PRESS:
    mywdg->input ( mywdg, msg, key, x, y );
    if ( wm2->changed )
      PostMenuExposeEvent ( wm2 );
    break;

default:
    break;
  }
} /*Win1CallBack*/

xwinmenu *SetupApp3bMenu ( void )
{
  xwinmenu *wm;
  int      i;

  if ( !(wm = NewWinMenu ( window[1], MENU_WIDTH, WIN0_HEIGHT, 0, 0,
                           NULL, NULL, Win1Callback )) )
    ExitOnError ( "SetupApp3Menu" );
  NewButton ( wm, BTN_ID_EXIT, 60, 18, 2, 2, str_EXIT );
  for ( i = 0; i <= NPALMMESHES; i++ )
    NewSwitch ( wm, SW_ID_MESH0+i, 16, 16, 2+20*i, 22, NULL, &appwdg->sw[i] );
  for ( i = 0; i < NKLARTPARAMS; i++ )
    NewSlidebarf ( wm, SL_ID_ARTP0+i, 116, 10, 2, 46+15*i, &appwdg->artp[i] );
  return wm;
} /*SetupApp3bMenu*/

LRESULT CALLBACK Win1MessageProc ( HWND window, UINT msg, WPARAM wParam, LPARAM lParam )
{
  LRESULT result = 0;

  if ( !wm1 )
    return DefWindowProcA ( window, msg, wParam, lParam );
  switch ( msg ) {
case WM_PAINT:
    WinMenuRedraw ( wm1 );
    break;
default:
    result = WinMenuInput ( wm1, msg, wParam, lParam );
    if ( wm1->changed )
      redraw = true;
    break;
  }
  return result;
} /*Win1MessageProc*/

  /* ////////////////////////////////////////////////////////////////////////// */
void MyWinResizeFunc ( HWND wind, int width, int height )
{
  SetWindowPos ( window[1], window[0], 0, 0, MENU_WIDTH, height,
                 SWP_NOZORDER );
  SetWindowPos ( window[2], window[0], MENU_WIDTH, 0,
                 width - MENU_WIDTH, height, SWP_NOZORDER );
  redraw = true;
} /*MyWinResizeFunc*/

LRESULT CALLBACK Win0MessageProc ( HWND window, UINT msg, WPARAM wParam, LPARAM lParam )
{
  LRESULT result = 0;

  switch ( msg ) {
case WM_CLOSE:
case WM_DESTROY:
    PostQuitMessage ( 0 );
    break;
case WM_SIZE:
    if ( wParam != SIZE_MINIMIZED )
      MyWinResizeFunc ( window, LOWORD(lParam), HIWORD(lParam) );
    break;
case WM_CHAR:
case WM_KEYDOWN:
case WM_KEYUP:
case WM_SYSKEYDOWN:
case WM_SYSKEYUP:
    if ( IsCursorInMenu ( wm1 ) )
      SendMessage ( wm1->window, msg, wParam, lParam );
    else if ( IsCursorInMenu ( wm2 ) )
      SendMessage ( wm2->window, msg, wParam, lParam );
    else
      result = DefWindowProcA ( window, msg, wParam, lParam );
    break;
default:
    result = DefWindowProcA ( window, msg, wParam, lParam );
    break;
  }
  return result;
} /*Win0MessageProc*/

/* ////////////////////////////////////////////////////////////////////////// */
void MyIdleFunc ( void )
{
  MoveOn ();
  redraw = true;
} /*MyIdleFunc*/

void My3DWidgetRedraw ( struct xwidget *wdg )
{
  RedrawMyWorld ();
} /*My3DWidgetRedraw*/

char My3DWidgetInput ( struct xwidget *wdg, int msg, int key, int x, int y )
{
/*  XClientMessageEvent *xclient;*/
  widget3d            *ww;

  ww = (widget3d*)wdg->data0;
  switch ( wdg->state ) {
case WDGSTATE_DEFAULT:
    switch ( msg ) {
  case XWMSG_BUTTON_PRESS:
      if ( key == Button1 ) {
        ww->last_x = x;  ww->last_y = y;
        wdg->state = WDGSTATE_VIEW_TURNING;
        GrabInput ( wdg );
        return true;
      }
      break;
  case XWMSG_KEY_PRESS:
      goto process_key;
  case WDGMSG_RECONFIGURE:
      ResizeMyWorld ( wdg->r.width = x, wdg->r.height = y );
      break;
  case XWMSG_CLIENT_MESSAGE:
      goto process_client_message;
  case XWMSG_DELETE:
      goto process_delete_message;
  default:
      break;
    }
    break;

case WDGSTATE_VIEW_TURNING:
    switch ( msg ) {
  case XWMSG_MOUSE_MOTION:
      if ( IsMouseButtonDown ( Button1 ) ) {
        RotateViewer ( (double)(x - ww->last_x), (double)(y - ww->last_y) );
        ww->last_x = x;  ww->last_y = y;
        wdg->wm->changed = true;
      }
      else
        goto release;
      break;
  case XWMSG_BUTTON_RELEASE:
      if ( !IsMouseButtonDown ( Button1 ) ) {
release:
        wdg->state = WDGSTATE_DEFAULT;
        UngrabInput ( wdg );
        return true;
      }
      break;
  case XWMSG_KEY_PRESS:
process_key:
      if ( ProcessCharCommand ( key ) ) {
        redraw = true;
        return wdg->wm->changed = true;
      }
      break;

  case XWMSG_CLIENT_MESSAGE:
process_client_message:
      break;
  case XWMSG_DELETE:
process_delete_message:
      free ( wdg->data0 );
      return true;
  default:
      break;
    }
    break;

default:
    break;
  }
  return false;
} /*My3DWidgetInput*/

xwidget *New3DWidget ( struct xwinmenu *wm, int id, int w, int h )
{
  widget3d *ww;

  if ( !(ww = malloc ( sizeof(widget3d) )) )
    ExitOnError ( "New3DWidget" );
  ww->opti = 0;
  return NewWidget ( wm, sizeof(xwidget), id, w, h, 0, 0,
                     My3DWidgetInput, My3DWidgetRedraw, ww, NULL );
} /*New3DWidget*/

void RedrawWin2 ( xwinmenu *wm )
{
  widget3d *ww;

  ww = (widget3d*)mywdg->data0;
  if ( ww->opti > 0 )
    ww->opti --;
  else {
    mywdg->redraw ( mywdg );
    redraw = false;
  }
  SwapBuffers ( gldc );
} /*RedrawWin2*/

void Win2Callback ( struct xwidget *wdg, int msg, int key, int x, int y )
{
  widget3d *ww;

  ww = (widget3d*)mywdg->data0;
  switch ( msg ) {
case WDGMSG_RECONFIGURE:
    mywdg->input ( mywdg, WDGMSG_RECONFIGURE, 0, x, y );
    ww->opti = 4;
    redraw = true;
    break;
case XWMSG_CLIENT_MESSAGE:
    mywdg->input ( mywdg, msg, key, x, y );
    break;
default:
    break;
  }
} /*Win2Callback*/

LRESULT CALLBACK Win2MessageProc ( HWND window, UINT msg, WPARAM wParam, LPARAM lParam )
{
  LRESULT result = 0;

  if ( !wm2 )
    return DefWindowProcA ( window, msg, wParam, lParam );
  result = WinMenuInput ( wm2, msg, wParam, lParam );
  if ( wm2->changed )
    redraw = true;
  return result;
} /*Win2MessageProc*/

xwinmenu *SetupApp3GLWindow ( void )
{
  xwinmenu *wm;

  if ( !(wm = NewWinMenu ( window[2], WIN0_WIDTH-MENU_WIDTH, WIN0_HEIGHT, 0, 0,
                           NULL, RedrawWin2, Win2Callback )) )
    ExitOnError ( "SetupApp3GLWindow 0" );
  if ( !(mywdg = New3DWidget ( wm, GLWIN_ID_VIEW, wm->r.width, wm->r.height )) )
    ExitOnError ( "SetupApp3GLWindow 1" );
  return wm;
} /*SetupApp3GLWindow*/

/* ////////////////////////////////////////////////////////////////////////// */
char ProcessWorldRequest ( int msg, void *data, void *reply )
{
  switch ( msg ) {
case WMSG_ANIMATION_ON:
    idlefunc = MyIdleFunc;
    return true;
case WMSG_ANIMATION_OFF:
    idlefunc = NULL;
    return true;
default:
    return false;
  }
} /*ProcessWorldRequest*/

/* ////////////////////////////////////////////////////////////////////////// */
void MessageLoop ( void )
{
  char terminate;

  for ( terminate = false; !terminate; ) {
    if ( PeekMessageA ( &msg, 0, 0, 0, PM_REMOVE ) ) {
      if ( msg.message == WM_QUIT )
        terminate = true;
      else {
        TranslateMessage ( &msg );
        DispatchMessage ( &msg );
      }
    }
    if ( redraw )
      RedrawWin2 ( wm2 );
    if ( idlefunc )
      idlefunc ();
    else
      WaitMessage ();
  }
} /*MessageLoop*/

void InitApp3Windows ( HINSTANCE inst, int argc, char **argv, int major, int minor,
                       int width, int height )
{
  WNDCLASSA wclass;
  RECT      rect;
  DWORD     wstyle;

  memset ( &wclass, 0, sizeof(WNDCLASSA) );
  wclass.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
  wclass.lpfnWndProc = Win0MessageProc;
  wclass.hInstance = inst;
  wclass.hCursor = LoadCursor ( 0, IDC_ARROW );
  wclass.hbrBackground = 0;
  wclass.lpszClassName = "WGL_window";
  if ( !RegisterClassA ( &wclass ) )
    ExitOnError ( "Failed to register window class 0." );
  memset ( &rect, 0, sizeof(RECT) );
  rect.right = width;  rect.bottom = height;
/*printf("before: w = %d, h = %d\n", rect.right - rect.left, rect.bottom - rect.top);*/
  wstyle = WS_OVERLAPPEDWINDOW;
  AdjustWindowRect ( &rect, wstyle, 0 );
/*printf("after: w = %d, h = %d\n", rect.right - rect.left, rect.bottom - rect.top); */
  window[0] = CreateWindowExA ( 0, wclass.lpszClassName, "Aplikacja 3B",
                        WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT,
                        rect.right-rect.left, rect.bottom-rect.top, 0, 0, inst, NULL );
  if ( !window[0] )
    ExitOnError ( "Failed to create window[0]." );
  wclass.cbClsExtra = sizeof(long);
  wclass.hIcon = NULL;
  wclass.lpfnWndProc = Win1MessageProc;
  wclass.lpszClassName = "WGL_subwindow_1";
  if ( !RegisterClassA ( &wclass ) )
    ExitOnError ( "Failed to register window class 1." );
  window[1] = CreateWindowExA ( 0, wclass.lpszClassName, "", WS_CHILD,
        0, 0, MENU_WIDTH, height, window[0], 0, inst, NULL );
  wclass.lpfnWndProc = Win2MessageProc;
  wclass.lpszClassName = "WGL_subwindow_2";
  if ( !RegisterClassA ( &wclass ) )
    ExitOnError ( "Failed to register window class 2." );
  window[2] = CreateWindowExA ( 0, wclass.lpszClassName, "", WS_CHILD,
        MENU_WIDTH, 0, width-MENU_WIDTH, height, window[0], 0, inst, NULL );
  InitWinMenuPalette ();
  window0_width = width;
  window0_height = height;
} /*InitApp3Windows*/

void Initialise ( HINSTANCE inst, int argc, char **argv )
{
  InitWGLExtensions ( APP3B_GL_MAJOR, APP3B_GL_MINOR );
  InitApp3Windows ( inst, argc, argv, APP3B_GL_MAJOR, APP3B_GL_MINOR,
                    WIN0_WIDTH, WIN0_HEIGHT );
  gldc = GetDC ( window[2] );
  wglcontext = InitWGLContext ( gldc, APP3B_GL_MAJOR, APP3B_GL_MINOR, 0, NULL );
  ShowWindow ( window[0], true );
  ShowWindow ( window[1], true );
  ShowWindow ( window[2], true );
  appwdg = InitMyWorld ( argc, argv, WIN0_WIDTH - MENU_WIDTH, WIN0_HEIGHT );
  wm1 = SetupApp3bMenu ();
  wm2 = SetupApp3GLWindow ();
  PostMenuExposeEvent ( wm1 );
} /*Initialise*/

void Cleanup ( void )
{
  DeleteMyWorld ();
  DeleteWinMenu ( wm1 );
  DeleteWinMenu ( wm2 );
  DestroyWindow ( window[0] );
} /*Cleanup*/

int main ( int argc, char **argv )
{
  Initialise ( GetModuleHandle ( 0 ), argc, argv );
  MessageLoop ();
  Cleanup ();
  exit ( 0 );
} /*main*/
