#version 450 core

layout(location=0) out int instance;
layout(location=1) out vec3 colour; 

layout(std430,binding=1) buffer meshhe { ivec4 mhe[]; } mhe;
layout(std430,binding=2) buffer meshvc { float vc[];  } mvc;
layout(std430,binding=3) buffer meshsurf {
    int  nv, nhe, nfac, nsattr, pdim, pofs, nvofs;
    bool MeshNormals;
    vec3 Colour;
  };

#define V0 x
#define V1 y

#define FetchVertex(I) \
  switch ( pdim ) { \
case 2: \
    gl_Position = vec4( mvc.vc[I], mvc.vc[(I)+1], 0.0, 1.0 );  break; \
case 3: \
    gl_Position = vec4( mvc.vc[I], mvc.vc[(I)+1], mvc.vc[(I)+2], \
                        1.0 );  break; \
default: \
    gl_Position = vec4( mvc.vc[I], mvc.vc[(I)+1], mvc.vc[(I)+2], \
                        mvc.vc[(I)+3] );  break; \
  }

void main ( void )
{
  int  i, j, k;
  vec4 vp;

  instance = i = gl_InstanceID;
  j = gl_VertexID == 0 ? mhe.mhe[i].V0 : mhe.mhe[i].V1;
  k = nsattr*j + pofs;
  FetchVertex ( k );
  colour = Colour;
} /*main*/

