
#define MAX_NLIGHTS 8

typedef struct LSPar {
          GLfloat position[4];
          GLfloat ambient[3];
          GLfloat direct[3];
          GLfloat attenuation[3];
        } LSPar;

typedef struct LightBl {
          GLuint lsbuf;
          GLuint nls, mask;
          LSPar  ls[MAX_NLIGHTS];
        } LightBl;

GLuint GetAccessToLightBlockUniform ( GLuint program_id );
GLuint NewUniformLightBlock ( void );
void AttachUniformLightBlockToBP ( GLuint program_id );

void SetLightPosition ( LightBl *light, int l, GLfloat pos[4] );
void SetLightAmbient ( LightBl *light, int l, GLfloat amb[3] );
void SetLightDirect ( LightBl *light, int l, GLfloat dir[3] );
void SetLightAttenuation ( LightBl *light, int l, GLfloat at3[3] );
void SetLightOnOff ( LightBl *light, int l, char on );
