#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "../utilities/openglheader.h"

#include "../utilities/GPUsparsemat.h"
#include "../utilities/meshes.h"
#include "palm.h"

static BSMvertex mv[PALM_NV] =
 {{4,0},{5,4},{5,9},{5,14},{4,19},
  {6,23},{4,29},{4,33},{5,37},{5,42},
  {5,47},{4,52},{6,56},{4,62},{4,66},
  {4,70},{3,74},{3,77},{3,80},{4,83},
  {4,87},{3,91},{4,94},{4,98},{4,102},
  {4,106},{4,110},{4,114},{4,118},{4,122},
  {4,126},{4,130},{4,134},{4,138},{3,142},
  {3,145},{3,148},{3,151},{4,154},{4,158},
  {4,162},{4,166},{4,170},{4,174},{4,178},
  {4,182},{4,186},{4,190},{4,194},{4,198},
  {4,202},{4,206},{4,210},{4,214},{4,218},
  {4,222},{4,226},{4,230},{3,234},{3,237},
  {3,240},{3,243},{4,246},{4,250},{4,254},
  {4,258},{4,262},{4,266},{4,270},{4,274},
  {4,278},{4,282},{4,286},{4,290},{4,294},
  {4,298},{4,302},{4,306},{4,310},{4,314},
  {4,318},{4,322},{3,326},{3,329},{3,332},
  {3,335},{4,338},{4,342},{4,346},{4,350},
  {4,354},{4,358},{4,362},{4,366},{4,370},
  {4,374},{4,378},{4,382},{4,386},{4,390},
  {4,394},{4,398},{4,402},{4,406},{4,410},
  {4,414},{3,418},{3,421},{3,424},{3,427},
  {4,430},{4,434},{4,438},{4,442},{4,446},
  {4,450},{4,454},{4,458},{4,462},{4,466},
  {4,470},{4,474},{4,478},{4,482},{4,486},
  {4,490},{4,494},{4,498},{4,502},{4,506},
  {3,510},{3,513},{3,516},{3,519},{4,522},
  {4,526},{4,530},{4,534},{4,538},{4,542},
  {4,546},{4,550},{5,554},{5,559}};

static int mvhei[PALM_NHE] =
 {0,428,431,13,1,332,335,440,427,2,236,239,344,331,3,140,
  143,248,235,562,541,523,38,524,527,64,80,83,11,6,40,56,
  43,34,432,435,27,436,439,336,339,21,340,343,240,243,22,244,
  247,144,147,23,558,561,18,537,32,84,87,71,536,539,52,55,
  20,26,60,63,528,531,535,72,59,532,53,50,33,57,54,12,
  61,58,45,76,79,62,47,69,88,75,48,73,70,46,77,74,
  92,95,81,78,96,99,85,82,100,103,89,86,104,91,93,90,
  108,111,97,94,112,115,101,98,116,119,105,102,120,107,109,106,
  124,127,113,110,128,131,117,114,132,135,121,118,136,123,125,122,
  65,129,126,67,133,130,68,137,134,66,141,138,156,159,145,142,
  160,163,149,146,164,167,153,150,168,155,157,154,172,175,161,158,
  176,179,165,162,180,183,169,166,184,171,173,170,188,191,177,174,
  192,195,181,178,196,199,185,182,200,187,189,186,204,207,193,190,
  208,211,197,194,212,215,201,198,216,203,205,202,220,223,209,206,
  224,227,213,210,228,231,217,214,232,219,221,218,37,225,222,17,
  229,226,31,233,230,10,237,234,252,255,241,238,256,259,245,242,
  260,263,249,246,264,251,253,250,268,271,257,254,272,275,261,258,
  276,279,265,262,280,267,269,266,284,287,273,270,288,291,277,274,
  292,295,281,278,296,283,285,282,300,303,289,286,304,307,293,290,
  308,311,297,294,312,299,301,298,316,319,305,302,320,323,309,306,
  324,327,313,310,328,315,317,314,36,321,318,16,325,322,30,329,
  326,9,333,330,348,351,337,334,352,355,341,338,356,359,345,342,
  360,347,349,346,364,367,353,350,368,371,357,354,372,375,361,358,
  376,363,365,362,380,383,369,366,384,387,373,370,388,391,377,374,
  392,379,381,378,396,399,385,382,400,403,389,386,404,407,393,390,
  408,395,397,394,412,415,401,398,416,419,405,402,420,423,409,406,
  424,411,413,410,35,417,414,15,421,418,29,425,422,8,429,426,
  444,447,433,430,448,451,437,434,452,455,441,438,456,443,445,442,
  460,463,449,446,464,467,453,450,468,471,457,454,472,459,461,458,
  476,479,465,462,480,483,469,466,484,487,473,470,488,475,477,474,
  492,495,481,478,496,499,485,482,500,503,489,486,504,491,493,490,
  508,511,497,494,512,515,501,498,516,519,505,502,520,507,509,506,
  41,513,510,14,517,514,28,521,518,7,542,545,526,522,546,549,
  530,525,550,553,534,529,554,557,538,533,543,540,5,44,547,544,
  42,39,551,548,19,49,555,552,51,25,559,556,24,148,151,563,
  560,152,139,4};

static GLfloat vc[PALM_NV][3] =
 {{-0.64428,-0.01967,0.10625},{-0.46387,0.04767,0.10604},{-0.24062,0.07614,0.10579},
  {-0.01738,0.06084,0.10554},{0.18089,-0.17557,0.10533},{0.19489,-0.35997,0.16671},
  {-0.61824,-0.37300,0.16784},{-0.64446,-0.06411,-0.13756},{-0.46405,0.00323,-0.13777},
  {-0.24081,0.03170,-0.13802},{-0.01757,0.01639,-0.13827},{0.16822,-0.20400,0.03128},
  {0.11346,-0.35997,-0.16789},{-0.61842,-0.37300,-0.16675},{0.12763,-0.85993,0.20724},
  {0.04620,-0.85993,-0.20848},{-0.49440,-0.85992,-0.20734},{-0.49421,-0.85992,0.20838},
  {0.26829,-0.74212,0.20700},{0.37711,-0.44979,0.16646},{0.37692,-0.44979,-0.16814},
  {0.23256,-0.82930,-0.20871},{0.41852,-0.31568,0.10581},{0.23631,-0.22586,0.10597},
  {0.23612,-0.22586,-0.10679},{0.38820,-0.42438,-0.16347},{0.44541,-0.18397,0.11083},
  {0.26589,-0.09415,0.07962},{0.30233,-0.09415,-0.13000},{0.49012,-0.13629,-0.09735},
  {0.43672,-0.06657,0.14697},{0.27976,0.02326,0.05442},{0.38783,0.02326,-0.12886},
  {0.49067,-0.12580,-0.09729},{0.48279,0.10868,0.17414},{0.32583,0.14850,0.08160},
  {0.43390,0.19850,-0.10168},{0.59086,0.20868,-0.00914},{-0.00566,0.13627,0.10618},
  {-0.01045,0.06860,-0.13311},{0.16753,0.05353,-0.13326},{0.16772,0.12249,0.10603},
  {0.00246,0.25082,0.10617},{0.00228,0.29430,-0.10659},{0.17134,0.28134,-0.10674},
  {0.17153,0.23786,0.10603},{0.00986,0.39387,0.10617},{0.00967,0.35473,-0.10660},
  {0.17821,0.34096,-0.10674},{0.17840,0.38009,0.10602},{0.01869,0.52621,0.10616},
  {0.01851,0.56969,-0.10661},{0.18705,0.55510,-0.10675},{0.18723,0.51162,0.10601},
  {0.02317,0.63143,0.10616},{0.02298,0.59230,-0.10661},{0.19066,0.58342,-0.10675},
  {0.19084,0.62255,0.10601},{0.02554,0.74077,0.10615},{0.02536,0.88077,-0.10661},
  {0.18959,0.87434,-0.10675},{0.18977,0.73434,0.10601},{-0.22667,0.15263,0.10637},
  {-0.23253,0.08443,-0.13292},{-0.03135,0.07652,-0.13308},{-0.03782,0.14650,0.10621},
  {-0.22633,0.28081,0.10637},{-0.22652,0.32864,-0.10639},{-0.03766,0.32189,-0.10656},
  {-0.03748,0.27406,0.10621},{-0.22864,0.42407,0.10637},{-0.22882,0.38059,-0.10639},
  {-0.03997,0.37384,-0.10656},{-0.03978,0.41732,0.10621},{-0.23146,0.56838,0.10638},
  {-0.23164,0.61621,-0.10639},{-0.04279,0.60946,-0.10655},{-0.04261,0.56163,0.10621},
  {-0.23453,0.68410,0.10638},{-0.23472,0.64062,-0.10639},{-0.04587,0.63387,-0.10655},
  {-0.04568,0.67735,0.10622},{-0.24009,0.80066,0.10638},{-0.24028,0.94066,-0.10638},
  {-0.05142,0.93721,-0.10655},{-0.05124,0.79721,0.10622},{-0.45202,0.13748,0.10657},
  {-0.45221,0.06852,-0.13272},{-0.25605,0.07388,-0.13288},{-0.26708,0.14361,0.10641},
  {-0.45674,0.25980,0.10657},{-0.45692,0.27719,-0.10619},{-0.27198,0.28332,-0.10635},
  {-0.27180,0.26593,0.10641},{-0.46066,0.39087,0.10657},{-0.46084,0.34739,-0.10619},
  {-0.27590,0.35353,-0.10635},{-0.27572,0.39700,0.10641},{-0.46380,0.51953,0.10658},
  {-0.46398,0.53692,-0.10619},{-0.27904,0.54305,-0.10635},{-0.27885,0.52566,0.10642},
  {-0.46850,0.60956,0.10658},{-0.46869,0.56608,-0.10618},{-0.28375,0.57221,-0.10634},
  {-0.28356,0.61569,0.10642},{-0.47400,0.68290,0.10659},{-0.47418,0.82290,-0.10618},
  {-0.28924,0.82903,-0.10634},{-0.28905,0.68903,0.10643},{-0.65284,0.06313,0.10674},
  {-0.65302,-0.00583,-0.13255},{-0.47551,0.02639,-0.13269},{-0.49198,0.07524,0.10660},
  {-0.66436,0.17749,0.10675},{-0.66455,0.21227,-0.10601},{-0.51071,0.22438,-0.10615},
  {-0.51053,0.18960,0.10662},{-0.67317,0.27622,0.10676},{-0.67335,0.24578,-0.10601},
  {-0.51952,0.25789,-0.10614},{-0.51933,0.28833,0.10663},{-0.68039,0.36010,0.10676},
  {-0.68057,0.39488,-0.10600},{-0.52674,0.40699,-0.10613},{-0.52655,0.37221,0.10663},
  {-0.68359,0.43130,0.10677},{-0.68377,0.40087,-0.10600},{-0.52994,0.41298,-0.10613},
  {-0.52975,0.44341,0.10663},{-0.68680,0.46971,0.10677},{-0.68698,0.60971,-0.10600},
  {-0.53315,0.62182,-0.10613},{-0.53296,0.48182,0.10664},{0.04929,-0.35143,0.06819},
  {-0.17992,-0.86727,0.20863},{-0.04630,-0.86425,-0.20822},{0.08939,-0.35469,-0.18100},
  {-0.09708,-0.35143,0.06819},{-0.27332,-0.86425,0.20749},{-0.15383,-0.86124,-0.20822},
  {0.00633,-0.34901,-0.18100},{0.16974,-0.05348,-0.13848},{0.16963,0.01677,0.10533}};

static BSMhalfedge mhe[PALM_NHE] =
 {{0,1,0,427},{1,2,0,331},{2,3,0,235},{3,143,0,139},
  {143,138,0,540},{138,6,0,43},{6,0,0,13},{133,130,2,506},
  {109,106,3,410},{85,82,4,314},{61,58,5,218},{5,4,6,523},
  {17,139,7,42},{0,6,8,6},{131,132,2,514},{107,108,3,418},
  {83,84,4,322},{59,60,5,226},{11,12,6,539},{140,16,7,50},
  {13,7,8,27},{8,7,1,435},{9,8,1,339},{10,9,1,243},
  {142,10,1,147},{141,142,1,556},{13,141,1,51},{7,13,1,20},
  {132,133,2,518},{108,109,3,422},{84,85,4,326},{60,61,5,230},
  {12,5,6,83},{16,17,7,54},{7,0,8,431},{106,107,3,414},
  {82,83,4,318},{58,59,5,222},{4,11,6,561},{139,140,7,548},
  {6,13,8,55},{130,131,2,510},{139,17,9,12},{6,138,9,5},
  {138,139,9,544},{18,19,10,62},{21,18,10,58},{19,20,10,75},
  {20,21,10,70},{140,141,11,552},{16,140,11,19},{141,13,11,26},
  {13,16,11,53},{16,13,12,52},{17,16,12,33},{13,6,12,40},
  {6,17,12,57},{17,6,9,56},{18,21,13,46},{15,14,13,531},
  {14,18,13,61},{18,14,14,60},{19,18,14,45},{14,5,14,527},
  {5,19,14,79},{34,35,15,126},{37,34,15,122},{35,36,15,130},
  {36,37,15,134},{20,12,16,87},{21,20,16,48},{12,15,16,535},
  {15,21,16,73},{21,15,13,72},{22,25,17,91},{20,19,17,47},
  {19,22,17,77},{22,19,18,76},{23,22,18,95},{19,5,18,64},
  {5,23,18,81},{23,5,19,80},{24,23,19,99},{5,12,19,32},
  {12,24,19,85},{24,12,20,84},{25,24,20,103},{12,20,20,69},
  {20,25,20,89},{25,20,17,88},{26,29,21,107},{25,22,21,74},
  {22,26,21,93},{26,22,22,92},{27,26,22,111},{22,23,22,78},
  {23,27,22,97},{27,23,23,96},{28,27,23,115},{23,24,23,82},
  {24,28,23,101},{28,24,24,100},{29,28,24,119},{24,25,24,86},
  {25,29,24,105},{29,25,21,104},{30,33,25,123},{29,26,25,90},
  {26,30,25,109},{30,26,26,108},{31,30,26,127},{26,27,26,94},
  {27,31,26,113},{31,27,27,112},{32,31,27,131},{27,28,27,98},
  {28,32,27,117},{32,28,28,116},{33,32,28,135},{28,29,28,102},
  {29,33,28,121},{33,29,25,120},{34,37,29,66},{33,30,29,106},
  {30,34,29,125},{34,30,30,124},{35,34,30,65},{30,31,30,110},
  {31,35,30,129},{35,31,31,128},{36,35,31,67},{31,32,31,114},
  {32,36,31,133},{36,32,32,132},{37,36,32,68},{32,33,32,118},
  {33,37,32,137},{37,33,29,136},{38,41,33,155},{143,3,33,3},
  {3,38,33,141},{38,3,34,140},{39,38,34,159},{3,10,34,247},
  {10,39,34,145},{39,10,35,144},{40,39,35,163},{10,142,35,24},
  {142,40,35,149},{40,142,36,148},{41,40,36,167},{142,143,36,560},
  {143,41,36,153},{41,143,33,152},{42,45,37,171},{41,38,37,138},
  {38,42,37,157},{42,38,38,156},{43,42,38,175},{38,39,38,142},
  {39,43,38,161},{43,39,39,160},{44,43,39,179},{39,40,39,146},
  {40,44,39,165},{44,40,40,164},{45,44,40,183},{40,41,40,150},
  {41,45,40,169},{45,41,37,168},{46,49,41,187},{45,42,41,154},
  {42,46,41,173},{46,42,42,172},{47,46,42,191},{42,43,42,158},
  {43,47,42,177},{47,43,43,176},{48,47,43,195},{43,44,43,162},
  {44,48,43,181},{48,44,44,180},{49,48,44,199},{44,45,44,166},
  {45,49,44,185},{49,45,41,184},{50,53,45,203},{49,46,45,170},
  {46,50,45,189},{50,46,46,188},{51,50,46,207},{46,47,46,174},
  {47,51,46,193},{51,47,47,192},{52,51,47,211},{47,48,47,178},
  {48,52,47,197},{52,48,48,196},{53,52,48,215},{48,49,48,182},
  {49,53,48,201},{53,49,45,200},{54,57,49,219},{53,50,49,186},
  {50,54,49,205},{54,50,50,204},{55,54,50,223},{50,51,50,190},
  {51,55,50,209},{55,51,51,208},{56,55,51,227},{51,52,51,194},
  {52,56,51,213},{56,52,52,212},{57,56,52,231},{52,53,52,198},
  {53,57,52,217},{57,53,49,216},{58,61,53,10},{57,54,53,202},
  {54,58,53,221},{58,54,54,220},{59,58,54,37},{54,55,54,206},
  {55,59,54,225},{59,55,55,224},{60,59,55,17},{55,56,55,210},
  {56,60,55,229},{60,56,56,228},{61,60,56,31},{56,57,56,214},
  {57,61,56,233},{61,57,53,232},{62,65,57,251},{3,2,57,2},
  {2,62,57,237},{62,2,58,236},{63,62,58,255},{2,9,58,343},
  {9,63,58,241},{63,9,59,240},{64,63,59,259},{9,10,59,23},
  {10,64,59,245},{64,10,60,244},{65,64,60,263},{10,3,60,143},
  {3,65,60,249},{65,3,57,248},{66,69,61,267},{65,62,61,234},
  {62,66,61,253},{66,62,62,252},{67,66,62,271},{62,63,62,238},
  {63,67,62,257},{67,63,63,256},{68,67,63,275},{63,64,63,242},
  {64,68,63,261},{68,64,64,260},{69,68,64,279},{64,65,64,246},
  {65,69,64,265},{69,65,61,264},{70,73,65,283},{69,66,65,250},
  {66,70,65,269},{70,66,66,268},{71,70,66,287},{66,67,66,254},
  {67,71,66,273},{71,67,67,272},{72,71,67,291},{67,68,67,258},
  {68,72,67,277},{72,68,68,276},{73,72,68,295},{68,69,68,262},
  {69,73,68,281},{73,69,65,280},{74,77,69,299},{73,70,69,266},
  {70,74,69,285},{74,70,70,284},{75,74,70,303},{70,71,70,270},
  {71,75,70,289},{75,71,71,288},{76,75,71,307},{71,72,71,274},
  {72,76,71,293},{76,72,72,292},{77,76,72,311},{72,73,72,278},
  {73,77,72,297},{77,73,69,296},{78,81,73,315},{77,74,73,282},
  {74,78,73,301},{78,74,74,300},{79,78,74,319},{74,75,74,286},
  {75,79,74,305},{79,75,75,304},{80,79,75,323},{75,76,75,290},
  {76,80,75,309},{80,76,76,308},{81,80,76,327},{76,77,76,294},
  {77,81,76,313},{81,77,73,312},{82,85,77,9},{81,78,77,298},
  {78,82,77,317},{82,78,78,316},{83,82,78,36},{78,79,78,302},
  {79,83,78,321},{83,79,79,320},{84,83,79,16},{79,80,79,306},
  {80,84,79,325},{84,80,80,324},{85,84,80,30},{80,81,80,310},
  {81,85,80,329},{85,81,77,328},{86,89,81,347},{2,1,81,1},
  {1,86,81,333},{86,1,82,332},{87,86,82,351},{1,8,82,439},
  {8,87,82,337},{87,8,83,336},{88,87,83,355},{8,9,83,22},
  {9,88,83,341},{88,9,84,340},{89,88,84,359},{9,2,84,239},
  {2,89,84,345},{89,2,81,344},{90,93,85,363},{89,86,85,330},
  {86,90,85,349},{90,86,86,348},{91,90,86,367},{86,87,86,334},
  {87,91,86,353},{91,87,87,352},{92,91,87,371},{87,88,87,338},
  {88,92,87,357},{92,88,88,356},{93,92,88,375},{88,89,88,342},
  {89,93,88,361},{93,89,85,360},{94,97,89,379},{93,90,89,346},
  {90,94,89,365},{94,90,90,364},{95,94,90,383},{90,91,90,350},
  {91,95,90,369},{95,91,91,368},{96,95,91,387},{91,92,91,354},
  {92,96,91,373},{96,92,92,372},{97,96,92,391},{92,93,92,358},
  {93,97,92,377},{97,93,89,376},{98,101,93,395},{97,94,93,362},
  {94,98,93,381},{98,94,94,380},{99,98,94,399},{94,95,94,366},
  {95,99,94,385},{99,95,95,384},{100,99,95,403},{95,96,95,370},
  {96,100,95,389},{100,96,96,388},{101,100,96,407},{96,97,96,374},
  {97,101,96,393},{101,97,93,392},{102,105,97,411},{101,98,97,378},
  {98,102,97,397},{102,98,98,396},{103,102,98,415},{98,99,98,382},
  {99,103,98,401},{103,99,99,400},{104,103,99,419},{99,100,99,386},
  {100,104,99,405},{104,100,100,404},{105,104,100,423},{100,101,100,390},
  {101,105,100,409},{105,101,97,408},{106,109,101,8},{105,102,101,394},
  {102,106,101,413},{106,102,102,412},{107,106,102,35},{102,103,102,398},
  {103,107,102,417},{107,103,103,416},{108,107,103,15},{103,104,103,402},
  {104,108,103,421},{108,104,104,420},{109,108,104,29},{104,105,104,406},
  {105,109,104,425},{109,105,101,424},{110,113,105,443},{1,0,105,0},
  {0,110,105,429},{110,0,106,428},{111,110,106,447},{0,7,106,34},
  {7,111,106,433},{111,7,107,432},{112,111,107,451},{7,8,107,21},
  {8,112,107,437},{112,8,108,436},{113,112,108,455},{8,1,108,335},
  {1,113,108,441},{113,1,105,440},{114,117,109,459},{113,110,109,426},
  {110,114,109,445},{114,110,110,444},{115,114,110,463},{110,111,110,430},
  {111,115,110,449},{115,111,111,448},{116,115,111,467},{111,112,111,434},
  {112,116,111,453},{116,112,112,452},{117,116,112,471},{112,113,112,438},
  {113,117,112,457},{117,113,109,456},{118,121,113,475},{117,114,113,442},
  {114,118,113,461},{118,114,114,460},{119,118,114,479},{114,115,114,446},
  {115,119,114,465},{119,115,115,464},{120,119,115,483},{115,116,115,450},
  {116,120,115,469},{120,116,116,468},{121,120,116,487},{116,117,116,454},
  {117,121,116,473},{121,117,113,472},{122,125,117,491},{121,118,117,458},
  {118,122,117,477},{122,118,118,476},{123,122,118,495},{118,119,118,462},
  {119,123,118,481},{123,119,119,480},{124,123,119,499},{119,120,119,466},
  {120,124,119,485},{124,120,120,484},{125,124,120,503},{120,121,120,470},
  {121,125,120,489},{125,121,117,488},{126,129,121,507},{125,122,121,474},
  {122,126,121,493},{126,122,122,492},{127,126,122,511},{122,123,122,478},
  {123,127,122,497},{127,123,123,496},{128,127,123,515},{123,124,123,482},
  {124,128,123,501},{128,124,124,500},{129,128,124,519},{124,125,124,486},
  {125,129,124,505},{129,125,121,504},{130,133,125,7},{129,126,125,490},
  {126,130,125,509},{130,126,126,508},{131,130,126,41},{126,127,126,494},
  {127,131,126,513},{131,127,127,512},{132,131,127,14},{127,128,127,498},
  {128,132,127,517},{132,128,128,516},{133,132,128,28},{128,129,128,502},
  {129,133,128,521},{133,129,125,520},{134,4,129,541},{4,5,129,11},
  {5,134,129,526},{135,134,130,545},{134,5,130,524},{5,14,130,63},
  {14,135,130,530},{136,135,131,549},{135,14,131,528},{14,15,131,59},
  {15,136,131,534},{137,136,132,553},{136,15,132,532},{15,12,132,71},
  {12,137,132,538},{11,137,133,557},{137,12,133,536},{12,11,133,18},
  {138,143,134,4},{4,134,134,522},{134,138,134,543},{138,134,135,542},
  {139,138,135,44},{134,135,135,525},{135,139,135,547},{139,135,136,546},
  {140,139,136,39},{135,136,136,529},{136,140,136,551},{140,136,137,550},
  {141,140,137,49},{136,137,137,533},{137,141,137,555},{141,137,138,554},
  {142,141,138,25},{137,11,138,537},{11,142,138,559},{142,11,139,558},
  {143,142,139,151},{11,4,139,38},{4,143,139,563},{143,4,134,562}};

static BSMfacet mfac[PALM_NFAC] =
 {{7,0},{7,7},{4,14},{4,18},{4,22},
  {4,26},{4,30},{4,34},{4,38},{4,42},
  {4,46},{4,50},{4,54},{4,58},{4,62},
  {4,66},{4,70},{4,74},{4,78},{4,82},
  {4,86},{4,90},{4,94},{4,98},{4,102},
  {4,106},{4,110},{4,114},{4,118},{4,122},
  {4,126},{4,130},{4,134},{4,138},{4,142},
  {4,146},{4,150},{4,154},{4,158},{4,162},
  {4,166},{4,170},{4,174},{4,178},{4,182},
  {4,186},{4,190},{4,194},{4,198},{4,202},
  {4,206},{4,210},{4,214},{4,218},{4,222},
  {4,226},{4,230},{4,234},{4,238},{4,242},
  {4,246},{4,250},{4,254},{4,258},{4,262},
  {4,266},{4,270},{4,274},{4,278},{4,282},
  {4,286},{4,290},{4,294},{4,298},{4,302},
  {4,306},{4,310},{4,314},{4,318},{4,322},
  {4,326},{4,330},{4,334},{4,338},{4,342},
  {4,346},{4,350},{4,354},{4,358},{4,362},
  {4,366},{4,370},{4,374},{4,378},{4,382},
  {4,386},{4,390},{4,394},{4,398},{4,402},
  {4,406},{4,410},{4,414},{4,418},{4,422},
  {4,426},{4,430},{4,434},{4,438},{4,442},
  {4,446},{4,450},{4,454},{4,458},{4,462},
  {4,466},{4,470},{4,474},{4,478},{4,482},
  {4,486},{4,490},{4,494},{4,498},{4,502},
  {4,506},{4,510},{4,514},{4,518},{3,522},
  {4,525},{4,529},{4,533},{3,537},{4,540},
  {4,544},{4,548},{4,552},{4,556},{4,560}};

static int mfhei[PALM_NHE] =
 {0,1,2,3,4,5,6,27,26,25,24,23,22,21,7,41,
  14,28,8,35,15,29,9,36,16,30,10,37,17,31,11,38,
  18,32,12,39,19,33,13,40,20,34,42,57,43,44,46,45,
  47,48,50,49,51,52,54,53,55,56,58,73,59,60,62,61,
  63,64,66,65,67,68,70,69,71,72,74,89,75,76,78,77,
  79,80,82,81,83,84,86,85,87,88,90,105,91,92,94,93,
  95,96,98,97,99,100,102,101,103,104,106,121,107,108,110,109,
  111,112,114,113,115,116,118,117,119,120,122,137,123,124,126,125,
  127,128,130,129,131,132,134,133,135,136,138,153,139,140,142,141,
  143,144,146,145,147,148,150,149,151,152,154,169,155,156,158,157,
  159,160,162,161,163,164,166,165,167,168,170,185,171,172,174,173,
  175,176,178,177,179,180,182,181,183,184,186,201,187,188,190,189,
  191,192,194,193,195,196,198,197,199,200,202,217,203,204,206,205,
  207,208,210,209,211,212,214,213,215,216,218,233,219,220,222,221,
  223,224,226,225,227,228,230,229,231,232,234,249,235,236,238,237,
  239,240,242,241,243,244,246,245,247,248,250,265,251,252,254,253,
  255,256,258,257,259,260,262,261,263,264,266,281,267,268,270,269,
  271,272,274,273,275,276,278,277,279,280,282,297,283,284,286,285,
  287,288,290,289,291,292,294,293,295,296,298,313,299,300,302,301,
  303,304,306,305,307,308,310,309,311,312,314,329,315,316,318,317,
  319,320,322,321,323,324,326,325,327,328,330,345,331,332,334,333,
  335,336,338,337,339,340,342,341,343,344,346,361,347,348,350,349,
  351,352,354,353,355,356,358,357,359,360,362,377,363,364,366,365,
  367,368,370,369,371,372,374,373,375,376,378,393,379,380,382,381,
  383,384,386,385,387,388,390,389,391,392,394,409,395,396,398,397,
  399,400,402,401,403,404,406,405,407,408,410,425,411,412,414,413,
  415,416,418,417,419,420,422,421,423,424,426,441,427,428,430,429,
  431,432,434,433,435,436,438,437,439,440,442,457,443,444,446,445,
  447,448,450,449,451,452,454,453,455,456,458,473,459,460,462,461,
  463,464,466,465,467,468,470,469,471,472,474,489,475,476,478,477,
  479,480,482,481,483,484,486,485,487,488,490,505,491,492,494,493,
  495,496,498,497,499,500,502,501,503,504,506,521,507,508,510,509,
  511,512,514,513,515,516,518,517,519,520,522,523,524,525,526,527,
  528,529,530,531,532,533,534,535,536,537,538,539,540,563,541,542,
  544,543,545,546,548,547,549,550,552,551,553,554,556,555,557,558,
  560,559,561,562};

GPUmesh *EnterPalmToGPU ( void )
{
  CPUmesh cpalm;
  GPUmesh *gpalm;

  if ( !(gpalm = malloc ( sizeof(GPUmesh) )) )
    return NULL;
  memset ( gpalm, 0, sizeof(GPUmesh) );
  cpalm.nsattr = cpalm.pdim = 3;  cpalm.pofs = 0;  cpalm.nvofs = -1;
  cpalm.nv = PALM_NV;  cpalm.nhe = PALM_NHE;  cpalm.nfac = PALM_NFAC;
  cpalm.mv = mv;  cpalm.mhe = mhe;  cpalm.mfac = mfac;
  cpalm.mvhei = mvhei;  cpalm.mfhei = mfhei;  cpalm.vc = &vc[0][0];
  if ( CPUmeshToGPU ( &cpalm, gpalm ) )
    return gpalm;
  else {
    free ( gpalm );
    return NULL;
  }
} /*EnterPalmToGPU*/

