
typedef struct {
    char degree;
    int  firsthalfedge;
  } BSMfacet, BSMvertex;

typedef struct {
    int v0, v1;
    int facetnum;
    int otherhalf;
  } BSMhalfedge;

typedef struct CPUmesh {
    int         nsattr, pdim, pofs, nvofs;
    int         nv, nhe, nfac;
    BSMvertex   *mv;
    BSMhalfedge *mhe;
    BSMfacet    *mfac;
    int         *mvhei, *mfhei;
    float       *vc;
  } CPUmesh;

typedef struct GPUmesh {
    int    nsattr, pdim, pofs, nvofs;
    int    nv, nhe, nfac;
    GLuint mbuf[4];
  } GPUmesh;

GLuint GetAccessToMeshSurfBlock ( GLuint program_id );
void UploadMeshParams ( GPUmesh *gmesh );
void SetMeshColour ( GPUmesh *gmesh, GLfloat Colour[3] );
void SetMeshNVS ( GPUmesh *gmesh, GLint nvs );

char ReallocGPUmesh ( GPUmesh *gmesh, int nv, int nhe, int nfac, int nsattr,
                      int pdim, int pofs, int nvofs );
char ReallocCPUmesh ( CPUmesh *cmesh, int nv, int nhe, int nfac, int nsattr,
                      int pdim, int pofs, int nvofs );
void FreeCPUmeshTab ( CPUmesh *cmesh );
char CPUmeshToGPU ( CPUmesh *cmesh, GPUmesh *gmesh );
char GPUmeshToCPU ( GPUmesh *gmesh, CPUmesh *cmesh );
void DeleteCPUmesh ( CPUmesh *cmesh );
void DeleteGPUmesh ( GPUmesh *gmesh );


void LoadMeshRefinementProgram ( void );
void DeleteMeshRefinementProgram ( void );
char GPUmeshDoubling ( GPUmesh *inmesh, GPUmesh *outmesh );
char GPUmeshAveraging ( GPUmesh *inmesh, GPUmesh *outmesh );
char GPUmeshRefinement ( int n, GPUmesh *inmesh, GPUmesh *outmesh );

typedef struct {
    GPUmesh *cm, *fm;
    GLuint  rc, a;
    GLuint  m, n, nnz, lmax;
  } MeshRefineMatrix;

void LoadMeshRefinementMatrixProgram ( void );
void DeleteMeshRefinementMatrixProgram ( void );
char GPUmeshDoublingMatrix ( GPUmesh *inmesh, GPUmesh *outmesh,
                             MeshRefineMatrix *mm );
char GPUmeshAveragingMatrix ( GPUmesh *inmesh, GPUmesh *outmesh,
                              MeshRefineMatrix *mm );
char GPUmeshRefinementMatrix ( int n, GPUmesh *inmesh, GPUmesh *outmesh,
                               MeshRefineMatrix *mm );
void GPUMatrixRefineMesh ( MeshRefineMatrix *mm );
void GPUDeleteMeshRefinementMatrix ( MeshRefineMatrix *mm );


void LoadMeshNormalVectorProgram ( void );
void DeleteMeshNormalVectorProgram ( void );

void ComputeMeshNormalVectors ( GPUmesh *mesh, int nsattr, int nvofs );

