#version 450 core

layout(location=0) in vec4 in_Position;
layout(location=1) in vec4 in_Normal;

uniform TransBlock {
    mat4 mm, mmti, vm, pm, vpm;
    vec4 eyepos;
  } trb;

layout(location=0) out vec2 TexCoord;

void main ( void )
{
  switch ( gl_VertexID ) {
default: TexCoord = vec2 ( 0.0, 0.0 );  break;
 case 1: TexCoord = vec2 ( 1.0, 0.0 );  break;
 case 2: TexCoord = vec2 ( 1.0, 1.0 );  break;
 case 3: TexCoord = vec2 ( 0.0, 1.0 );  break;
  }
  gl_Position = trb.vpm * (trb.mm * in_Position);
} /*main*/
