#version 450 core

layout(local_size_x=1) in;

layout(std430,binding=0) buffer CPoints { float cp[]; } cpin;

layout(std430,binding=1) buffer CPointsOut { float cp[]; } cpout;

layout(std430,binding=2) buffer Tr { mat4 tr[]; } cptr;

layout(std430,binding=3) buffer TrInd { uint ind[]; } cptrind;

uniform int dim, ncp, trnum;

void main ( void )
{
  uint i, k;
  vec4 v0, v1;

  i = gl_GlobalInvocationID.x;
  k = dim*i;
  i = trnum >= 0 ? trnum : cptrind.ind[i];
  switch ( dim ) {
case 3:
    v0 = vec4 ( cpin.cp[k], cpin.cp[k+1], cpin.cp[k+2], 1.0 );
    v1 = cptr.tr[i]*v0;
    cpout.cp[k] = v1.x;  cpout.cp[k+1] = v1.y;  cpout.cp[k+2] = v1.z;
    break;
case 4:
    v0 = vec4 ( cpin.cp[k], cpin.cp[k+1], cpin.cp[k+2], cpin.cp[k+3] );
    v1 = cptr.tr[i]*v0;
    cpout.cp[k] = v1.x;   cpout.cp[k+1] = v1.y;
    cpout.cp[k+2] = v1.z; cpout.cp[k+3] = v1.w;
    break;
default:
    break;
  }
} /*main*/
