#version 420

layout(location=0) in vec4 in_Position;
layout(location=1) in vec3 in_Colour;

out Vertex {
  vec3 Colour;
  vec3 Position;
} Out;

uniform TransBlock {
    mat4 mm, mmti, vm, pm, vpm;
    vec4 eyepos;
  } trb;

void main ( void )
{
  vec4 Pos;

  Pos = trb.mm * in_Position;
  gl_Position = trb.vpm * Pos;
  Out.Position = Pos.xyz / Pos.w;
  Out.Colour = in_Colour;
} /*main*/
