#include <stdlib.h>
#include <stdio.h>
#include "../utilities/openglheader.h"   /* najpierw ten */
#include <GL/freeglut.h>  /* potem ten */

#include "../utilities/utilities.h"
#include "../utilities/linkage.h"
#include "lights.h"
#include "trans.h"
#include "../utilities/mygltext.h"
#include "app1e.h"
#include "app1eproc.h"

#define STATE_NOTHING 0
#define STATE_TURNING 1

int  WindowHandle;
int  last_xi, last_eta;
int  opti = 0;
int  app_state = STATE_NOTHING;
char animate = false;

void ReshapeFunc ( int width, int height )
{
  ResizeMyWorld ( width, height );
  opti = 4;
} /*ReshapeFunc*/

void DisplayFunc ( void )
{
  if ( opti > 0 ) {
    opti --;
    glutPostWindowRedisplay ( WindowHandle );
  }
  else
    RedrawMyWorld ( app_state == STATE_TURNING );
  glutSwapBuffers ();
} /*DisplayFunc*/

void MouseFunc ( int button, int state, int x, int y )
{
  switch ( button ) {
case GLUT_LEFT_BUTTON:
    switch ( app_state ) {
  case STATE_NOTHING:
      if ( state == GLUT_DOWN ) {
        last_xi = x,  last_eta = y;
        app_state = STATE_TURNING;
        glutPostWindowRedisplay ( WindowHandle );
      }
      break;
  case STATE_TURNING:
      if ( state != GLUT_DOWN ) {
        app_state = STATE_NOTHING;
        glutPostWindowRedisplay ( WindowHandle );
      }
      break;
  default:
      break;
    }
    break;
case GLUT_LEFT_BUTTON+3:
    if ( state == GLUT_DOWN && ChangeZoom ( true ) )
      glutPostWindowRedisplay ( WindowHandle );
    break;
case GLUT_LEFT_BUTTON+4:
    if ( state == GLUT_DOWN && ChangeZoom ( false ) )
      glutPostWindowRedisplay ( WindowHandle );
    break;
default:
    break;
  }
} /*MouseFunc*/

void MotionFunc ( int x, int y )
{
  switch ( app_state ) {
case STATE_TURNING:
    if ( x != last_xi || y != last_eta ) {
      RotateViewer ( x-last_xi, y-last_eta );
      last_xi = x,  last_eta = y;
      glutPostWindowRedisplay ( WindowHandle );
    }
    break;
default:
    break;
  }
} /*MotionFunc*/

void IdleFunc ( void )
{
  if ( MoveOn () )
    glutPostWindowRedisplay ( WindowHandle );
} /*IdleFunc*/

void ToggleAnimation ( void )
{
  if ( (animate = !animate) ) {
    TimerTic ();
    glutIdleFunc ( IdleFunc );
  }
  else
    glutIdleFunc ( NULL );
} /*ToggleAnimation*/

void Cleanup ( void )
{
  DeleteMyWorld ();
  glutDestroyWindow ( WindowHandle );
} /*Cleanup*/

void KeyboardFunc ( unsigned char key, int x, int y )
{
  switch ( key ) {
case 0x1B:            /* klawisz Esc - zatrzymanie programu */
    Cleanup ();
    glutLeaveMainLoop ();
    break;
case ' ':
    ToggleAnimation ();
    break;
default:
    if ( ProcessCharCommand ( key ) )
      glutPostWindowRedisplay ( WindowHandle );
    break;
  }
} /*KeyboardFunc*/

void JoystickFunc ( unsigned int buttonmask, int x, int y, int z ) { }
void TimerFunc ( int value ) {  }

void Initialise ( int argc, char *argv[] )
{
  glutInit ( &argc, argv );
  glutInitContextVersion ( 2, 1 );
  glutInitContextFlags ( GLUT_FORWARD_COMPATIBLE );
  glutInitContextProfile ( GLUT_CORE_PROFILE );
  glutSetOption ( GLUT_ACTION_ON_WINDOW_CLOSE,
                  GLUT_ACTION_GLUTMAINLOOP_RETURNS );
  glutInitWindowSize ( 480, 360 );
  glutInitDisplayMode ( GLUT_DEPTH | GLUT_DOUBLE | GLUT_RGBA );
  WindowHandle = glutCreateWindow ( "aplikacja 1E" );
  if ( WindowHandle < 1 ) {
    fprintf ( stderr, "Error: Could not create a window\n" );
    exit ( 1 );
  }
  GetGLProcAddresses ( APP1E_GL_MAJOR, APP1E_GL_MINOR );
  PrintGLVersion ();
  glutReshapeFunc ( ReshapeFunc );
  glutDisplayFunc ( DisplayFunc );
  glutKeyboardFunc ( KeyboardFunc );
  glutMouseFunc ( MouseFunc );
  glutMotionFunc ( MotionFunc );
  /*glutJoystickFunc ( JoystickFunc, 16 );*/
  /*glutTimerFunc ( 0, TimerFunc, 0 );*/
  InitMyWorld ( argc, argv, 480, 360 );
} /*Initialise*/

int main ( int argc, char *argv[] )
{
  Initialise ( argc, argv );
  glutMainLoop ();
  exit ( 0 );
} /*main*/
