#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "../utilities/openglheader.h"

#include "../utilities/utilities.h"
#include "lights.h"

#define NLSUOFFS 7

static GLuint lsbbp = GL_INVALID_INDEX;
static GLint  lsbsize, lsbofs[NLSUOFFS];

static const GLchar *ULSNames[] =
  { "LSBlock", "LSBlock.nls", "LSBlock.mask",
    "LSBlock.ls[0].ambient", "LSBlock.ls[0].direct", "LSBlock.ls[0].position",
    "LSBlock.ls[0].attenuation", "LSBlock.ls[1].ambient" };

GLuint GetAccessToLightBlockUniform ( GLuint program_id )
{
  if ( lsbbp == GL_INVALID_INDEX )
    GetAccessToUniformBlock ( program_id, NLSUOFFS, &ULSNames[0],
                              &lsbsize, lsbofs, &lsbbp );
  else
    AttachUniformBlockToBP ( program_id, ULSNames[0], lsbbp );
  return lsbbp;
} /*GetAccessToLightBlockUniform*/

GLuint NewUniformLightBlock ( void )
{
  return NewUniformBuffer ( lsbsize, lsbbp );
} /*NewUniformLightBlock*/

void AttachUniformLightBlockToBP ( GLuint program_id )
{
  AttachUniformBlockToBP ( program_id, ULSNames[0], lsbbp );
} /*AttachUniformLightBlockToBP*/

void SetLightAmbient ( LightBl *light, int l, GLfloat amb[3] )
{
  GLint ofs;

  if ( l < 0 || l >= MAX_NLIGHTS )
    return;
  memcpy ( light->ls[l].ambient, amb, 3*sizeof(GLfloat) );
  ofs = l*(lsbofs[6]-lsbofs[2]) + lsbofs[2];
  glBindBuffer ( GL_UNIFORM_BUFFER, light->lsbuf );
  glBufferSubData ( GL_UNIFORM_BUFFER, ofs, 3*sizeof(GLfloat), amb );
  ExitIfGLError ( "SetLightAmbient" );
} /*SetLightAmbient*/

void SetLightDirect ( LightBl *light, int l, GLfloat dir[3] )
{
  GLint ofs;

  if ( l < 0 || l >= MAX_NLIGHTS )
    return;
  memcpy ( light->ls[l].direct, dir, 3*sizeof(GLfloat) );
  ofs = l*(lsbofs[6]-lsbofs[2]) + lsbofs[3];
  glBindBuffer ( GL_UNIFORM_BUFFER, light->lsbuf );
  glBufferSubData ( GL_UNIFORM_BUFFER, ofs, 3*sizeof(GLfloat), dir );
  ExitIfGLError ( "SetLightDirect" );
} /*SetLightDirect*/

void SetLightPosition ( LightBl *light, int l, GLfloat pos[4] )
{
  GLint   ofs;
  GLfloat w, *p;

  if ( l < 0 || l >= MAX_NLIGHTS )
    return;
  memcpy ( p = light->ls[l].position, pos, 4*sizeof(GLfloat) );
  w = p[3];
  if ( w != 0.0 && w != 1.0 )
    p[0] /= w, p[1] /= w, p[2] /= w, p[3] = 1.0;
  ofs = l*(lsbofs[6]-lsbofs[2]) + lsbofs[4];
  glBindBuffer ( GL_UNIFORM_BUFFER, light->lsbuf );
  glBufferSubData ( GL_UNIFORM_BUFFER, ofs, 4*sizeof(GLfloat), p );
  ExitIfGLError ( "SetLightPosition" );
} /*SetLightPosition*/

void SetLightAttenuation ( LightBl *light, int l, GLfloat atn[3] )
{
  GLint ofs;

  if ( l < 0 || l >= MAX_NLIGHTS )
    return;
  memcpy ( light->ls[l].attenuation, atn, 3*sizeof(GLfloat) );
  ofs = l*(lsbofs[6]-lsbofs[2]) + lsbofs[5];
  glBindBuffer ( GL_UNIFORM_BUFFER, light->lsbuf );
  glBufferSubData ( GL_UNIFORM_BUFFER, ofs, 3*sizeof(GLfloat), atn );
  ExitIfGLError ( "SetLightAttenuation" );
} /*SetLightAttenuation*/

void SetLightOnOff ( LightBl *light, int l, char on )
{
  GLuint mask;

  if ( l < 0 || l >= MAX_NLIGHTS )
    return;
  mask = 0x01 << l;
  if ( on ) {
    light->mask |= mask;
    if ( l >= light->nls )
      light->nls = l+1;
  }
  else {
    light->mask &= ~mask;
    for ( mask = 0x01 << (light->nls-1); mask; mask >>= 1 ) {
      if ( light->mask & mask )
        break;
      else
        light->nls --;
    }
  }
  glBindBuffer ( GL_UNIFORM_BUFFER, light->lsbuf );
  glBufferSubData ( GL_UNIFORM_BUFFER, lsbofs[0], sizeof(GLuint), &light->nls );
  glBufferSubData ( GL_UNIFORM_BUFFER, lsbofs[1], sizeof(GLuint), &light->mask );
  ExitIfGLError ( "SetLightOnOff" );
} /*SetLightOnOff*/

