```markdown
# Fuzzy Interpretation Minimization

**Author:** Linh Anh Nguyen  
**Email:** nguyen@mimuw.edu.pl  
**Last version:** 2025-06-28  

This package provides an implementation of **Algorithm 2** from the paper:

> *Approximate minimization of interpretations in fuzzy description logics under the Gödel semantics*  
> by Linh Anh Nguyen.

---

## 1. Requirements

- Python 3

---

## 2. Input Format

- A line in the form:

```

o a

```

means the individual name `o` is associated with the domain element `a`.

- A line in the form:

```

a c d

```

for example:

```

a c 0.7

```

means the domain element `a` is an instance of the concept `c` with degree `d` (a number).

- A line in the form:

```

a b r d

```

for example:

```

a b r 0.6

````

means the pair ⟨a, b⟩ is an instance of the role `r` with degree `d`.

**Notes:**
- Names (of concepts, roles, individuals, and domain elements) can be numbers.
- Individual names should differ from concept names.
- Role names should **not** end with a minus sign (reserved for inverse roles).

**Examples** of input files are included in the package.

---

## 3. Output Format

The output format is identical to the input format.

---

## 4. Running the Program `fuzzyMinG.py`

```bash
python3 fuzzyMinG.py [options] < input_file
````

### Options:

* `gamma=value` – a real number from (0,1]; default is 1
* `withI` – enable inverse roles
* `withO` – enable nominals
* `verbose` – enable verbose mode

**Example usage** is shown in the file `examples.sh`.

---

## 5. Running Experiments

```bash
python3 experiments.py
```

---

```
