signature MY_TEXT_WIDGET =
  sig

    type text_widget

    val mkTextWidget : Widget.root -> {rows : int, cols : int} -> text_widget

    val widgetOf   : text_widget -> Widget.widget

    val scrollUp    : text_widget-> unit
    val scrollDown  : text_widget-> unit
    val scrollLeft  : text_widget-> unit
    val scrollRight : text_widget-> unit

    val insertText : text_widget -> string list -> unit

    val onClickEvt : text_widget -> string CML.event

  end (* MY_TEXT_WIDGET *)

signature SCROLLABLE_TEXT =
  sig

    type scroll_text

    val mkScrollableTextWidget: Widget.root -> {rows: int, cols: int} -> scroll_text

    val widgetOf: scroll_text -> Widget.widget

    val insertText: scroll_text -> string list -> unit

    val onClickEvt: scroll_text -> string CML.event

  end (* SCROLLABLE_TEXT *)

