structure StepsShell:
     sig
       structure W: WIDGET
       type steps_shell
       val mkStepsShell: (W.root * W.view * W.arg list) ->
                         (string * (string list * string list * string list * bool)) ->
                         ((string -> unit) -> unit -> unit) ->
                         ((string -> unit) -> unit -> unit) ->
                         (unit -> unit) ->
                         (string -> unit) ->
                         string
                         -> steps_shell
       val shellOf: steps_shell -> Shell.shell
       val stepOf: steps_shell -> string
       val show: steps_shell -> (string * (string list * string list * string list * bool)) -> steps_shell
       val clear: steps_shell -> steps_shell
       val changes: steps_shell -> string list * bool
     end =
struct
  open CommonFuns
  structure W = Widget
  structure A = Attrs

  type steps_shell = string *
                     Shell.shell * Label.label *
                     (ScrollableText.scroll_text *
                      ScrollableText.scroll_text *
                      ScrollableText.scroll_text *
                      Toggle.toggle)

  fun show_first ([]) (Lmemo, Rmemo, Pmemo, checkBox) = 
         (showInMemo [] Lmemo;
          showInMemo [] Rmemo;
          (*showInMemo [] Pmemo;*)
          Toggle.setState (checkBox, false))
    | show_first ((l, r, p, ok)::rest) (Lmemo, Rmemo, Pmemo, checkBox) =
         (showInMemo l Lmemo;
          showInMemo r Rmemo;
          (*showInMemo p Pmemo;*)
          Toggle.setState (checkBox, ok))


  fun changes (_, _, _, (l, r, p, ok)) = ([], Toggle.getState ok)
  fun shellOf (_, shell, _, _) = shell
  fun stepOf (name, _, _, _) = name


  fun show (_, shell, label, widgts)  (name, ob) =
              ((*Label.setLabel label (Label.Text name);*)
               show_first [ob] widgts;
               (name, shell, label, widgts))
  fun clear (_, shell, label, widgts) = 
              ((*Label.setLabel label (Label.Text "");*)
               show_first [] widgts;
               ("", shell, label, widgts))

  fun do_checkBox on = ()

  fun mkStepsShell (root, view, args) nb do_next_oblig do_next_to_proof closeFn openSigShell progress_info =
        let

          val label = Label.label (root, view, [])
              (*val _ = Label.setBackground SIGlabel white*)

          fun show_progress str = 
               let
                 val _ = Label.setLabel label (Label.Text str)
               in
                 ()
               end

          val _ = show_progress progress_info

          val Llabel = Label.label (root, view, [])
          val _ = Label.setLabel Llabel (Label.Text("Implementation"))
          val Rlabel = Label.label (root, view, [])
          val _ = Label.setLabel Rlabel (Label.Text("Specification"))
          val Plabel = Label.label (root, view, [])
          val _ = Label.setLabel Plabel (Label.Text("PROOF"))

          val Lmemo = ScrollableText.mkScrollableTextWidget root
                            {
                              rows=15,
                              cols=80
                            }
          val LmemoF = Frame.mkFrame {color=SOME (black root), width=1, widget=ScrollableText.widgetOf Lmemo}
          val Rmemo = ScrollableText.mkScrollableTextWidget root
                            {
                              rows=15,
                              cols=80
                            }
          val RmemoF = Frame.mkFrame {color=SOME (black root), width=1, widget=ScrollableText.widgetOf Rmemo}
          val Pmemo = ScrollableText.mkScrollableTextWidget root
                            {
                              rows=5,
                              cols=80
                            }
          val PmemoF = Frame.mkFrame {color=SOME (black root), width=1, widget=ScrollableText.widgetOf Pmemo}

          val checkBox = Toggle.checkButton (root, view, [(A.attr_label, A.AV_Str "  q. e. d.  ")])
                            do_checkBox
          val fix_checkBox = Shape.mkRigid (Toggle.widgetOf checkBox)

          val nextBttn = Button.textCmd
                             (root, view, [(A.attr_label, A.AV_Str "  next  ")])
                             (do_next_oblig show_progress)
          val fix_nextBttn = Shape.mkRigid (Button.widgetOf nextBttn)

          val nextTPBttn = Button.textCmd
                             (root, view, [(A.attr_label, A.AV_Str "  next to proof  ")])
                             (do_next_to_proof show_progress)
          val fix_nextTPBttn = Shape.mkRigid (Button.widgetOf nextTPBttn)

          val closeBtn = Button.textCmd
                          (root, view, [(A.attr_label, A.AV_Str "  close  ")])
                          closeFn
          val fix_closeBtn = Shape.mkRigid (Button.widgetOf closeBtn)

          val layout = Box.mkLayout root (Box.VtLeft [
                            Box.WBox (Label.widgetOf label),
                            Box.WBox (Label.widgetOf Llabel),
                            Box.WBox (Frame.widgetOf LmemoF),
                            Box.WBox (Label.widgetOf Rlabel),
                            Box.WBox (Frame.widgetOf RmemoF),
                            (*Box.WBox (Label.widgetOf Plabel),
                            Box.WBox (Frame.widgetOf PmemoF),*)
                            Box.WBox (fix_checkBox),
                            Box.HzCenter [
                                          Box.WBox (fix_nextBttn),
                                          Box.WBox (fix_nextTPBttn)
                                         ],
                            Box.WBox (fix_closeBtn)
                                                     ])

          val shell = Shell.shell (root, view, args) (Box.widgetOf layout)

          fun loop () =
            let
              fun handleOnClick s = openSigShell s
            in
              CML.sync (CML.choose [CML.wrap (ScrollableText.onClickEvt Lmemo, handleOnClick),
                                    CML.wrap (ScrollableText.onClickEvt Rmemo, handleOnClick)(*,
                                    CML.wrap (ScrollableText.onClickEvt Pmemo, handleOnClick)*)]);
              loop ()
            end
        in
          Shell.init shell;
          CML.spawn loop;
          show ("", shell, label, (Lmemo, Rmemo, Pmemo, checkBox)) nb
        end
end;
