structure SigsShell:
     sig
       structure W: WIDGET
       type sigs_shell
       val mkSigsShell: (W.root * W.view * W.arg list) -> (string * string list) ->
                        (unit -> unit) ->
                        (string -> unit)
                         -> sigs_shell
       val shellOf: sigs_shell -> Shell.shell
       val signatureOf: sigs_shell -> string
       val show: sigs_shell -> (string * string list) -> sigs_shell
       val clear: sigs_shell -> sigs_shell
     end =
struct
  open CommonFuns
  structure W = Widget
  structure A = Attrs

  type sigs_shell = string * Shell.shell * Label.label * ScrollableText.scroll_text

  fun shellOf (_, shell, _, _) = shell
  fun signatureOf (name, _, _, _) = name
  fun show (_, shell, label, memo)  (name, body) =
              (Label.setLabel label (Label.Text name);
               showInMemo body memo;
               (name, shell, label, memo))
  fun clear (_, shell, label, memo) =
              (Label.setLabel label (Label.Text "");
               (*TextWidget.clear memo;*)
               ("", shell, label, memo))

  fun mkSigsShell (root, view, args) nb closeFn openSigShell =
        let

          val label = Label.label (root, view, [])
              (*val _ = Label.setBackground SIGlabel white*)
          val memo = ScrollableText.mkScrollableTextWidget root
                            {
                              rows=20,
                              cols=80
                            }
          val memoF = Frame.mkFrame {color=SOME (black root), width=1, widget=ScrollableText.widgetOf memo}
          val closeBtn = Button.textCmd
                          (root, view, [(A.attr_label, A.AV_Str "  close  ")])
                          closeFn

          val rigClose = Box.HzTop [Box.WBox (Button.widgetOf closeBtn),
                                       Box.Glue {nat=9,min=5,max=SOME(10)}]

          val closeRig = Shape.mkRigid (Button.widgetOf closeBtn)
          val layout = Box.mkLayout root (Box.VtLeft [
                            (*Box.WBox (Label.widgetOf label),*)
                            Box.WBox (Frame.widgetOf memoF),
                            (*Box.WBox (Button.widgetOf closeBtn)*)
                            Box.WBox (closeRig)
                                                     ])
          val shell = Shell.shell (root, view, args) (Box.widgetOf layout)

          fun loop () =
            let
              fun handleOnClick s = openSigShell s
            in
              CML.sync (CML.choose [CML.wrap (ScrollableText.onClickEvt memo, handleOnClick)]);
              loop ()
            end
        in
          Shell.init shell;
          CML.spawn loop;
          show ("", shell, label, memo) nb
        end
end;
