signature OBLIGS_STREAM =
sig
  val run: string -> string list
end;

local

structure ObligsStreamFromEMLKit: OBLIGS_STREAM =
struct
  fun doit ogen fN ref_ls = let
	val proc = Unix.execute (ogen, [])
	val (fin,fout) = Unix.streamsOf proc
	fun echo ls = (case TextIO.inputLine fin
	       of "" => ls
		| s =>
		     let
		       val ll = (!ls)
		     in
		      (TextIO.output(TextIO.stdOut, s); ls := (ll @ [s]); echo (ls))
		     end
	      (* end case *))
        in
          TextIO.output (fout, "use \"" ^ fN ^ "\"");
	  TextIO.closeOut fout;
	  echo ref_ls;
	  TextIO.closeIn fin;
	  ignore(Unix.reap proc);
	  ()
        end

  fun run fN = 
         let
           val ls = ref []
           val (defined, ogen) = case OS.Process.getEnv "OBLIGS_GEN" of
                                   NONE => (false, "")
                                 | SOME s => (true, s)
         in
            if defined then 
              (doit ogen fN ls)
            else
              (TextIO.print "\n\nDefine environment variable OBLIGS_GEN\n e.g. OBLIGS_GEN=/eml11/src/emlkit\n\n");
            (!ls)
         end
end

in
  structure ObligsStream = ObligsStreamFromEMLKit;
end;
