structure Main : 
  sig
    val doit' : string list * string -> unit
    val doit : unit -> unit
    val main : (string * string list) -> OS.Process.status
  end = 
  struct
    structure W = Widget
    structure A = Attrs

    val resources = [
        "*background: forestgreen"
      ]

    fun goodbye root = let
          val mgrs = ref (0, [])
          
          fun quitMgr n =
              let
                fun quit n [] = []
                  | quit n ((n', mgr)::rest) =
                      if n = n' then (Shell.destroy (ObligsMgrShell.shellOf mgr); rest)
                      else (n', mgr)::(quit n rest)
                      
                val (next, shells) = (!mgrs)
                val new_shells = quit n shells
              in
                mgrs := (next, shells)
              end

          fun quit () =
               let
                 val (next, shells) = (!mgrs)
                 fun qall [] = ()
                   | qall ((n, s)::rest) = (quitMgr n; qall rest)
               in
                 W.delRoot root; 
                 RunCML.shutdown(1)
               end

          val style = W.styleFromStrings (root, resources)
          val name = Styles.mkView {name = Styles.styleName [],
                                    aliases = [Styles.styleName []]}
          val view = (name,style)
          val args = [(A.attr_label, A.AV_Str "quit all")]
          val bttn = Button.textCmd (root,view,args) quit


          val white = Widget.EXB.whiteOfScr (Root.screenOf root) 
          val black = Widget.EXB.blackOfScr (Root.screenOf root) 
         
          val FNlabel = Label.label (root, view, [])
          val _ = Label.setLabel FNlabel (Label.Text("File name"))
          val _ = Label.setBackground FNlabel white
          val FNedit = FieldEdit.mkFieldEdit root 
                     { foregrnd=NONE,
                       backgrnd=SOME(white),
                       initval="",
                       minlen=20
                     } 


          fun generate () =
            let
              val fileName = FieldEdit.getString FNedit
              val res = MyGenerator.generate [fileName]
            in
              case res of
                SOME (ks, ps) =>
                  let
                    val (next, shells) = (!mgrs)
                    val shell = ObligsMgrShell.mkObligsMgrShell 
                                     (root, view, []) ks ps 
                                     (fn () => quitMgr next) fileName
                  in
                    mgrs := (next+1, (next, shell)::shells)
                  end
              | NONE => ()    (* mayby: File not found or Elaboration failure *)
            end
            
          val args = [(A.attr_label, A.AV_Str "Generate obligations")]
          val GENbttn = Button.textCmd (root,view,args) generate

          val layout = Box.layout (root, view, []) (Box.VtLeft
               [Box.WBox(Label.widgetOf FNlabel),
                Box.WBox(FieldEdit.widgetOf FNedit),
                Box.Glue {nat=5,min=0,max=NONE},
                Box.WBox(Button.widgetOf GENbttn),
                Box.Glue {nat=5,min=0,max=NONE},
                Box.WBox (Button.widgetOf bttn)])
         
          val args = [(A.attr_title, A.AV_Str "GPP"),
                      (A.attr_title, A.AV_Str "GPP")]
          val shell = Shell.shell (root,view,args) (Box.widgetOf layout)
          fun loop () =
                if (TextIO.inputLine TextIO.stdIn) = "quit\n"
                  then quit ()
                  else loop ()
          in
            Shell.init shell;
            loop ()
          end
  
    fun doit' (debugFlags, server) = (
          XDebug.init debugFlags;
          RunEXene.runWArgs goodbye {dpy= SOME server,timeq=NONE}
        )
  
    fun doit () = RunEXene.run goodbye
  
    fun main (_, prog::server::_) = (doit'([], server); OS.Process.success)
      | main _ = (doit (); OS.Process.success)
  
  end (* Main *)
