require "MLYacc_base";
require "Topdec_sig";
require "Vector";
require "Array";
require "String";

functor TopdecLrVals(
           structure Token: TOKEN
           structure LexBasics: LEX_BASICS
           structure GrammarUtils: GRAMMAR_UTILS
             sharing type GrammarUtils.pos = LexBasics.pos
         )
         = 
struct
structure ParserData=
struct
structure Header = 
struct
(* Grammar for top-level declarations.                  NICK, August 1990. *)

(* This version of the grammar is intended to be the final version of
EML-Kit grammar so it will not contain stupid commented out parts *)

(* We have some divergences from the grammar described in the definition
   document. This is because the correct parsing of SML sometimes requires
   left context to be carried a rather horrific distance into the parse.
   In these cases, we parse a slightly more general syntactic form which
   conforms to LR(1), and then knock out the illegal forms in the reduction
   semantic rules.

        (i)     The parser doesn't know about infix status at all. I had a
                bash at doing a preprocessor which attached the correct infix
                status to identifiers, but it was a bit of a nightmare, and
                dealing with "*" and "=" as well became a *lot* of a nightmare.
                So, all application expressions, patterns and so on are
                parsed just as chains of atomic exp's/pat's. Any infixed
                identifiers are resolved later. This means we have to hang
                onto the "op" attached to identifiers, to be aware of the
                difference between

                        f + g

                and

                        f op+ g

        (ii)    This grammar parses `<Pat> as <Pat>', and eliminates illegal
                forms (`<Pat> as ...' where <Pat> is not an <OpId> or
                <OpId> : <Ty>) in the reduction rules. This is because a
                correct parse of

                        fun F(X : ty as ...)

                requires infinite lookahead to determine whether the `X' can
                be reduced to an <AtPat>, or whether there's an `as'-clause
                following the type expression. This could conceivably be
                fixed in the grammar (much like the disambiguating of LOCAL)
                but would add considerable complexity.

        (iii)   <FValBind> function bindings are a nightmare. The expression

                        fun (A infix1 B) infix2 C = ...

                is ambiguous because `A <infix1> B' should be read as two
                infix-separated <AtPat>'s *unless* there's an infix following
                the closing bracket, in which case `A <infix1> B' is part of
                a bracketted <Pat>.

                Because we're resolving infix in a post-pass anyway, this gets
                deferred. The functor Infixing() does all the work - look to
                that for more details.

        (iv)    The grammar actually accepts `op =' in a pattern. This is
                because we want to define equality in terms of the bool type
                declared in the prelude, which precludes us from building `='
                into the initial environment. We reject subsequent declarations
                of `=' during semantic analysis.

                I hate this language.

        (v)     Hey, guess what, I've found another one. Which of the
                following is legal?

                        val rec f = fn x => x: int
                        val rec f = (fn x => x)
                        val rec f = (fn x => x): int -> int

                The Definition is rather political about this (i.e. it
                contradicts itself and doesn't make a commitment one way
                or the other). I've decided to allow the first and third
                alternatives (i.e. `fn match' or `(fn match) : ty') which
                seem to be sort-of in the spirit of the definition. I'm
                making the second form illegal to stop programmers getting
                cocky.

                [MEMO: a couple of remaining bugs. Firstly, nested LOCAL
                 declarations are not handled correctly (see the bug list).
                 Secondly, we aren't lexing the correct tokens for numeric
                 record labels.
                ]

        (vi)    Whoops, just found something else. Semicolon dec/strdec/spec
                separators are difficult to do as per the Definition, since
                they are optional everywhere and they separate optional (i.e.
                possibly empty) phrases. We deal with this by giving ";"
                the same status as the phrase class it serves to separate.
                The `compose' functions from GrammarUtils are to swallow
                empty absyn phrases which can result from this treatment.
                Needless to say, this all means that we can't reconstitute
                semicolons in the source (that would require an abstract
                syntax class for them at least). Tough. Real SML programmers
                don't use semicolons.
 *)

open GrammarUtils GrammarUtils.M GrammarUtils.C LexBasics
type arg = unit


end
structure LrTable = Token.LrTable
structure Token = Token
local open LrTable in 
val table=let val actionRows =
"\
\\001\000\005\000\221\001\070\000\029\000\075\000\024\000\000\000\
\\001\000\005\000\201\002\070\000\029\000\075\000\024\000\000\000\
\\001\000\007\000\138\002\009\000\058\000\010\000\057\000\036\000\137\002\
\\066\000\141\002\070\000\029\000\075\000\024\000\000\000\
\\001\000\007\000\138\002\009\000\058\000\010\000\057\000\036\000\137\002\
\\066\000\008\003\070\000\029\000\075\000\024\000\000\000\
\\001\000\007\000\138\002\009\000\058\000\010\000\057\000\036\000\137\002\
\\066\000\040\003\070\000\029\000\075\000\024\000\000\000\
\\001\000\007\000\138\002\009\000\058\000\010\000\057\000\036\000\137\002\
\\066\000\043\003\070\000\029\000\075\000\024\000\000\000\
\\001\000\007\000\138\002\009\000\058\000\010\000\057\000\036\000\137\002\
\\070\000\029\000\075\000\024\000\000\000\
\\001\000\009\000\058\000\010\000\057\000\014\000\055\000\015\000\054\000\
\\023\000\052\000\029\000\049\000\032\000\047\000\036\000\044\000\
\\040\000\041\000\043\000\039\000\050\000\036\000\051\000\035\000\
\\052\000\108\000\053\000\034\000\055\000\033\000\065\000\032\000\
\\066\000\031\000\069\000\030\000\070\000\029\000\071\000\028\000\
\\072\000\027\000\073\000\026\000\074\000\025\000\075\000\024\000\
\\077\000\023\000\000\000\
\\001\000\009\000\058\000\010\000\057\000\014\000\055\000\015\000\054\000\
\\023\000\052\000\029\000\049\000\032\000\047\000\036\000\044\000\
\\040\000\041\000\043\000\039\000\050\000\036\000\051\000\035\000\
\\053\000\034\000\055\000\033\000\065\000\032\000\066\000\031\000\
\\069\000\030\000\070\000\029\000\071\000\028\000\072\000\027\000\
\\073\000\026\000\074\000\025\000\075\000\024\000\077\000\023\000\000\000\
\\001\000\009\000\058\000\010\000\057\000\014\000\055\000\015\000\054\000\
\\023\000\197\000\029\000\196\000\032\000\195\000\036\000\194\000\
\\040\000\041\000\043\000\193\000\050\000\192\000\051\000\191\000\
\\052\000\108\000\053\000\190\000\055\000\189\000\065\000\032\000\
\\069\000\030\000\070\000\029\000\071\000\028\000\072\000\027\000\
\\073\000\026\000\074\000\025\000\075\000\024\000\077\000\023\000\000\000\
\\001\000\009\000\058\000\010\000\057\000\014\000\055\000\015\000\054\000\
\\023\000\197\000\029\000\196\000\032\000\195\000\036\000\194\000\
\\040\000\041\000\043\000\193\000\050\000\192\000\051\000\191\000\
\\053\000\190\000\055\000\189\000\065\000\032\000\069\000\030\000\
\\070\000\029\000\071\000\028\000\072\000\027\000\073\000\026\000\
\\074\000\025\000\075\000\024\000\077\000\023\000\000\000\
\\001\000\009\000\058\000\010\000\057\000\014\000\055\000\015\000\054\000\
\\023\000\197\000\029\000\196\000\032\000\195\000\036\000\074\002\
\\040\000\041\000\043\000\193\000\050\000\192\000\051\000\191\000\
\\053\000\190\000\055\000\189\000\065\000\032\000\069\000\030\000\
\\070\000\029\000\071\000\028\000\072\000\027\000\073\000\026\000\
\\074\000\025\000\075\000\024\000\077\000\023\000\000\000\
\\001\000\009\000\058\000\010\000\057\000\036\000\217\001\070\000\029\000\
\\075\000\024\000\000\000\
\\001\000\009\000\058\000\010\000\057\000\040\000\041\000\069\000\030\000\
\\070\000\029\000\075\000\024\000\000\000\
\\001\000\009\000\058\000\010\000\057\000\040\000\123\000\044\000\122\000\
\\051\000\121\000\053\000\120\000\055\000\119\000\061\000\118\000\
\\070\000\029\000\071\000\028\000\072\000\027\000\073\000\026\000\
\\074\000\025\000\075\000\024\000\077\000\023\000\000\000\
\\001\000\009\000\058\000\010\000\057\000\040\000\123\000\044\000\028\001\
\\051\000\121\000\053\000\120\000\055\000\119\000\061\000\118\000\
\\070\000\029\000\071\000\028\000\072\000\027\000\073\000\026\000\
\\074\000\025\000\075\000\024\000\077\000\023\000\000\000\
\\001\000\009\000\058\000\010\000\057\000\040\000\123\000\044\000\207\001\
\\051\000\121\000\053\000\120\000\055\000\119\000\061\000\118\000\
\\070\000\029\000\071\000\028\000\072\000\027\000\073\000\026\000\
\\074\000\025\000\075\000\024\000\077\000\023\000\000\000\
\\001\000\009\000\058\000\010\000\057\000\040\000\123\000\044\000\045\002\
\\051\000\121\000\053\000\120\000\055\000\119\000\061\000\118\000\
\\070\000\029\000\071\000\028\000\072\000\027\000\073\000\026\000\
\\074\000\025\000\075\000\024\000\077\000\023\000\000\000\
\\001\000\009\000\058\000\010\000\057\000\040\000\123\000\051\000\121\000\
\\052\000\024\001\053\000\120\000\055\000\119\000\061\000\118\000\
\\070\000\029\000\071\000\028\000\072\000\027\000\073\000\026\000\
\\074\000\025\000\075\000\024\000\077\000\023\000\000\000\
\\001\000\009\000\058\000\010\000\057\000\040\000\123\000\051\000\121\000\
\\053\000\120\000\055\000\119\000\061\000\118\000\070\000\029\000\
\\071\000\028\000\072\000\027\000\073\000\026\000\074\000\025\000\
\\075\000\024\000\077\000\023\000\000\000\
\\001\000\009\000\058\000\010\000\057\000\046\000\080\002\070\000\029\000\
\\075\000\024\000\000\000\
\\001\000\009\000\058\000\010\000\057\000\069\000\134\000\070\000\029\000\
\\075\000\024\000\000\000\
\\001\000\009\000\058\000\010\000\057\000\069\000\029\001\070\000\029\000\
\\075\000\024\000\000\000\
\\001\000\009\000\058\000\010\000\057\000\070\000\029\000\075\000\024\000\000\000\
\\001\000\009\000\217\000\051\000\216\000\055\000\215\000\066\000\010\002\
\\075\000\214\000\076\000\213\000\000\000\
\\001\000\009\000\217\000\051\000\216\000\055\000\215\000\075\000\214\000\
\\076\000\213\000\000\000\
\\001\000\009\000\217\000\075\000\214\000\000\000\
\\001\000\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\024\000\008\001\031\000\067\000\042\000\066\000\058\000\065\000\000\000\
\\001\000\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\026\000\025\002\031\000\067\000\042\000\066\000\058\000\065\000\000\000\
\\001\000\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\026\000\027\002\031\000\067\000\042\000\066\000\058\000\065\000\000\000\
\\001\000\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\027\000\014\002\031\000\067\000\042\000\066\000\058\000\065\000\
\\059\000\000\001\000\000\
\\001\000\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\027\000\018\002\031\000\067\000\042\000\066\000\058\000\065\000\
\\059\000\000\001\000\000\
\\001\000\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\031\000\067\000\039\000\069\001\042\000\066\000\058\000\065\000\000\000\
\\001\000\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\031\000\067\000\042\000\066\000\045\000\047\001\058\000\065\000\000\000\
\\001\000\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\031\000\067\000\042\000\066\000\052\000\002\001\057\000\001\001\
\\058\000\065\000\059\000\000\001\000\000\
\\001\000\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\024\000\009\001\031\000\076\000\
\\042\000\075\000\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\001\000\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\026\000\026\002\031\000\076\000\
\\042\000\075\000\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\001\000\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\026\000\028\002\031\000\076\000\
\\042\000\075\000\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\001\000\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\027\000\015\002\031\000\076\000\
\\042\000\075\000\058\000\074\000\059\000\003\001\067\000\073\000\
\\068\000\072\000\000\000\
\\001\000\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\027\000\019\002\031\000\076\000\
\\042\000\075\000\058\000\074\000\059\000\003\001\067\000\073\000\
\\068\000\072\000\000\000\
\\001\000\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\031\000\076\000\039\000\070\001\
\\042\000\075\000\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\001\000\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\031\000\076\000\042\000\075\000\
\\045\000\048\001\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\001\000\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\031\000\076\000\042\000\075\000\
\\052\000\005\001\057\000\004\001\058\000\074\000\059\000\003\001\
\\067\000\073\000\068\000\072\000\000\000\
\\001\000\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\024\000\204\001\031\000\076\001\
\\042\000\075\001\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\001\000\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\026\000\132\002\031\000\076\001\
\\042\000\075\001\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\001\000\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\027\000\019\002\031\000\076\001\
\\042\000\075\001\058\000\074\000\059\000\202\001\067\000\073\000\
\\068\000\072\000\000\000\
\\001\000\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\031\000\076\001\039\000\213\001\
\\042\000\075\001\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\001\000\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\031\000\076\001\042\000\075\001\
\\045\000\212\001\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\001\000\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\031\000\076\001\042\000\075\001\
\\052\000\005\001\057\000\203\001\058\000\074\000\059\000\202\001\
\\067\000\073\000\068\000\072\000\000\000\
\\001\000\022\000\163\004\056\000\163\004\057\000\163\004\058\000\055\001\
\\069\000\074\003\000\000\
\\001\000\022\000\013\001\052\000\149\001\057\000\148\001\058\000\012\001\000\000\
\\001\000\022\000\013\001\058\000\012\001\063\000\062\001\000\000\
\\001\000\022\000\013\001\058\000\012\001\063\000\074\001\000\000\
\\001\000\022\000\013\001\058\000\012\001\069\000\011\001\000\000\
\\001\000\022\000\013\001\058\000\012\001\069\000\150\001\000\000\
\\001\000\022\000\013\001\058\000\012\001\069\000\043\002\000\000\
\\001\000\022\000\013\001\058\000\012\001\069\000\129\002\000\000\
\\001\000\027\000\012\002\000\000\
\\001\000\027\000\013\002\000\000\
\\001\000\027\000\016\002\000\000\
\\001\000\027\000\017\002\000\000\
\\001\000\027\000\020\002\000\000\
\\001\000\027\000\037\002\000\000\
\\001\000\027\000\038\002\000\000\
\\001\000\027\000\104\002\000\000\
\\001\000\027\000\105\002\000\000\
\\001\000\027\000\106\002\000\000\
\\001\000\027\000\107\002\000\000\
\\001\000\027\000\142\002\000\000\
\\001\000\027\000\185\002\000\000\
\\001\000\027\000\186\002\000\000\
\\001\000\027\000\235\002\000\000\
\\001\000\027\000\236\002\000\000\
\\001\000\027\000\243\002\000\000\
\\001\000\027\000\009\003\000\000\
\\001\000\027\000\014\003\000\000\
\\001\000\027\000\025\003\000\000\
\\001\000\027\000\034\003\000\000\
\\001\000\027\000\035\003\000\000\
\\001\000\027\000\036\003\000\000\
\\001\000\029\000\008\002\051\000\007\002\000\000\
\\001\000\029\000\096\002\000\000\
\\001\000\029\000\189\002\051\000\188\002\000\000\
\\001\000\029\000\229\002\000\000\
\\001\000\033\000\036\001\000\000\
\\001\000\033\000\037\001\000\000\
\\001\000\033\000\040\001\000\000\
\\001\000\033\000\165\001\000\000\
\\001\000\033\000\166\001\000\000\
\\001\000\033\000\205\001\000\000\
\\001\000\033\000\046\002\000\000\
\\001\000\033\000\139\002\000\000\
\\001\000\033\000\148\002\000\000\
\\001\000\033\000\211\002\000\000\
\\001\000\033\000\234\002\000\000\
\\001\000\033\000\248\002\000\000\
\\001\000\033\000\249\002\000\000\
\\001\000\040\000\175\000\070\000\029\000\075\000\024\000\000\000\
\\001\000\048\000\072\001\049\000\071\001\000\000\
\\001\000\048\000\036\002\000\000\
\\001\000\048\000\050\002\049\000\049\002\000\000\
\\001\000\048\000\191\002\000\000\
\\001\000\051\000\105\001\000\000\
\\001\000\052\000\254\000\000\000\
\\001\000\052\000\255\000\000\000\
\\001\000\052\000\006\001\000\000\
\\001\000\052\000\007\001\000\000\
\\001\000\052\000\147\001\000\000\
\\001\000\052\000\154\001\000\000\
\\001\000\052\000\245\001\000\000\
\\001\000\052\000\247\001\057\000\246\001\000\000\
\\001\000\052\000\060\002\000\000\
\\001\000\052\000\194\002\000\000\
\\001\000\052\000\195\002\000\000\
\\001\000\052\000\199\002\000\000\
\\001\000\052\000\223\002\000\000\
\\001\000\052\000\224\002\000\000\
\\001\000\052\000\003\003\000\000\
\\001\000\052\000\004\003\000\000\
\\001\000\052\000\024\003\000\000\
\\001\000\054\000\250\000\000\000\
\\001\000\054\000\253\000\000\000\
\\001\000\054\000\145\001\000\000\
\\001\000\056\000\248\000\000\000\
\\001\000\056\000\249\000\000\000\
\\001\000\056\000\144\001\000\000\
\\001\000\056\000\244\001\000\000\
\\001\000\058\000\099\001\069\000\098\001\000\000\
\\001\000\058\000\243\001\000\000\
\\001\000\058\000\058\002\000\000\
\\001\000\058\000\145\002\000\000\
\\001\000\058\000\146\002\000\000\
\\001\000\058\000\161\002\000\000\
\\001\000\058\000\237\002\000\000\
\\001\000\058\000\255\002\000\000\
\\001\000\059\000\000\000\078\000\000\000\000\000\
\\001\000\060\000\018\001\070\000\029\000\071\000\090\000\075\000\024\000\
\\077\000\089\000\000\000\
\\001\000\069\000\138\000\070\000\029\000\075\000\024\000\000\000\
\\001\000\069\000\247\000\000\000\
\\001\000\069\000\102\001\000\000\
\\001\000\069\000\142\001\000\000\
\\001\000\069\000\153\001\000\000\
\\001\000\069\000\173\001\000\000\
\\001\000\069\000\185\001\000\000\
\\001\000\069\000\200\001\000\000\
\\001\000\069\000\054\002\000\000\
\\001\000\069\000\121\002\000\000\
\\001\000\069\000\130\002\000\000\
\\001\000\069\000\162\002\000\000\
\\001\000\069\000\208\002\000\000\
\\001\000\069\000\221\002\000\000\
\\001\000\069\000\238\002\000\000\
\\001\000\069\000\026\003\000\000\
\\001\000\069\000\030\003\000\000\
\\001\000\070\000\029\000\071\000\090\000\075\000\024\000\077\000\089\000\000\000\
\\001\000\070\000\029\000\075\000\024\000\000\000\
\\001\000\075\000\214\000\000\000\
\\001\000\076\000\032\001\000\000\
\\050\003\000\000\
\\051\003\000\000\
\\052\003\000\000\
\\053\003\000\000\
\\054\003\000\000\
\\055\003\000\000\
\\056\003\000\000\
\\057\003\000\000\
\\058\003\000\000\
\\059\003\000\000\
\\059\003\051\000\052\002\000\000\
\\059\003\051\000\193\002\000\000\
\\060\003\000\000\
\\061\003\000\000\
\\062\003\000\000\
\\063\003\000\000\
\\064\003\000\000\
\\065\003\000\000\
\\066\003\000\000\
\\067\003\000\000\
\\068\003\077\000\157\000\000\000\
\\069\003\000\000\
\\070\003\000\000\
\\071\003\000\000\
\\072\003\000\000\
\\073\003\000\000\
\\074\003\000\000\
\\075\003\000\000\
\\076\003\000\000\
\\077\003\070\000\029\000\075\000\024\000\000\000\
\\078\003\000\000\
\\079\003\069\000\138\000\070\000\029\000\075\000\024\000\000\000\
\\080\003\000\000\
\\081\003\009\000\058\000\010\000\057\000\070\000\029\000\075\000\024\000\000\000\
\\082\003\000\000\
\\083\003\069\000\162\002\000\000\
\\084\003\000\000\
\\085\003\069\000\221\002\000\000\
\\086\003\000\000\
\\087\003\000\000\
\\088\003\000\000\
\\089\003\000\000\
\\090\003\000\000\
\\091\003\000\000\
\\092\003\000\000\
\\093\003\000\000\
\\094\003\000\000\
\\095\003\000\000\
\\096\003\000\000\
\\097\003\020\000\028\003\000\000\
\\098\003\000\000\
\\099\003\000\000\
\\100\003\002\000\061\000\000\000\
\\101\003\000\000\
\\102\003\000\000\
\\103\003\020\000\163\002\000\000\
\\104\003\000\000\
\\105\003\000\000\
\\106\003\020\000\251\002\000\000\
\\107\003\000\000\
\\108\003\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\031\000\076\001\042\000\075\001\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\109\003\001\000\062\000\008\000\059\000\011\000\056\000\019\000\053\000\
\\025\000\051\000\028\000\050\000\030\000\048\000\034\000\046\000\
\\035\000\045\000\037\000\043\000\038\000\042\000\041\000\040\000\
\\046\000\038\000\047\000\037\000\059\000\143\000\000\000\
\\110\003\000\000\
\\111\003\000\000\
\\112\003\000\000\
\\113\003\000\000\
\\114\003\000\000\
\\115\003\000\000\
\\116\003\000\000\
\\117\003\000\000\
\\118\003\000\000\
\\119\003\000\000\
\\120\003\000\000\
\\121\003\020\000\152\002\000\000\
\\122\003\000\000\
\\123\003\000\000\
\\124\003\020\000\207\002\000\000\
\\125\003\000\000\
\\126\003\000\000\
\\127\003\062\000\032\003\000\000\
\\128\003\000\000\
\\129\003\000\000\
\\130\003\020\000\013\003\000\000\
\\131\003\000\000\
\\132\003\000\000\
\\133\003\020\000\204\002\000\000\
\\134\003\000\000\
\\135\003\000\000\
\\136\003\020\000\241\002\000\000\
\\137\003\000\000\
\\138\003\000\000\
\\139\003\001\000\240\001\003\000\239\001\004\000\238\001\008\000\237\001\
\\011\000\236\001\025\000\235\001\028\000\234\001\037\000\233\001\
\\041\000\232\001\046\000\231\001\047\000\230\001\059\000\229\001\000\000\
\\140\003\001\000\240\001\003\000\239\001\004\000\238\001\008\000\237\001\
\\011\000\236\001\025\000\235\001\028\000\234\001\037\000\233\001\
\\041\000\232\001\046\000\231\001\047\000\230\001\059\000\229\001\000\000\
\\140\003\001\000\240\001\003\000\239\001\004\000\238\001\008\000\237\001\
\\011\000\236\001\025\000\235\001\028\000\234\001\037\000\233\001\
\\041\000\232\001\046\000\231\001\047\000\230\001\059\000\229\001\
\\070\000\029\000\075\000\024\000\000\000\
\\141\003\000\000\
\\142\003\000\000\
\\143\003\000\000\
\\144\003\000\000\
\\145\003\000\000\
\\146\003\000\000\
\\147\003\000\000\
\\148\003\000\000\
\\149\003\000\000\
\\150\003\020\000\163\002\000\000\
\\151\003\000\000\
\\152\003\000\000\
\\153\003\000\000\
\\154\003\000\000\
\\155\003\000\000\
\\156\003\000\000\
\\157\003\000\000\
\\158\003\000\000\
\\159\003\000\000\
\\160\003\000\000\
\\161\003\000\000\
\\162\003\000\000\
\\163\003\000\000\
\\164\003\001\000\062\000\002\000\061\000\006\000\060\000\008\000\059\000\
\\009\000\058\000\010\000\057\000\011\000\056\000\014\000\055\000\
\\015\000\054\000\019\000\053\000\023\000\052\000\025\000\051\000\
\\028\000\050\000\029\000\049\000\030\000\048\000\032\000\047\000\
\\034\000\046\000\035\000\045\000\036\000\044\000\037\000\043\000\
\\038\000\042\000\040\000\041\000\041\000\040\000\043\000\039\000\
\\046\000\038\000\047\000\037\000\050\000\036\000\051\000\035\000\
\\053\000\034\000\055\000\033\000\065\000\032\000\066\000\031\000\
\\069\000\030\000\070\000\029\000\071\000\028\000\072\000\027\000\
\\073\000\026\000\074\000\025\000\075\000\024\000\077\000\023\000\000\000\
\\164\003\001\000\062\000\008\000\059\000\011\000\056\000\019\000\053\000\
\\025\000\051\000\028\000\050\000\030\000\048\000\034\000\046\000\
\\035\000\045\000\037\000\043\000\038\000\042\000\041\000\040\000\
\\046\000\038\000\047\000\037\000\000\000\
\\165\003\000\000\
\\166\003\000\000\
\\167\003\001\000\062\000\008\000\059\000\011\000\056\000\019\000\053\000\
\\025\000\051\000\028\000\050\000\030\000\048\000\034\000\046\000\
\\035\000\045\000\037\000\043\000\038\000\042\000\041\000\040\000\
\\046\000\038\000\047\000\037\000\059\000\143\000\000\000\
\\168\003\001\000\062\000\007\000\138\002\008\000\059\000\009\000\058\000\
\\010\000\057\000\011\000\056\000\019\000\053\000\025\000\051\000\
\\028\000\050\000\030\000\048\000\034\000\046\000\035\000\045\000\
\\036\000\137\002\037\000\043\000\038\000\042\000\041\000\040\000\
\\046\000\038\000\047\000\037\000\059\000\143\000\070\000\029\000\
\\075\000\024\000\000\000\
\\168\003\001\000\062\000\008\000\059\000\011\000\056\000\019\000\053\000\
\\025\000\051\000\028\000\050\000\030\000\048\000\034\000\046\000\
\\035\000\045\000\037\000\043\000\038\000\042\000\041\000\040\000\
\\046\000\038\000\047\000\037\000\059\000\143\000\000\000\
\\169\003\000\000\
\\170\003\000\000\
\\171\003\000\000\
\\172\003\000\000\
\\173\003\000\000\
\\174\003\000\000\
\\175\003\000\000\
\\176\003\000\000\
\\177\003\020\000\082\001\000\000\
\\178\003\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\031\000\076\001\042\000\075\001\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\179\003\000\000\
\\180\003\000\000\
\\181\003\000\000\
\\182\003\000\000\
\\183\003\000\000\
\\184\003\020\000\101\001\000\000\
\\185\003\000\000\
\\186\003\000\000\
\\187\003\000\000\
\\188\003\000\000\
\\189\003\000\000\
\\190\003\006\000\060\000\000\000\
\\191\003\000\000\
\\192\003\000\000\
\\193\003\020\000\057\002\000\000\
\\194\003\000\000\
\\195\003\000\000\
\\196\003\000\000\
\\197\003\000\000\
\\198\003\000\000\
\\199\003\000\000\
\\200\003\000\000\
\\201\003\000\000\
\\202\003\000\000\
\\203\003\000\000\
\\204\003\000\000\
\\205\003\000\000\
\\206\003\000\000\
\\207\003\000\000\
\\208\003\000\000\
\\209\003\000\000\
\\210\003\000\000\
\\211\003\000\000\
\\212\003\000\000\
\\213\003\000\000\
\\214\003\000\000\
\\215\003\000\000\
\\216\003\000\000\
\\217\003\000\000\
\\218\003\000\000\
\\219\003\000\000\
\\220\003\000\000\
\\221\003\000\000\
\\222\003\000\000\
\\223\003\000\000\
\\224\003\000\000\
\\225\003\000\000\
\\226\003\000\000\
\\227\003\000\000\
\\228\003\000\000\
\\229\003\000\000\
\\230\003\000\000\
\\231\003\000\000\
\\232\003\000\000\
\\233\003\000\000\
\\234\003\001\000\062\000\019\000\053\000\025\000\051\000\028\000\050\000\
\\030\000\048\000\034\000\046\000\035\000\045\000\037\000\155\000\
\\038\000\042\000\041\000\040\000\046\000\038\000\047\000\037\000\
\\059\000\154\000\000\000\
\\235\003\000\000\
\\236\003\000\000\
\\237\003\000\000\
\\238\003\000\000\
\\239\003\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\031\000\067\000\042\000\066\000\058\000\065\000\000\000\
\\240\003\000\000\
\\241\003\000\000\
\\242\003\000\000\
\\243\003\000\000\
\\244\003\000\000\
\\245\003\000\000\
\\246\003\000\000\
\\247\003\000\000\
\\248\003\000\000\
\\249\003\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\031\000\067\000\042\000\066\000\057\000\251\000\058\000\065\000\000\000\
\\250\003\000\000\
\\251\003\000\000\
\\252\003\000\000\
\\253\003\000\000\
\\254\003\000\000\
\\255\003\000\000\
\\000\004\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\031\000\067\000\042\000\066\000\058\000\065\000\059\000\000\001\000\000\
\\001\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\031\000\076\000\042\000\075\000\
\\058\000\074\000\059\000\003\001\067\000\073\000\068\000\072\000\000\000\
\\002\004\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\031\000\067\000\042\000\066\000\058\000\065\000\059\000\000\001\000\000\
\\003\004\000\000\
\\004\004\000\000\
\\005\004\000\000\
\\006\004\000\000\
\\007\004\000\000\
\\008\004\000\000\
\\009\004\000\000\
\\010\004\000\000\
\\011\004\000\000\
\\012\004\000\000\
\\013\004\000\000\
\\014\004\000\000\
\\015\004\000\000\
\\016\004\000\000\
\\017\004\000\000\
\\018\004\009\000\058\000\010\000\057\000\036\000\044\000\040\000\041\000\
\\051\000\035\000\053\000\034\000\055\000\033\000\065\000\032\000\
\\066\000\031\000\069\000\030\000\070\000\029\000\071\000\028\000\
\\072\000\027\000\073\000\026\000\074\000\025\000\075\000\024\000\
\\077\000\023\000\000\000\
\\019\004\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\031\000\067\000\042\000\066\000\058\000\065\000\000\000\
\\020\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\031\000\076\000\042\000\075\000\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\021\004\000\000\
\\022\004\000\000\
\\023\004\000\000\
\\024\004\000\000\
\\025\004\000\000\
\\026\004\000\000\
\\027\004\000\000\
\\028\004\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\031\000\067\000\042\000\066\000\058\000\065\000\000\000\
\\029\004\000\000\
\\030\004\000\000\
\\031\004\000\000\
\\032\004\000\000\
\\033\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\031\000\076\000\042\000\075\000\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\034\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\031\000\076\000\042\000\075\000\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\035\004\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\031\000\067\000\042\000\066\000\058\000\065\000\000\000\
\\036\004\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\031\000\067\000\042\000\066\000\058\000\065\000\000\000\
\\037\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\031\000\076\000\042\000\075\000\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\038\004\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\031\000\067\000\042\000\066\000\058\000\065\000\000\000\
\\039\004\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\031\000\067\000\042\000\066\000\058\000\065\000\000\000\
\\040\004\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\042\000\066\000\058\000\065\000\000\000\
\\041\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\042\000\075\000\058\000\074\000\
\\067\000\073\000\068\000\072\000\000\000\
\\042\004\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\042\000\066\000\058\000\065\000\000\000\
\\043\004\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\058\000\065\000\000\000\
\\044\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\058\000\074\000\067\000\073\000\
\\068\000\072\000\000\000\
\\045\004\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\058\000\065\000\000\000\
\\046\004\012\000\071\000\013\000\070\000\017\000\069\000\058\000\065\000\000\000\
\\047\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\048\004\012\000\071\000\013\000\070\000\017\000\069\000\058\000\065\000\000\000\
\\049\004\013\000\070\000\017\000\069\000\058\000\065\000\000\000\
\\050\004\013\000\081\000\016\000\080\000\017\000\079\000\018\000\078\000\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\051\004\013\000\070\000\017\000\069\000\058\000\065\000\000\000\
\\052\004\000\000\
\\053\004\000\000\
\\054\004\000\000\
\\055\004\022\000\013\001\058\000\012\001\063\000\062\001\000\000\
\\056\004\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\031\000\067\000\042\000\066\000\058\000\065\000\000\000\
\\057\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\031\000\076\000\042\000\075\000\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\058\004\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\031\000\067\000\042\000\066\000\058\000\065\000\000\000\
\\059\004\000\000\
\\060\004\000\000\
\\061\004\062\000\059\001\000\000\
\\061\004\062\000\073\001\000\000\
\\062\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\031\000\076\000\042\000\075\000\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\062\004\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\031\000\076\001\042\000\075\001\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\063\004\000\000\
\\064\004\000\000\
\\065\004\000\000\
\\066\004\012\000\071\000\013\000\070\000\017\000\069\000\020\000\255\001\
\\021\000\068\000\031\000\067\000\042\000\066\000\058\000\065\000\000\000\
\\066\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\020\000\255\001\021\000\077\000\031\000\076\000\
\\042\000\075\000\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\066\004\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\020\000\187\002\021\000\077\001\031\000\076\001\
\\042\000\075\001\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\067\004\000\000\
\\068\004\000\000\
\\069\004\020\000\051\001\000\000\
\\069\004\020\000\047\002\000\000\
\\070\004\000\000\
\\071\004\000\000\
\\072\004\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\031\000\067\000\042\000\066\000\058\000\065\000\062\000\118\002\000\000\
\\072\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\031\000\076\000\042\000\075\000\
\\058\000\074\000\062\000\118\002\067\000\073\000\068\000\072\000\000\000\
\\072\004\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\031\000\076\001\042\000\075\001\
\\058\000\074\000\062\000\231\002\067\000\073\000\068\000\072\000\000\000\
\\073\004\000\000\
\\074\004\020\000\174\002\000\000\
\\074\004\020\000\002\003\000\000\
\\075\004\000\000\
\\076\004\000\000\
\\077\004\000\000\
\\078\004\000\000\
\\079\004\000\000\
\\080\004\020\000\101\002\000\000\
\\080\004\020\000\227\002\000\000\
\\081\004\000\000\
\\082\004\000\000\
\\083\004\049\000\067\001\000\000\
\\084\004\000\000\
\\085\004\000\000\
\\086\004\000\000\
\\087\004\000\000\
\\088\004\000\000\
\\089\004\000\000\
\\090\004\000\000\
\\091\004\000\000\
\\092\004\000\000\
\\093\004\000\000\
\\094\004\000\000\
\\095\004\000\000\
\\096\004\000\000\
\\097\004\000\000\
\\098\004\000\000\
\\099\004\000\000\
\\100\004\001\000\062\000\008\000\160\002\011\000\159\002\019\000\053\000\
\\025\000\051\000\028\000\050\000\030\000\048\000\034\000\046\000\
\\035\000\045\000\037\000\158\002\038\000\042\000\041\000\040\000\
\\046\000\038\000\047\000\037\000\059\000\154\000\000\000\
\\100\004\001\000\062\000\019\000\053\000\025\000\051\000\028\000\050\000\
\\030\000\048\000\034\000\046\000\035\000\045\000\037\000\155\000\
\\038\000\042\000\041\000\040\000\046\000\038\000\047\000\037\000\
\\059\000\154\000\000\000\
\\100\004\001\000\095\001\019\000\094\001\025\000\051\000\028\000\050\000\
\\030\000\093\001\034\000\046\000\035\000\045\000\037\000\092\001\
\\038\000\042\000\041\000\040\000\046\000\091\001\047\000\090\001\
\\059\000\154\000\000\000\
\\101\004\001\000\062\000\008\000\160\002\011\000\159\002\019\000\053\000\
\\025\000\051\000\028\000\050\000\030\000\048\000\034\000\046\000\
\\035\000\045\000\037\000\158\002\038\000\042\000\041\000\040\000\
\\046\000\038\000\047\000\037\000\059\000\154\000\000\000\
\\101\004\001\000\062\000\019\000\053\000\025\000\051\000\028\000\050\000\
\\030\000\048\000\034\000\046\000\035\000\045\000\037\000\155\000\
\\038\000\042\000\041\000\040\000\046\000\038\000\047\000\037\000\
\\059\000\154\000\000\000\
\\101\004\001\000\095\001\019\000\094\001\025\000\051\000\028\000\050\000\
\\030\000\093\001\034\000\046\000\035\000\045\000\037\000\092\001\
\\038\000\042\000\041\000\040\000\046\000\091\001\047\000\090\001\
\\059\000\154\000\000\000\
\\102\004\000\000\
\\103\004\009\000\058\000\010\000\057\000\036\000\044\000\040\000\041\000\
\\051\000\035\000\053\000\034\000\055\000\033\000\065\000\032\000\
\\066\000\031\000\069\000\030\000\070\000\029\000\071\000\028\000\
\\072\000\027\000\073\000\026\000\074\000\025\000\075\000\024\000\
\\077\000\023\000\000\000\
\\103\004\009\000\058\000\010\000\057\000\036\000\194\000\040\000\041\000\
\\051\000\191\000\053\000\190\000\055\000\189\000\065\000\032\000\
\\069\000\030\000\070\000\029\000\071\000\028\000\072\000\027\000\
\\073\000\026\000\074\000\025\000\075\000\024\000\077\000\023\000\000\000\
\\104\004\000\000\
\\105\004\000\000\
\\106\004\070\000\029\000\071\000\090\000\075\000\024\000\077\000\089\000\000\000\
\\107\004\000\000\
\\108\004\012\000\071\000\013\000\070\000\017\000\069\000\021\000\068\000\
\\031\000\067\000\042\000\066\000\057\000\250\001\058\000\065\000\000\000\
\\108\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\031\000\076\000\042\000\075\000\
\\057\000\250\001\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\108\004\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\031\000\076\001\042\000\075\001\
\\057\000\127\002\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\109\004\000\000\
\\110\004\009\000\058\000\010\000\057\000\014\000\055\000\015\000\054\000\
\\023\000\052\000\029\000\049\000\032\000\047\000\036\000\044\000\
\\040\000\041\000\043\000\039\000\050\000\036\000\051\000\035\000\
\\053\000\034\000\055\000\033\000\065\000\032\000\066\000\031\000\
\\069\000\030\000\070\000\029\000\071\000\028\000\072\000\027\000\
\\073\000\026\000\074\000\025\000\075\000\024\000\077\000\023\000\000\000\
\\110\004\009\000\058\000\010\000\057\000\014\000\055\000\015\000\054\000\
\\023\000\197\000\029\000\196\000\032\000\195\000\036\000\194\000\
\\040\000\041\000\043\000\193\000\050\000\192\000\051\000\191\000\
\\053\000\190\000\055\000\189\000\065\000\032\000\069\000\030\000\
\\070\000\029\000\071\000\028\000\072\000\027\000\073\000\026\000\
\\074\000\025\000\075\000\024\000\077\000\023\000\000\000\
\\111\004\000\000\
\\112\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\031\000\076\000\042\000\075\000\
\\057\000\252\000\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\112\004\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\031\000\076\001\042\000\075\001\
\\057\000\201\001\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\113\004\000\000\
\\114\004\000\000\
\\115\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\031\000\076\000\042\000\075\000\
\\058\000\074\000\059\000\003\001\067\000\073\000\068\000\072\000\000\000\
\\115\004\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\031\000\076\001\042\000\075\001\
\\058\000\074\000\059\000\202\001\067\000\073\000\068\000\072\000\000\000\
\\116\004\000\000\
\\117\004\000\000\
\\118\004\000\000\
\\119\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\031\000\076\000\042\000\075\000\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\119\004\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\031\000\076\001\042\000\075\001\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\120\004\000\000\
\\121\004\000\000\
\\122\004\000\000\
\\123\004\000\000\
\\124\004\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\125\004\000\000\
\\126\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\031\000\076\000\042\000\075\000\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\126\004\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\031\000\076\001\042\000\075\001\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\127\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\042\000\075\000\058\000\074\000\
\\067\000\073\000\068\000\072\000\000\000\
\\127\004\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\042\000\075\001\058\000\074\000\
\\067\000\073\000\068\000\072\000\000\000\
\\128\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\058\000\074\000\067\000\073\000\
\\068\000\072\000\000\000\
\\128\004\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\058\000\074\000\067\000\073\000\
\\068\000\072\000\000\000\
\\129\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\129\004\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\130\004\013\000\081\000\016\000\080\000\017\000\079\000\018\000\078\000\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\130\004\013\000\079\001\016\000\080\000\017\000\078\001\018\000\078\000\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\131\004\000\000\
\\132\004\000\000\
\\133\004\022\000\013\001\058\000\012\001\063\000\062\001\000\000\
\\133\004\022\000\013\001\058\000\012\001\063\000\074\001\000\000\
\\134\004\058\000\074\000\068\000\072\000\000\000\
\\135\004\012\000\082\000\013\000\081\000\016\000\080\000\017\000\079\000\
\\018\000\078\000\021\000\077\000\031\000\076\000\042\000\075\000\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\135\004\012\000\080\001\013\000\079\001\016\000\080\000\017\000\078\001\
\\018\000\078\000\021\000\077\001\031\000\076\001\042\000\075\001\
\\058\000\074\000\067\000\073\000\068\000\072\000\000\000\
\\136\004\000\000\
\\137\004\000\000\
\\138\004\000\000\
\\139\004\000\000\
\\140\004\000\000\
\\141\004\000\000\
\\142\004\000\000\
\\143\004\000\000\
\\144\004\000\000\
\\145\004\000\000\
\\146\004\000\000\
\\147\004\000\000\
\\148\004\058\000\255\002\000\000\
\\149\004\000\000\
\\150\004\000\000\
\\151\004\020\000\124\002\000\000\
\\152\004\000\000\
\\153\004\000\000\
\\154\004\062\000\183\002\000\000\
\\155\004\000\000\
\\156\004\000\000\
\\157\004\000\000\
\\158\004\020\000\180\001\000\000\
\\159\004\000\000\
\\160\004\000\000\
\\161\004\009\000\058\000\010\000\057\000\040\000\123\000\051\000\121\000\
\\053\000\120\000\055\000\119\000\061\000\118\000\070\000\029\000\
\\071\000\028\000\072\000\027\000\073\000\026\000\074\000\025\000\
\\075\000\024\000\077\000\023\000\000\000\
\\162\004\000\000\
\\163\004\058\000\055\001\000\000\
\\164\004\000\000\
\\165\004\039\000\065\001\000\000\
\\165\004\039\000\065\001\069\000\064\001\000\000\
\\166\004\000\000\
\\167\004\000\000\
\\168\004\000\000\
\\169\004\000\000\
\\170\004\000\000\
\\171\004\000\000\
\\172\004\000\000\
\\173\004\000\000\
\\174\004\000\000\
\\175\004\000\000\
\\176\004\060\000\018\001\070\000\029\000\071\000\090\000\075\000\024\000\
\\077\000\089\000\000\000\
\\177\004\000\000\
\\178\004\000\000\
\\179\004\000\000\
\\180\004\022\000\013\001\058\000\012\001\000\000\
\\181\004\022\000\004\002\000\000\
\\182\004\000\000\
\\183\004\022\000\013\001\057\000\093\002\058\000\012\001\000\000\
\\183\004\057\000\093\002\000\000\
\\184\004\000\000\
\\185\004\009\000\058\000\010\000\057\000\040\000\123\000\051\000\121\000\
\\053\000\120\000\055\000\119\000\061\000\118\000\070\000\029\000\
\\071\000\028\000\072\000\027\000\073\000\026\000\074\000\025\000\
\\075\000\024\000\077\000\023\000\000\000\
\\186\004\000\000\
\\187\004\022\000\013\001\057\000\146\001\058\000\012\001\000\000\
\\188\004\000\000\
\\189\004\009\000\058\000\010\000\057\000\040\000\123\000\051\000\121\000\
\\053\000\120\000\055\000\119\000\061\000\118\000\070\000\029\000\
\\071\000\028\000\072\000\027\000\073\000\026\000\074\000\025\000\
\\075\000\024\000\077\000\023\000\000\000\
\\190\004\000\000\
\\191\004\000\000\
\\192\004\022\000\013\001\058\000\012\001\000\000\
\\193\004\000\000\
\\194\004\064\000\110\001\000\000\
\\195\004\009\000\217\000\070\000\109\001\075\000\214\000\000\000\
\\196\004\000\000\
\\197\004\000\000\
\\198\004\000\000\
\\199\004\000\000\
\\200\004\000\000\
\\201\004\057\000\246\001\000\000\
\\202\004\000\000\
\\203\004\000\000\
\\204\004\000\000\
\\205\004\000\000\
\\206\004\000\000\
\\207\004\070\000\029\000\071\000\090\000\075\000\024\000\077\000\089\000\000\000\
\\208\004\000\000\
\\209\004\000\000\
\\210\004\057\000\168\002\000\000\
\\211\004\000\000\
\\212\004\000\000\
\\213\004\000\000\
\\214\004\000\000\
\\215\004\000\000\
\\216\004\051\000\128\000\076\000\127\000\000\000\
\\217\004\000\000\
\\218\004\057\000\155\001\000\000\
\"
val actionRowNumbers =
"\019\001\097\002\021\002\174\000\
\\172\000\167\000\134\001\131\001\
\\136\001\132\001\133\001\248\001\
\\229\001\135\001\028\001\199\000\
\\020\002\020\001\198\000\196\000\
\\197\000\181\000\158\000\098\002\
\\099\002\180\000\179\000\159\000\
\\175\000\121\001\154\000\233\001\
\\239\001\007\000\008\000\014\000\
\\102\002\008\000\023\000\021\000\
\\137\000\025\001\226\001\178\000\
\\178\000\008\000\019\000\019\000\
\\097\000\102\002\008\000\102\002\
\\019\000\019\000\010\000\171\000\
\\170\000\155\000\155\000\155\000\
\\102\002\128\001\129\001\025\000\
\\008\000\019\000\008\000\019\000\
\\008\000\008\000\010\000\010\000\
\\025\000\008\000\019\000\008\000\
\\000\002\019\000\013\002\008\000\
\\008\000\130\001\228\001\018\001\
\\185\000\027\002\184\000\183\000\
\\182\000\138\000\123\000\100\001\
\\124\000\232\001\102\001\120\000\
\\106\001\242\001\238\001\121\000\
\\103\000\104\000\034\000\042\000\
\\105\000\106\000\025\002\027\000\
\\035\000\053\002\076\001\203\001\
\\076\002\075\002\053\000\052\002\
\\051\002\061\002\071\002\018\000\
\\015\000\022\000\077\001\204\001\
\\156\000\100\002\157\000\141\001\
\\251\001\191\000\209\001\173\000\
\\176\000\189\000\162\000\212\001\
\\163\000\023\001\022\001\084\000\
\\026\001\027\001\085\000\091\001\
\\090\001\086\001\085\001\086\000\
\\223\001\221\001\218\001\217\001\
\\219\001\226\001\137\000\177\000\
\\137\000\033\000\041\000\186\001\
\\081\001\186\001\215\001\047\002\
\\045\002\174\001\142\001\253\001\
\\174\001\051\000\050\002\160\000\
\\208\001\155\000\205\001\156\000\
\\032\000\040\000\098\000\255\001\
\\175\001\052\000\254\001\035\001\
\\230\001\029\001\034\001\233\001\
\\240\001\009\000\010\000\010\000\
\\227\001\010\000\019\000\010\000\
\\127\000\041\001\030\001\139\000\
\\047\001\102\000\210\000\079\001\
\\207\001\088\002\165\000\085\002\
\\081\002\080\002\137\001\089\002\
\\164\000\093\002\025\000\166\000\
\\155\001\154\001\140\001\138\001\
\\158\001\157\001\167\001\166\001\
\\168\001\164\001\163\001\161\001\
\\160\001\017\002\001\002\249\001\
\\153\001\005\002\139\001\250\001\
\\156\001\007\002\165\001\014\002\
\\015\002\162\001\011\002\159\001\
\\009\002\008\000\116\001\022\002\
\\127\001\008\000\008\000\030\002\
\\123\001\122\001\008\000\008\000\
\\120\001\008\000\008\000\024\002\
\\028\002\026\002\008\000\008\000\
\\043\002\008\000\025\000\019\000\
\\140\000\049\000\125\000\060\002\
\\062\002\070\002\122\000\073\002\
\\107\000\050\000\057\002\054\001\
\\179\001\054\000\015\000\054\002\
\\141\000\108\000\104\002\190\000\
\\188\000\021\001\025\001\008\000\
\\089\001\088\001\008\000\087\001\
\\220\001\087\000\088\000\211\001\
\\210\001\008\000\008\000\068\001\
\\069\001\019\000\070\001\184\001\
\\142\000\025\000\044\002\094\001\
\\092\001\019\000\093\001\172\001\
\\008\000\042\002\013\000\025\000\
\\161\000\102\002\143\000\019\000\
\\019\000\102\002\226\001\019\000\
\\010\000\010\000\019\000\010\000\
\\019\000\010\000\010\000\032\001\
\\010\000\144\000\243\001\048\000\
\\043\000\252\001\089\000\224\001\
\\016\000\102\002\227\001\019\000\
\\102\002\102\002\047\000\046\000\
\\012\000\000\000\039\001\155\000\
\\000\000\045\001\046\001\251\000\
\\208\000\209\000\084\002\025\000\
\\025\000\128\000\126\000\092\002\
\\109\000\110\000\235\001\236\001\
\\105\001\103\001\104\001\241\001\
\\112\001\115\001\114\001\111\001\
\\109\001\107\001\110\001\113\001\
\\246\001\245\001\108\001\244\001\
\\171\001\170\001\169\001\018\002\
\\181\001\182\001\077\002\078\002\
\\019\000\066\002\055\002\059\002\
\\019\000\058\002\019\000\056\002\
\\080\000\062\001\198\001\024\000\
\\101\002\157\000\057\000\058\000\
\\030\000\038\000\059\000\060\000\
\\031\000\039\000\061\000\226\001\
\\226\001\028\000\036\000\029\000\
\\037\000\071\001\185\001\008\000\
\\046\002\095\001\173\001\096\001\
\\176\001\039\002\097\000\042\002\
\\048\002\213\001\156\000\097\000\
\\145\001\143\001\144\001\002\002\
\\099\000\062\000\063\000\177\001\
\\006\002\008\002\016\002\012\002\
\\010\002\033\001\010\000\010\000\
\\010\000\010\000\010\000\010\000\
\\055\000\017\000\090\000\187\001\
\\047\002\100\000\010\000\019\000\
\\014\001\168\000\038\001\025\001\
\\043\001\044\001\145\000\250\000\
\\040\001\050\001\129\000\249\000\
\\248\000\252\000\111\000\253\000\
\\137\000\102\002\023\000\250\000\
\\155\000\102\002\011\000\155\000\
\\020\000\155\000\102\002\082\002\
\\079\002\025\000\090\002\026\000\
\\025\000\091\002\099\001\097\001\
\\154\000\098\001\231\001\053\001\
\\051\001\014\000\052\001\178\001\
\\068\002\069\002\019\000\072\002\
\\074\002\081\000\019\000\201\001\
\\201\001\103\002\031\001\126\001\
\\119\001\118\001\125\001\124\001\
\\117\001\023\002\029\002\064\000\
\\065\000\066\000\067\000\008\000\
\\008\000\008\000\008\000\190\001\
\\191\001\041\002\040\002\146\000\
\\049\002\035\002\226\001\078\001\
\\206\001\237\001\247\001\019\002\
\\045\000\010\000\056\000\017\000\
\\227\001\019\000\147\000\102\002\
\\227\001\044\000\024\001\091\000\
\\002\000\068\000\048\001\155\000\
\\000\000\247\000\130\000\131\000\
\\254\000\156\000\255\000\007\001\
\\092\000\049\002\002\001\156\000\
\\001\001\218\000\003\001\231\000\
\\225\001\132\000\004\001\148\000\
\\211\000\005\001\026\000\187\000\
\\008\001\000\001\096\002\083\002\
\\086\002\087\002\101\001\234\001\
\\055\001\180\001\063\002\136\000\
\\064\002\065\002\019\000\194\001\
\\194\001\065\001\199\001\102\002\
\\066\001\064\001\084\001\083\001\
\\082\001\216\001\149\001\147\001\
\\148\001\146\001\151\001\150\001\
\\152\001\003\002\074\001\073\001\
\\019\000\072\001\188\001\025\000\
\\038\002\033\002\102\002\069\000\
\\070\000\154\000\183\001\082\000\
\\010\000\101\000\010\000\010\001\
\\169\000\112\000\113\000\025\001\
\\025\001\012\000\036\001\037\001\
\\042\001\049\001\114\000\001\000\
\\025\000\243\000\250\000\234\000\
\\149\000\229\000\011\000\219\000\
\\221\000\093\000\223\000\222\001\
\\225\001\010\000\155\000\000\000\
\\023\000\020\000\150\000\212\000\
\\186\000\094\002\154\000\067\002\
\\115\000\116\000\058\001\057\001\
\\015\000\056\001\196\001\067\001\
\\200\001\075\001\189\001\202\001\
\\036\002\097\000\034\002\080\001\
\\214\001\016\000\083\000\019\000\
\\192\001\227\001\004\002\024\001\
\\015\001\017\001\094\000\071\000\
\\072\000\133\000\151\000\250\000\
\\246\000\241\000\102\002\073\000\
\\232\000\155\000\097\000\230\000\
\\220\000\010\000\222\000\095\000\
\\096\000\224\000\225\000\216\000\
\\193\000\192\000\213\000\026\000\
\\095\002\134\000\134\000\063\001\
\\193\001\102\002\037\002\019\000\
\\195\001\019\000\117\000\118\000\
\\006\000\009\001\016\001\000\000\
\\003\000\074\000\244\000\137\000\
\\242\000\006\001\233\000\049\002\
\\240\000\075\000\225\001\225\001\
\\214\000\155\000\195\000\194\000\
\\194\001\025\000\194\001\119\000\
\\017\000\011\001\013\001\076\000\
\\152\000\207\000\207\000\153\000\
\\245\000\237\000\238\000\102\002\
\\217\000\077\000\078\000\079\000\
\\215\000\061\001\060\001\032\002\
\\059\001\197\001\134\000\012\001\
\\004\000\202\000\155\000\204\000\
\\005\000\235\000\097\000\239\000\
\\228\000\227\000\226\000\031\002\
\\195\001\207\000\207\000\206\000\
\\207\000\207\000\236\000\200\000\
\\201\000\203\000\205\000\135\000"
val gotoT =
"\
\\001\000\047\003\002\000\020\000\003\000\019\000\004\000\018\000\
\\005\000\017\000\050\000\016\000\057\000\015\000\082\000\014\000\
\\090\000\013\000\095\000\012\000\096\000\011\000\104\000\010\000\
\\114\000\009\000\115\000\008\000\116\000\007\000\128\000\006\000\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\016\000\095\000\012\000\096\000\062\000\115\000\061\000\
\\116\000\007\000\143\000\005\000\148\000\004\000\149\000\003\000\
\\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\016\000\095\000\012\000\096\000\082\000\115\000\081\000\
\\116\000\007\000\143\000\005\000\148\000\004\000\149\000\003\000\
\\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\083\000\005\000\017\000\082\000\014\000\090\000\013\000\
\\128\000\006\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\143\000\086\000\151\000\085\000\152\000\084\000\000\000\
\\097\000\093\000\098\000\092\000\117\000\091\000\118\000\090\000\
\\143\000\086\000\151\000\089\000\152\000\084\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\100\000\099\000\
\\101\000\098\000\104\000\097\000\114\000\096\000\115\000\008\000\
\\116\000\007\000\120\000\095\000\121\000\094\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\102\000\105\000\
\\103\000\104\000\104\000\103\000\114\000\102\000\115\000\008\000\
\\116\000\007\000\122\000\101\000\123\000\100\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\108\000\
\\114\000\107\000\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\050\000\115\000\051\000\114\000\053\000\113\000\072\000\112\000\
\\085\000\111\000\135\000\110\000\143\000\005\000\148\000\004\000\
\\149\000\109\000\153\000\001\000\000\000\
\\049\000\124\000\110\000\123\000\133\000\122\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\128\000\
\\114\000\127\000\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\078\000\130\000\143\000\005\000\148\000\129\000\000\000\
\\143\000\005\000\148\000\131\000\000\000\
\\077\000\135\000\143\000\134\000\145\000\133\000\000\000\
\\005\000\140\000\025\000\139\000\042\000\138\000\043\000\137\000\
\\082\000\014\000\090\000\013\000\128\000\006\000\000\000\
\\090\000\151\000\091\000\150\000\092\000\149\000\093\000\148\000\
\\094\000\147\000\128\000\146\000\129\000\145\000\130\000\144\000\
\\131\000\143\000\132\000\142\000\000\000\
\\081\000\154\000\000\000\
\\081\000\156\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\158\000\
\\114\000\157\000\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\050\000\115\000\053\000\164\000\073\000\163\000\106\000\162\000\
\\108\000\161\000\124\000\160\000\126\000\159\000\143\000\005\000\
\\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\050\000\115\000\051\000\169\000\053\000\113\000\072\000\112\000\
\\084\000\168\000\105\000\167\000\111\000\166\000\113\000\165\000\
\\143\000\005\000\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\054\000\172\000\143\000\171\000\144\000\170\000\000\000\
\\049\000\175\000\056\000\174\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\177\000\
\\114\000\176\000\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\049\000\175\000\056\000\178\000\000\000\
\\050\000\115\000\051\000\181\000\053\000\113\000\072\000\112\000\
\\084\000\180\000\105\000\179\000\143\000\005\000\148\000\004\000\
\\149\000\109\000\153\000\001\000\000\000\
\\050\000\115\000\051\000\181\000\053\000\113\000\072\000\112\000\
\\084\000\180\000\105\000\182\000\143\000\005\000\148\000\004\000\
\\149\000\109\000\153\000\001\000\000\000\
\\023\000\186\000\024\000\185\000\050\000\016\000\095\000\184\000\
\\096\000\011\000\104\000\183\000\143\000\005\000\148\000\004\000\
\\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\021\000\198\000\022\000\197\000\143\000\196\000\000\000\
\\018\000\200\000\143\000\199\000\000\000\
\\006\000\202\000\143\000\201\000\000\000\
\\049\000\124\000\110\000\204\000\133\000\203\000\000\000\
\\000\000\
\\000\000\
\\045\000\210\000\046\000\209\000\047\000\208\000\048\000\207\000\
\\146\000\206\000\147\000\205\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\217\000\
\\114\000\216\000\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\050\000\115\000\051\000\169\000\053\000\113\000\072\000\112\000\
\\084\000\168\000\105\000\219\000\111\000\218\000\113\000\165\000\
\\143\000\005\000\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\221\000\
\\114\000\220\000\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\050\000\115\000\051\000\224\000\053\000\113\000\072\000\112\000\
\\084\000\168\000\105\000\223\000\111\000\222\000\113\000\165\000\
\\143\000\005\000\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\226\000\
\\114\000\225\000\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\228\000\
\\114\000\227\000\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\104\000\229\000\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\104\000\230\000\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\045\000\231\000\046\000\209\000\047\000\208\000\048\000\207\000\
\\146\000\206\000\147\000\205\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\233\000\
\\114\000\232\000\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\050\000\115\000\051\000\169\000\053\000\113\000\072\000\112\000\
\\084\000\168\000\105\000\235\000\111\000\234\000\113\000\165\000\
\\143\000\005\000\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\237\000\
\\114\000\236\000\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\050\000\115\000\051\000\240\000\053\000\113\000\072\000\112\000\
\\084\000\168\000\105\000\239\000\111\000\238\000\113\000\165\000\
\\143\000\005\000\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\242\000\
\\114\000\241\000\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\244\000\
\\114\000\243\000\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\115\000\053\000\164\000\073\000\008\001\143\000\005\000\
\\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\052\000\015\001\061\000\014\001\143\000\013\001\151\000\012\001\
\\152\000\084\000\000\000\
\\050\000\115\000\051\000\019\001\053\000\113\000\069\000\018\001\
\\070\000\017\001\072\000\112\000\143\000\005\000\148\000\004\000\
\\149\000\109\000\153\000\001\000\000\000\
\\050\000\115\000\051\000\021\001\053\000\113\000\071\000\020\001\
\\072\000\112\000\143\000\005\000\148\000\004\000\149\000\109\000\
\\153\000\001\000\000\000\
\\050\000\115\000\051\000\025\001\053\000\113\000\072\000\112\000\
\\088\000\024\001\136\000\023\001\143\000\005\000\148\000\004\000\
\\149\000\109\000\153\000\001\000\000\000\
\\143\000\005\000\148\000\131\000\000\000\
\\000\000\
\\000\000\
\\146\000\028\001\000\000\
\\000\000\
\\074\000\029\001\000\000\
\\000\000\
\\000\000\
\\078\000\031\001\143\000\005\000\148\000\129\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\077\000\032\001\143\000\134\000\145\000\133\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\005\000\140\000\042\000\033\001\082\000\014\000\090\000\013\000\
\\128\000\006\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\090\000\151\000\091\000\150\000\092\000\037\001\128\000\146\000\
\\129\000\145\000\130\000\036\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\090\000\151\000\091\000\150\000\092\000\040\001\128\000\146\000\
\\129\000\145\000\130\000\039\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\090\000\151\000\091\000\150\000\092\000\149\000\093\000\148\000\
\\094\000\042\001\128\000\146\000\129\000\145\000\130\000\144\000\
\\131\000\143\000\132\000\041\001\000\000\
\\077\000\043\001\143\000\134\000\145\000\133\000\000\000\
\\000\000\
\\077\000\044\001\143\000\134\000\145\000\133\000\000\000\
\\000\000\
\\000\000\
\\107\000\048\001\125\000\047\001\000\000\
\\000\000\
\\107\000\051\001\125\000\050\001\000\000\
\\000\000\
\\064\000\052\001\000\000\
\\050\000\115\000\053\000\164\000\073\000\054\001\143\000\005\000\
\\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\083\000\056\001\112\000\055\001\000\000\
\\000\000\
\\000\000\
\\083\000\059\001\112\000\058\001\000\000\
\\000\000\
\\068\000\061\001\000\000\
\\000\000\
\\000\000\
\\143\000\064\001\000\000\
\\000\000\
\\146\000\066\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\083\000\059\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\016\000\095\000\184\000\096\000\082\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\039\000\079\001\000\000\
\\097\000\093\000\098\000\092\000\143\000\086\000\151\000\081\001\
\\152\000\084\000\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\100\000\099\000\
\\101\000\098\000\104\000\082\001\143\000\005\000\148\000\004\000\
\\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\102\000\105\000\
\\103\000\104\000\104\000\083\001\143\000\005\000\148\000\004\000\
\\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\104\000\084\001\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\104\000\085\001\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\090\000\151\000\091\000\150\000\092\000\149\000\093\000\087\001\
\\094\000\086\001\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\104\000\094\001\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\050\000\115\000\051\000\181\000\053\000\113\000\072\000\112\000\
\\084\000\180\000\105\000\167\000\143\000\005\000\148\000\004\000\
\\149\000\109\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\104\000\095\001\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\000\000\
\\030\000\098\001\000\000\
\\000\000\
\\000\000\
\\002\000\102\001\027\000\101\001\000\000\
\\000\000\
\\004\000\105\001\028\000\104\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\146\000\206\000\147\000\106\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\044\000\111\001\066\000\110\001\143\000\086\000\151\000\109\001\
\\152\000\084\000\000\000\
\\045\000\113\001\046\000\209\000\047\000\208\000\048\000\207\000\
\\075\000\112\001\146\000\206\000\147\000\205\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\115\001\
\\114\000\114\001\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\101\000\117\001\
\\104\000\097\000\114\000\096\000\115\000\008\000\116\000\007\000\
\\121\000\116\001\143\000\005\000\148\000\004\000\149\000\003\000\
\\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\101\000\119\001\
\\104\000\097\000\114\000\096\000\115\000\008\000\116\000\007\000\
\\121\000\118\001\143\000\005\000\148\000\004\000\149\000\003\000\
\\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\103\000\123\001\
\\104\000\122\001\114\000\121\001\115\000\008\000\116\000\007\000\
\\123\000\120\001\143\000\005\000\148\000\004\000\149\000\003\000\
\\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\101\000\125\001\
\\104\000\097\000\114\000\096\000\115\000\008\000\116\000\007\000\
\\121\000\124\001\143\000\005\000\148\000\004\000\149\000\003\000\
\\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\103\000\129\001\
\\104\000\128\001\114\000\127\001\115\000\008\000\116\000\007\000\
\\123\000\126\001\143\000\005\000\148\000\004\000\149\000\003\000\
\\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\101\000\131\001\
\\104\000\097\000\114\000\096\000\115\000\008\000\116\000\007\000\
\\121\000\130\001\143\000\005\000\148\000\004\000\149\000\003\000\
\\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\133\001\
\\114\000\132\001\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\135\001\
\\114\000\134\001\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\137\001\
\\114\000\136\001\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\045\000\138\001\046\000\209\000\047\000\208\000\048\000\207\000\
\\146\000\206\000\147\000\205\000\000\000\
\\050\000\115\000\051\000\139\001\053\000\113\000\072\000\112\000\
\\143\000\005\000\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\000\000\
\\064\000\141\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\115\000\051\000\025\001\053\000\113\000\072\000\112\000\
\\088\000\150\001\136\000\149\001\143\000\005\000\148\000\004\000\
\\149\000\109\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\005\000\140\000\025\000\154\001\042\000\138\000\043\000\137\000\
\\082\000\014\000\090\000\013\000\128\000\006\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\103\000\158\001\
\\104\000\157\001\114\000\156\001\115\000\008\000\116\000\007\000\
\\123\000\155\001\143\000\005\000\148\000\004\000\149\000\003\000\
\\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\103\000\162\001\
\\104\000\161\001\114\000\160\001\115\000\008\000\116\000\007\000\
\\123\000\159\001\143\000\005\000\148\000\004\000\149\000\003\000\
\\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\166\001\
\\114\000\165\001\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\168\001\
\\114\000\167\001\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\050\000\115\000\053\000\164\000\073\000\163\000\106\000\170\001\
\\108\000\161\000\124\000\169\001\126\000\159\000\143\000\005\000\
\\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\045\000\172\001\046\000\209\000\047\000\208\000\048\000\207\000\
\\146\000\206\000\147\000\205\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\115\000\051\000\169\000\053\000\113\000\072\000\112\000\
\\084\000\168\000\105\000\174\001\111\000\173\001\113\000\165\000\
\\143\000\005\000\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\176\001\
\\114\000\175\001\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\060\000\177\001\000\000\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\179\001\000\000\
\\045\000\180\001\046\000\209\000\047\000\208\000\048\000\207\000\
\\146\000\206\000\147\000\205\000\000\000\
\\000\000\
\\049\000\182\001\110\000\181\001\000\000\
\\000\000\
\\050\000\115\000\051\000\169\000\053\000\113\000\072\000\112\000\
\\084\000\168\000\105\000\185\001\111\000\184\001\113\000\165\000\
\\143\000\005\000\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\050\000\115\000\051\000\169\000\053\000\113\000\072\000\112\000\
\\084\000\168\000\105\000\187\001\111\000\186\001\113\000\165\000\
\\143\000\005\000\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\049\000\182\001\110\000\188\001\000\000\
\\090\000\151\000\091\000\150\000\092\000\149\000\093\000\148\000\
\\094\000\190\001\128\000\146\000\129\000\145\000\130\000\144\000\
\\131\000\143\000\132\000\189\001\000\000\
\\050\000\115\000\051\000\181\000\053\000\113\000\072\000\112\000\
\\084\000\180\000\105\000\174\001\143\000\005\000\148\000\004\000\
\\149\000\109\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\104\000\191\001\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\104\000\192\001\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\050\000\115\000\051\000\181\000\053\000\113\000\072\000\112\000\
\\084\000\180\000\105\000\235\000\143\000\005\000\148\000\004\000\
\\149\000\109\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\104\000\193\001\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\050\000\115\000\051\000\194\001\053\000\113\000\072\000\112\000\
\\084\000\180\000\105\000\239\000\143\000\005\000\148\000\004\000\
\\149\000\109\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\104\000\195\001\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\104\000\196\001\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\000\000\
\\023\000\186\000\024\000\197\001\050\000\016\000\095\000\184\000\
\\096\000\011\000\104\000\183\000\143\000\005\000\148\000\004\000\
\\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\090\000\151\000\091\000\150\000\092\000\040\001\000\000\
\\050\000\115\000\051\000\204\001\053\000\113\000\072\000\112\000\
\\085\000\111\000\143\000\005\000\148\000\004\000\149\000\109\000\
\\153\000\001\000\000\000\
\\049\000\182\001\110\000\123\000\000\000\
\\090\000\151\000\091\000\150\000\092\000\149\000\093\000\087\001\
\\094\000\206\001\000\000\
\\050\000\115\000\053\000\164\000\073\000\208\001\106\000\162\000\
\\108\000\207\001\143\000\005\000\148\000\004\000\149\000\109\000\
\\153\000\001\000\000\000\
\\049\000\175\000\056\000\209\001\000\000\
\\049\000\182\001\110\000\204\000\000\000\
\\000\000\
\\000\000\
\\142\000\214\001\143\000\213\001\148\000\212\001\000\000\
\\019\000\218\001\020\000\217\001\143\000\216\001\000\000\
\\000\000\
\\021\000\220\001\022\000\197\000\143\000\196\000\000\000\
\\019\000\221\001\020\000\217\001\143\000\216\001\000\000\
\\000\000\
\\000\000\
\\016\000\226\001\017\000\225\001\040\000\224\001\041\000\223\001\
\\143\000\222\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\046\000\239\001\047\000\208\000\048\000\207\000\146\000\206\000\
\\147\000\205\000\000\000\
\\045\000\240\001\046\000\209\000\047\000\208\000\048\000\207\000\
\\146\000\206\000\147\000\205\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\099\000\247\001\119\000\246\001\000\000\
\\099\000\250\001\119\000\249\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\086\000\252\001\137\000\251\001\000\000\
\\086\000\255\001\137\000\254\001\000\000\
\\000\000\
\\000\000\
\\050\000\115\000\051\000\000\002\053\000\113\000\072\000\112\000\
\\143\000\005\000\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\062\000\001\002\000\000\
\\000\000\
\\000\000\
\\050\000\115\000\051\000\019\001\053\000\113\000\070\000\003\002\
\\072\000\112\000\143\000\005\000\148\000\004\000\149\000\109\000\
\\153\000\001\000\000\000\
\\000\000\
\\050\000\115\000\051\000\019\001\053\000\113\000\070\000\004\002\
\\072\000\112\000\143\000\005\000\148\000\004\000\149\000\109\000\
\\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\045\000\007\002\046\000\209\000\047\000\208\000\048\000\207\000\
\\146\000\206\000\147\000\205\000\000\000\
\\000\000\
\\074\000\009\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\090\000\151\000\091\000\150\000\092\000\149\000\093\000\148\000\
\\094\000\020\002\128\000\146\000\129\000\145\000\130\000\144\000\
\\131\000\143\000\132\000\019\002\000\000\
\\090\000\151\000\091\000\150\000\092\000\149\000\093\000\148\000\
\\094\000\022\002\128\000\146\000\129\000\145\000\130\000\144\000\
\\131\000\143\000\132\000\021\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\028\002\
\\114\000\027\002\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\054\000\029\002\143\000\171\000\144\000\170\000\000\000\
\\060\000\030\002\000\000\
\\000\000\
\\000\000\
\\146\000\031\002\000\000\
\\055\000\033\002\143\000\171\000\144\000\032\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\104\000\037\002\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\101\000\119\001\
\\104\000\082\001\143\000\005\000\148\000\004\000\149\000\003\000\
\\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\103\000\129\001\
\\104\000\038\002\143\000\005\000\148\000\004\000\149\000\003\000\
\\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\101\000\131\001\
\\104\000\082\001\143\000\005\000\148\000\004\000\149\000\003\000\
\\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\104\000\039\002\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\103\000\162\001\
\\104\000\040\002\143\000\005\000\148\000\004\000\149\000\003\000\
\\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\050\000\115\000\051\000\042\002\053\000\113\000\072\000\112\000\
\\088\000\024\001\143\000\005\000\148\000\004\000\149\000\109\000\
\\153\000\001\000\000\000\
\\000\000\
\\107\000\051\001\000\000\
\\064\000\046\002\000\000\
\\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\104\000\049\002\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\050\000\115\000\051\000\181\000\053\000\113\000\072\000\112\000\
\\084\000\180\000\105\000\187\001\143\000\005\000\148\000\004\000\
\\149\000\109\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\005\000\140\000\025\000\051\002\042\000\138\000\043\000\137\000\
\\082\000\014\000\090\000\013\000\128\000\006\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\016\000\053\002\017\000\225\001\040\000\224\001\041\000\223\001\000\000\
\\000\000\
\\031\000\054\002\000\000\
\\000\000\
\\017\000\225\001\040\000\057\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\015\000\060\002\143\000\134\000\145\000\059\002\000\000\
\\014\000\062\002\049\000\061\002\000\000\
\\078\000\063\002\143\000\005\000\148\000\129\000\000\000\
\\016\000\064\002\017\000\225\001\040\000\224\001\041\000\223\001\000\000\
\\011\000\066\002\143\000\065\002\000\000\
\\013\000\068\002\049\000\067\002\000\000\
\\009\000\071\002\010\000\070\002\050\000\016\000\095\000\184\000\
\\096\000\011\000\104\000\069\002\143\000\005\000\148\000\004\000\
\\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\008\000\074\002\143\000\073\002\000\000\
\\007\000\077\002\079\000\076\002\143\000\005\000\148\000\075\002\000\000\
\\076\000\080\002\143\000\079\002\000\000\
\\014\000\081\002\049\000\061\002\000\000\
\\000\000\
\\000\000\
\\045\000\082\002\046\000\209\000\047\000\208\000\048\000\207\000\
\\146\000\206\000\147\000\205\000\000\000\
\\000\000\
\\146\000\206\000\147\000\083\002\000\000\
\\045\000\085\002\046\000\209\000\047\000\208\000\048\000\207\000\
\\075\000\084\002\146\000\206\000\147\000\205\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\097\000\087\002\117\000\086\002\143\000\086\000\151\000\089\000\
\\152\000\084\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\115\000\051\000\114\000\053\000\113\000\072\000\112\000\
\\085\000\089\002\135\000\088\002\143\000\005\000\148\000\004\000\
\\149\000\109\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\063\000\090\002\000\000\
\\063\000\092\002\000\000\
\\050\000\115\000\051\000\093\002\053\000\113\000\072\000\112\000\
\\143\000\005\000\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\115\000\051\000\169\000\053\000\113\000\072\000\112\000\
\\084\000\168\000\105\000\096\002\111\000\095\002\113\000\165\000\
\\143\000\005\000\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\089\000\098\002\134\000\097\002\000\000\
\\089\000\101\002\134\000\100\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\107\002\
\\114\000\106\002\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\109\002\
\\114\000\108\002\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\111\002\
\\114\000\110\002\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\050\000\016\000\095\000\012\000\096\000\011\000\104\000\113\002\
\\114\000\112\002\115\000\008\000\116\000\007\000\143\000\005\000\
\\148\000\004\000\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\109\000\115\002\127\000\114\002\000\000\
\\109\000\118\002\127\000\117\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\068\000\120\002\000\000\
\\058\000\121\002\000\000\
\\090\000\151\000\091\000\150\000\092\000\149\000\093\000\148\000\
\\094\000\124\002\128\000\146\000\129\000\145\000\130\000\144\000\
\\131\000\143\000\132\000\123\002\000\000\
\\000\000\
\\000\000\
\\099\000\250\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\104\000\126\002\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\000\000\
\\050\000\115\000\051\000\042\002\053\000\113\000\072\000\112\000\
\\088\000\150\001\143\000\005\000\148\000\004\000\149\000\109\000\
\\153\000\001\000\000\000\
\\090\000\151\000\091\000\150\000\092\000\149\000\093\000\087\001\
\\094\000\022\002\000\000\
\\050\000\115\000\053\000\164\000\073\000\208\001\106\000\170\001\
\\108\000\207\001\143\000\005\000\148\000\004\000\149\000\109\000\
\\153\000\001\000\000\000\
\\000\000\
\\049\000\182\001\110\000\129\002\000\000\
\\090\000\151\000\091\000\150\000\092\000\149\000\093\000\087\001\
\\094\000\190\001\000\000\
\\000\000\
\\005\000\140\000\025\000\134\002\026\000\133\002\042\000\138\000\
\\043\000\137\000\082\000\014\000\090\000\013\000\128\000\006\000\
\\143\000\132\002\148\000\131\002\000\000\
\\000\000\
\\026\000\138\002\143\000\132\002\148\000\131\002\000\000\
\\000\000\
\\000\000\
\\018\000\141\002\143\000\199\000\000\000\
\\019\000\142\002\020\000\217\001\143\000\216\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\146\000\145\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\068\000\147\002\000\000\
\\000\000\
\\146\000\148\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\033\000\149\002\000\000\
\\090\000\151\000\091\000\150\000\092\000\149\000\093\000\155\002\
\\094\000\086\001\128\000\154\002\139\000\153\002\140\000\152\002\
\\141\000\151\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\080\000\163\002\146\000\206\000\147\000\162\002\000\000\
\\076\000\164\002\143\000\079\002\000\000\
\\000\000\
\\000\000\
\\067\000\165\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\052\000\167\002\143\000\013\001\151\000\012\001\152\000\084\000\000\000\
\\000\000\
\\000\000\
\\050\000\115\000\051\000\169\000\053\000\113\000\072\000\112\000\
\\084\000\168\000\105\000\169\002\111\000\168\002\113\000\165\000\
\\143\000\005\000\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\087\000\171\002\138\000\170\002\000\000\
\\087\000\174\002\138\000\173\002\000\000\
\\000\000\
\\000\000\
\\049\000\124\000\110\000\176\002\133\000\175\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\115\000\053\000\164\000\073\000\163\000\108\000\178\002\
\\126\000\177\002\143\000\005\000\148\000\004\000\149\000\109\000\
\\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\045\000\179\002\046\000\209\000\047\000\208\000\048\000\207\000\
\\146\000\206\000\147\000\205\000\000\000\
\\059\000\180\002\000\000\
\\000\000\
\\049\000\175\000\056\000\182\002\000\000\
\\000\000\
\\000\000\
\\097\000\087\002\143\000\086\000\151\000\081\001\152\000\084\000\000\000\
\\086\000\255\001\000\000\
\\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\104\000\188\002\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\000\000\
\\050\000\016\000\095\000\184\000\096\000\011\000\104\000\190\002\
\\143\000\005\000\148\000\004\000\149\000\003\000\150\000\002\000\
\\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\005\000\140\000\025\000\194\002\042\000\138\000\043\000\137\000\
\\082\000\014\000\090\000\013\000\128\000\006\000\000\000\
\\005\000\140\000\025\000\195\002\042\000\138\000\043\000\137\000\
\\082\000\014\000\090\000\013\000\128\000\006\000\000\000\
\\142\000\196\002\143\000\213\001\148\000\212\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\143\000\198\002\000\000\
\\045\000\200\002\046\000\209\000\047\000\208\000\048\000\207\000\
\\146\000\206\000\147\000\205\000\000\000\
\\037\000\201\002\000\000\
\\016\000\203\002\017\000\225\001\040\000\224\001\041\000\223\001\000\000\
\\034\000\204\002\000\000\
\\000\000\
\\000\000\
\\009\000\071\002\010\000\207\002\050\000\016\000\095\000\184\000\
\\096\000\011\000\104\000\069\002\143\000\005\000\148\000\004\000\
\\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\005\000\140\000\042\000\208\002\082\000\014\000\090\000\013\000\
\\128\000\006\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\090\000\151\000\091\000\150\000\092\000\040\001\128\000\154\002\
\\140\000\210\002\000\000\
\\090\000\151\000\091\000\150\000\092\000\149\000\093\000\155\002\
\\094\000\212\002\128\000\154\002\139\000\211\002\140\000\152\002\
\\141\000\151\002\000\000\
\\023\000\186\000\024\000\213\002\050\000\016\000\095\000\184\000\
\\096\000\011\000\104\000\183\000\143\000\005\000\148\000\004\000\
\\149\000\003\000\150\000\002\000\153\000\001\000\000\000\
\\021\000\214\002\022\000\197\000\143\000\196\000\000\000\
\\020\000\215\002\143\000\216\001\000\000\
\\079\000\217\002\143\000\005\000\148\000\216\002\000\000\
\\007\000\218\002\079\000\076\002\143\000\005\000\148\000\075\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\044\000\220\002\143\000\086\000\151\000\109\001\152\000\084\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\115\000\051\000\025\001\053\000\113\000\072\000\112\000\
\\088\000\224\002\136\000\223\002\143\000\005\000\148\000\004\000\
\\149\000\109\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\089\000\098\002\000\000\
\\000\000\
\\055\000\226\002\143\000\171\000\144\000\032\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\115\000\051\000\204\001\053\000\113\000\072\000\112\000\
\\085\000\089\002\143\000\005\000\148\000\004\000\149\000\109\000\
\\153\000\001\000\000\000\
\\000\000\
\\050\000\115\000\051\000\181\000\053\000\113\000\072\000\112\000\
\\084\000\180\000\105\000\228\002\143\000\005\000\148\000\004\000\
\\149\000\109\000\153\000\001\000\000\000\
\\109\000\118\002\000\000\
\\090\000\151\000\091\000\150\000\092\000\149\000\093\000\087\001\
\\094\000\124\002\000\000\
\\000\000\
\\005\000\140\000\025\000\231\002\026\000\230\002\042\000\138\000\
\\043\000\137\000\082\000\014\000\090\000\013\000\128\000\006\000\
\\143\000\132\002\148\000\131\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\016\000\237\002\017\000\225\001\040\000\224\001\041\000\223\001\000\000\
\\038\000\238\002\000\000\
\\000\000\
\\014\000\240\002\049\000\061\002\000\000\
\\000\000\
\\000\000\
\\011\000\242\002\143\000\065\002\000\000\
\\012\000\244\002\143\000\171\000\144\000\243\002\000\000\
\\000\000\
\\000\000\
\\023\000\245\002\050\000\016\000\095\000\184\000\096\000\011\000\
\\104\000\183\000\143\000\005\000\148\000\004\000\149\000\003\000\
\\150\000\002\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\032\000\248\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\080\000\251\002\146\000\206\000\147\000\250\002\000\000\
\\000\000\
\\065\000\252\002\000\000\
\\065\000\254\002\000\000\
\\000\000\
\\000\000\
\\049\000\182\001\110\000\176\002\000\000\
\\000\000\
\\050\000\115\000\051\000\181\000\053\000\113\000\072\000\112\000\
\\084\000\180\000\105\000\255\002\143\000\005\000\148\000\004\000\
\\149\000\109\000\153\000\001\000\000\000\
\\087\000\174\002\000\000\
\\050\000\115\000\053\000\164\000\073\000\208\001\108\000\178\002\
\\143\000\005\000\148\000\004\000\149\000\109\000\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\026\000\003\003\143\000\132\002\148\000\131\002\000\000\
\\000\000\
\\000\000\
\\019\000\004\003\020\000\217\001\143\000\216\001\000\000\
\\026\000\005\003\143\000\132\002\148\000\131\002\000\000\
\\000\000\
\\000\000\
\\015\000\008\003\143\000\134\000\145\000\059\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\068\000\009\003\000\000\
\\036\000\010\003\000\000\
\\000\000\
\\090\000\151\000\091\000\150\000\092\000\149\000\093\000\155\002\
\\094\000\014\003\128\000\154\002\139\000\013\003\140\000\152\002\
\\141\000\151\002\000\000\
\\090\000\151\000\091\000\150\000\092\000\149\000\093\000\155\002\
\\094\000\022\002\128\000\154\002\139\000\015\003\140\000\152\002\
\\141\000\151\002\000\000\
\\000\000\
\\008\000\016\003\143\000\073\002\000\000\
\\000\000\
\\000\000\
\\087\000\018\003\138\000\017\003\000\000\
\\045\000\019\003\046\000\209\000\047\000\208\000\048\000\207\000\
\\146\000\206\000\147\000\205\000\000\000\
\\087\000\021\003\138\000\020\003\000\000\
\\000\000\
\\050\000\115\000\051\000\042\002\053\000\113\000\072\000\112\000\
\\088\000\224\002\143\000\005\000\148\000\004\000\149\000\109\000\
\\153\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\029\000\025\003\000\000\
\\029\000\027\003\000\000\
\\000\000\
\\000\000\
\\035\000\029\003\000\000\
\\000\000\
\\013\000\031\003\049\000\067\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\065\000\035\003\000\000\
\\000\000\
\\000\000\
\\065\000\036\003\000\000\
\\000\000\
\\026\000\037\003\143\000\132\002\148\000\131\002\000\000\
\\000\000\
\\006\000\039\003\143\000\201\000\000\000\
\\000\000\
\\026\000\040\003\143\000\132\002\148\000\131\002\000\000\
\\000\000\
\\012\000\042\003\143\000\171\000\144\000\243\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\087\000\021\003\000\000\
\\029\000\043\003\000\000\
\\029\000\044\003\000\000\
\\000\000\
\\029\000\045\003\000\000\
\\029\000\046\003\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\"
val numstates = 816
val numrules = 425
val s = ref "" and index = ref 0
val string_to_int = fn () => 
let val i = !index
in index := i+2;
String.ord(String.nth i (!s)) + String.ord(String.nth (i+1) (!s)) * 256
end
val string_to_list = fn s' =>
    let val len = String.size s'
        fun f () =
           if !index < len then string_to_int() :: f()
           else nil
   in index := 0; s := s'; f ()
   end
val string_to_pairlist = fn (conv_key,conv_entry) =>
     let fun f () =
         case string_to_int()
         of 0 => EMPTY
          | n => PAIR(conv_key (n-1),conv_entry (string_to_int()),f())
     in f
     end
val string_to_pairlist_default = fn (conv_key,conv_entry) =>
    let val conv_row = string_to_pairlist(conv_key,conv_entry)
    in fn () =>
       let val default = conv_entry(string_to_int())
           val row = conv_row()
       in (row,default)
       end
   end
val string_to_table = fn (convert_row,s') =>
    let val len = String.size s'
        fun f ()=
          if !index < len then convert_row() :: f()
          else nil
    in (s := s'; index := 0; f ())
    end
local
  val memo = Array.create (numstates+numrules) ERROR
  val _ =let fun g i=(Array.update(memo,i,REDUCE(i-numstates)); g(i+1))
  fun f i =
     if i=numstates then g i
     else (Array.update(memo,i,SHIFT (STATE i)); f (i+1))
   in f 0 handle Array.Update _ => ()
   end
in
  val entry_to_action = fn 0 => ACCEPT | 1 => ERROR | j => Array.sub(memo,(j-2))
end
val gotoT=Array.fromList(string_to_table(string_to_pairlist(NT,STATE),gotoT))
val actionRows=string_to_table(string_to_pairlist_default(T,entry_to_action),actionRows)
val actionRowNumbers = string_to_list actionRowNumbers
val actionT = let val actionRowLookUp=
let val a=Array.fromList(actionRows) in fn i=>Array.sub(a,i) end
in Array.fromList(map actionRowLookUp actionRowNumbers)
end
in LrTable.mkLrTable {actions=actionT,gotos=gotoT,numRules=numrules,
numStates=numstates,initialState=STATE 0}
end
end
local open Header in
type pos = LexBasics.pos
type arg = unit
structure MlyValue = 
struct
datatype svalue = VOID | ntVOID of unit ->  unit
 | DIGIT of unit ->  (int) | TYVAR of unit ->  (string)
 | ID of unit ->  (string) | STRING of unit ->  (string)
 | REAL of unit ->  (real) | NEGINT of unit ->  (int)
 | POSINT2 of unit ->  (int) | QUAL_STAR of unit ->  (string list)
 | QUAL_ID of unit ->  (string list) | Integer of unit ->  (int)
 | PosInt of unit ->  (int) | Label of unit ->  (lab)
 | LongOpEqIdent of unit ->  (string list op_opt)
 | LongOpIdent of unit ->  (string list op_opt)
 | LongIdent of unit ->  (string list)
 | LongTypeIdent of unit ->  (string list)
 | TypeIdent of unit ->  (string) | EqIdent of unit ->  (string)
 | OpIdent of unit ->  (string op_opt) | Ident of unit ->  (string)
 | StrExp_guarded of unit ->  (strexp)
 | NonEmptyStrDec_SpecExp of unit ->  (strdec)
 | OneStrDec_SpecExp of unit ->  (strdec)
 | StrDec_SpecExp of unit ->  (strdec)
 | AndFnValBind_optquestionmark of unit ->  (valbind Option)
 | AndValBind_optquestionmark of unit ->  (valbind Option)
 | FnValBindquestionmark of unit ->  (valbind)
 | ValBindquestionmark of unit ->  (valbind)
 | AndTypBind_optquestionmark of unit ->  (typbind Option)
 | TypBindquestionmark of unit ->  (typbind)
 | Decquestionmark of unit ->  (dec)
 | NonEmptyDecquestionmark of unit ->  (dec)
 | OneDec_or_SEMICOLONquestionmark of unit ->  (dec Option)
 | OneDecquestionmark of unit ->  (dec)
 | OneDec_sans_LOCALquestionmark of unit ->  (dec)
 | BarFClause_optquestionmark of unit ->  (FClause Option)
 | FClausequestionmark of unit ->  (FClause)
 | AndFValBind_optquestionmark of unit ->  (FValBind Option)
 | FValBindquestionmark of unit ->  (FValBind)
 | ExpSemicolon_seq2questionmark of unit ->  (exp list)
 | ExpComma_seq2questionmark of unit ->  (exp list)
 | ExpComma_seq1questionmark of unit ->  (exp list)
 | ExpComma_seq0questionmark of unit ->  (exp list)
 | CommaExpRow_optquestionmark of unit ->  (exprow Option)
 | ExpRow_optquestionmark of unit ->  (exprow Option)
 | ExpRowquestionmark of unit ->  (exprow)
 | AtExpquestionmark of unit ->  (atexp)
 | AtExp_seq1questionmark of unit ->  (atexp list)
 | Exp_questionmark of unit ->  (exp)
 | MRulequestionmark of unit ->  (mrule)
 | BarMatch_optquestionmark of unit ->  (match Option)
 | Match_questionmark of unit ->  (match)
 | TypBindbullet of unit ->  (typbind)
 | BarFClause_optbullet of unit ->  (FClause Option)
 | FClausebullet of unit ->  (FClause)
 | AndFValBind_optbullet of unit ->  (FValBind Option)
 | FValBindbullet of unit ->  (FValBind)
 | Match_bullet of unit ->  (match) | Exp_bullet of unit ->  (exp)
 | ExpSemicolon_seq2bullet of unit ->  (exp list)
 | ExpComma_seq2bullet of unit ->  (exp list)
 | ExpComma_seq1bullet of unit ->  (exp list)
 | ExpComma_seq0bullet of unit ->  (exp list)
 | CommaExpRow_optbullet of unit ->  (exprow Option)
 | ExpRow_optbullet of unit ->  (exprow Option)
 | ExpRowbullet of unit ->  (exprow)
 | AtExp_seq1bullet of unit ->  (atexp list)
 | AtExpbullet of unit ->  (atexp) | Decbullet of unit ->  (dec)
 | NonEmptyDecbullet of unit ->  (dec)
 | OneDec_or_SEMICOLONbullet of unit ->  (dec Option)
 | OneDecbullet of unit ->  (dec)
 | OneDec_sans_LOCALbullet of unit ->  (dec)
 | AndTypBind_optbullet of unit ->  (typbind Option)
 | FnValBindbullet of unit ->  (valbind)
 | AndFnValBind_optbullet of unit ->  (valbind Option)
 | AndValBind_optbullet of unit ->  (valbind Option)
 | ValBindbullet of unit ->  (valbind)
 | MRulebullet of unit ->  (mrule)
 | BarMatch_optbullet of unit ->  (match Option)
 | OneDec_sans_LOCAL of unit ->  (dec)
 | DIGIT_opt of unit ->  (int Option)
 | LongTypeIdentEq_seq2 of unit ->  (string list WithInfo list)
 | LongIdentEq_seq2 of unit ->  (string list WithInfo list)
 | LongIdent_seq1 of unit ->  (string list WithInfo list)
 | EqIdent_seq1 of unit ->  (string list)
 | Ident_seq1 of unit ->  (string WithInfo list)
 | TyComma_seq2 of unit ->  (ty list)
 | TyVarComma_seq1 of unit ->  (tyvar list)
 | AtPat_seq1 of unit ->  (atpat list)
 | AtPat_seq2 of unit ->  (atpat list)
 | PatComma_seq2 of unit ->  (pat list)
 | PatComma_seq1 of unit ->  (pat list)
 | PatComma_seq0 of unit ->  (pat list)
 | OfTy_opt of unit ->  (ty Option)
 | CommaTyRow_opt of unit ->  (tyrow Option)
 | TyRow_opt of unit ->  (tyrow Option)
 | ColonTy_seq1 of unit ->  ( ( ty * pos )  list)
 | ColonTy_opt of unit ->  (ty Option)
 | CommaPatRow_opt of unit ->  (patrow Option)
 | AsPat_opt of unit ->  (pat Option)
 | PatRow_opt of unit ->  (patrow Option)
 | AndExBind_opt of unit ->  (exbind Option)
 | BarConBind_opt of unit ->  (conbind Option)
 | AndDatBind_opt of unit ->  (datbind Option)
 | Exp_ of unit ->  (exp) | DatBind of unit ->  (datbind)
 | ConBind of unit ->  (conbind) | ExBind of unit ->  (exbind)
 | AtPat of unit ->  (atpat) | PatRow of unit ->  (patrow)
 | Pat of unit ->  (pat) | SCon of unit ->  (scon)
 | TyVarSeq of unit ->  (tyvar list) | AtomicTy of unit ->  (ty)
 | Ty_sans_STAR of unit ->  (ty) | TupleTy of unit ->  (ty list)
 | Ty of unit ->  (ty) | TyRow of unit ->  (tyrow)
 | NonEmptyStrDec of unit ->  (strdec)
 | OneStrDec_or_SEMICOLON of unit ->  (strdec Option)
 | NonEmptySpec of unit ->  (spec)
 | OneSpec_or_SEMICOLON of unit ->  (spec Option)
 | AndAx_opt of unit ->  (ax Option)
 | AndValDesc_opt of unit ->  (valdesc Option)
 | AndTypDesc_opt of unit ->  (typdesc Option)
 | AndDatDesc_opt of unit ->  (datdesc Option)
 | BarConDesc_opt of unit ->  (condesc Option)
 | AndExDesc_opt of unit ->  (exdesc Option)
 | AndAxDesc_opt of unit ->  (axdesc Option)
 | AndStrDesc_opt of unit ->  (strdesc Option)
 | AndSigBind_opt of unit ->  (sigbind Option)
 | AndStrBind_opt of unit ->  (strbind Option)
 | AndFunBind_opt of unit ->  (funbind Option)
 | FunDec_sans_SC_opt of unit ->  (fundec Option)
 | SigDec_sans_SC_opt of unit ->  (sigdec Option)
 | StrExp of unit ->  (strexp) | StrDec of unit ->  (strdec)
 | Ax of unit ->  (ax) | AxExp of unit ->  (axexp)
 | SglStrBind of unit ->  (sglstrbind) | StrBind of unit ->  (strbind)
 | SigExp of unit ->  (sigexp) | PSigExp of unit ->  (psigexp)
 | SigBind of unit ->  (sigbind) | OneSpec of unit ->  (spec)
 | Spec of unit ->  (spec) | ValDesc of unit ->  (valdesc)
 | TypDesc of unit ->  (typdesc) | DatDesc of unit ->  (datdesc)
 | ConDesc of unit ->  (condesc) | ExDesc of unit ->  (exdesc)
 | AxDesc of unit ->  (axdesc) | SpecExp of unit ->  (specexp)
 | StrDesc of unit ->  (strdesc) | SharEq of unit ->  (shareq)
 | FunBind of unit ->  (funbind) | OneStrDec of unit ->  (strdec)
 | FunDec_sans_SEMICOLON of unit ->  (fundec)
 | StrDec_sans_SEMICOLON of unit ->  (strdec)
 | SigDec_sans_SEMICOLON of unit ->  (sigdec)
 | TopDec of unit ->  (topdec)
end
type svalue = MlyValue.svalue
type result = topdec
end
structure EC=
struct
open LrTable
val is_keyword =
fn (T 67) => true | (T 66) => true | (T 65) => true | (T 17) => true
 | (T 16) => true | (T 15) => true | (T 14) => true | (T 13) => true
 | (T 12) => true | (T 11) => true | (T 10) => true | (T 49) => true
 | (T 48) => true | (T 47) => true | (T 46) => true | (T 45) => true
 | (T 44) => true | (T 43) => true | (T 42) => true | (T 41) => true
 | (T 40) => true | (T 39) => true | (T 38) => true | (T 37) => true
 | (T 36) => true | (T 35) => true | (T 34) => true | (T 33) => true
 | (T 32) => true | (T 31) => true | (T 30) => true | (T 29) => true
 | (T 28) => true | (T 27) => true | (T 26) => true | (T 25) => true
 | (T 24) => true | (T 23) => true | (T 22) => true | (T 21) => true
 | (T 20) => true | (T 19) => true | (T 18) => true | (T 7) => true | 
(T 6) => true | (T 5) => true | (T 4) => true | (T 3) => true | (T 2)
 => true | (T 1) => true | (T 0) => true | _ => false
val preferred_insert =
fn _ => false
val preferred_subst =
fn  _ => nil
val noShift = 
fn (T 77) => true | _ => false
val showTerminal =
fn (T 0) => "EQTYPE"
  | (T 1) => "FUNCTOR"
  | (T 2) => "INCLUDE"
  | (T 3) => "SHARING"
  | (T 4) => "SIG"
  | (T 5) => "SIGNATURE"
  | (T 6) => "STRUCT"
  | (T 7) => "STRUCTURE"
  | (T 8) => "QUAL_ID"
  | (T 9) => "QUAL_STAR"
  | (T 10) => "AXIOM"
  | (T 11) => "IMPLIES"
  | (T 12) => "IFF"
  | (T 13) => "EXISTS"
  | (T 14) => "FORALL"
  | (T 15) => "PROPER"
  | (T 16) => "RAISES"
  | (T 17) => "TERMINATES"
  | (T 18) => "ABSTYPE"
  | (T 19) => "AND"
  | (T 20) => "ANDALSO"
  | (T 21) => "AS"
  | (T 22) => "CASE"
  | (T 23) => "DO"
  | (T 24) => "DATATYPE"
  | (T 25) => "ELSE"
  | (T 26) => "END"
  | (T 27) => "EXCEPTION"
  | (T 28) => "FN"
  | (T 29) => "FUN"
  | (T 30) => "HANDLE"
  | (T 31) => "IF"
  | (T 32) => "IN"
  | (T 33) => "INFIX"
  | (T 34) => "INFIXR"
  | (T 35) => "LET"
  | (T 36) => "LOCAL"
  | (T 37) => "NONFIX"
  | (T 38) => "OF"
  | (T 39) => "OP"
  | (T 40) => "OPEN"
  | (T 41) => "ORELSE"
  | (T 42) => "RAISE"
  | (T 43) => "REC"
  | (T 44) => "THEN"
  | (T 45) => "TYPE"
  | (T 46) => "VAL"
  | (T 47) => "WITH"
  | (T 48) => "WITHTYPE"
  | (T 49) => "WHILE"
  | (T 50) => "LPAREN"
  | (T 51) => "RPAREN"
  | (T 52) => "LBRACKET"
  | (T 53) => "RBRACKET"
  | (T 54) => "LBRACE"
  | (T 55) => "RBRACE"
  | (T 56) => "COMMA"
  | (T 57) => "COLON"
  | (T 58) => "SEMICOLON"
  | (T 59) => "DOTDOTDOT"
  | (T 60) => "UNDERBAR"
  | (T 61) => "BAR"
  | (T 62) => "DARROW"
  | (T 63) => "ARROW"
  | (T 64) => "HASH"
  | (T 65) => "QUESTIONMARK"
  | (T 66) => "EQUALEQUAL"
  | (T 67) => "EQUALSLASHEQUAL"
  | (T 68) => "EQUALS"
  | (T 69) => "STAR"
  | (T 70) => "POSINT2"
  | (T 71) => "NEGINT"
  | (T 72) => "REAL"
  | (T 73) => "STRING"
  | (T 74) => "ID"
  | (T 75) => "TYVAR"
  | (T 76) => "DIGIT"
  | (T 77) => "EOF"
  | _ => "bogus-term"
val errtermvalue=
let open Header in
fn (T 8) => MlyValue.QUAL_ID(fn () => (["bogus"])) | 
(T 9) => MlyValue.QUAL_STAR(fn () => (["bogus"])) | 
(T 70) => MlyValue.POSINT2(fn () => (0)) | 
(T 71) => MlyValue.NEGINT(fn () => (0)) | 
(T 72) => MlyValue.REAL(fn () => (0.0)) | 
(T 73) => MlyValue.STRING(fn () => ("")) | 
(T 74) => MlyValue.ID(fn () => ("bogus")) | 
(T 75) => MlyValue.TYVAR(fn () => ("'bogus")) | 
(T 76) => MlyValue.DIGIT(fn () => (0)) | 
_ => MlyValue.VOID
end
val terms = (T 0) :: (T 1) :: (T 2) :: (T 3) :: (T 4) :: (T 5) :: (T 6
) :: (T 7) :: (T 10) :: (T 11) :: (T 12) :: (T 13) :: (T 14) :: (T 15)
 :: (T 16) :: (T 17) :: (T 18) :: (T 19) :: (T 20) :: (T 21) :: (T 22)
 :: (T 23) :: (T 24) :: (T 25) :: (T 26) :: (T 27) :: (T 28) :: (T 29)
 :: (T 30) :: (T 31) :: (T 32) :: (T 33) :: (T 34) :: (T 35) :: (T 36)
 :: (T 37) :: (T 38) :: (T 39) :: (T 40) :: (T 41) :: (T 42) :: (T 43)
 :: (T 44) :: (T 45) :: (T 46) :: (T 47) :: (T 48) :: (T 49) :: (T 50)
 :: (T 51) :: (T 52) :: (T 53) :: (T 54) :: (T 55) :: (T 56) :: (T 57)
 :: (T 58) :: (T 59) :: (T 60) :: (T 61) :: (T 62) :: (T 63) :: (T 64)
 :: (T 65) :: (T 66) :: (T 67) :: (T 68) :: (T 69) :: (T 77) :: nil
end
structure Actions =
struct 
exception mlyAction of int
val actions = 
let open Header
in
fn (i392,defaultPos,stack,
    (()):arg) =>
case (i392,stack)
of (0,(_,(MlyValue.ID ID1,ID1left,ID1right))::rest671) => let val 
result=MlyValue.Ident(fn _ => let val ID as ID1=ID1 ()
 in ( ID ) end
)
 in (LrTable.NT 142,(result,ID1left,ID1right),rest671) end
| (1,(_,(_,STAR1left,STAR1right))::rest671) => let val result=
MlyValue.Ident(fn _ => ( "*" ))
 in (LrTable.NT 142,(result,STAR1left,STAR1right),rest671) end
| (2,(_,(MlyValue.Ident Ident1,Ident1left,Ident1right))::rest671) => 
let val result=MlyValue.OpIdent(fn _ => let val Ident as Ident1=Ident1
 ()
 in ( OP_OPT(Ident, false) ) end
)
 in (LrTable.NT 143,(result,Ident1left,Ident1right),rest671) end
| (3,(_,(MlyValue.Ident Ident1,_,Ident1right))::(_,(_,OP1left,_))::
rest671) => let val result=MlyValue.OpIdent(fn _ => let val Ident as 
Ident1=Ident1 ()
 in ( OP_OPT(Ident, true) ) end
)
 in (LrTable.NT 143,(result,OP1left,Ident1right),rest671) end
| (4,(_,(MlyValue.Ident Ident1,Ident1left,Ident1right))::rest671) => 
let val result=MlyValue.EqIdent(fn _ => let val Ident as Ident1=Ident1
 ()
 in ( Ident ) end
)
 in (LrTable.NT 144,(result,Ident1left,Ident1right),rest671) end
| (5,(_,(_,EQUALS1left,EQUALS1right))::rest671) => let val result=
MlyValue.EqIdent(fn _ => ( "=" ))
 in (LrTable.NT 144,(result,EQUALS1left,EQUALS1right),rest671) end
| (6,(_,(MlyValue.ID ID1,ID1left,ID1right))::rest671) => let val 
result=MlyValue.TypeIdent(fn _ => let val ID as ID1=ID1 ()
 in ( ID ) end
)
 in (LrTable.NT 145,(result,ID1left,ID1right),rest671) end
| (7,(_,(MlyValue.TypeIdent TypeIdent1,TypeIdent1left,TypeIdent1right)
)::rest671) => let val result=MlyValue.LongTypeIdent(fn _ => let val 
TypeIdent as TypeIdent1=TypeIdent1 ()
 in ( [TypeIdent] ) end
)
 in (LrTable.NT 146,(result,TypeIdent1left,TypeIdent1right),rest671)
 end
| (8,(_,(MlyValue.QUAL_ID QUAL_ID1,QUAL_ID1left,QUAL_ID1right))::
rest671) => let val result=MlyValue.LongTypeIdent(fn _ => let val 
QUAL_ID as QUAL_ID1=QUAL_ID1 ()
 in ( QUAL_ID ) end
)
 in (LrTable.NT 146,(result,QUAL_ID1left,QUAL_ID1right),rest671) end
| (9,(_,(MlyValue.Ident Ident1,Ident1left,Ident1right))::rest671) => 
let val result=MlyValue.LongIdent(fn _ => let val Ident as Ident1=
Ident1 ()
 in ( [Ident] ) end
)
 in (LrTable.NT 147,(result,Ident1left,Ident1right),rest671) end
| (10,(_,(MlyValue.QUAL_ID QUAL_ID1,QUAL_ID1left,QUAL_ID1right))::
rest671) => let val result=MlyValue.LongIdent(fn _ => let val QUAL_ID
 as QUAL_ID1=QUAL_ID1 ()
 in ( QUAL_ID ) end
)
 in (LrTable.NT 147,(result,QUAL_ID1left,QUAL_ID1right),rest671) end
| (11,(_,(MlyValue.QUAL_STAR QUAL_STAR1,QUAL_STAR1left,QUAL_STAR1right
))::rest671) => let val result=MlyValue.LongIdent(fn _ => let val 
QUAL_STAR as QUAL_STAR1=QUAL_STAR1 ()
 in ( QUAL_STAR ) end
)
 in (LrTable.NT 147,(result,QUAL_STAR1left,QUAL_STAR1right),rest671)
 end
| (12,(_,(MlyValue.LongIdent LongIdent1,LongIdent1left,LongIdent1right
))::rest671) => let val result=MlyValue.LongOpIdent(fn _ => let val 
LongIdent as LongIdent1=LongIdent1 ()
 in ( OP_OPT(LongIdent, false) ) end
)
 in (LrTable.NT 148,(result,LongIdent1left,LongIdent1right),rest671)
 end
| (13,(_,(MlyValue.LongIdent LongIdent1,_,LongIdent1right))::(_,(_,
OP1left,_))::rest671) => let val result=MlyValue.LongOpIdent(fn _ => 
let val LongIdent as LongIdent1=LongIdent1 ()
 in ( OP_OPT(LongIdent, true) ) end
)
 in (LrTable.NT 148,(result,OP1left,LongIdent1right),rest671) end
| (14,(_,(MlyValue.LongOpIdent LongOpIdent1,LongOpIdent1left,
LongOpIdent1right))::rest671) => let val result=MlyValue.LongOpEqIdent
(fn _ => let val LongOpIdent as LongOpIdent1=LongOpIdent1 ()
 in ( LongOpIdent ) end
)
 in (LrTable.NT 149,(result,LongOpIdent1left,LongOpIdent1right),
rest671) end
| (15,(_,(_,EQUALS1left,EQUALS1right))::rest671) => let val result=
MlyValue.LongOpEqIdent(fn _ => ( OP_OPT(["="], false) ))
 in (LrTable.NT 149,(result,EQUALS1left,EQUALS1right),rest671) end
| (16,(_,(_,_,EQUALS1right))::(_,(_,OP1left,_))::rest671) => let val 
result=MlyValue.LongOpEqIdent(fn _ => ( OP_OPT(["="], true) ))
 in (LrTable.NT 149,(result,OP1left,EQUALS1right),rest671) end
| (17,(_,(MlyValue.DIGIT DIGIT1,DIGIT1left,DIGIT1right))::rest671) => 
let val result=MlyValue.DIGIT_opt(fn _ => let val DIGIT as DIGIT1=
DIGIT1 ()
 in ( Some DIGIT ) end
)
 in (LrTable.NT 80,(result,DIGIT1left,DIGIT1right),rest671) end
| (18,rest671) => let val result=MlyValue.DIGIT_opt(fn _ => ( None ))
 in (LrTable.NT 80,(result,defaultPos,defaultPos),rest671) end
| (19,(_,(MlyValue.POSINT2 POSINT21,POSINT21left,POSINT21right))::
rest671) => let val result=MlyValue.Integer(fn _ => let val POSINT2
 as POSINT21=POSINT21 ()
 in ( POSINT2 ) end
)
 in (LrTable.NT 152,(result,POSINT21left,POSINT21right),rest671) end
| (20,(_,(MlyValue.NEGINT NEGINT1,NEGINT1left,NEGINT1right))::rest671)
 => let val result=MlyValue.Integer(fn _ => let val NEGINT as NEGINT1=
NEGINT1 ()
 in ( NEGINT ) end
)
 in (LrTable.NT 152,(result,NEGINT1left,NEGINT1right),rest671) end
| (21,(_,(MlyValue.DIGIT DIGIT1,DIGIT1left,DIGIT1right))::rest671) => 
let val result=MlyValue.Integer(fn _ => let val DIGIT as DIGIT1=DIGIT1
 ()
 in ( DIGIT ) end
)
 in (LrTable.NT 152,(result,DIGIT1left,DIGIT1right),rest671) end
| (22,(_,(MlyValue.POSINT2 POSINT21,POSINT21left,POSINT21right))::
rest671) => let val result=MlyValue.PosInt(fn _ => let val POSINT2 as 
POSINT21=POSINT21 ()
 in ( POSINT2 ) end
)
 in (LrTable.NT 151,(result,POSINT21left,POSINT21right),rest671) end
| (23,(_,(MlyValue.DIGIT DIGIT1,DIGIT1left,DIGIT1right))::rest671) => 
let val result=MlyValue.PosInt(fn _ => let val DIGIT as DIGIT1=DIGIT1 
()
 in ( DIGIT ) end
)
 in (LrTable.NT 151,(result,DIGIT1left,DIGIT1right),rest671) end
| (24,(_,(MlyValue.Ident Ident1,Ident1left,Ident1right))::rest671) => 
let val result=MlyValue.Label(fn _ => let val Ident as Ident1=Ident1 
()
 in ( mk_IdentLab Ident ) end
)
 in (LrTable.NT 150,(result,Ident1left,Ident1right),rest671) end
| (25,(_,(MlyValue.PosInt PosInt1,PosInt1left,PosInt1right))::rest671)
 => let val result=MlyValue.Label(fn _ => let val PosInt as PosInt1=
PosInt1 ()
 in ( mk_IntegerLab PosInt ) end
)
 in (LrTable.NT 150,(result,PosInt1left,PosInt1right),rest671) end
| (26,(_,(MlyValue.Ident_seq1 Ident_seq11,_,Ident_seq11right))::(_,(
MlyValue.Ident Ident1,Identleft as Ident1left,Identright))::rest671)
 => let val result=MlyValue.Ident_seq1(fn _ => let val Ident as Ident1
=Ident1 ()
val Ident_seq1 as Ident_seq11=Ident_seq11 ()
 in (
 WITH_INFO(PP Identleft Identright, Ident)
                          :: Ident_seq1
                        
) end
)
 in (LrTable.NT 75,(result,Ident1left,Ident_seq11right),rest671) end
| (27,(_,(MlyValue.Ident Ident1,Identleft as Ident1left,Identright as 
Ident1right))::rest671) => let val result=MlyValue.Ident_seq1(fn _ => 
let val Ident as Ident1=Ident1 ()
 in ( [WITH_INFO(PP Identleft Identright, Ident)] ) end
)
 in (LrTable.NT 75,(result,Ident1left,Ident1right),rest671) end
| (28,(_,(MlyValue.EqIdent_seq1 EqIdent_seq11,_,EqIdent_seq11right))::
(_,(MlyValue.EqIdent EqIdent1,EqIdent1left,_))::rest671) => let val 
result=MlyValue.EqIdent_seq1(fn _ => let val EqIdent as EqIdent1=
EqIdent1 ()
val EqIdent_seq1 as EqIdent_seq11=EqIdent_seq11 ()
 in ( EqIdent :: EqIdent_seq1 ) end
)
 in (LrTable.NT 76,(result,EqIdent1left,EqIdent_seq11right),rest671)
 end
| (29,(_,(MlyValue.EqIdent EqIdent1,EqIdent1left,EqIdent1right))::
rest671) => let val result=MlyValue.EqIdent_seq1(fn _ => let val 
EqIdent as EqIdent1=EqIdent1 ()
 in ( [EqIdent] ) end
)
 in (LrTable.NT 76,(result,EqIdent1left,EqIdent1right),rest671) end
| (30,(_,(MlyValue.LongIdent_seq1 LongIdent_seq11,_,
LongIdent_seq11right))::(_,(MlyValue.LongIdent LongIdent1,
LongIdentleft as LongIdent1left,LongIdentright))::rest671) => let val 
result=MlyValue.LongIdent_seq1(fn _ => let val LongIdent as LongIdent1
=LongIdent1 ()
val LongIdent_seq1 as LongIdent_seq11=LongIdent_seq11 ()
 in (
 WITH_INFO(PP LongIdentleft LongIdentright,
                                    LongIdent
                                   ) :: LongIdent_seq1
                        
) end
)
 in (LrTable.NT 77,(result,LongIdent1left,LongIdent_seq11right),
rest671) end
| (31,(_,(MlyValue.LongIdent LongIdent1,LongIdentleft as 
LongIdent1left,LongIdentright as LongIdent1right))::rest671) => let 
val result=MlyValue.LongIdent_seq1(fn _ => let val LongIdent as 
LongIdent1=LongIdent1 ()
 in (
 [WITH_INFO(PP LongIdentleft LongIdentright,
                                     LongIdent
                                    )
                          ]
                        
) end
)
 in (LrTable.NT 77,(result,LongIdent1left,LongIdent1right),rest671)
 end
| (32,(_,(MlyValue.LongIdentEq_seq2 LongIdentEq_seq21,_,
LongIdentEq_seq21right))::_::(_,(MlyValue.LongIdent LongIdent1,
LongIdentleft as LongIdent1left,LongIdentright))::rest671) => let val 
result=MlyValue.LongIdentEq_seq2(fn _ => let val LongIdent as 
LongIdent1=LongIdent1 ()
val LongIdentEq_seq2 as LongIdentEq_seq21=LongIdentEq_seq21 ()
 in (
 WITH_INFO(PP LongIdentleft LongIdentright, LongIdent)
                          :: LongIdentEq_seq2
                        
) end
)
 in (LrTable.NT 78,(result,LongIdent1left,LongIdentEq_seq21right),
rest671) end
| (33,(_,(MlyValue.LongIdent LongIdent2,LongIdent2left,LongIdent2right
))::_::(_,(MlyValue.LongIdent LongIdent1,LongIdent1left,
LongIdent1right))::rest671) => let val result=
MlyValue.LongIdentEq_seq2(fn _ => let val LongIdent1=LongIdent1 ()
val LongIdent2=LongIdent2 ()
 in (
 [WITH_INFO(PP LongIdent1left LongIdent1right,
                                     LongIdent1
                                    ),
                           WITH_INFO(PP LongIdent2left LongIdent2right,
                                     LongIdent2
                                    )
                          ]
                        
) end
)
 in (LrTable.NT 78,(result,LongIdent1left,LongIdent2right),rest671)
 end
| (34,(_,(MlyValue.LongTypeIdentEq_seq2 LongTypeIdentEq_seq21,_,
LongTypeIdentEq_seq21right))::_::(_,(MlyValue.LongTypeIdent 
LongTypeIdent1,LongTypeIdentleft as LongTypeIdent1left,
LongTypeIdentright))::rest671) => let val result=
MlyValue.LongTypeIdentEq_seq2(fn _ => let val LongTypeIdent as 
LongTypeIdent1=LongTypeIdent1 ()
val LongTypeIdentEq_seq2 as LongTypeIdentEq_seq21=
LongTypeIdentEq_seq21 ()
 in (
 WITH_INFO(PP LongTypeIdentleft LongTypeIdentright,
                                    LongTypeIdent
                                   )
                          :: LongTypeIdentEq_seq2
                        
) end
)
 in (LrTable.NT 79,(result,LongTypeIdent1left,
LongTypeIdentEq_seq21right),rest671) end
| (35,(_,(MlyValue.LongTypeIdent LongTypeIdent2,LongTypeIdent2left,
LongTypeIdent2right))::_::(_,(MlyValue.LongTypeIdent LongTypeIdent1,
LongTypeIdent1left,LongTypeIdent1right))::rest671) => let val result=
MlyValue.LongTypeIdentEq_seq2(fn _ => let val LongTypeIdent1=
LongTypeIdent1 ()
val LongTypeIdent2=LongTypeIdent2 ()
 in (
 [WITH_INFO(PP LongTypeIdent1left LongTypeIdent1right,
                                     LongTypeIdent1
                                    ),
                           WITH_INFO(PP LongTypeIdent2left LongTypeIdent2right,
                                     LongTypeIdent2
                                    )
                          ]
                        
) end
)
 in (LrTable.NT 79,(result,LongTypeIdent1left,LongTypeIdent2right),
rest671) end
| (36,(_,(MlyValue.StrDec_sans_SEMICOLON StrDec_sans_SEMICOLON1,
StrDec_sans_SEMICOLONleft as StrDec_sans_SEMICOLON1left,
StrDec_sans_SEMICOLONright as StrDec_sans_SEMICOLON1right))::rest671)
 => let val result=MlyValue.TopDec(fn _ => let val 
StrDec_sans_SEMICOLON as StrDec_sans_SEMICOLON1=StrDec_sans_SEMICOLON1
 ()
 in (
 STRtopdec(PP StrDec_sans_SEMICOLONleft
                                       StrDec_sans_SEMICOLONright,
                                    StrDec_sans_SEMICOLON
                                   )
                        
) end
)
 in (LrTable.NT 0,(result,StrDec_sans_SEMICOLON1left,
StrDec_sans_SEMICOLON1right),rest671) end
| (37,(_,(MlyValue.SigDec_sans_SEMICOLON SigDec_sans_SEMICOLON1,
SigDec_sans_SEMICOLONleft as SigDec_sans_SEMICOLON1left,
SigDec_sans_SEMICOLONright as SigDec_sans_SEMICOLON1right))::rest671)
 => let val result=MlyValue.TopDec(fn _ => let val 
SigDec_sans_SEMICOLON as SigDec_sans_SEMICOLON1=SigDec_sans_SEMICOLON1
 ()
 in (
 SIGtopdec(PP SigDec_sans_SEMICOLONleft
                                       SigDec_sans_SEMICOLONright,
                                    SigDec_sans_SEMICOLON
                                   )
                        
) end
)
 in (LrTable.NT 0,(result,SigDec_sans_SEMICOLON1left,
SigDec_sans_SEMICOLON1right),rest671) end
| (38,(_,(MlyValue.FunDec_sans_SEMICOLON FunDec_sans_SEMICOLON1,
FunDec_sans_SEMICOLONleft as FunDec_sans_SEMICOLON1left,
FunDec_sans_SEMICOLONright as FunDec_sans_SEMICOLON1right))::rest671)
 => let val result=MlyValue.TopDec(fn _ => let val 
FunDec_sans_SEMICOLON as FunDec_sans_SEMICOLON1=FunDec_sans_SEMICOLON1
 ()
 in (
 FUNtopdec(PP FunDec_sans_SEMICOLONleft
                                       FunDec_sans_SEMICOLONright,
                                    FunDec_sans_SEMICOLON
                                   )
                        
) end
)
 in (LrTable.NT 0,(result,FunDec_sans_SEMICOLON1left,
FunDec_sans_SEMICOLON1right),rest671) end
| (39,(_,(MlyValue.Exp_ Exp_1,Exp_1left,Exp_1right))::rest671) => let 
val result=MlyValue.TopDec(fn _ => let val Exp_ as Exp_1=Exp_1 ()
 in ( topdecOfExp Exp_ ) end
)
 in (LrTable.NT 0,(result,Exp_1left,Exp_1right),rest671) end
| (40,(_,(MlyValue.AndFunBind_opt AndFunBind_opt1,_,
AndFunBind_optright as AndFunBind_opt1right))::(_,(MlyValue.StrExp 
StrExp1,_,_))::_::(_,(MlyValue.PSigExp PSigExp2,_,_))::_::_::(_,(
MlyValue.PSigExp PSigExp1,_,PSigExp1right))::_::(_,(MlyValue.Ident 
Ident2,Ident2left,_))::_::(_,(MlyValue.Ident Ident1,Ident1left,_))::
rest671) => let val result=MlyValue.FunBind(fn _ => let val Ident1=
Ident1 ()
val Ident2=Ident2 ()
val PSigExp1=PSigExp1 ()
val PSigExp2=PSigExp2 ()
val StrExp as StrExp1=StrExp1 ()
val AndFunBind_opt as AndFunBind_opt1=AndFunBind_opt1 ()
 in (
 let
                            val PRINCIPpsigexp (_, SigExp) = PSigExp1
                            val PSigExp1' = PRINCIPpsigexp (PP Ident2left PSigExp1right, SigExp)
                          in
                            FUNBINDfunbind(PP Ident1left AndFunBind_optright,
                                  mk_FunId Ident1, mk_StrId Ident2, PSigExp1',
                                  PSigExp2, StrExp, AndFunBind_opt
                                 )
                          end
                        
) end
)
 in (LrTable.NT 5,(result,Ident1left,AndFunBind_opt1right),rest671)
 end
| (41,(_,(MlyValue.AndFunBind_opt AndFunBind_opt1,_,
AndFunBind_optright as AndFunBind_opt1right))::_::_::(_,(
MlyValue.PSigExp PSigExp2,_,_))::_::_::(_,(MlyValue.PSigExp PSigExp1,_
,PSigExp1right))::_::(_,(MlyValue.Ident Ident2,Ident2left,_))::_::(_,(
MlyValue.Ident Ident1,Ident1left,_))::rest671) => let val result=
MlyValue.FunBind(fn _ => let val Ident1=Ident1 ()
val Ident2=Ident2 ()
val PSigExp1=PSigExp1 ()
val PSigExp2=PSigExp2 ()
val AndFunBind_opt as AndFunBind_opt1=AndFunBind_opt1 ()
 in (
 let
                            val PRINCIPpsigexp (_, SigExp) = PSigExp1
                            val PSigExp1' = PRINCIPpsigexp (PP Ident2left PSigExp1right, SigExp)
                          in 
                            UNDEFfunbind(PP Ident1left AndFunBind_optright,
                                  mk_FunId Ident1, mk_StrId Ident2, PSigExp1,
                                  PSigExp2, AndFunBind_opt
                                 )
                        
end
) end
)
 in (LrTable.NT 5,(result,Ident1left,AndFunBind_opt1right),rest671)
 end
| (42,(_,(MlyValue.AndFunBind_opt AndFunBind_opt1,_,
AndFunBind_optright as AndFunBind_opt1right))::(_,(MlyValue.StrExp 
StrExp1,StrExpleft,StrExpright))::_::(_,(MlyValue.Ident Ident2,
Ident2left,Ident2right))::_::_::(_,(MlyValue.Spec Spec1,Specleft,
Specright))::_::(_,(MlyValue.Ident Ident1,Ident1left,_))::rest671) => 
let val result=MlyValue.FunBind(fn _ => let val Ident as Ident1=Ident1
 ()
val Spec as Spec1=Spec1 ()
val Ident2=Ident2 ()
val StrExp as StrExp1=StrExp1 ()
val AndFunBind_opt as AndFunBind_opt1=AndFunBind_opt1 ()
 in (
 let
                            val newStrId   = inventStrId()
                            val Ident2Info = PP Ident2left Ident2right
                            val StrExpInfo = PP StrExpleft StrExpright
                          in
                            FUNBINDfunbind(PP Ident1left AndFunBind_optright,
                                    mk_FunId Ident, newStrId,
                specAsSig(PP Specleft Specright, Spec),
                                    mk_PSigId( Ident2, Ident2Info),
                                    convertFunctorBody(newStrId, StrExp, StrExpInfo),
                                    AndFunBind_opt
                                   )
                          end
                        
) end
)
 in (LrTable.NT 5,(result,Ident1left,AndFunBind_opt1right),rest671)
 end
| (43,(_,(MlyValue.AndFunBind_opt AndFunBind_opt1,_,
AndFunBind_optright as AndFunBind_opt1right))::(_,(MlyValue.StrExp 
StrExp1,StrExpleft,StrExpright))::_::(_,(_,_,ENDright))::(_,(
MlyValue.Spec Spec2,_,_))::(_,(_,SIGleft,_))::_::_::(_,(MlyValue.Spec 
Spec1,Spec1left,Spec1right))::_::(_,(MlyValue.Ident Ident1,Ident1left,
_))::rest671) => let val result=MlyValue.FunBind(fn _ => let val Ident
 as Ident1=Ident1 ()
val Spec1=Spec1 ()
val Spec2=Spec2 ()
val StrExp as StrExp1=StrExp1 ()
val AndFunBind_opt as AndFunBind_opt1=AndFunBind_opt1 ()
 in (
 let
                            val newStrId = inventStrId()
                            val Spec2Info = PP SIGleft ENDright
                            val StrExpInfo = PP StrExpleft StrExpright
                          in
                            FUNBINDfunbind(PP Ident1left AndFunBind_optright,
                                    mk_FunId Ident, newStrId,
                specAsSig(PP Spec1left Spec1right, Spec1),
                                    functPSigExp(Spec2, newStrId, Spec2Info),
                                    convertFunctorBody(newStrId, StrExp, StrExpInfo),
                                    AndFunBind_opt
                                   )
                          end
                        
) end
)
 in (LrTable.NT 5,(result,Ident1left,AndFunBind_opt1right),rest671)
 end
| (44,(_,(MlyValue.AndFunBind_opt AndFunBind_opt1,_,
AndFunBind_optright as AndFunBind_opt1right))::_::_::(_,(
MlyValue.Ident Ident2,Ident2left,Ident2right))::_::_::(_,(
MlyValue.Spec Spec1,Specleft,Specright))::_::(_,(MlyValue.Ident Ident1
,Ident1left,_))::rest671) => let val result=MlyValue.FunBind(fn _ => 
let val Ident1=Ident1 ()
val Spec as Spec1=Spec1 ()
val Ident2=Ident2 ()
val AndFunBind_opt as AndFunBind_opt1=AndFunBind_opt1 ()
 in (
 let
                            val newStrId = inventStrId()
                            val Ident2Info = PP Ident2left Ident2right
                          in
                            UNDEFfunbind(PP Ident1left AndFunBind_optright,
                                    mk_FunId Ident1, newStrId,
                specAsSig(PP Specleft Specright, Spec),
                                    mk_PSigId( Ident2, Ident2Info),
                                    AndFunBind_opt
                                   )
                          end
                        
) end
)
 in (LrTable.NT 5,(result,Ident1left,AndFunBind_opt1right),rest671)
 end
| (45,(_,(MlyValue.AndFunBind_opt AndFunBind_opt1,_,
AndFunBind_optright as AndFunBind_opt1right))::_::_::(_,(_,_,ENDright)
)::(_,(MlyValue.Spec Spec2,_,_))::(_,(_,SIGleft,_))::_::_::(_,(
MlyValue.Spec Spec1,Spec1left,Spec1right))::_::(_,(MlyValue.Ident 
Ident1,Ident1left,_))::rest671) => let val result=MlyValue.FunBind(fn 
_ => let val Ident1=Ident1 ()
val Spec1=Spec1 ()
val Spec2=Spec2 ()
val AndFunBind_opt as AndFunBind_opt1=AndFunBind_opt1 ()
 in (
 let
                            val newStrId = inventStrId()
                            val Spec2Info = PP SIGleft ENDright
                          in
                            UNDEFfunbind(PP Ident1left AndFunBind_optright,
                                    mk_FunId Ident1, newStrId,
                specAsSig(PP Spec1left Spec1right, Spec1),
                                    functPSigExp(Spec2, newStrId, Spec2Info),
                                    AndFunBind_opt
                                   )
                          end
                        
) end
)
 in (LrTable.NT 5,(result,Ident1left,AndFunBind_opt1right),rest671)
 end
| (46,(_,(MlyValue.FunBind FunBind1,_,FunBind1right))::(_,(_,AND1left,
_))::rest671) => let val result=MlyValue.AndFunBind_opt(fn _ => let 
val FunBind as FunBind1=FunBind1 ()
 in ( Some FunBind ) end
)
 in (LrTable.NT 28,(result,AND1left,FunBind1right),rest671) end
| (47,rest671) => let val result=MlyValue.AndFunBind_opt(fn _ => (
 None ))
 in (LrTable.NT 28,(result,defaultPos,defaultPos),rest671) end
| (48,(_,(MlyValue.FunDec_sans_SC_opt FunDec_sans_SC_opt1,_,
FunDec_sans_SC_optright as FunDec_sans_SC_opt1right))::(_,(
MlyValue.FunBind FunBind1,_,_))::(_,(_,FUNCTORleft as FUNCTOR1left,_))
::rest671) => let val result=MlyValue.FunDec_sans_SEMICOLON(fn _ => 
let val FunBind as FunBind1=FunBind1 ()
val FunDec_sans_SC_opt as FunDec_sans_SC_opt1=FunDec_sans_SC_opt1 ()
 in (
 let
                            val i = PP FUNCTORleft FunDec_sans_SC_optright
                            val fundec1 = FUNCTORfundec(i, FunBind)
                          in
                            case FunDec_sans_SC_opt
                              of Some fd => SEQfundec(i, fundec1, fd)
                               | None => fundec1
                          end
                        
) end
)
 in (LrTable.NT 3,(result,FUNCTOR1left,FunDec_sans_SC_opt1right),
rest671) end
| (49,(_,(MlyValue.FunDec_sans_SEMICOLON FunDec_sans_SEMICOLON1,
FunDec_sans_SEMICOLON1left,FunDec_sans_SEMICOLON1right))::rest671) => 
let val result=MlyValue.FunDec_sans_SC_opt(fn _ => let val 
FunDec_sans_SEMICOLON as FunDec_sans_SEMICOLON1=FunDec_sans_SEMICOLON1
 ()
 in ( Some FunDec_sans_SEMICOLON ) end
)
 in (LrTable.NT 27,(result,FunDec_sans_SEMICOLON1left,
FunDec_sans_SEMICOLON1right),rest671) end
| (50,rest671) => let val result=MlyValue.FunDec_sans_SC_opt(fn _ => (
 None ))
 in (LrTable.NT 27,(result,defaultPos,defaultPos),rest671) end
| (51,(_,(MlyValue.LongIdentEq_seq2 LongIdentEq_seq21,
LongIdentEq_seq2left as LongIdentEq_seq21left,LongIdentEq_seq2right
 as LongIdentEq_seq21right))::rest671) => let val result=
MlyValue.SharEq(fn _ => let val LongIdentEq_seq2 as LongIdentEq_seq21=
LongIdentEq_seq21 ()
 in (
 STRUCTUREshareq(PP LongIdentEq_seq2left
                                             LongIdentEq_seq2right,
                                          wi_Convert mk_LongStrId
                                                     LongIdentEq_seq2
                                         )
                        
) end
)
 in (LrTable.NT 6,(result,LongIdentEq_seq21left,LongIdentEq_seq21right
),rest671) end
| (52,(_,(MlyValue.LongTypeIdentEq_seq2 LongTypeIdentEq_seq21,_,
LongTypeIdentEq_seq2right as LongTypeIdentEq_seq21right))::(_,(_,
TYPEleft as TYPE1left,_))::rest671) => let val result=MlyValue.SharEq(
fn _ => let val LongTypeIdentEq_seq2 as LongTypeIdentEq_seq21=
LongTypeIdentEq_seq21 ()
 in (
 TYPEshareq(PP TYPEleft LongTypeIdentEq_seq2right,
                                     wi_Convert mk_LongTyCon
                                                LongTypeIdentEq_seq2
                                    )
                        
) end
)
 in (LrTable.NT 6,(result,TYPE1left,LongTypeIdentEq_seq21right),
rest671) end
| (53,(_,(MlyValue.SharEq SharEq2,_,SharEq2right))::_::(_,(
MlyValue.SharEq SharEq1,SharEq1left,_))::rest671) => let val result=
MlyValue.SharEq(fn _ => let val SharEq1=SharEq1 ()
val SharEq2=SharEq2 ()
 in (
 ANDshareq(PP SharEq1left SharEq2right,
                                    SharEq1, SharEq2
                                   )
                        
) end
)
 in (LrTable.NT 6,(result,SharEq1left,SharEq2right),rest671) end
| (54,(_,(MlyValue.AndStrDesc_opt AndStrDesc_opt1,_,
AndStrDesc_optright as AndStrDesc_opt1right))::(_,(MlyValue.SigExp 
SigExp1,_,_))::_::(_,(MlyValue.Ident Ident1,Identleft as Ident1left,_)
)::rest671) => let val result=MlyValue.StrDesc(fn _ => let val Ident
 as Ident1=Ident1 ()
val SigExp as SigExp1=SigExp1 ()
val AndStrDesc_opt as AndStrDesc_opt1=AndStrDesc_opt1 ()
 in (
 STRDESC(PP Identleft AndStrDesc_optright,
                                  mk_StrId Ident, SigExp, AndStrDesc_opt
                                 )
                        
) end
)
 in (LrTable.NT 7,(result,Ident1left,AndStrDesc_opt1right),rest671)
 end
| (55,(_,(MlyValue.StrDesc StrDesc1,_,StrDesc1right))::(_,(_,AND1left,
_))::rest671) => let val result=MlyValue.AndStrDesc_opt(fn _ => let 
val StrDesc as StrDesc1=StrDesc1 ()
 in ( Some StrDesc ) end
)
 in (LrTable.NT 31,(result,AND1left,StrDesc1right),rest671) end
| (56,rest671) => let val result=MlyValue.AndStrDesc_opt(fn _ => (
 None ))
 in (LrTable.NT 31,(result,defaultPos,defaultPos),rest671) end
| (57,(_,(_,_,ENDright as END1right))::(_,(MlyValue.AxExp AxExp1,_,_))
::_::(_,(MlyValue.StrDec_SpecExp StrDec_SpecExp1,_,_))::(_,(_,LETleft
 as LET1left,_))::rest671) => let val result=MlyValue.SpecExp(fn _ => 
let val StrDec_SpecExp as StrDec_SpecExp1=StrDec_SpecExp1 ()
val AxExp as AxExp1=AxExp1 ()
 in (
 SPECEXP(PP LETleft ENDright, 
                                  StrDec_SpecExp, AxExp)
) end
)
 in (LrTable.NT 8,(result,LET1left,END1right),rest671) end
| (58,(_,(MlyValue.Exp_bullet Exp_bullet1,Exp_bulletleft as 
Exp_bullet1left,Exp_bulletright as Exp_bullet1right))::rest671) => 
let val result=MlyValue.SpecExp(fn _ => let val Exp_bullet as 
Exp_bullet1=Exp_bullet1 ()
 in (
 SPECEXP(
                            PP Exp_bulletleft 
                               Exp_bulletright,
                            EMPTYstrdec(PP defaultPos defaultPos),
                            AXIOM_EXPaxexp( PP Exp_bulletleft  
                                               Exp_bulletright,
                                            Exp_bullet))
) end
)
 in (LrTable.NT 8,(result,Exp_bullet1left,Exp_bullet1right),rest671)
 end
| (59,(_,(MlyValue.NonEmptyStrDec_SpecExp NonEmptyStrDec_SpecExp1,
NonEmptyStrDec_SpecExp1left,NonEmptyStrDec_SpecExp1right))::rest671)
 => let val result=MlyValue.StrDec_SpecExp(fn _ => let val 
NonEmptyStrDec_SpecExp as NonEmptyStrDec_SpecExp1=
NonEmptyStrDec_SpecExp1 ()
 in ( NonEmptyStrDec_SpecExp ) end
)
 in (LrTable.NT 138,(result,NonEmptyStrDec_SpecExp1left,
NonEmptyStrDec_SpecExp1right),rest671) end
| (60,(_,(MlyValue.OneStrDec_or_SEMICOLON OneStrDec_or_SEMICOLON1,_,
OneStrDec_or_SEMICOLONright as OneStrDec_or_SEMICOLON1right))::(_,(
MlyValue.NonEmptyStrDec_SpecExp NonEmptyStrDec_SpecExp1,
NonEmptyStrDec_SpecExpleft as NonEmptyStrDec_SpecExp1left,_))::rest671
) => let val result=MlyValue.NonEmptyStrDec_SpecExp(fn _ => let val 
NonEmptyStrDec_SpecExp as NonEmptyStrDec_SpecExp1=
NonEmptyStrDec_SpecExp1 ()
val OneStrDec_or_SEMICOLON as OneStrDec_or_SEMICOLON1=
OneStrDec_or_SEMICOLON1 ()
 in (
 case OneStrDec_or_SEMICOLON
                            of Some strdec =>
                                 composeStrDec(PP NonEmptyStrDec_SpecExpleft
                                                  OneStrDec_or_SEMICOLONright,
                                               NonEmptyStrDec_SpecExp, strdec)
                             | None =>
                                 NonEmptyStrDec_SpecExp 
) end
)
 in (LrTable.NT 140,(result,NonEmptyStrDec_SpecExp1left,
OneStrDec_or_SEMICOLON1right),rest671) end
| (61,(_,(MlyValue.OneStrDec_SpecExp OneStrDec_SpecExp1,
OneStrDec_SpecExp1left,OneStrDec_SpecExp1right))::rest671) => let val 
result=MlyValue.NonEmptyStrDec_SpecExp(fn _ => let val 
OneStrDec_SpecExp as OneStrDec_SpecExp1=OneStrDec_SpecExp1 ()
 in ( OneStrDec_SpecExp) end
)
 in (LrTable.NT 140,(result,OneStrDec_SpecExp1left,
OneStrDec_SpecExp1right),rest671) end
| (62,(_,(MlyValue.OneStrDec_SpecExp OneStrDec_SpecExp1,_,
OneStrDec_SpecExpright as OneStrDec_SpecExp1right))::(_,(
MlyValue.NonEmptyDecbullet NonEmptyDecbullet1,NonEmptyDecbulletleft
 as NonEmptyDecbullet1left,NonEmptyDecbulletright))::rest671) => let 
val result=MlyValue.NonEmptyStrDec_SpecExp(fn _ => let val 
NonEmptyDecbullet as NonEmptyDecbullet1=NonEmptyDecbullet1 ()
val OneStrDec_SpecExp as OneStrDec_SpecExp1=OneStrDec_SpecExp1 ()
 in (
 composeStrDec(
                                   PP NonEmptyDecbulletleft
                                      OneStrDec_SpecExpright,
                                   Dec2StrDec( PP NonEmptyDecbulletleft
                                                  NonEmptyDecbulletright,
                                               NonEmptyDecbullet ), 
                                   OneStrDec_SpecExp) 
) end
)
 in (LrTable.NT 140,(result,NonEmptyDecbullet1left,
OneStrDec_SpecExp1right),rest671) end
| (63,(_,(MlyValue.OneDec_sans_LOCALquestionmark 
OneDec_sans_LOCALquestionmark1,OneDec_sans_LOCALquestionmarkleft as 
OneDec_sans_LOCALquestionmark1left,OneDec_sans_LOCALquestionmarkright
 as OneDec_sans_LOCALquestionmark1right))::rest671) => let val result=
MlyValue.OneStrDec_SpecExp(fn _ => let val 
OneDec_sans_LOCALquestionmark as OneDec_sans_LOCALquestionmark1=
OneDec_sans_LOCALquestionmark1 ()
 in (
 DECstrdec(PP OneDec_sans_LOCALquestionmarkleft
                                       OneDec_sans_LOCALquestionmarkright,
                                    OneDec_sans_LOCALquestionmark)
) end
)
 in (LrTable.NT 139,(result,OneDec_sans_LOCALquestionmark1left,
OneDec_sans_LOCALquestionmark1right),rest671) end
| (64,(_,(MlyValue.Ax Ax1,_,Axright as Ax1right))::(_,(_,AXIOMleft as 
AXIOM1left,_))::rest671) => let val result=MlyValue.OneStrDec_SpecExp(
fn _ => let val Ax as Ax1=Ax1 ()
 in (
 AXIOMstrdec( PP AXIOMleft Axright ,
                                 Ax )
) end
)
 in (LrTable.NT 139,(result,AXIOM1left,Ax1right),rest671) end
| (65,(_,(MlyValue.StrBind StrBind1,_,StrBindright as StrBind1right))
::(_,(_,STRUCTUREleft as STRUCTURE1left,_))::rest671) => let val 
result=MlyValue.OneStrDec_SpecExp(fn _ => let val StrBind as StrBind1=
StrBind1 ()
 in (
 STRUCTUREstrdec(PP STRUCTUREleft StrBindright,
                                             StrBind)
) end
)
 in (LrTable.NT 139,(result,STRUCTURE1left,StrBind1right),rest671) end
| (66,(_,(_,_,ENDright as END1right))::(_,(MlyValue.StrDec_SpecExp 
StrDec_SpecExp1,_,_))::_::(_,(MlyValue.Decbullet Decbullet1,
Decbulletleft,Decbulletright))::(_,(_,LOCALleft as LOCAL1left,_))::
rest671) => let val result=MlyValue.OneStrDec_SpecExp(fn _ => let val 
Decbullet as Decbullet1=Decbullet1 ()
val StrDec_SpecExp as StrDec_SpecExp1=StrDec_SpecExp1 ()
 in (
 LOCALstrdec(PP LOCALleft ENDright,
                                      Dec2StrDec( PP Decbulletleft
                                                     Decbulletright,
                                                  Decbullet ), 
                                      StrDec_SpecExp)
) end
)
 in (LrTable.NT 139,(result,LOCAL1left,END1right),rest671) end
| (67,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Decbullet 
Decbullet1,Decbulletleft,Decbulletright))::_::(_,(
MlyValue.StrDec_SpecExp StrDec_SpecExp1,_,_))::(_,(_,LOCALleft as 
LOCAL1left,_))::rest671) => let val result=MlyValue.OneStrDec_SpecExp(
fn _ => let val StrDec_SpecExp as StrDec_SpecExp1=StrDec_SpecExp1 ()
val Decbullet as Decbullet1=Decbullet1 ()
 in (
 LOCALstrdec(PP LOCALleft ENDright,
                                      StrDec_SpecExp, 
                                      Dec2StrDec( PP Decbulletleft
                                                     Decbulletright,
                                                 Decbullet ))
) end
)
 in (LrTable.NT 139,(result,LOCAL1left,END1right),rest671) end
| (68,(_,(_,_,ENDright as END1right))::(_,(MlyValue.StrDec_SpecExp 
StrDec_SpecExp2,_,_))::_::(_,(MlyValue.StrDec_SpecExp StrDec_SpecExp1,
_,_))::(_,(_,LOCALleft as LOCAL1left,_))::rest671) => let val result=
MlyValue.OneStrDec_SpecExp(fn _ => let val StrDec_SpecExp as 
StrDec_SpecExp1=StrDec_SpecExp1 ()
val StrDec_SpecExp2=StrDec_SpecExp2 ()
 in (
 LOCALstrdec(PP LOCALleft ENDright,
                                      StrDec_SpecExp, 
                                      StrDec_SpecExp)
) end
)
 in (LrTable.NT 139,(result,LOCAL1left,END1right),rest671) end
| (69,(_,(MlyValue.AndAxDesc_opt AndAxDesc_opt1,_,AndAxDesc_optright
 as AndAxDesc_opt1right))::(_,(MlyValue.SpecExp SpecExp1,SpecExpleft
 as SpecExp1left,_))::rest671) => let val result=MlyValue.AxDesc(fn _
 => let val SpecExp as SpecExp1=SpecExp1 ()
val AndAxDesc_opt as AndAxDesc_opt1=AndAxDesc_opt1 ()
 in (
 AXDESC(PP SpecExpleft AndAxDesc_optright, 
                 SpecExp, AndAxDesc_opt)
        
) end
)
 in (LrTable.NT 9,(result,SpecExp1left,AndAxDesc_opt1right),rest671)
 end
| (70,(_,(MlyValue.AxDesc AxDesc1,_,AxDesc1right))::(_,(_,AND1left,_))
::rest671) => let val result=MlyValue.AndAxDesc_opt(fn _ => let val 
AxDesc as AxDesc1=AxDesc1 ()
 in ( Some AxDesc ) end
)
 in (LrTable.NT 32,(result,AND1left,AxDesc1right),rest671) end
| (71,rest671) => let val result=MlyValue.AndAxDesc_opt(fn _ => (
 None ))
 in (LrTable.NT 32,(result,defaultPos,defaultPos),rest671) end
| (72,(_,(MlyValue.AndExDesc_opt AndExDesc_opt1,_,AndExDesc_optright
 as AndExDesc_opt1right))::(_,(MlyValue.OfTy_opt OfTy_opt1,_,_))::(_,(
MlyValue.Ident Ident1,Identleft as Ident1left,_))::rest671) => let 
val result=MlyValue.ExDesc(fn _ => let val Ident as Ident1=Ident1 ()
val OfTy_opt as OfTy_opt1=OfTy_opt1 ()
val AndExDesc_opt as AndExDesc_opt1=AndExDesc_opt1 ()
 in (
 EXDESC(PP Identleft AndExDesc_optright,
                                 mk_ExCon Ident, OfTy_opt, AndExDesc_opt
                                )
                        
) end
)
 in (LrTable.NT 10,(result,Ident1left,AndExDesc_opt1right),rest671)
 end
| (73,(_,(MlyValue.ExDesc ExDesc1,_,ExDesc1right))::(_,(_,AND1left,_))
::rest671) => let val result=MlyValue.AndExDesc_opt(fn _ => let val 
ExDesc as ExDesc1=ExDesc1 ()
 in ( Some ExDesc ) end
)
 in (LrTable.NT 33,(result,AND1left,ExDesc1right),rest671) end
| (74,rest671) => let val result=MlyValue.AndExDesc_opt(fn _ => (
 None ))
 in (LrTable.NT 33,(result,defaultPos,defaultPos),rest671) end
| (75,(_,(MlyValue.BarConDesc_opt BarConDesc_opt1,_,
BarConDesc_optright as BarConDesc_opt1right))::(_,(MlyValue.OfTy_opt 
OfTy_opt1,_,_))::(_,(MlyValue.OpIdent OpIdent1,OpIdentleft as 
OpIdent1left,_))::rest671) => let val result=MlyValue.ConDesc(fn _ => 
let val OpIdent as OpIdent1=OpIdent1 ()
val OfTy_opt as OfTy_opt1=OfTy_opt1 ()
val BarConDesc_opt as BarConDesc_opt1=BarConDesc_opt1 ()
 in (
 let
                            val OP_OPT(id, _) = OpIdent
                          in
                            CONDESC(PP OpIdentleft BarConDesc_optright,
                                    mk_Con id, OfTy_opt, BarConDesc_opt
                                   )
                          end
                        
) end
)
 in (LrTable.NT 11,(result,OpIdent1left,BarConDesc_opt1right),rest671)
 end
| (76,(_,(MlyValue.ConDesc ConDesc1,_,ConDesc1right))::(_,(_,BAR1left,
_))::rest671) => let val result=MlyValue.BarConDesc_opt(fn _ => let 
val ConDesc as ConDesc1=ConDesc1 ()
 in ( Some ConDesc ) end
)
 in (LrTable.NT 34,(result,BAR1left,ConDesc1right),rest671) end
| (77,rest671) => let val result=MlyValue.BarConDesc_opt(fn _ => (
 None ))
 in (LrTable.NT 34,(result,defaultPos,defaultPos),rest671) end
| (78,(_,(MlyValue.AndDatDesc_opt AndDatDesc_opt1,_,
AndDatDesc_optright as AndDatDesc_opt1right))::(_,(MlyValue.ConDesc 
ConDesc1,_,_))::_::(_,(MlyValue.TypeIdent TypeIdent1,_,_))::(_,(
MlyValue.TyVarSeq TyVarSeq1,TyVarSeqleft as TyVarSeq1left,_))::rest671
) => let val result=MlyValue.DatDesc(fn _ => let val TyVarSeq as 
TyVarSeq1=TyVarSeq1 ()
val TypeIdent as TypeIdent1=TypeIdent1 ()
val ConDesc as ConDesc1=ConDesc1 ()
val AndDatDesc_opt as AndDatDesc_opt1=AndDatDesc_opt1 ()
 in (
 DATDESC(PP TyVarSeqleft AndDatDesc_optright,
                                  TyVarSeq, mk_TyCon TypeIdent,
                                  ConDesc, AndDatDesc_opt
                                 )
                        
) end
)
 in (LrTable.NT 12,(result,TyVarSeq1left,AndDatDesc_opt1right),rest671
) end
| (79,(_,(MlyValue.DatDesc DatDesc1,_,DatDesc1right))::(_,(_,AND1left,
_))::rest671) => let val result=MlyValue.AndDatDesc_opt(fn _ => let 
val DatDesc as DatDesc1=DatDesc1 ()
 in ( Some DatDesc ) end
)
 in (LrTable.NT 35,(result,AND1left,DatDesc1right),rest671) end
| (80,rest671) => let val result=MlyValue.AndDatDesc_opt(fn _ => (
 None ))
 in (LrTable.NT 35,(result,defaultPos,defaultPos),rest671) end
| (81,(_,(MlyValue.AndTypDesc_opt AndTypDesc_opt1,_,
AndTypDesc_optright as AndTypDesc_opt1right))::(_,(MlyValue.TypeIdent 
TypeIdent1,_,_))::(_,(MlyValue.TyVarSeq TyVarSeq1,TyVarSeqleft as 
TyVarSeq1left,_))::rest671) => let val result=MlyValue.TypDesc(fn _
 => let val TyVarSeq as TyVarSeq1=TyVarSeq1 ()
val TypeIdent as TypeIdent1=TypeIdent1 ()
val AndTypDesc_opt as AndTypDesc_opt1=AndTypDesc_opt1 ()
 in (
 TYPDESC(PP TyVarSeqleft AndTypDesc_optright,
                                  TyVarSeq, mk_TyCon TypeIdent,
                                  AndTypDesc_opt
                                 )
                        
) end
)
 in (LrTable.NT 13,(result,TyVarSeq1left,AndTypDesc_opt1right),rest671
) end
| (82,(_,(MlyValue.TypDesc TypDesc1,_,TypDesc1right))::(_,(_,AND1left,
_))::rest671) => let val result=MlyValue.AndTypDesc_opt(fn _ => let 
val TypDesc as TypDesc1=TypDesc1 ()
 in ( Some TypDesc ) end
)
 in (LrTable.NT 36,(result,AND1left,TypDesc1right),rest671) end
| (83,rest671) => let val result=MlyValue.AndTypDesc_opt(fn _ => (
 None ))
 in (LrTable.NT 36,(result,defaultPos,defaultPos),rest671) end
| (84,(_,(MlyValue.AndValDesc_opt AndValDesc_opt1,_,
AndValDesc_optright as AndValDesc_opt1right))::(_,(MlyValue.Ty Ty1,_,_
))::_::(_,(MlyValue.EqIdent EqIdent1,EqIdentleft as EqIdent1left,_))::
rest671) => let val result=MlyValue.ValDesc(fn _ => let val EqIdent
 as EqIdent1=EqIdent1 ()
val Ty as Ty1=Ty1 ()
val AndValDesc_opt as AndValDesc_opt1=AndValDesc_opt1 ()
 in (
 VALDESC(PP EqIdentleft AndValDesc_optright,
                                  mk_Id EqIdent, Ty, AndValDesc_opt
                                 )
                        
) end
)
 in (LrTable.NT 14,(result,EqIdent1left,AndValDesc_opt1right),rest671)
 end
| (85,(_,(MlyValue.ValDesc ValDesc1,_,ValDesc1right))::(_,(_,AND1left,
_))::rest671) => let val result=MlyValue.AndValDesc_opt(fn _ => let 
val ValDesc as ValDesc1=ValDesc1 ()
 in ( Some ValDesc ) end
)
 in (LrTable.NT 37,(result,AND1left,ValDesc1right),rest671) end
| (86,rest671) => let val result=MlyValue.AndValDesc_opt(fn _ => (
 None ))
 in (LrTable.NT 37,(result,defaultPos,defaultPos),rest671) end
| (87,(_,(MlyValue.OneSpec_or_SEMICOLON OneSpec_or_SEMICOLON1,_,
OneSpec_or_SEMICOLONright as OneSpec_or_SEMICOLON1right))::(_,(
MlyValue.NonEmptySpec NonEmptySpec1,NonEmptySpecleft as 
NonEmptySpec1left,_))::rest671) => let val result=
MlyValue.NonEmptySpec(fn _ => let val NonEmptySpec as NonEmptySpec1=
NonEmptySpec1 ()
val OneSpec_or_SEMICOLON as OneSpec_or_SEMICOLON1=
OneSpec_or_SEMICOLON1 ()
 in (
 case OneSpec_or_SEMICOLON
                            of Some spec =>
                                 composeSpec(PP NonEmptySpecleft
                                                OneSpec_or_SEMICOLONright,
                                             NonEmptySpec, spec
                                            )
                             | None => NonEmptySpec
                        
) end
)
 in (LrTable.NT 40,(result,NonEmptySpec1left,
OneSpec_or_SEMICOLON1right),rest671) end
| (88,(_,(MlyValue.OneSpec_or_SEMICOLON OneSpec_or_SEMICOLON1,
OneSpec_or_SEMICOLON1left,OneSpec_or_SEMICOLON1right))::rest671) => 
let val result=MlyValue.NonEmptySpec(fn _ => let val 
OneSpec_or_SEMICOLON as OneSpec_or_SEMICOLON1=OneSpec_or_SEMICOLON1 ()
 in (
 case OneSpec_or_SEMICOLON
                            of Some spec => spec
                             | None => EMPTYspec(PP defaultPos defaultPos)
                        
) end
)
 in (LrTable.NT 40,(result,OneSpec_or_SEMICOLON1left,
OneSpec_or_SEMICOLON1right),rest671) end
| (89,(_,(MlyValue.NonEmptySpec NonEmptySpec1,NonEmptySpec1left,
NonEmptySpec1right))::rest671) => let val result=MlyValue.Spec(fn _
 => let val NonEmptySpec as NonEmptySpec1=NonEmptySpec1 ()
 in ( NonEmptySpec ) end
)
 in (LrTable.NT 15,(result,NonEmptySpec1left,NonEmptySpec1right),
rest671) end
| (90,rest671) => let val result=MlyValue.Spec(fn _ => (
 EMPTYspec(PP defaultPos defaultPos) ))
 in (LrTable.NT 15,(result,defaultPos,defaultPos),rest671) end
| (91,(_,(MlyValue.OneSpec OneSpec1,OneSpec1left,OneSpec1right))::
rest671) => let val result=MlyValue.OneSpec_or_SEMICOLON(fn _ => let 
val OneSpec as OneSpec1=OneSpec1 ()
 in ( Some OneSpec ) end
)
 in (LrTable.NT 39,(result,OneSpec1left,OneSpec1right),rest671) end
| (92,(_,(_,SEMICOLON1left,SEMICOLON1right))::rest671) => let val 
result=MlyValue.OneSpec_or_SEMICOLON(fn _ => ( None ))
 in (LrTable.NT 39,(result,SEMICOLON1left,SEMICOLON1right),rest671)
 end
| (93,(_,(MlyValue.ValDesc ValDesc1,_,ValDescright as ValDesc1right))
::(_,(_,VALleft as VAL1left,_))::rest671) => let val result=
MlyValue.OneSpec(fn _ => let val ValDesc as ValDesc1=ValDesc1 ()
 in ( VALspec(PP VALleft ValDescright, ValDesc) ) end
)
 in (LrTable.NT 16,(result,VAL1left,ValDesc1right),rest671) end
| (94,(_,(MlyValue.TypDesc TypDesc1,_,TypDescright as TypDesc1right))
::(_,(_,TYPEleft as TYPE1left,_))::rest671) => let val result=
MlyValue.OneSpec(fn _ => let val TypDesc as TypDesc1=TypDesc1 ()
 in ( TYPEspec(PP TYPEleft TypDescright, TypDesc) ) end
)
 in (LrTable.NT 16,(result,TYPE1left,TypDesc1right),rest671) end
| (95,(_,(MlyValue.TypDesc TypDesc1,_,TypDescright as TypDesc1right))
::(_,(_,EQTYPEleft as EQTYPE1left,_))::rest671) => let val result=
MlyValue.OneSpec(fn _ => let val TypDesc as TypDesc1=TypDesc1 ()
 in ( EQTYPEspec(PP EQTYPEleft TypDescright, TypDesc) ) end
)
 in (LrTable.NT 16,(result,EQTYPE1left,TypDesc1right),rest671) end
| (96,(_,(MlyValue.DatDesc DatDesc1,_,DatDescright as DatDesc1right))
::(_,(_,DATATYPEleft as DATATYPE1left,_))::rest671) => let val result=
MlyValue.OneSpec(fn _ => let val DatDesc as DatDesc1=DatDesc1 ()
 in ( DATATYPEspec(PP DATATYPEleft DatDescright, DatDesc) ) end
)
 in (LrTable.NT 16,(result,DATATYPE1left,DatDesc1right),rest671) end
| (97,(_,(MlyValue.ExDesc ExDesc1,_,ExDescright as ExDesc1right))::(_,
(_,EXCEPTIONleft as EXCEPTION1left,_))::rest671) => let val result=
MlyValue.OneSpec(fn _ => let val ExDesc as ExDesc1=ExDesc1 ()
 in ( EXCEPTIONspec(PP EXCEPTIONleft ExDescright, ExDesc) ) end
)
 in (LrTable.NT 16,(result,EXCEPTION1left,ExDesc1right),rest671) end
| (98,(_,(MlyValue.AxDesc AxDesc1,_,AxDescright as AxDesc1right))::(_,
(_,AXIOMleft as AXIOM1left,_))::rest671) => let val result=
MlyValue.OneSpec(fn _ => let val AxDesc as AxDesc1=AxDesc1 ()
 in ( AXIOMspec(PP AXIOMleft AxDescright, AxDesc) ) end
)
 in (LrTable.NT 16,(result,AXIOM1left,AxDesc1right),rest671) end
| (99,(_,(MlyValue.StrDesc StrDesc1,_,StrDescright as StrDesc1right))
::(_,(_,STRUCTUREleft as STRUCTURE1left,_))::rest671) => let val 
result=MlyValue.OneSpec(fn _ => let val StrDesc as StrDesc1=StrDesc1 
()
 in (
 STRUCTUREspec(PP STRUCTUREleft StrDescright, StrDesc)
                        
) end
)
 in (LrTable.NT 16,(result,STRUCTURE1left,StrDesc1right),rest671) end
| (100,(_,(MlyValue.SharEq SharEq1,_,SharEqright as SharEq1right))::(_
,(_,SHARINGleft as SHARING1left,_))::rest671) => let val result=
MlyValue.OneSpec(fn _ => let val SharEq as SharEq1=SharEq1 ()
 in ( SHARINGspec(PP SHARINGleft SharEqright, SharEq) ) end
)
 in (LrTable.NT 16,(result,SHARING1left,SharEq1right),rest671) end
| (101,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Spec Spec2,_,_))
::_::(_,(MlyValue.Spec Spec1,_,_))::(_,(_,LOCALleft as LOCAL1left,_))
::rest671) => let val result=MlyValue.OneSpec(fn _ => let val Spec1=
Spec1 ()
val Spec2=Spec2 ()
 in ( LOCALspec(PP LOCALleft ENDright, Spec1, Spec2) ) end
)
 in (LrTable.NT 16,(result,LOCAL1left,END1right),rest671) end
| (102,(_,(MlyValue.LongIdent_seq1 LongIdent_seq11,_,
LongIdent_seq1right as LongIdent_seq11right))::(_,(_,OPENleft as 
OPEN1left,_))::rest671) => let val result=MlyValue.OneSpec(fn _ => 
let val LongIdent_seq1 as LongIdent_seq11=LongIdent_seq11 ()
 in (
 OPENspec(PP OPENleft LongIdent_seq1right,
                                   wi_Convert mk_LongStrId LongIdent_seq1
                                  )
                        
) end
)
 in (LrTable.NT 16,(result,OPEN1left,LongIdent_seq11right),rest671)
 end
| (103,(_,(MlyValue.Ident_seq1 Ident_seq11,_,Ident_seq1right as 
Ident_seq11right))::(_,(_,INCLUDEleft as INCLUDE1left,_))::rest671)
 => let val result=MlyValue.OneSpec(fn _ => let val Ident_seq1 as 
Ident_seq11=Ident_seq11 ()
 in (
 INCLUDEspec(PP INCLUDEleft Ident_seq1right,
                                      wi_Convert mk_SigId Ident_seq1
                                     )
                        
) end
)
 in (LrTable.NT 16,(result,INCLUDE1left,Ident_seq11right),rest671) end
| (104,(_,(_,_,ENDright as END1right))::(_,(MlyValue.StrDec StrDec1,_,
_))::(_,(_,STRUCTleft as STRUCT1left,_))::rest671) => let val result=
MlyValue.StrExp(fn _ => let val StrDec as StrDec1=StrDec1 ()
 in ( STRUCTstrexp(PP STRUCTleft ENDright, StrDec) ) end
)
 in (LrTable.NT 25,(result,STRUCT1left,END1right),rest671) end
| (105,(_,(MlyValue.LongIdent LongIdent1,LongIdentleft as 
LongIdent1left,LongIdentright as LongIdent1right))::rest671) => let 
val result=MlyValue.StrExp(fn _ => let val LongIdent as LongIdent1=
LongIdent1 ()
 in (
 LONGSTRIDstrexp(PP LongIdentleft LongIdentright,
                                          mk_LongStrId LongIdent
                                         )
                        
) end
)
 in (LrTable.NT 25,(result,LongIdent1left,LongIdent1right),rest671)
 end
| (106,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.StrExp 
StrExp1,_,_))::_::(_,(MlyValue.Ident Ident1,Identleft as Ident1left,_)
)::rest671) => let val result=MlyValue.StrExp(fn _ => let val Ident
 as Ident1=Ident1 ()
val StrExp as StrExp1=StrExp1 ()
 in (
 APPstrexp(PP Identleft RPARENright,
                                    mk_FunId Ident, StrExp
                                   )
                        
) end
)
 in (LrTable.NT 25,(result,Ident1left,RPAREN1right),rest671) end
| (107,(_,(_,_,ENDright as END1right))::(_,(MlyValue.StrExp StrExp1,_,
_))::_::(_,(MlyValue.StrDec StrDec1,_,_))::(_,(_,LETleft as LET1left,_
))::rest671) => let val result=MlyValue.StrExp(fn _ => let val StrDec
 as StrDec1=StrDec1 ()
val StrExp as StrExp1=StrExp1 ()
 in ( LETstrexp(PP LETleft ENDright, StrDec, StrExp) ) end
)
 in (LrTable.NT 25,(result,LET1left,END1right),rest671) end
| (108,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.StrDec 
StrDec1,StrDecleft,StrDecright))::_::(_,(MlyValue.Ident Ident1,
Identleft as Ident1left,_))::rest671) => let val result=
MlyValue.StrExp(fn _ => let val Ident as Ident1=Ident1 ()
val StrDec as StrDec1=StrDec1 ()
 in (
 APPstrexp(PP Identleft RPARENright, mk_FunId Ident,
                                    STRUCTstrexp(PP StrDecleft StrDecright,
                                                 StrDec
                                                )
                                   )
                        
) end
)
 in (LrTable.NT 25,(result,Ident1left,RPAREN1right),rest671) end
| (109,(_,(MlyValue.LongIdent LongIdent1,LongIdentleft as 
LongIdent1left,LongIdentright as LongIdent1right))::rest671) => let 
val result=MlyValue.StrExp_guarded(fn _ => let val LongIdent as 
LongIdent1=LongIdent1 ()
 in (
 LONGSTRIDstrexp(PP LongIdentleft LongIdentright,
                                          mk_LongStrId LongIdent
                                         )
                        
) end
)
 in (LrTable.NT 141,(result,LongIdent1left,LongIdent1right),rest671)
 end
| (110,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.StrExp 
StrExp1,_,_))::_::(_,(MlyValue.Ident Ident1,Identleft as Ident1left,_)
)::rest671) => let val result=MlyValue.StrExp_guarded(fn _ => let val 
Ident as Ident1=Ident1 ()
val StrExp as StrExp1=StrExp1 ()
 in (
 APPstrexp(PP Identleft RPARENright,
                                    mk_FunId Ident, StrExp
                                   )
                        
) end
)
 in (LrTable.NT 141,(result,Ident1left,RPAREN1right),rest671) end
| (111,(_,(_,_,ENDright as END1right))::(_,(MlyValue.StrExp_guarded 
StrExp_guarded1,_,_))::_::(_,(MlyValue.StrDec StrDec1,_,_))::(_,(_,
LETleft as LET1left,_))::rest671) => let val result=
MlyValue.StrExp_guarded(fn _ => let val StrDec as StrDec1=StrDec1 ()
val StrExp_guarded as StrExp_guarded1=StrExp_guarded1 ()
 in ( LETstrexp(PP LETleft ENDright, StrDec, StrExp_guarded) ) end
)
 in (LrTable.NT 141,(result,LET1left,END1right),rest671) end
| (112,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.StrDec 
StrDec1,StrDecleft,StrDecright))::_::(_,(MlyValue.Ident Ident1,
Identleft as Ident1left,_))::rest671) => let val result=
MlyValue.StrExp_guarded(fn _ => let val Ident as Ident1=Ident1 ()
val StrDec as StrDec1=StrDec1 ()
 in (
 APPstrexp(PP Identleft RPARENright, mk_FunId Ident,
                                    STRUCTstrexp(PP StrDecleft StrDecright,
                                                 StrDec
                                                )
                                   )
                        
) end
)
 in (LrTable.NT 141,(result,Ident1left,RPAREN1right),rest671) end
| (113,(_,(MlyValue.StrDec_sans_SEMICOLON StrDec_sans_SEMICOLON1,_,
StrDec_sans_SEMICOLONright as StrDec_sans_SEMICOLON1right))::(_,(
MlyValue.OneStrDec OneStrDec1,OneStrDecleft as OneStrDec1left,_))::
rest671) => let val result=MlyValue.StrDec_sans_SEMICOLON(fn _ => let 
val OneStrDec as OneStrDec1=OneStrDec1 ()
val StrDec_sans_SEMICOLON as StrDec_sans_SEMICOLON1=
StrDec_sans_SEMICOLON1 ()
 in (
 composeStrDec(PP OneStrDecleft
                                           StrDec_sans_SEMICOLONright,
                                        OneStrDec, StrDec_sans_SEMICOLON
                                       )
                        
) end
)
 in (LrTable.NT 2,(result,OneStrDec1left,StrDec_sans_SEMICOLON1right),
rest671) end
| (114,rest671) => let val result=MlyValue.StrDec_sans_SEMICOLON(fn _
 => ( EMPTYstrdec(PP defaultPos defaultPos) ))
 in (LrTable.NT 2,(result,defaultPos,defaultPos),rest671) end
| (115,(_,(MlyValue.OneStrDec_or_SEMICOLON OneStrDec_or_SEMICOLON1,_,
OneStrDec_or_SEMICOLONright as OneStrDec_or_SEMICOLON1right))::(_,(
MlyValue.NonEmptyStrDec NonEmptyStrDec1,NonEmptyStrDecleft as 
NonEmptyStrDec1left,_))::rest671) => let val result=
MlyValue.NonEmptyStrDec(fn _ => let val NonEmptyStrDec as 
NonEmptyStrDec1=NonEmptyStrDec1 ()
val OneStrDec_or_SEMICOLON as OneStrDec_or_SEMICOLON1=
OneStrDec_or_SEMICOLON1 ()
 in (
 case OneStrDec_or_SEMICOLON
                            of Some strdec =>
                                 composeStrDec(PP NonEmptyStrDecleft
                                                  OneStrDec_or_SEMICOLONright,
                                               NonEmptyStrDec, strdec
                                              )
                             | None =>
                                 NonEmptyStrDec
                        
) end
)
 in (LrTable.NT 42,(result,NonEmptyStrDec1left,
OneStrDec_or_SEMICOLON1right),rest671) end
| (116,(_,(MlyValue.OneStrDec_or_SEMICOLON OneStrDec_or_SEMICOLON1,
OneStrDec_or_SEMICOLON1left,OneStrDec_or_SEMICOLON1right))::rest671)
 => let val result=MlyValue.NonEmptyStrDec(fn _ => let val 
OneStrDec_or_SEMICOLON as OneStrDec_or_SEMICOLON1=
OneStrDec_or_SEMICOLON1 ()
 in (
 case OneStrDec_or_SEMICOLON
                            of Some strdec => strdec
                             | None => EMPTYstrdec(PP defaultPos defaultPos)
                        
) end
)
 in (LrTable.NT 42,(result,OneStrDec_or_SEMICOLON1left,
OneStrDec_or_SEMICOLON1right),rest671) end
| (117,(_,(MlyValue.NonEmptyStrDec NonEmptyStrDec1,NonEmptyStrDec1left
,NonEmptyStrDec1right))::rest671) => let val result=MlyValue.StrDec(
fn _ => let val NonEmptyStrDec as NonEmptyStrDec1=NonEmptyStrDec1 ()
 in ( NonEmptyStrDec ) end
)
 in (LrTable.NT 24,(result,NonEmptyStrDec1left,NonEmptyStrDec1right),
rest671) end
| (118,rest671) => let val result=MlyValue.StrDec(fn _ => (
 EMPTYstrdec(PP defaultPos defaultPos) ))
 in (LrTable.NT 24,(result,defaultPos,defaultPos),rest671) end
| (119,(_,(MlyValue.OneStrDec OneStrDec1,OneStrDec1left,
OneStrDec1right))::rest671) => let val result=
MlyValue.OneStrDec_or_SEMICOLON(fn _ => let val OneStrDec as 
OneStrDec1=OneStrDec1 ()
 in ( Some OneStrDec ) end
)
 in (LrTable.NT 41,(result,OneStrDec1left,OneStrDec1right),rest671)
 end
| (120,(_,(_,SEMICOLON1left,SEMICOLON1right))::rest671) => let val 
result=MlyValue.OneStrDec_or_SEMICOLON(fn _ => ( None ))
 in (LrTable.NT 41,(result,SEMICOLON1left,SEMICOLON1right),rest671)
 end
| (121,(_,(MlyValue.OneDec_sans_LOCAL OneDec_sans_LOCAL1,
OneDec_sans_LOCALleft as OneDec_sans_LOCAL1left,OneDec_sans_LOCALright
 as OneDec_sans_LOCAL1right))::rest671) => let val result=
MlyValue.OneStrDec(fn _ => let val OneDec_sans_LOCAL as 
OneDec_sans_LOCAL1=OneDec_sans_LOCAL1 ()
 in (
 DECstrdec(PP OneDec_sans_LOCALleft
                                       OneDec_sans_LOCALright,
                                    OneDec_sans_LOCAL
                                   )
                        
) end
)
 in (LrTable.NT 4,(result,OneDec_sans_LOCAL1left,
OneDec_sans_LOCAL1right),rest671) end
| (122,(_,(MlyValue.Ax Ax1,_,Axright as Ax1right))::(_,(_,AXIOMleft
 as AXIOM1left,_))::rest671) => let val result=MlyValue.OneStrDec(fn _
 => let val Ax as Ax1=Ax1 ()
 in (
 AXIOMstrdec( PP AXIOMleft Axright ,
                       Ax )
        
) end
)
 in (LrTable.NT 4,(result,AXIOM1left,Ax1right),rest671) end
| (123,(_,(MlyValue.StrBind StrBind1,_,StrBindright as StrBind1right))
::(_,(_,STRUCTUREleft as STRUCTURE1left,_))::rest671) => let val 
result=MlyValue.OneStrDec(fn _ => let val StrBind as StrBind1=StrBind1
 ()
 in (
 STRUCTUREstrdec(PP STRUCTUREleft StrBindright,
                                          StrBind
                                         )
                        
) end
)
 in (LrTable.NT 4,(result,STRUCTURE1left,StrBind1right),rest671) end
| (124,(_,(_,_,ENDright as END1right))::(_,(MlyValue.StrDec StrDec2,_,
_))::_::(_,(MlyValue.StrDec StrDec1,_,_))::(_,(_,LOCALleft as 
LOCAL1left,_))::rest671) => let val result=MlyValue.OneStrDec(fn _ => 
let val StrDec1=StrDec1 ()
val StrDec2=StrDec2 ()
 in (
 LOCALstrdec(PP LOCALleft ENDright,
                                      StrDec1, StrDec2
                                     )
                        
) end
)
 in (LrTable.NT 4,(result,LOCAL1left,END1right),rest671) end
| (125,(_,(MlyValue.AndAx_opt AndAx_opt1,_,AndAx_optright as 
AndAx_opt1right))::(_,(MlyValue.AxExp AxExp1,AxExpleft as AxExp1left,_
))::rest671) => let val result=MlyValue.Ax(fn _ => let val AxExp as 
AxExp1=AxExp1 ()
val AndAx_opt as AndAx_opt1=AndAx_opt1 ()
 in (
 AXIOMax(PP AxExpleft AndAx_optright,
                                  AxExp, AndAx_opt
                                 )
                        
) end
)
 in (LrTable.NT 23,(result,AxExp1left,AndAx_opt1right),rest671) end
| (126,(_,(MlyValue.Ax Ax1,_,Ax1right))::(_,(_,AND1left,_))::rest671)
 => let val result=MlyValue.AndAx_opt(fn _ => let val Ax as Ax1=Ax1 ()
 in ( Some Ax ) end
)
 in (LrTable.NT 38,(result,AND1left,Ax1right),rest671) end
| (127,rest671) => let val result=MlyValue.AndAx_opt(fn _ => ( None ))
 in (LrTable.NT 38,(result,defaultPos,defaultPos),rest671) end
| (128,(_,(MlyValue.Exp_bullet Exp_bullet1,Exp_bulletleft as 
Exp_bullet1left,Exp_bulletright as Exp_bullet1right))::rest671) => 
let val result=MlyValue.AxExp(fn _ => let val Exp_bullet as 
Exp_bullet1=Exp_bullet1 ()
 in (
 AXIOM_EXPaxexp( PP Exp_bulletleft Exp_bulletright,
                      Exp_bullet )
      
) end
)
 in (LrTable.NT 22,(result,Exp_bullet1left,Exp_bullet1right),rest671)
 end
| (129,(_,(MlyValue.StrExp StrExp1,_,StrExpright as StrExp1right))::_
::(_,(MlyValue.PSigExp PSigExp1,_,_))::_::(_,(MlyValue.Ident Ident1,
Identleft as Ident1left,_))::rest671) => let val result=
MlyValue.SglStrBind(fn _ => let val Ident as Ident1=Ident1 ()
val PSigExp as PSigExp1=PSigExp1 ()
val StrExp as StrExp1=StrExp1 ()
 in (
 SINGLEsglstrbind(PP Identleft StrExpright,
                                                mk_StrId Ident, PSigExp,
                                                StrExp)
                        
) end
)
 in (LrTable.NT 21,(result,Ident1left,StrExp1right),rest671) end
| (130,(_,(_,_,QUESTIONMARKright as QUESTIONMARK1right))::_::(_,(
MlyValue.PSigExp PSigExp1,_,_))::_::(_,(MlyValue.Ident Ident1,
Identleft as Ident1left,_))::rest671) => let val result=
MlyValue.SglStrBind(fn _ => let val Ident as Ident1=Ident1 ()
val PSigExp as PSigExp1=PSigExp1 ()
 in (
 UNDEFsglstrbind(PP Identleft QUESTIONMARKright,
                                                mk_StrId Ident, PSigExp)
                        
) end
)
 in (LrTable.NT 21,(result,Ident1left,QUESTIONMARK1right),rest671) end
| (131,(_,(MlyValue.StrExp_guarded StrExp_guarded1,_,
StrExp_guardedright as StrExp_guarded1right))::_::(_,(MlyValue.Ident 
Ident1,Identleft as Ident1left,_))::rest671) => let val result=
MlyValue.SglStrBind(fn _ => let val Ident as Ident1=Ident1 ()
val StrExp_guarded as StrExp_guarded1=StrExp_guarded1 ()
 in (
 UNGUARDsglstrbind(PP Identleft StrExp_guardedright,
                                mk_StrId Ident, StrExp_guarded)
) end
)
 in (LrTable.NT 21,(result,Ident1left,StrExp_guarded1right),rest671)
 end
| (132,(_,(MlyValue.AndStrBind_opt AndStrBind_opt1,_,
AndStrBind_optright as AndStrBind_opt1right))::(_,(MlyValue.SglStrBind
 SglStrBind1,SglStrBindleft as SglStrBind1left,_))::rest671) => let 
val result=MlyValue.StrBind(fn _ => let val SglStrBind as SglStrBind1=
SglStrBind1 ()
val AndStrBind_opt as AndStrBind_opt1=AndStrBind_opt1 ()
 in (
 STRBIND(PP SglStrBindleft AndStrBind_optright,
                                  SglStrBind, AndStrBind_opt
                                 )
                        
) end
)
 in (LrTable.NT 20,(result,SglStrBind1left,AndStrBind_opt1right),
rest671) end
| (133,(_,(MlyValue.StrBind StrBind1,_,StrBind1right))::(_,(_,AND1left
,_))::rest671) => let val result=MlyValue.AndStrBind_opt(fn _ => let 
val StrBind as StrBind1=StrBind1 ()
 in ( Some StrBind ) end
)
 in (LrTable.NT 29,(result,AND1left,StrBind1right),rest671) end
| (134,rest671) => let val result=MlyValue.AndStrBind_opt(fn _ => (
 None ))
 in (LrTable.NT 29,(result,defaultPos,defaultPos),rest671) end
| (135,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Spec Spec1,_,_))
::(_,(_,SIGleft as SIG1left,_))::rest671) => let val result=
MlyValue.SigExp(fn _ => let val Spec as Spec1=Spec1 ()
 in ( SIGsigexp(PP SIGleft ENDright, Spec) ) end
)
 in (LrTable.NT 19,(result,SIG1left,END1right),rest671) end
| (136,(_,(MlyValue.Ident Ident1,Identleft as Ident1left,Identright
 as Ident1right))::rest671) => let val result=MlyValue.SigExp(fn _ => 
let val Ident as Ident1=Ident1 ()
 in ( SIGIDsigexp(PP Identleft Identright, mk_SigId Ident)) end
)
 in (LrTable.NT 19,(result,Ident1left,Ident1right),rest671) end
| (137,(_,(MlyValue.SigExp SigExp1,SigExpleft as SigExp1left,
SigExpright as SigExp1right))::rest671) => let val result=
MlyValue.PSigExp(fn _ => let val SigExp as SigExp1=SigExp1 ()
 in ( PRINCIPpsigexp(PP SigExpleft SigExpright, SigExp) ) end
)
 in (LrTable.NT 18,(result,SigExp1left,SigExp1right),rest671) end
| (138,(_,(MlyValue.SigDec_sans_SC_opt SigDec_sans_SC_opt1,_,
SigDec_sans_SC_optright as SigDec_sans_SC_opt1right))::(_,(
MlyValue.SigBind SigBind1,_,_))::(_,(_,SIGNATUREleft as SIGNATURE1left
,_))::rest671) => let val result=MlyValue.SigDec_sans_SEMICOLON(fn _
 => let val SigBind as SigBind1=SigBind1 ()
val SigDec_sans_SC_opt as SigDec_sans_SC_opt1=SigDec_sans_SC_opt1 ()
 in (
 let
                            val i = PP SIGNATUREleft SigDec_sans_SC_optright
                            val sigdec1 = SIGNATUREsigdec(i, SigBind)
                          in
                            case SigDec_sans_SC_opt
                              of Some sd => SEQsigdec(i, sigdec1, sd)
                               | None => sigdec1
                          end
                        
) end
)
 in (LrTable.NT 1,(result,SIGNATURE1left,SigDec_sans_SC_opt1right),
rest671) end
| (139,(_,(MlyValue.SigDec_sans_SEMICOLON SigDec_sans_SEMICOLON1,
SigDec_sans_SEMICOLON1left,SigDec_sans_SEMICOLON1right))::rest671) => 
let val result=MlyValue.SigDec_sans_SC_opt(fn _ => let val 
SigDec_sans_SEMICOLON as SigDec_sans_SEMICOLON1=SigDec_sans_SEMICOLON1
 ()
 in ( Some SigDec_sans_SEMICOLON ) end
)
 in (LrTable.NT 26,(result,SigDec_sans_SEMICOLON1left,
SigDec_sans_SEMICOLON1right),rest671) end
| (140,rest671) => let val result=MlyValue.SigDec_sans_SC_opt(fn _ => 
( None ))
 in (LrTable.NT 26,(result,defaultPos,defaultPos),rest671) end
| (141,(_,(MlyValue.AndSigBind_opt AndSigBind_opt1,_,
AndSigBind_optright as AndSigBind_opt1right))::(_,(MlyValue.PSigExp 
PSigExp1,_,_))::_::(_,(MlyValue.Ident Ident1,Identleft as Ident1left,_
))::rest671) => let val result=MlyValue.SigBind(fn _ => let val Ident
 as Ident1=Ident1 ()
val PSigExp as PSigExp1=PSigExp1 ()
val AndSigBind_opt as AndSigBind_opt1=AndSigBind_opt1 ()
 in (
 SIGBIND(PP Identleft AndSigBind_optright,
                                  mk_SigId Ident, PSigExp, AndSigBind_opt
                                 )
                        
) end
)
 in (LrTable.NT 17,(result,Ident1left,AndSigBind_opt1right),rest671)
 end
| (142,(_,(MlyValue.SigBind SigBind1,_,SigBind1right))::(_,(_,AND1left
,_))::rest671) => let val result=MlyValue.AndSigBind_opt(fn _ => let 
val SigBind as SigBind1=SigBind1 ()
 in ( Some SigBind ) end
)
 in (LrTable.NT 30,(result,AND1left,SigBind1right),rest671) end
| (143,rest671) => let val result=MlyValue.AndSigBind_opt(fn _ => (
 None ))
 in (LrTable.NT 30,(result,defaultPos,defaultPos),rest671) end
| (144,(_,(MlyValue.AndValBind_optbullet AndValBind_optbullet1,_,
AndValBind_optbulletright as AndValBind_optbullet1right))::(_,(
MlyValue.Exp_questionmark Exp_questionmark1,_,_))::_::(_,(MlyValue.Pat
 Pat1,Patleft as Pat1left,_))::rest671) => let val result=
MlyValue.ValBindquestionmark(fn _ => let val Pat as Pat1=Pat1 ()
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val AndValBind_optbullet as AndValBind_optbullet1=
AndValBind_optbullet1 ()
 in (
 PLAINvalbind(PP Patleft 
                                          AndValBind_optbulletright,
                                       Pat, Exp_questionmark, 
                                       AndValBind_optbullet)
) end
)
 in (LrTable.NT 134,(result,Pat1left,AndValBind_optbullet1right),
rest671) end
| (145,(_,(MlyValue.AndValBind_optquestionmark 
AndValBind_optquestionmark1,_,AndValBind_optquestionmarkright as 
AndValBind_optquestionmark1right))::(_,(MlyValue.Exp_bullet 
Exp_bullet1,_,_))::_::(_,(MlyValue.Pat Pat1,Patleft as Pat1left,_))::
rest671) => let val result=MlyValue.ValBindquestionmark(fn _ => let 
val Pat as Pat1=Pat1 ()
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
val AndValBind_optquestionmark as AndValBind_optquestionmark1=
AndValBind_optquestionmark1 ()
 in (
 PLAINvalbind(PP Patleft 
                                          AndValBind_optquestionmarkright,
                                       Pat, Exp_bullet, 
                                       AndValBind_optquestionmark)
) end
)
 in (LrTable.NT 134,(result,Pat1left,AndValBind_optquestionmark1right)
,rest671) end
| (146,(_,(MlyValue.AndValBind_optquestionmark 
AndValBind_optquestionmark1,_,AndValBind_optquestionmarkright as 
AndValBind_optquestionmark1right))::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,_,_))::_::(_,(MlyValue.Pat Pat1,Patleft as Pat1left,
_))::rest671) => let val result=MlyValue.ValBindquestionmark(fn _ => 
let val Pat as Pat1=Pat1 ()
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val AndValBind_optquestionmark as AndValBind_optquestionmark1=
AndValBind_optquestionmark1 ()
 in (
 PLAINvalbind(PP Patleft 
                                          AndValBind_optquestionmarkright,
                                       Pat, Exp_questionmark, 
                                       AndValBind_optquestionmark)
) end
)
 in (LrTable.NT 134,(result,Pat1left,AndValBind_optquestionmark1right)
,rest671) end
| (147,(_,(MlyValue.FnValBindquestionmark FnValBindquestionmark1,_,
FnValBindquestionmarkright as FnValBindquestionmark1right))::(_,(_,
RECleft as REC1left,_))::rest671) => let val result=
MlyValue.ValBindquestionmark(fn _ => let val FnValBindquestionmark as 
FnValBindquestionmark1=FnValBindquestionmark1 ()
 in (
 RECvalbind(PP RECleft 
                                        FnValBindquestionmarkright, 
                                     FnValBindquestionmark) 
) end
)
 in (LrTable.NT 134,(result,REC1left,FnValBindquestionmark1right),
rest671) end
| (148,(_,(MlyValue.ValBindquestionmark ValBindquestionmark1,_,
ValBindquestionmark1right))::(_,(_,AND1left,_))::rest671) => let val 
result=MlyValue.AndValBind_optquestionmark(fn _ => let val 
ValBindquestionmark as ValBindquestionmark1=ValBindquestionmark1 ()
 in ( Some ValBindquestionmark ) end
)
 in (LrTable.NT 136,(result,AND1left,ValBindquestionmark1right),
rest671) end
| (149,(_,(MlyValue.AndFnValBind_optquestionmark 
AndFnValBind_optquestionmark1,_,AndFnValBind_optquestionmarkright as 
AndFnValBind_optquestionmark1right))::(_,(MlyValue.Match_bullet 
Match_bullet1,_,Match_bulletright))::(_,(_,FNleft,_))::_::(_,(
MlyValue.Pat Pat1,Patleft as Pat1left,_))::rest671) => let val result=
MlyValue.FnValBindquestionmark(fn _ => let val Pat as Pat1=Pat1 ()
val Match_bullet as Match_bullet1=Match_bullet1 ()
val AndFnValBind_optquestionmark as AndFnValBind_optquestionmark1=
AndFnValBind_optquestionmark1 ()
 in (
 PLAINvalbind(PP Patleft 
                                          AndFnValBind_optquestionmarkright,
                                       Pat,
                                       FNexp(PP FNleft
                                                Match_bulletright, 
                                             Match_bullet),
                                       AndFnValBind_optquestionmark)
) end
)
 in (LrTable.NT 135,(result,Pat1left,
AndFnValBind_optquestionmark1right),rest671) end
| (150,(_,(MlyValue.AndFnValBind_optbullet AndFnValBind_optbullet1,_,
AndFnValBind_optbulletright as AndFnValBind_optbullet1right))::(_,(
MlyValue.Match_questionmark Match_questionmark1,_,
Match_questionmarkright))::(_,(_,FNleft,_))::_::(_,(MlyValue.Pat Pat1,
Patleft as Pat1left,_))::rest671) => let val result=
MlyValue.FnValBindquestionmark(fn _ => let val Pat as Pat1=Pat1 ()
val Match_questionmark as Match_questionmark1=Match_questionmark1 ()
val AndFnValBind_optbullet as AndFnValBind_optbullet1=
AndFnValBind_optbullet1 ()
 in (
 PLAINvalbind(PP Patleft 
                                          AndFnValBind_optbulletright,
                                       Pat,
                                       FNexp(PP FNleft 
                                                Match_questionmarkright, 
                                             Match_questionmark),
                                       AndFnValBind_optbullet)
) end
)
 in (LrTable.NT 135,(result,Pat1left,AndFnValBind_optbullet1right),
rest671) end
| (151,(_,(MlyValue.AndFnValBind_optquestionmark 
AndFnValBind_optquestionmark1,_,AndFnValBind_optquestionmarkright as 
AndFnValBind_optquestionmark1right))::(_,(MlyValue.Match_questionmark 
Match_questionmark1,_,Match_questionmarkright))::(_,(_,FNleft,_))::_::
(_,(MlyValue.Pat Pat1,Patleft as Pat1left,_))::rest671) => let val 
result=MlyValue.FnValBindquestionmark(fn _ => let val Pat as Pat1=Pat1
 ()
val Match_questionmark as Match_questionmark1=Match_questionmark1 ()
val AndFnValBind_optquestionmark as AndFnValBind_optquestionmark1=
AndFnValBind_optquestionmark1 ()
 in (
 PLAINvalbind(PP Patleft 
                                          AndFnValBind_optquestionmarkright,
                                       Pat,
                                       FNexp(PP FNleft 
                                                Match_questionmarkright, 
                                             Match_questionmark),
                                       AndFnValBind_optquestionmark)
) end
)
 in (LrTable.NT 135,(result,Pat1left,
AndFnValBind_optquestionmark1right),rest671) end
| (152,(_,(MlyValue.AndFnValBind_optquestionmark 
AndFnValBind_optquestionmark1,_,AndFnValBind_optquestionmarkright as 
AndFnValBind_optquestionmark1right))::(_,(MlyValue.ColonTy_seq1 
ColonTy_seq11,_,_))::(_,(_,_,RPARENright))::(_,(MlyValue.Match_bullet 
Match_bullet1,_,Match_bulletright))::(_,(_,FNleft,_))::(_,(_,
LPARENleft,_))::_::(_,(MlyValue.Pat Pat1,Patleft as Pat1left,_))::
rest671) => let val result=MlyValue.FnValBindquestionmark(fn _ => let 
val Pat as Pat1=Pat1 ()
val Match_bullet as Match_bullet1=Match_bullet1 ()
val ColonTy_seq1 as ColonTy_seq11=ColonTy_seq11 ()
val AndFnValBind_optquestionmark as AndFnValBind_optquestionmark1=
AndFnValBind_optquestionmark1 ()
 in (
 let
                            val fnExp = FNexp(PP FNleft 
                                                 Match_bulletright, 
                                              Match_bullet)
                            val parAtexp =
                              PARatexp(PP LPARENleft RPARENright, fnExp)
                            val atexpExp =
                              ATEXPexp(PP LPARENleft RPARENright, parAtexp)
                            fun attachTypes(e, nil) = e
                              | attachTypes(e, (ty, p) :: rest) =
                                  attachTypes(TYPEDexp(PP FNleft p, e, ty),
                                              rest
                                             )
                          in
                            PLAINvalbind(PP Patleft 
                                            AndFnValBind_optquestionmarkright,
                                         Pat,
                                         attachTypes(atexpExp, ColonTy_seq1),
                                         AndFnValBind_optquestionmark
                                        )
                          end
                        
) end
)
 in (LrTable.NT 135,(result,Pat1left,
AndFnValBind_optquestionmark1right),rest671) end
| (153,(_,(MlyValue.AndFnValBind_optbullet AndFnValBind_optbullet1,_,
AndFnValBind_optbulletright as AndFnValBind_optbullet1right))::(_,(
MlyValue.ColonTy_seq1 ColonTy_seq11,_,_))::(_,(_,_,RPARENright))::(_,(
MlyValue.Match_questionmark Match_questionmark1,_,
Match_questionmarkright))::(_,(_,FNleft,_))::(_,(_,LPARENleft,_))::_::
(_,(MlyValue.Pat Pat1,Patleft as Pat1left,_))::rest671) => let val 
result=MlyValue.FnValBindquestionmark(fn _ => let val Pat as Pat1=Pat1
 ()
val Match_questionmark as Match_questionmark1=Match_questionmark1 ()
val ColonTy_seq1 as ColonTy_seq11=ColonTy_seq11 ()
val AndFnValBind_optbullet as AndFnValBind_optbullet1=
AndFnValBind_optbullet1 ()
 in (
 let
                            val fnExp = FNexp(PP FNleft 
                                                 Match_questionmarkright, 
                                              Match_questionmark)
                            val parAtexp =
                              PARatexp(PP LPARENleft RPARENright, fnExp)
                            val atexpExp =
                              ATEXPexp(PP LPARENleft RPARENright, parAtexp)
                            fun attachTypes(e, nil) = e
                              | attachTypes(e, (ty, p) :: rest) =
                                  attachTypes(TYPEDexp(PP FNleft p, e, ty),
                                              rest
                                             )
                          in
                            PLAINvalbind(PP Patleft 
                                            AndFnValBind_optbulletright,
                                         Pat,
                                         attachTypes(atexpExp, ColonTy_seq1),
                                         AndFnValBind_optbullet
                                        )
                          end
                        
) end
)
 in (LrTable.NT 135,(result,Pat1left,AndFnValBind_optbullet1right),
rest671) end
| (154,(_,(MlyValue.AndFnValBind_optquestionmark 
AndFnValBind_optquestionmark1,_,AndFnValBind_optquestionmarkright as 
AndFnValBind_optquestionmark1right))::(_,(MlyValue.ColonTy_seq1 
ColonTy_seq11,_,_))::(_,(_,_,RPARENright))::(_,(
MlyValue.Match_questionmark Match_questionmark1,_,
Match_questionmarkright))::(_,(_,FNleft,_))::(_,(_,LPARENleft,_))::_::
(_,(MlyValue.Pat Pat1,Patleft as Pat1left,_))::rest671) => let val 
result=MlyValue.FnValBindquestionmark(fn _ => let val Pat as Pat1=Pat1
 ()
val Match_questionmark as Match_questionmark1=Match_questionmark1 ()
val ColonTy_seq1 as ColonTy_seq11=ColonTy_seq11 ()
val AndFnValBind_optquestionmark as AndFnValBind_optquestionmark1=
AndFnValBind_optquestionmark1 ()
 in (
 let
                            val fnExp = FNexp(PP FNleft 
                                                 Match_questionmarkright, 
                                              Match_questionmark)
                            val parAtexp =
                              PARatexp(PP LPARENleft RPARENright, fnExp)
                            val atexpExp =
                              ATEXPexp(PP LPARENleft RPARENright, parAtexp)
                            fun attachTypes(e, nil) = e
                              | attachTypes(e, (ty, p) :: rest) =
                                  attachTypes(TYPEDexp(PP FNleft p, e, ty),
                                              rest
                                             )
                          in
                            PLAINvalbind(PP Patleft 
                                            AndFnValBind_optquestionmarkright,
                                         Pat,
                                         attachTypes(atexpExp, ColonTy_seq1),
                                         AndFnValBind_optquestionmark
                                        )
                          end
                        
) end
)
 in (LrTable.NT 135,(result,Pat1left,
AndFnValBind_optquestionmark1right),rest671) end
| (155,(_,(MlyValue.FnValBindquestionmark FnValBindquestionmark1,_,
FnValBindquestionmarkright as FnValBindquestionmark1right))::(_,(_,
RECleft as REC1left,_))::rest671) => let val result=
MlyValue.FnValBindquestionmark(fn _ => let val FnValBindquestionmark
 as FnValBindquestionmark1=FnValBindquestionmark1 ()
 in (
 RECvalbind(PP RECleft 
                                        FnValBindquestionmarkright, 
                                     FnValBindquestionmark) 
) end
)
 in (LrTable.NT 135,(result,REC1left,FnValBindquestionmark1right),
rest671) end
| (156,(_,(MlyValue.FnValBindquestionmark FnValBindquestionmark1,_,
FnValBindquestionmark1right))::(_,(_,AND1left,_))::rest671) => let 
val result=MlyValue.AndFnValBind_optquestionmark(fn _ => let val 
FnValBindquestionmark as FnValBindquestionmark1=FnValBindquestionmark1
 ()
 in ( Some FnValBindquestionmark ) end
)
 in (LrTable.NT 137,(result,AND1left,FnValBindquestionmark1right),
rest671) end
| (157,(_,(MlyValue.AndTypBind_optbullet AndTypBind_optbullet1,_,
AndTypBind_optbulletright as AndTypBind_optbullet1right))::_::_::(_,(
MlyValue.TypeIdent TypeIdent1,_,_))::(_,(MlyValue.TyVarSeq TyVarSeq1,
TyVarSeqleft as TyVarSeq1left,_))::rest671) => let val result=
MlyValue.TypBindquestionmark(fn _ => let val TyVarSeq as TyVarSeq1=
TyVarSeq1 ()
val TypeIdent as TypeIdent1=TypeIdent1 ()
val AndTypBind_optbullet as AndTypBind_optbullet1=
AndTypBind_optbullet1 ()
 in (
 QUEST_TYPBIND(PP TyVarSeqleft
                                           AndTypBind_optbulletright,
                                        TyVarSeq, mk_TyCon TypeIdent,
                                        AndTypBind_optbullet)
) end
)
 in (LrTable.NT 132,(result,TyVarSeq1left,AndTypBind_optbullet1right),
rest671) end
| (158,(_,(MlyValue.AndTypBind_optquestionmark 
AndTypBind_optquestionmark1,_,AndTypBind_optquestionmarkright as 
AndTypBind_optquestionmark1right))::(_,(MlyValue.Ty Ty1,_,_))::_::(_,(
MlyValue.TypeIdent TypeIdent1,_,_))::(_,(MlyValue.TyVarSeq TyVarSeq1,
TyVarSeqleft as TyVarSeq1left,_))::rest671) => let val result=
MlyValue.TypBindquestionmark(fn _ => let val TyVarSeq as TyVarSeq1=
TyVarSeq1 ()
val TypeIdent as TypeIdent1=TypeIdent1 ()
val Ty as Ty1=Ty1 ()
val AndTypBind_optquestionmark as AndTypBind_optquestionmark1=
AndTypBind_optquestionmark1 ()
 in (
 TYPBIND(PP TyVarSeqleft
                                     AndTypBind_optquestionmarkright,
                                  TyVarSeq, mk_TyCon TypeIdent,
                                  Ty, AndTypBind_optquestionmark)
) end
)
 in (LrTable.NT 132,(result,TyVarSeq1left,
AndTypBind_optquestionmark1right),rest671) end
| (159,(_,(MlyValue.AndTypBind_optquestionmark 
AndTypBind_optquestionmark1,_,AndTypBind_optquestionmarkright as 
AndTypBind_optquestionmark1right))::_::_::(_,(MlyValue.TypeIdent 
TypeIdent1,_,_))::(_,(MlyValue.TyVarSeq TyVarSeq1,TyVarSeqleft as 
TyVarSeq1left,_))::rest671) => let val result=
MlyValue.TypBindquestionmark(fn _ => let val TyVarSeq as TyVarSeq1=
TyVarSeq1 ()
val TypeIdent as TypeIdent1=TypeIdent1 ()
val AndTypBind_optquestionmark as AndTypBind_optquestionmark1=
AndTypBind_optquestionmark1 ()
 in (
 QUEST_TYPBIND(PP TyVarSeqleft
                                           AndTypBind_optquestionmarkright,
                                        TyVarSeq, mk_TyCon TypeIdent,
                                        AndTypBind_optquestionmark)
) end
)
 in (LrTable.NT 132,(result,TyVarSeq1left,
AndTypBind_optquestionmark1right),rest671) end
| (160,(_,(MlyValue.TypBindquestionmark TypBindquestionmark1,_,
TypBindquestionmark1right))::(_,(_,AND1left,_))::rest671) => let val 
result=MlyValue.AndTypBind_optquestionmark(fn _ => let val 
TypBindquestionmark as TypBindquestionmark1=TypBindquestionmark1 ()
 in ( Some TypBindquestionmark ) end
)
 in (LrTable.NT 133,(result,AND1left,TypBindquestionmark1right),
rest671) end
| (161,(_,(MlyValue.AndFValBind_optquestionmark 
AndFValBind_optquestionmark1,_,AndFValBind_optquestionmarkright as 
AndFValBind_optquestionmark1right))::(_,(MlyValue.FClausequestionmark 
FClausequestionmark1,FClausequestionmarkleft as 
FClausequestionmark1left,_))::rest671) => let val result=
MlyValue.FValBindquestionmark(fn _ => let val FClausequestionmark as 
FClausequestionmark1=FClausequestionmark1 ()
val AndFValBind_optquestionmark as AndFValBind_optquestionmark1=
AndFValBind_optquestionmark1 ()
 in (
 FVALBIND(PP FClausequestionmarkleft 
                                      AndFValBind_optquestionmarkright,
                                   FClausequestionmark, 
                                   AndFValBind_optquestionmark
                                  )
                        
) end
)
 in (LrTable.NT 123,(result,FClausequestionmark1left,
AndFValBind_optquestionmark1right),rest671) end
| (162,(_,(MlyValue.AndFValBind_optbullet AndFValBind_optbullet1,_,
AndFValBind_optbulletright as AndFValBind_optbullet1right))::(_,(
MlyValue.FClausequestionmark FClausequestionmark1,
FClausequestionmarkleft as FClausequestionmark1left,_))::rest671) => 
let val result=MlyValue.FValBindquestionmark(fn _ => let val 
FClausequestionmark as FClausequestionmark1=FClausequestionmark1 ()
val AndFValBind_optbullet as AndFValBind_optbullet1=
AndFValBind_optbullet1 ()
 in (
 FVALBIND(PP FClausequestionmarkleft 
                                      AndFValBind_optbulletright,
                                   FClausequestionmark, 
                                   AndFValBind_optbullet
                                  )
                        
) end
)
 in (LrTable.NT 123,(result,FClausequestionmark1left,
AndFValBind_optbullet1right),rest671) end
| (163,(_,(MlyValue.AndFValBind_optquestionmark 
AndFValBind_optquestionmark1,_,AndFValBind_optquestionmarkright as 
AndFValBind_optquestionmark1right))::(_,(MlyValue.FClausebullet 
FClausebullet1,FClausebulletleft as FClausebullet1left,_))::rest671)
 => let val result=MlyValue.FValBindquestionmark(fn _ => let val 
FClausebullet as FClausebullet1=FClausebullet1 ()
val AndFValBind_optquestionmark as AndFValBind_optquestionmark1=
AndFValBind_optquestionmark1 ()
 in (
 FVALBIND(PP FClausebulletleft 
                                      AndFValBind_optquestionmarkright,
                                   FClausebullet, 
                                   AndFValBind_optquestionmark
                                  )
                        
) end
)
 in (LrTable.NT 123,(result,FClausebullet1left,
AndFValBind_optquestionmark1right),rest671) end
| (164,(_,(MlyValue.FValBindquestionmark FValBindquestionmark1,_,
FValBindquestionmark1right))::(_,(_,AND1left,_))::rest671) => let val 
result=MlyValue.AndFValBind_optquestionmark(fn _ => let val 
FValBindquestionmark as FValBindquestionmark1=FValBindquestionmark1 ()
 in ( Some FValBindquestionmark ) end
)
 in (LrTable.NT 124,(result,AND1left,FValBindquestionmark1right),
rest671) end
| (165,(_,(MlyValue.BarFClause_optquestionmark 
BarFClause_optquestionmark1,_,BarFClause_optquestionmarkright as 
BarFClause_optquestionmark1right))::(_,(MlyValue.Exp_bullet 
Exp_bullet1,_,_))::_::(_,(MlyValue.ColonTy_opt ColonTy_opt1,_,_))::(_,
(MlyValue.AtPat_seq1 AtPat_seq11,AtPat_seq1left as AtPat_seq11left,_))
::rest671) => let val result=MlyValue.FClausequestionmark(fn _ => let 
val AtPat_seq1 as AtPat_seq11=AtPat_seq11 ()
val ColonTy_opt as ColonTy_opt1=ColonTy_opt1 ()
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
val BarFClause_optquestionmark as BarFClause_optquestionmark1=
BarFClause_optquestionmark1 ()
 in (
 FCLAUSE(PP AtPat_seq1left 
                                     BarFClause_optquestionmarkright,
                                  AtPat_seq1, ColonTy_opt,
                                  Exp_bullet, 
                                  BarFClause_optquestionmark
                                 )
                        
) end
)
 in (LrTable.NT 125,(result,AtPat_seq11left,
BarFClause_optquestionmark1right),rest671) end
| (166,(_,(MlyValue.BarFClause_optbullet BarFClause_optbullet1,_,
BarFClause_optbulletright as BarFClause_optbullet1right))::(_,(
MlyValue.Exp_questionmark Exp_questionmark1,_,_))::_::(_,(
MlyValue.ColonTy_opt ColonTy_opt1,_,_))::(_,(MlyValue.AtPat_seq1 
AtPat_seq11,AtPat_seq1left as AtPat_seq11left,_))::rest671) => let 
val result=MlyValue.FClausequestionmark(fn _ => let val AtPat_seq1 as 
AtPat_seq11=AtPat_seq11 ()
val ColonTy_opt as ColonTy_opt1=ColonTy_opt1 ()
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val BarFClause_optbullet as BarFClause_optbullet1=
BarFClause_optbullet1 ()
 in (
 FCLAUSE(PP AtPat_seq1left BarFClause_optbulletright,
                                  AtPat_seq1, ColonTy_opt,
                                  Exp_questionmark, 
                                  BarFClause_optbullet
                                 )
                        
) end
)
 in (LrTable.NT 125,(result,AtPat_seq11left,BarFClause_optbullet1right
),rest671) end
| (167,(_,(MlyValue.BarFClause_optquestionmark 
BarFClause_optquestionmark1,_,BarFClause_optquestionmarkright as 
BarFClause_optquestionmark1right))::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,_,_))::_::(_,(MlyValue.ColonTy_opt ColonTy_opt1,_,_)
)::(_,(MlyValue.AtPat_seq1 AtPat_seq11,AtPat_seq1left as 
AtPat_seq11left,_))::rest671) => let val result=
MlyValue.FClausequestionmark(fn _ => let val AtPat_seq1 as AtPat_seq11
=AtPat_seq11 ()
val ColonTy_opt as ColonTy_opt1=ColonTy_opt1 ()
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val BarFClause_optquestionmark as BarFClause_optquestionmark1=
BarFClause_optquestionmark1 ()
 in (
 FCLAUSE(PP AtPat_seq1left 
                                     BarFClause_optquestionmarkright,
                                  AtPat_seq1, ColonTy_opt,
                                  Exp_questionmark, 
                                  BarFClause_optquestionmark
                                 )
                        
) end
)
 in (LrTable.NT 125,(result,AtPat_seq11left,
BarFClause_optquestionmark1right),rest671) end
| (168,(_,(MlyValue.FClausequestionmark FClausequestionmark1,_,
FClausequestionmark1right))::(_,(_,BAR1left,_))::rest671) => let val 
result=MlyValue.BarFClause_optquestionmark(fn _ => let val 
FClausequestionmark as FClausequestionmark1=FClausequestionmark1 ()
 in ( Some FClausequestionmark ) end
)
 in (LrTable.NT 126,(result,BAR1left,FClausequestionmark1right),
rest671) end
| (169,(_,(MlyValue.ValBindquestionmark ValBindquestionmark1,_,
ValBindquestionmarkright as ValBindquestionmark1right))::(_,(_,VALleft
 as VAL1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCALquestionmark(fn _ => let val 
ValBindquestionmark as ValBindquestionmark1=ValBindquestionmark1 ()
 in (
 VALdec(PP VALleft 
                                    ValBindquestionmarkright, 
                                 ValBindquestionmark) 
) end
)
 in (LrTable.NT 127,(result,VAL1left,ValBindquestionmark1right),
rest671) end
| (170,(_,(MlyValue.TypBindquestionmark TypBindquestionmark1,_,
TypBindquestionmarkright as TypBindquestionmark1right))::(_,(_,
TYPEleft as TYPE1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCALquestionmark(fn _ => let val 
TypBindquestionmark as TypBindquestionmark1=TypBindquestionmark1 ()
 in (
 TYPEdec(PP TYPEleft
                                     TypBindquestionmarkright, 
                                  TypBindquestionmark) 
) end
)
 in (LrTable.NT 127,(result,TYPE1left,TypBindquestionmark1right),
rest671) end
| (171,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Decquestionmark 
Decquestionmark1,_,_))::_::(_,(MlyValue.DatBind DatBind1,_,_))::(_,(_,
ABSTYPEleft as ABSTYPE1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCALquestionmark(fn _ => let val DatBind as 
DatBind1=DatBind1 ()
val Decquestionmark as Decquestionmark1=Decquestionmark1 ()
 in (
 ABSTYPEdec(PP ABSTYPEleft ENDright, 
                                     DatBind, 
                                     Decquestionmark) 
) end
)
 in (LrTable.NT 127,(result,ABSTYPE1left,END1right),rest671) end
| (172,(_,(MlyValue.TypBindquestionmark TypBindquestionmark1,_,
TypBindquestionmarkright as TypBindquestionmark1right))::(_,(_,
EQTYPEleft as EQTYPE1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCALquestionmark(fn _ => let val 
TypBindquestionmark as TypBindquestionmark1=TypBindquestionmark1 ()
 in (
 EQTYPEdec(PP EQTYPEleft
                                       TypBindquestionmarkright, 
                                    TypBindquestionmark) 
) end
)
 in (LrTable.NT 127,(result,EQTYPE1left,TypBindquestionmark1right),
rest671) end
| (173,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Decquestionmark 
Decquestionmark1,_,Decquestionmarkright))::_::(_,(
MlyValue.TypBindbullet TypBindbullet1,TypBindbulletleft,
TypBindbulletright))::_::(_,(MlyValue.DatBind DatBind1,_,_))::(_,(_,
ABSTYPEleft as ABSTYPE1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCALquestionmark(fn _ => let val DatBind as 
DatBind1=DatBind1 ()
val TypBindbullet as TypBindbullet1=TypBindbullet1 ()
val Decquestionmark as Decquestionmark1=Decquestionmark1 ()
 in (
 let
                            val db = rewriteDatBind(DatBind, TypBindbullet)
                          in
                            ABSTYPEdec(PP ABSTYPEleft ENDright, db,
                                       SEQdec(PP TypBindbulletleft 
                                                 Decquestionmarkright,
                                              TYPEdec(PP TypBindbulletleft
                                                         TypBindbulletright,
                                                      TypBindbullet
                                                     ),
                                              Decquestionmark
                                             )
                                      )
                          end
                        
) end
)
 in (LrTable.NT 127,(result,ABSTYPE1left,END1right),rest671) end
| (174,(_,(MlyValue.FValBindquestionmark FValBindquestionmark1,_,
FValBindquestionmarkright as FValBindquestionmark1right))::(_,(_,
FUNleft as FUN1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCALquestionmark(fn _ => let val 
FValBindquestionmark as FValBindquestionmark1=FValBindquestionmark1 ()
 in (
 UNRES_FUNdec(PP FUNleft
                                          FValBindquestionmarkright, 
                                       FValBindquestionmark) 
) end
)
 in (LrTable.NT 127,(result,FUN1left,FValBindquestionmark1right),
rest671) end
| (175,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Decquestionmark 
Decquestionmark1,_,_))::_::(_,(MlyValue.Decbullet Decbullet1,_,_))::(_
,(_,LOCALleft as LOCAL1left,_))::rest671) => let val result=
MlyValue.OneDecquestionmark(fn _ => let val Decbullet as Decbullet1=
Decbullet1 ()
val Decquestionmark as Decquestionmark1=Decquestionmark1 ()
 in (
 LOCALdec(PP LOCALleft ENDright, 
                                   Decbullet, 
                                   Decquestionmark) 
) end
)
 in (LrTable.NT 128,(result,LOCAL1left,END1right),rest671) end
| (176,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Decbullet 
Decbullet1,_,_))::_::(_,(MlyValue.Decquestionmark Decquestionmark1,_,_
))::(_,(_,LOCALleft as LOCAL1left,_))::rest671) => let val result=
MlyValue.OneDecquestionmark(fn _ => let val Decquestionmark as 
Decquestionmark1=Decquestionmark1 ()
val Decbullet as Decbullet1=Decbullet1 ()
 in (
 LOCALdec(PP LOCALleft ENDright, 
                                   Decquestionmark, 
                                   Decbullet) 
) end
)
 in (LrTable.NT 128,(result,LOCAL1left,END1right),rest671) end
| (177,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Decquestionmark 
Decquestionmark2,_,_))::_::(_,(MlyValue.Decquestionmark 
Decquestionmark1,_,_))::(_,(_,LOCALleft as LOCAL1left,_))::rest671)
 => let val result=MlyValue.OneDecquestionmark(fn _ => let val 
Decquestionmark1=Decquestionmark1 ()
val Decquestionmark2=Decquestionmark2 ()
 in (
 LOCALdec(PP LOCALleft ENDright, 
                                   Decquestionmark1, 
                                   Decquestionmark2) 
) end
)
 in (LrTable.NT 128,(result,LOCAL1left,END1right),rest671) end
| (178,(_,(MlyValue.OneDec_sans_LOCALquestionmark 
OneDec_sans_LOCALquestionmark1,OneDec_sans_LOCALquestionmark1left,
OneDec_sans_LOCALquestionmark1right))::rest671) => let val result=
MlyValue.OneDecquestionmark(fn _ => let val 
OneDec_sans_LOCALquestionmark as OneDec_sans_LOCALquestionmark1=
OneDec_sans_LOCALquestionmark1 ()
 in ( OneDec_sans_LOCALquestionmark ) end
)
 in (LrTable.NT 128,(result,OneDec_sans_LOCALquestionmark1left,
OneDec_sans_LOCALquestionmark1right),rest671) end
| (179,(_,(MlyValue.OneDecquestionmark OneDecquestionmark1,
OneDecquestionmark1left,OneDecquestionmark1right))::rest671) => let 
val result=MlyValue.OneDec_or_SEMICOLONquestionmark(fn _ => let val 
OneDecquestionmark as OneDecquestionmark1=OneDecquestionmark1 ()
 in ( Some OneDecquestionmark ) end
)
 in (LrTable.NT 129,(result,OneDecquestionmark1left,
OneDecquestionmark1right),rest671) end
| (180,(_,(MlyValue.OneDec_or_SEMICOLONquestionmark 
OneDec_or_SEMICOLONquestionmark1,_,
OneDec_or_SEMICOLONquestionmarkright as 
OneDec_or_SEMICOLONquestionmark1right))::(_,(
MlyValue.NonEmptyDecbullet NonEmptyDecbullet1,NonEmptyDecbulletleft
 as NonEmptyDecbullet1left,_))::rest671) => let val result=
MlyValue.NonEmptyDecquestionmark(fn _ => let val NonEmptyDecbullet as 
NonEmptyDecbullet1=NonEmptyDecbullet1 ()
val OneDec_or_SEMICOLONquestionmark as 
OneDec_or_SEMICOLONquestionmark1=OneDec_or_SEMICOLONquestionmark1 ()
 in (
 case OneDec_or_SEMICOLONquestionmark
                            of Some dec =>
                                 composeDec(PP NonEmptyDecbulletleft
                                               OneDec_or_SEMICOLONquestionmarkright,
                                            NonEmptyDecbullet, dec
                                           )

                             | None =>
                                 NonEmptyDecbullet
                        
) end
)
 in (LrTable.NT 130,(result,NonEmptyDecbullet1left,
OneDec_or_SEMICOLONquestionmark1right),rest671) end
| (181,(_,(MlyValue.OneDec_or_SEMICOLONbullet 
OneDec_or_SEMICOLONbullet1,_,OneDec_or_SEMICOLONbulletright as 
OneDec_or_SEMICOLONbullet1right))::(_,(
MlyValue.NonEmptyDecquestionmark NonEmptyDecquestionmark1,
NonEmptyDecquestionmarkleft as NonEmptyDecquestionmark1left,_))::
rest671) => let val result=MlyValue.NonEmptyDecquestionmark(fn _ => 
let val NonEmptyDecquestionmark as NonEmptyDecquestionmark1=
NonEmptyDecquestionmark1 ()
val OneDec_or_SEMICOLONbullet as OneDec_or_SEMICOLONbullet1=
OneDec_or_SEMICOLONbullet1 ()
 in (
 case OneDec_or_SEMICOLONbullet
                            of Some dec =>
                                 composeDec(PP NonEmptyDecquestionmarkleft
                                               OneDec_or_SEMICOLONbulletright,
                                            NonEmptyDecquestionmark, dec
                                           )

                             | None =>
                                 NonEmptyDecquestionmark
                        
) end
)
 in (LrTable.NT 130,(result,NonEmptyDecquestionmark1left,
OneDec_or_SEMICOLONbullet1right),rest671) end
| (182,(_,(MlyValue.OneDec_or_SEMICOLONquestionmark 
OneDec_or_SEMICOLONquestionmark1,_,
OneDec_or_SEMICOLONquestionmarkright as 
OneDec_or_SEMICOLONquestionmark1right))::(_,(
MlyValue.NonEmptyDecquestionmark NonEmptyDecquestionmark1,
NonEmptyDecquestionmarkleft as NonEmptyDecquestionmark1left,_))::
rest671) => let val result=MlyValue.NonEmptyDecquestionmark(fn _ => 
let val NonEmptyDecquestionmark as NonEmptyDecquestionmark1=
NonEmptyDecquestionmark1 ()
val OneDec_or_SEMICOLONquestionmark as 
OneDec_or_SEMICOLONquestionmark1=OneDec_or_SEMICOLONquestionmark1 ()
 in (
 case OneDec_or_SEMICOLONquestionmark
                            of Some dec =>
                                 composeDec(PP NonEmptyDecquestionmarkleft
                                               OneDec_or_SEMICOLONquestionmarkright,
                                            NonEmptyDecquestionmark, dec
                                           )

                             | None =>
                                 NonEmptyDecquestionmark
                        
) end
)
 in (LrTable.NT 130,(result,NonEmptyDecquestionmark1left,
OneDec_or_SEMICOLONquestionmark1right),rest671) end
| (183,(_,(MlyValue.OneDec_or_SEMICOLONquestionmark 
OneDec_or_SEMICOLONquestionmark1,OneDec_or_SEMICOLONquestionmark1left,
OneDec_or_SEMICOLONquestionmark1right))::rest671) => let val result=
MlyValue.NonEmptyDecquestionmark(fn _ => let val 
OneDec_or_SEMICOLONquestionmark as OneDec_or_SEMICOLONquestionmark1=
OneDec_or_SEMICOLONquestionmark1 ()
 in (
 case OneDec_or_SEMICOLONquestionmark
                            of Some dec => dec
                             | None => EMPTYdec(PP defaultPos defaultPos)
                        
) end
)
 in (LrTable.NT 130,(result,OneDec_or_SEMICOLONquestionmark1left,
OneDec_or_SEMICOLONquestionmark1right),rest671) end
| (184,(_,(MlyValue.NonEmptyDecquestionmark NonEmptyDecquestionmark1,
NonEmptyDecquestionmark1left,NonEmptyDecquestionmark1right))::rest671)
 => let val result=MlyValue.Decquestionmark(fn _ => let val 
NonEmptyDecquestionmark as NonEmptyDecquestionmark1=
NonEmptyDecquestionmark1 ()
 in ( NonEmptyDecquestionmark ) end
)
 in (LrTable.NT 131,(result,NonEmptyDecquestionmark1left,
NonEmptyDecquestionmark1right),rest671) end
| (185,(_,(MlyValue.BarMatch_optbullet BarMatch_optbullet1,_,
BarMatch_optbulletright as BarMatch_optbullet1right))::(_,(
MlyValue.MRulequestionmark MRulequestionmark1,MRulequestionmarkleft
 as MRulequestionmark1left,_))::rest671) => let val result=
MlyValue.Match_questionmark(fn _ => let val MRulequestionmark as 
MRulequestionmark1=MRulequestionmark1 ()
val BarMatch_optbullet as BarMatch_optbullet1=BarMatch_optbullet1 ()
 in (
 MATCH(PP MRulequestionmarkleft 
                                   BarMatch_optbulletright,
                                MRulequestionmark, BarMatch_optbullet
                               )
                        
) end
)
 in (LrTable.NT 110,(result,MRulequestionmark1left,
BarMatch_optbullet1right),rest671) end
| (186,(_,(MlyValue.BarMatch_optquestionmark BarMatch_optquestionmark1
,_,BarMatch_optquestionmarkright as BarMatch_optquestionmark1right))::
(_,(MlyValue.MRulebullet MRulebullet1,MRulebulletleft as 
MRulebullet1left,_))::rest671) => let val result=
MlyValue.Match_questionmark(fn _ => let val MRulebullet as 
MRulebullet1=MRulebullet1 ()
val BarMatch_optquestionmark as BarMatch_optquestionmark1=
BarMatch_optquestionmark1 ()
 in (
 MATCH(PP MRulebulletleft 
                                   BarMatch_optquestionmarkright,
                                MRulebullet, BarMatch_optquestionmark
                               )
                        
) end
)
 in (LrTable.NT 110,(result,MRulebullet1left,
BarMatch_optquestionmark1right),rest671) end
| (187,(_,(MlyValue.BarMatch_optquestionmark BarMatch_optquestionmark1
,_,BarMatch_optquestionmarkright as BarMatch_optquestionmark1right))::
(_,(MlyValue.MRulequestionmark MRulequestionmark1,
MRulequestionmarkleft as MRulequestionmark1left,_))::rest671) => let 
val result=MlyValue.Match_questionmark(fn _ => let val 
MRulequestionmark as MRulequestionmark1=MRulequestionmark1 ()
val BarMatch_optquestionmark as BarMatch_optquestionmark1=
BarMatch_optquestionmark1 ()
 in (
 MATCH(PP MRulequestionmarkleft 
                                   BarMatch_optquestionmarkright,
                                MRulequestionmark, BarMatch_optquestionmark
                               )
                        
) end
)
 in (LrTable.NT 110,(result,MRulequestionmark1left,
BarMatch_optquestionmark1right),rest671) end
| (188,(_,(MlyValue.Match_questionmark Match_questionmark1,_,
Match_questionmark1right))::(_,(_,BAR1left,_))::rest671) => let val 
result=MlyValue.BarMatch_optquestionmark(fn _ => let val 
Match_questionmark as Match_questionmark1=Match_questionmark1 ()
 in ( Some Match_questionmark ) end
)
 in (LrTable.NT 111,(result,BAR1left,Match_questionmark1right),rest671
) end
| (189,(_,(MlyValue.Exp_questionmark Exp_questionmark1,_,
Exp_questionmarkright as Exp_questionmark1right))::_::(_,(MlyValue.Pat
 Pat1,Patleft as Pat1left,_))::rest671) => let val result=
MlyValue.MRulequestionmark(fn _ => let val Pat as Pat1=Pat1 ()
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
 in (
 MRULE(PP Patleft Exp_questionmarkright, 
                                Pat, 
                                Exp_questionmark) 
) end
)
 in (LrTable.NT 112,(result,Pat1left,Exp_questionmark1right),rest671)
 end
| (190,(_,(MlyValue.CommaExpRow_optbullet CommaExpRow_optbullet1,_,
CommaExpRow_optbulletright as CommaExpRow_optbullet1right))::(_,(
MlyValue.Exp_questionmark Exp_questionmark1,_,_))::_::(_,(
MlyValue.Label Label1,Labelleft as Label1left,_))::rest671) => let 
val result=MlyValue.ExpRowquestionmark(fn _ => let val Label as Label1
=Label1 ()
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val CommaExpRow_optbullet as CommaExpRow_optbullet1=
CommaExpRow_optbullet1 ()
 in (
 EXPROW(PP Labelleft CommaExpRow_optbulletright,
                                 Label, 
                                 Exp_questionmark, 
                                 CommaExpRow_optbullet
                                )
                        
) end
)
 in (LrTable.NT 116,(result,Label1left,CommaExpRow_optbullet1right),
rest671) end
| (191,(_,(MlyValue.CommaExpRow_optquestionmark 
CommaExpRow_optquestionmark1,_,CommaExpRow_optquestionmarkright as 
CommaExpRow_optquestionmark1right))::(_,(MlyValue.Exp_bullet 
Exp_bullet1,_,_))::_::(_,(MlyValue.Label Label1,Labelleft as 
Label1left,_))::rest671) => let val result=MlyValue.ExpRowquestionmark
(fn _ => let val Label as Label1=Label1 ()
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
val CommaExpRow_optquestionmark as CommaExpRow_optquestionmark1=
CommaExpRow_optquestionmark1 ()
 in (
 EXPROW(PP Labelleft 
                                    CommaExpRow_optquestionmarkright,
                                 Label, 
                                 Exp_bullet, 
                                 CommaExpRow_optquestionmark
                                )
                        
) end
)
 in (LrTable.NT 116,(result,Label1left,
CommaExpRow_optquestionmark1right),rest671) end
| (192,(_,(MlyValue.CommaExpRow_optquestionmark 
CommaExpRow_optquestionmark1,_,CommaExpRow_optquestionmarkright as 
CommaExpRow_optquestionmark1right))::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,_,_))::_::(_,(MlyValue.Label Label1,Labelleft as 
Label1left,_))::rest671) => let val result=MlyValue.ExpRowquestionmark
(fn _ => let val Label as Label1=Label1 ()
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val CommaExpRow_optquestionmark as CommaExpRow_optquestionmark1=
CommaExpRow_optquestionmark1 ()
 in (
 EXPROW(PP Labelleft 
                                    CommaExpRow_optquestionmarkright,
                                 Label, 
                                 Exp_questionmark, 
                                 CommaExpRow_optquestionmark
                                )
                        
) end
)
 in (LrTable.NT 116,(result,Label1left,
CommaExpRow_optquestionmark1right),rest671) end
| (193,(_,(MlyValue.ExpRowquestionmark ExpRowquestionmark1,
ExpRowquestionmark1left,ExpRowquestionmark1right))::rest671) => let 
val result=MlyValue.ExpRow_optquestionmark(fn _ => let val 
ExpRowquestionmark as ExpRowquestionmark1=ExpRowquestionmark1 ()
 in ( Some ExpRowquestionmark ) end
)
 in (LrTable.NT 117,(result,ExpRowquestionmark1left,
ExpRowquestionmark1right),rest671) end
| (194,(_,(MlyValue.ExpRowquestionmark ExpRowquestionmark1,_,
ExpRowquestionmark1right))::(_,(_,COMMA1left,_))::rest671) => let val 
result=MlyValue.CommaExpRow_optquestionmark(fn _ => let val 
ExpRowquestionmark as ExpRowquestionmark1=ExpRowquestionmark1 ()
 in ( Some ExpRowquestionmark ) end
)
 in (LrTable.NT 118,(result,COMMA1left,ExpRowquestionmark1right),
rest671) end
| (195,(_,(MlyValue.ExpComma_seq1questionmark 
ExpComma_seq1questionmark1,ExpComma_seq1questionmark1left,
ExpComma_seq1questionmark1right))::rest671) => let val result=
MlyValue.ExpComma_seq0questionmark(fn _ => let val 
ExpComma_seq1questionmark as ExpComma_seq1questionmark1=
ExpComma_seq1questionmark1 ()
 in ( ExpComma_seq1questionmark ) end
)
 in (LrTable.NT 119,(result,ExpComma_seq1questionmark1left,
ExpComma_seq1questionmark1right),rest671) end
| (196,(_,(MlyValue.ExpComma_seq1bullet ExpComma_seq1bullet1,_,
ExpComma_seq1bullet1right))::_::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,Exp_questionmark1left,_))::rest671) => let val 
result=MlyValue.ExpComma_seq1questionmark(fn _ => let val 
Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val ExpComma_seq1bullet as ExpComma_seq1bullet1=ExpComma_seq1bullet1 
()
 in ( Exp_questionmark :: ExpComma_seq1bullet ) end
)
 in (LrTable.NT 120,(result,Exp_questionmark1left,
ExpComma_seq1bullet1right),rest671) end
| (197,(_,(MlyValue.ExpComma_seq1questionmark 
ExpComma_seq1questionmark1,_,ExpComma_seq1questionmark1right))::_::(_,
(MlyValue.Exp_bullet Exp_bullet1,Exp_bullet1left,_))::rest671) => let 
val result=MlyValue.ExpComma_seq1questionmark(fn _ => let val 
Exp_bullet as Exp_bullet1=Exp_bullet1 ()
val ExpComma_seq1questionmark as ExpComma_seq1questionmark1=
ExpComma_seq1questionmark1 ()
 in ( Exp_bullet :: ExpComma_seq1questionmark ) end
)
 in (LrTable.NT 120,(result,Exp_bullet1left,
ExpComma_seq1questionmark1right),rest671) end
| (198,(_,(MlyValue.ExpComma_seq1questionmark 
ExpComma_seq1questionmark1,_,ExpComma_seq1questionmark1right))::_::(_,
(MlyValue.Exp_questionmark Exp_questionmark1,Exp_questionmark1left,_))
::rest671) => let val result=MlyValue.ExpComma_seq1questionmark(fn _
 => let val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val ExpComma_seq1questionmark as ExpComma_seq1questionmark1=
ExpComma_seq1questionmark1 ()
 in ( Exp_questionmark :: ExpComma_seq1questionmark ) end
)
 in (LrTable.NT 120,(result,Exp_questionmark1left,
ExpComma_seq1questionmark1right),rest671) end
| (199,(_,(MlyValue.Exp_questionmark Exp_questionmark1,
Exp_questionmark1left,Exp_questionmark1right))::rest671) => let val 
result=MlyValue.ExpComma_seq1questionmark(fn _ => let val 
Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
 in ( [Exp_questionmark] ) end
)
 in (LrTable.NT 120,(result,Exp_questionmark1left,
Exp_questionmark1right),rest671) end
| (200,(_,(MlyValue.ExpComma_seq1bullet ExpComma_seq1bullet1,_,
ExpComma_seq1bullet1right))::_::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,Exp_questionmark1left,_))::rest671) => let val 
result=MlyValue.ExpComma_seq2questionmark(fn _ => let val 
Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val ExpComma_seq1bullet as ExpComma_seq1bullet1=ExpComma_seq1bullet1 
()
 in ( Exp_questionmark :: ExpComma_seq1bullet ) end
)
 in (LrTable.NT 121,(result,Exp_questionmark1left,
ExpComma_seq1bullet1right),rest671) end
| (201,(_,(MlyValue.ExpComma_seq1questionmark 
ExpComma_seq1questionmark1,_,ExpComma_seq1questionmark1right))::_::(_,
(MlyValue.Exp_bullet Exp_bullet1,Exp_bullet1left,_))::rest671) => let 
val result=MlyValue.ExpComma_seq2questionmark(fn _ => let val 
Exp_bullet as Exp_bullet1=Exp_bullet1 ()
val ExpComma_seq1questionmark as ExpComma_seq1questionmark1=
ExpComma_seq1questionmark1 ()
 in ( Exp_bullet :: ExpComma_seq1questionmark ) end
)
 in (LrTable.NT 121,(result,Exp_bullet1left,
ExpComma_seq1questionmark1right),rest671) end
| (202,(_,(MlyValue.ExpComma_seq1questionmark 
ExpComma_seq1questionmark1,_,ExpComma_seq1questionmark1right))::_::(_,
(MlyValue.Exp_questionmark Exp_questionmark1,Exp_questionmark1left,_))
::rest671) => let val result=MlyValue.ExpComma_seq2questionmark(fn _
 => let val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val ExpComma_seq1questionmark as ExpComma_seq1questionmark1=
ExpComma_seq1questionmark1 ()
 in ( Exp_questionmark :: ExpComma_seq1questionmark ) end
)
 in (LrTable.NT 121,(result,Exp_questionmark1left,
ExpComma_seq1questionmark1right),rest671) end
| (203,(_,(MlyValue.ExpSemicolon_seq2questionmark 
ExpSemicolon_seq2questionmark1,_,ExpSemicolon_seq2questionmark1right))
::_::(_,(MlyValue.Exp_bullet Exp_bullet1,Exp_bullet1left,_))::rest671)
 => let val result=MlyValue.ExpSemicolon_seq2questionmark(fn _ => let 
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
val ExpSemicolon_seq2questionmark as ExpSemicolon_seq2questionmark1=
ExpSemicolon_seq2questionmark1 ()
 in ( Exp_bullet :: ExpSemicolon_seq2questionmark) end
)
 in (LrTable.NT 122,(result,Exp_bullet1left,
ExpSemicolon_seq2questionmark1right),rest671) end
| (204,(_,(MlyValue.ExpSemicolon_seq2bullet ExpSemicolon_seq2bullet1,_
,ExpSemicolon_seq2bullet1right))::_::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,Exp_questionmark1left,_))::rest671) => let val 
result=MlyValue.ExpSemicolon_seq2questionmark(fn _ => let val 
Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val ExpSemicolon_seq2bullet as ExpSemicolon_seq2bullet1=
ExpSemicolon_seq2bullet1 ()
 in ( Exp_questionmark :: ExpSemicolon_seq2bullet) end
)
 in (LrTable.NT 122,(result,Exp_questionmark1left,
ExpSemicolon_seq2bullet1right),rest671) end
| (205,(_,(MlyValue.ExpSemicolon_seq2questionmark 
ExpSemicolon_seq2questionmark1,_,ExpSemicolon_seq2questionmark1right))
::_::(_,(MlyValue.Exp_questionmark Exp_questionmark1,
Exp_questionmark1left,_))::rest671) => let val result=
MlyValue.ExpSemicolon_seq2questionmark(fn _ => let val 
Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val ExpSemicolon_seq2questionmark as ExpSemicolon_seq2questionmark1=
ExpSemicolon_seq2questionmark1 ()
 in ( Exp_questionmark :: ExpSemicolon_seq2questionmark) end
)
 in (LrTable.NT 122,(result,Exp_questionmark1left,
ExpSemicolon_seq2questionmark1right),rest671) end
| (206,(_,(MlyValue.Exp_questionmark Exp_questionmark1,_,
Exp_questionmark1right))::_::(_,(MlyValue.Exp_bullet Exp_bullet1,
Exp_bullet1left,_))::rest671) => let val result=
MlyValue.ExpSemicolon_seq2questionmark(fn _ => let val Exp_bullet as 
Exp_bullet1=Exp_bullet1 ()
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
 in ( [Exp_bullet, Exp_questionmark] ) end
)
 in (LrTable.NT 122,(result,Exp_bullet1left,Exp_questionmark1right),
rest671) end
| (207,(_,(MlyValue.Exp_bullet Exp_bullet1,_,Exp_bullet1right))::_::(_
,(MlyValue.Exp_questionmark Exp_questionmark1,Exp_questionmark1left,_)
)::rest671) => let val result=MlyValue.ExpSemicolon_seq2questionmark(
fn _ => let val Exp_questionmark as Exp_questionmark1=
Exp_questionmark1 ()
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
 in ( [Exp_questionmark, Exp_bullet] ) end
)
 in (LrTable.NT 122,(result,Exp_questionmark1left,Exp_bullet1right),
rest671) end
| (208,(_,(MlyValue.Exp_questionmark Exp_questionmark2,_,
Exp_questionmark2right))::_::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,Exp_questionmark1left,_))::rest671) => let val 
result=MlyValue.ExpSemicolon_seq2questionmark(fn _ => let val 
Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val Exp_questionmark2=Exp_questionmark2 ()
 in ( [Exp_questionmark, Exp_questionmark] ) end
)
 in (LrTable.NT 122,(result,Exp_questionmark1left,
Exp_questionmark2right),rest671) end
| (209,(_,(_,_,RBRACEright as RBRACE1right))::(_,(
MlyValue.ExpRow_optquestionmark ExpRow_optquestionmark1,_,_))::(_,(_,
LBRACEleft as LBRACE1left,_))::rest671) => let val result=
MlyValue.AtExpquestionmark(fn _ => let val ExpRow_optquestionmark as 
ExpRow_optquestionmark1=ExpRow_optquestionmark1 ()
 in (
 RECORDatexp(PP LBRACEleft RBRACEright, 
                                      ExpRow_optquestionmark) 
) end
)
 in (LrTable.NT 115,(result,LBRACE1left,RBRACE1right),rest671) end
| (210,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,_,_))::_::(_,(MlyValue.Decbullet Decbullet1,_,_))::(
_,(_,LETleft as LET1left,_))::rest671) => let val result=
MlyValue.AtExpquestionmark(fn _ => let val Decbullet as Decbullet1=
Decbullet1 ()
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
 in (
 LETatexp(PP LETleft ENDright, 
                                   Decbullet, 
                                   Exp_questionmark) 
) end
)
 in (LrTable.NT 115,(result,LET1left,END1right),rest671) end
| (211,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Exp_bullet 
Exp_bullet1,_,_))::_::(_,(MlyValue.Decquestionmark Decquestionmark1,_,
_))::(_,(_,LETleft as LET1left,_))::rest671) => let val result=
MlyValue.AtExpquestionmark(fn _ => let val Decquestionmark as 
Decquestionmark1=Decquestionmark1 ()
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
 in (
 LETatexp(PP LETleft ENDright, 
                                   Decquestionmark, 
                                   Exp_bullet) 
) end
)
 in (LrTable.NT 115,(result,LET1left,END1right),rest671) end
| (212,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,_,_))::_::(_,(MlyValue.Decquestionmark 
Decquestionmark1,_,_))::(_,(_,LETleft as LET1left,_))::rest671) => 
let val result=MlyValue.AtExpquestionmark(fn _ => let val 
Decquestionmark as Decquestionmark1=Decquestionmark1 ()
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
 in (
 LETatexp(PP LETleft ENDright, 
                                   Decquestionmark, 
                                   Exp_questionmark) 
) end
)
 in (LrTable.NT 115,(result,LET1left,END1right),rest671) end
| (213,(_,(_,_,RPARENright as RPAREN1right))::(_,(
MlyValue.Exp_questionmark Exp_questionmark1,_,_))::(_,(_,LPARENleft
 as LPAREN1left,_))::rest671) => let val result=
MlyValue.AtExpquestionmark(fn _ => let val Exp_questionmark as 
Exp_questionmark1=Exp_questionmark1 ()
 in (
 PARatexp(PP LPARENleft RPARENright, 
                                   Exp_questionmark) 
) end
)
 in (LrTable.NT 115,(result,LPAREN1left,RPAREN1right),rest671) end
| (214,(_,(_,QUESTIONMARKleft as QUESTIONMARK1left,QUESTIONMARKright
 as QUESTIONMARK1right))::rest671) => let val result=
MlyValue.AtExpquestionmark(fn _ => (
 UNDEFatexp(PP QUESTIONMARKleft QUESTIONMARKright) ))
 in (LrTable.NT 115,(result,QUESTIONMARK1left,QUESTIONMARK1right),
rest671) end
| (215,(_,(_,_,RPAREN1right))::(_,(MlyValue.ExpComma_seq2questionmark 
ExpComma_seq2questionmark1,_,_))::(_,(_,LPAREN1left,_))::rest671) => 
let val result=MlyValue.AtExpquestionmark(fn _ => let val 
ExpComma_seq2questionmark as ExpComma_seq2questionmark1=
ExpComma_seq2questionmark1 ()
 in ( tupleAtExp ExpComma_seq2questionmark ) end
)
 in (LrTable.NT 115,(result,LPAREN1left,RPAREN1right),rest671) end
| (216,(_,(_,_,RPARENright as RPAREN1right))::(_,(
MlyValue.ExpSemicolon_seq2questionmark ExpSemicolon_seq2questionmark1,
_,_))::(_,(_,LPARENleft as LPAREN1left,_))::rest671) => let val result
=MlyValue.AtExpquestionmark(fn _ => let val 
ExpSemicolon_seq2questionmark as ExpSemicolon_seq2questionmark1=
ExpSemicolon_seq2questionmark1 ()
 in (
 PARatexp(PP LPARENleft RPARENright,
                                   sequenceExp ExpSemicolon_seq2questionmark
                                  )
                        
) end
)
 in (LrTable.NT 115,(result,LPAREN1left,RPAREN1right),rest671) end
| (217,(_,(_,_,ENDright as END1right))::(_,(
MlyValue.ExpSemicolon_seq2questionmark ExpSemicolon_seq2questionmark1,
_,_))::_::(_,(MlyValue.Decbullet Decbullet1,_,_))::(_,(_,LETleft as 
LET1left,_))::rest671) => let val result=MlyValue.AtExpquestionmark(
fn _ => let val Decbullet as Decbullet1=Decbullet1 ()
val ExpSemicolon_seq2questionmark as ExpSemicolon_seq2questionmark1=
ExpSemicolon_seq2questionmark1 ()
 in (
 LETatexp(PP LETleft ENDright,
                                   Decbullet, 
                                   sequenceExp ExpSemicolon_seq2questionmark
                                  )
                        
) end
)
 in (LrTable.NT 115,(result,LET1left,END1right),rest671) end
| (218,(_,(_,_,ENDright as END1right))::(_,(
MlyValue.ExpSemicolon_seq2bullet ExpSemicolon_seq2bullet1,_,_))::_::(_
,(MlyValue.Decquestionmark Decquestionmark1,_,_))::(_,(_,LETleft as 
LET1left,_))::rest671) => let val result=MlyValue.AtExpquestionmark(
fn _ => let val Decquestionmark as Decquestionmark1=Decquestionmark1 
()
val ExpSemicolon_seq2bullet as ExpSemicolon_seq2bullet1=
ExpSemicolon_seq2bullet1 ()
 in (
 LETatexp(PP LETleft ENDright,
                                   Decquestionmark, 
                                   sequenceExp ExpSemicolon_seq2bullet
                                  )
                        
) end
)
 in (LrTable.NT 115,(result,LET1left,END1right),rest671) end
| (219,(_,(_,_,ENDright as END1right))::(_,(
MlyValue.ExpSemicolon_seq2questionmark ExpSemicolon_seq2questionmark1,
_,_))::_::(_,(MlyValue.Decquestionmark Decquestionmark1,_,_))::(_,(_,
LETleft as LET1left,_))::rest671) => let val result=
MlyValue.AtExpquestionmark(fn _ => let val Decquestionmark as 
Decquestionmark1=Decquestionmark1 ()
val ExpSemicolon_seq2questionmark as ExpSemicolon_seq2questionmark1=
ExpSemicolon_seq2questionmark1 ()
 in (
 LETatexp(PP LETleft ENDright,
                                   Decquestionmark, 
                                   sequenceExp ExpSemicolon_seq2questionmark
                                  )
                        
) end
)
 in (LrTable.NT 115,(result,LET1left,END1right),rest671) end
| (220,(_,(_,_,RBRACKET1right))::(_,(
MlyValue.ExpComma_seq0questionmark ExpComma_seq0questionmark1,_,_))::(
_,(_,LBRACKET1left,_))::rest671) => let val result=
MlyValue.AtExpquestionmark(fn _ => let val ExpComma_seq0questionmark
 as ExpComma_seq0questionmark1=ExpComma_seq0questionmark1 ()
 in ( listAtExp ExpComma_seq0questionmark ) end
)
 in (LrTable.NT 115,(result,LBRACKET1left,RBRACKET1right),rest671) end
| (221,(_,(MlyValue.AtExp_seq1questionmark AtExp_seq1questionmark1,_,
AtExp_seq1questionmark1right))::(_,(MlyValue.AtExpquestionmark 
AtExpquestionmark1,AtExpquestionmark1left,_))::rest671) => let val 
result=MlyValue.AtExp_seq1questionmark(fn _ => let val 
AtExpquestionmark as AtExpquestionmark1=AtExpquestionmark1 ()
val AtExp_seq1questionmark as AtExp_seq1questionmark1=
AtExp_seq1questionmark1 ()
 in ( AtExpquestionmark :: AtExp_seq1questionmark ) end
)
 in (LrTable.NT 114,(result,AtExpquestionmark1left,
AtExp_seq1questionmark1right),rest671) end
| (222,(_,(MlyValue.AtExp_seq1bullet AtExp_seq1bullet1,_,
AtExp_seq1bullet1right))::(_,(MlyValue.AtExpquestionmark 
AtExpquestionmark1,AtExpquestionmark1left,_))::rest671) => let val 
result=MlyValue.AtExp_seq1questionmark(fn _ => let val 
AtExpquestionmark as AtExpquestionmark1=AtExpquestionmark1 ()
val AtExp_seq1bullet as AtExp_seq1bullet1=AtExp_seq1bullet1 ()
 in ( AtExpquestionmark :: AtExp_seq1bullet ) end
)
 in (LrTable.NT 114,(result,AtExpquestionmark1left,
AtExp_seq1bullet1right),rest671) end
| (223,(_,(MlyValue.AtExp_seq1questionmark AtExp_seq1questionmark1,_,
AtExp_seq1questionmark1right))::(_,(MlyValue.AtExpbullet AtExpbullet1,
AtExpbullet1left,_))::rest671) => let val result=
MlyValue.AtExp_seq1questionmark(fn _ => let val AtExpbullet as 
AtExpbullet1=AtExpbullet1 ()
val AtExp_seq1questionmark as AtExp_seq1questionmark1=
AtExp_seq1questionmark1 ()
 in ( AtExpbullet :: AtExp_seq1questionmark ) end
)
 in (LrTable.NT 114,(result,AtExpbullet1left,
AtExp_seq1questionmark1right),rest671) end
| (224,(_,(MlyValue.AtExpquestionmark AtExpquestionmark1,
AtExpquestionmark1left,AtExpquestionmark1right))::rest671) => let val 
result=MlyValue.AtExp_seq1questionmark(fn _ => let val 
AtExpquestionmark as AtExpquestionmark1=AtExpquestionmark1 ()
 in ( [AtExpquestionmark] ) end
)
 in (LrTable.NT 114,(result,AtExpquestionmark1left,
AtExpquestionmark1right),rest671) end
| (225,(_,(MlyValue.Exp_questionmark Exp_questionmark1,
Exp_questionmark1left,Exp_questionmark1right))::rest671) => let val 
result=MlyValue.Exp_(fn _ => let val Exp_questionmark as 
Exp_questionmark1=Exp_questionmark1 ()
 in ( Exp_questionmark ) end
)
 in (LrTable.NT 56,(result,Exp_questionmark1left,
Exp_questionmark1right),rest671) end
| (226,(_,(MlyValue.Exp_bullet Exp_bullet1,Exp_bullet1left,
Exp_bullet1right))::rest671) => let val result=MlyValue.Exp_(fn _ => 
let val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
 in ( Exp_bullet ) end
)
 in (LrTable.NT 56,(result,Exp_bullet1left,Exp_bullet1right),rest671)
 end
| (227,(_,(MlyValue.OneDec_sans_LOCALquestionmark 
OneDec_sans_LOCALquestionmark1,OneDec_sans_LOCALquestionmark1left,
OneDec_sans_LOCALquestionmark1right))::rest671) => let val result=
MlyValue.OneDec_sans_LOCAL(fn _ => let val 
OneDec_sans_LOCALquestionmark as OneDec_sans_LOCALquestionmark1=
OneDec_sans_LOCALquestionmark1 ()
 in ( OneDec_sans_LOCALquestionmark ) end
)
 in (LrTable.NT 81,(result,OneDec_sans_LOCALquestionmark1left,
OneDec_sans_LOCALquestionmark1right),rest671) end
| (228,(_,(MlyValue.OneDec_sans_LOCALbullet OneDec_sans_LOCALbullet1,
OneDec_sans_LOCALbullet1left,OneDec_sans_LOCALbullet1right))::rest671)
 => let val result=MlyValue.OneDec_sans_LOCAL(fn _ => let val 
OneDec_sans_LOCALbullet as OneDec_sans_LOCALbullet1=
OneDec_sans_LOCALbullet1 ()
 in ( OneDec_sans_LOCALbullet ) end
)
 in (LrTable.NT 81,(result,OneDec_sans_LOCALbullet1left,
OneDec_sans_LOCALbullet1right),rest671) end
| (229,(_,(MlyValue.AtExp_seq1questionmark AtExp_seq1questionmark1,
AtExp_seq1questionmark1left,AtExp_seq1questionmark1right))::rest671)
 => let val result=MlyValue.Exp_questionmark(fn _ => let val 
AtExp_seq1questionmark as AtExp_seq1questionmark1=
AtExp_seq1questionmark1 ()
 in ( UNRES_INFIXexp(i, AtExp_seq1questionmark) ) end
)
 in (LrTable.NT 113,(result,AtExp_seq1questionmark1left,
AtExp_seq1questionmark1right),rest671) end
| (230,(_,(MlyValue.Ty Ty1,_,Tyright as Ty1right))::_::(_,(
MlyValue.Exp_questionmark Exp_questionmark1,Exp_questionmarkleft as 
Exp_questionmark1left,_))::rest671) => let val result=
MlyValue.Exp_questionmark(fn _ => let val Exp_questionmark as 
Exp_questionmark1=Exp_questionmark1 ()
val Ty as Ty1=Ty1 ()
 in (
 TYPEDexp(PP Exp_questionmarkleft Tyright, 
                                   Exp_questionmark, Ty) 
) end
)
 in (LrTable.NT 113,(result,Exp_questionmark1left,Ty1right),rest671)
 end
| (231,(_,(MlyValue.Match_bullet Match_bullet1,_,Match_bulletright as 
Match_bullet1right))::_::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,Exp_questionmarkleft as Exp_questionmark1left,_))::
rest671) => let val result=MlyValue.Exp_questionmark(fn _ => let val 
Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val Match_bullet as Match_bullet1=Match_bullet1 ()
 in (
 HANDLEexp(PP Exp_questionmarkleft Match_bulletright, 
                                    Exp_questionmark, Match_bullet) 
) end
)
 in (LrTable.NT 113,(result,Exp_questionmark1left,Match_bullet1right),
rest671) end
| (232,(_,(MlyValue.Match_questionmark Match_questionmark1,_,
Match_questionmarkright as Match_questionmark1right))::_::(_,(
MlyValue.Exp_bullet Exp_bullet1,Exp_bulletleft as Exp_bullet1left,_))
::rest671) => let val result=MlyValue.Exp_questionmark(fn _ => let 
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
val Match_questionmark as Match_questionmark1=Match_questionmark1 ()
 in (
 HANDLEexp(PP Exp_bulletleft Match_questionmarkright, 
                                    Exp_bullet, Match_questionmark) 
) end
)
 in (LrTable.NT 113,(result,Exp_bullet1left,Match_questionmark1right),
rest671) end
| (233,(_,(MlyValue.Match_questionmark Match_questionmark1,_,
Match_questionmarkright as Match_questionmark1right))::_::(_,(
MlyValue.Exp_questionmark Exp_questionmark1,Exp_questionmarkleft as 
Exp_questionmark1left,_))::rest671) => let val result=
MlyValue.Exp_questionmark(fn _ => let val Exp_questionmark as 
Exp_questionmark1=Exp_questionmark1 ()
val Match_questionmark as Match_questionmark1=Match_questionmark1 ()
 in (
 HANDLEexp(PP Exp_questionmarkleft 
                                       Match_questionmarkright, 
                                    Exp_questionmark, Match_questionmark) 
) end
)
 in (LrTable.NT 113,(result,Exp_questionmark1left,
Match_questionmark1right),rest671) end
| (234,(_,(MlyValue.Exp_questionmark Exp_questionmark1,_,
Exp_questionmarkright as Exp_questionmark1right))::(_,(_,RAISEleft as 
RAISE1left,_))::rest671) => let val result=MlyValue.Exp_questionmark(
fn _ => let val Exp_questionmark as Exp_questionmark1=
Exp_questionmark1 ()
 in (
 RAISEexp(PP RAISEleft Exp_questionmarkright, 
                                   Exp_questionmark) 
) end
)
 in (LrTable.NT 113,(result,RAISE1left,Exp_questionmark1right),rest671
) end
| (235,(_,(MlyValue.Match_questionmark Match_questionmark1,_,
Match_questionmarkright as Match_questionmark1right))::(_,(_,FNleft
 as FN1left,_))::rest671) => let val result=MlyValue.Exp_questionmark(
fn _ => let val Match_questionmark as Match_questionmark1=
Match_questionmark1 ()
 in (
 FNexp(PP FNleft Match_questionmarkright, 
                          Match_questionmark) 
) end
)
 in (LrTable.NT 113,(result,FN1left,Match_questionmark1right),rest671)
 end
| (236,(_,(MlyValue.Match_bullet Match_bullet1,_,Match_bullet1right))
::_::(_,(MlyValue.Exp_questionmark Exp_questionmark1,_,_))::(_,(_,
CASE1left,_))::rest671) => let val result=MlyValue.Exp_questionmark(
fn _ => let val Exp_questionmark as Exp_questionmark1=
Exp_questionmark1 ()
val Match_bullet as Match_bullet1=Match_bullet1 ()
 in ( caseExp(Exp_questionmark, Match_bullet) ) end
)
 in (LrTable.NT 113,(result,CASE1left,Match_bullet1right),rest671) end
| (237,(_,(MlyValue.Match_questionmark Match_questionmark1,_,
Match_questionmark1right))::_::(_,(MlyValue.Exp_bullet Exp_bullet1,_,_
))::(_,(_,CASE1left,_))::rest671) => let val result=
MlyValue.Exp_questionmark(fn _ => let val Exp_bullet as Exp_bullet1=
Exp_bullet1 ()
val Match_questionmark as Match_questionmark1=Match_questionmark1 ()
 in ( caseExp(Exp_bullet, Match_questionmark) ) end
)
 in (LrTable.NT 113,(result,CASE1left,Match_questionmark1right),
rest671) end
| (238,(_,(MlyValue.Match_questionmark Match_questionmark1,_,
Match_questionmark1right))::_::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,_,_))::(_,(_,CASE1left,_))::rest671) => let val 
result=MlyValue.Exp_questionmark(fn _ => let val Exp_questionmark as 
Exp_questionmark1=Exp_questionmark1 ()
val Match_questionmark as Match_questionmark1=Match_questionmark1 ()
 in ( caseExp(Exp_questionmark, Match_questionmark) ) end
)
 in (LrTable.NT 113,(result,CASE1left,Match_questionmark1right),
rest671) end
| (239,(_,(MlyValue.Exp_bullet Exp_bullet2,_,Exp_bullet2right))::_::(_
,(MlyValue.Exp_bullet Exp_bullet1,_,_))::_::(_,(
MlyValue.Exp_questionmark Exp_questionmark1,_,_))::(_,(_,IF1left,_))::
rest671) => let val result=MlyValue.Exp_questionmark(fn _ => let val 
Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val Exp_bullet1=Exp_bullet1 ()
val Exp_bullet2=Exp_bullet2 ()
 in (
 ifThenElse(Exp_questionmark, 
                                     Exp_bullet1, 
                                     Exp_bullet2) 
) end
)
 in (LrTable.NT 113,(result,IF1left,Exp_bullet2right),rest671) end
| (240,(_,(MlyValue.Exp_bullet Exp_bullet1,_,Exp_bullet1right))::_::(_
,(MlyValue.Exp_questionmark Exp_questionmark2,_,_))::_::(_,(
MlyValue.Exp_questionmark Exp_questionmark1,_,_))::(_,(_,IF1left,_))::
rest671) => let val result=MlyValue.Exp_questionmark(fn _ => let val 
Exp_questionmark1=Exp_questionmark1 ()
val Exp_questionmark2=Exp_questionmark2 ()
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
 in (
 ifThenElse(Exp_questionmark1, 
                                     Exp_questionmark2, 
                                     Exp_bullet) 
) end
)
 in (LrTable.NT 113,(result,IF1left,Exp_bullet1right),rest671) end
| (241,(_,(MlyValue.Exp_questionmark Exp_questionmark2,_,
Exp_questionmark2right))::_::(_,(MlyValue.Exp_bullet Exp_bullet1,_,_))
::_::(_,(MlyValue.Exp_questionmark Exp_questionmark1,_,_))::(_,(_,
IF1left,_))::rest671) => let val result=MlyValue.Exp_questionmark(fn _
 => let val Exp_questionmark1=Exp_questionmark1 ()
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
val Exp_questionmark2=Exp_questionmark2 ()
 in (
 ifThenElse(Exp_questionmark1, 
                                     Exp_bullet, 
                                     Exp_questionmark2) 
) end
)
 in (LrTable.NT 113,(result,IF1left,Exp_questionmark2right),rest671)
 end
| (242,(_,(MlyValue.Exp_questionmark Exp_questionmark3,_,
Exp_questionmark3right))::_::(_,(MlyValue.Exp_questionmark 
Exp_questionmark2,_,_))::_::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,_,_))::(_,(_,IF1left,_))::rest671) => let val result
=MlyValue.Exp_questionmark(fn _ => let val Exp_questionmark1=
Exp_questionmark1 ()
val Exp_questionmark2=Exp_questionmark2 ()
val Exp_questionmark3=Exp_questionmark3 ()
 in (
 ifThenElse(Exp_questionmark1, 
                                     Exp_questionmark2, 
                                     Exp_questionmark3) 
) end
)
 in (LrTable.NT 113,(result,IF1left,Exp_questionmark3right),rest671)
 end
| (243,(_,(MlyValue.Exp_bullet Exp_bullet2,_,Exp_bullet2right))::_::(_
,(MlyValue.Exp_questionmark Exp_questionmark1,_,_))::_::(_,(
MlyValue.Exp_bullet Exp_bullet1,_,_))::(_,(_,IF1left,_))::rest671) => 
let val result=MlyValue.Exp_questionmark(fn _ => let val Exp_bullet1=
Exp_bullet1 ()
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val Exp_bullet2=Exp_bullet2 ()
 in (
 ifThenElse(Exp_bullet1, 
                                     Exp_questionmark, 
                                     Exp_bullet2) 
) end
)
 in (LrTable.NT 113,(result,IF1left,Exp_bullet2right),rest671) end
| (244,(_,(MlyValue.Exp_questionmark Exp_questionmark2,_,
Exp_questionmark2right))::_::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,_,_))::_::(_,(MlyValue.Exp_bullet Exp_bullet1,_,_))
::(_,(_,IF1left,_))::rest671) => let val result=
MlyValue.Exp_questionmark(fn _ => let val Exp_bullet as Exp_bullet1=
Exp_bullet1 ()
val Exp_questionmark1=Exp_questionmark1 ()
val Exp_questionmark2=Exp_questionmark2 ()
 in (
 ifThenElse(Exp_bullet, 
                                     Exp_questionmark1, 
                                     Exp_questionmark2) 
) end
)
 in (LrTable.NT 113,(result,IF1left,Exp_questionmark2right),rest671)
 end
| (245,(_,(MlyValue.Exp_questionmark Exp_questionmark1,_,
Exp_questionmark1right))::_::(_,(MlyValue.Exp_bullet Exp_bullet2,_,_))
::_::(_,(MlyValue.Exp_bullet Exp_bullet1,_,_))::(_,(_,IF1left,_))::
rest671) => let val result=MlyValue.Exp_questionmark(fn _ => let val 
Exp_bullet1=Exp_bullet1 ()
val Exp_bullet2=Exp_bullet2 ()
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
 in (
 ifThenElse(Exp_bullet1, 
                                     Exp_bullet2, 
                                     Exp_questionmark) 
) end
)
 in (LrTable.NT 113,(result,IF1left,Exp_questionmark1right),rest671)
 end
| (246,(_,(MlyValue.Exp_questionmark Exp_questionmark1,_,
Exp_questionmark1right))::_::(_,(MlyValue.Exp_bullet Exp_bullet1,
Exp_bullet1left,_))::rest671) => let val result=
MlyValue.Exp_questionmark(fn _ => let val Exp_bullet as Exp_bullet1=
Exp_bullet1 ()
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
 in (
 ifThenElse(Exp_bullet, 
                                     trueExp, 
                                     Exp_questionmark) 
) end
)
 in (LrTable.NT 113,(result,Exp_bullet1left,Exp_questionmark1right),
rest671) end
| (247,(_,(MlyValue.Exp_bullet Exp_bullet1,_,Exp_bullet1right))::_::(_
,(MlyValue.Exp_questionmark Exp_questionmark1,Exp_questionmark1left,_)
)::rest671) => let val result=MlyValue.Exp_questionmark(fn _ => let 
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
 in (
 ifThenElse(Exp_questionmark, 
                                     trueExp, 
                                     Exp_bullet) 
) end
)
 in (LrTable.NT 113,(result,Exp_questionmark1left,Exp_bullet1right),
rest671) end
| (248,(_,(MlyValue.Exp_questionmark Exp_questionmark2,_,
Exp_questionmark2right))::_::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,Exp_questionmark1left,_))::rest671) => let val 
result=MlyValue.Exp_questionmark(fn _ => let val Exp_questionmark1=
Exp_questionmark1 ()
val Exp_questionmark2=Exp_questionmark2 ()
 in (
 ifThenElse(Exp_questionmark1, 
                                     trueExp, 
                                     Exp_questionmark2) 
) end
)
 in (LrTable.NT 113,(result,Exp_questionmark1left,
Exp_questionmark2right),rest671) end
| (249,(_,(MlyValue.Exp_questionmark Exp_questionmark1,_,
Exp_questionmark1right))::_::(_,(MlyValue.Exp_bullet Exp_bullet1,
Exp_bullet1left,_))::rest671) => let val result=
MlyValue.Exp_questionmark(fn _ => let val Exp_bullet as Exp_bullet1=
Exp_bullet1 ()
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
 in (
 ifThenElse(Exp_bullet, 
                                     Exp_questionmark, 
                                     falseExp) 
) end
)
 in (LrTable.NT 113,(result,Exp_bullet1left,Exp_questionmark1right),
rest671) end
| (250,(_,(MlyValue.Exp_bullet Exp_bullet1,_,Exp_bullet1right))::_::(_
,(MlyValue.Exp_questionmark Exp_questionmark1,Exp_questionmark1left,_)
)::rest671) => let val result=MlyValue.Exp_questionmark(fn _ => let 
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
 in (
 ifThenElse(Exp_questionmark, 
                                     Exp_bullet, 
                                     falseExp) 
) end
)
 in (LrTable.NT 113,(result,Exp_questionmark1left,Exp_bullet1right),
rest671) end
| (251,(_,(MlyValue.Exp_questionmark Exp_questionmark2,_,
Exp_questionmark2right))::_::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,Exp_questionmark1left,_))::rest671) => let val 
result=MlyValue.Exp_questionmark(fn _ => let val Exp_questionmark1=
Exp_questionmark1 ()
val Exp_questionmark2=Exp_questionmark2 ()
 in (
 ifThenElse(Exp_questionmark1, 
                                     Exp_questionmark2, 
                                     falseExp) 
) end
)
 in (LrTable.NT 113,(result,Exp_questionmark1left,
Exp_questionmark2right),rest671) end
| (252,(_,(MlyValue.Exp_questionmark Exp_questionmark1,_,
Exp_questionmark1right))::_::(_,(MlyValue.Exp_bullet Exp_bullet1,
Exp_bullet1left,_))::rest671) => let val result=
MlyValue.Exp_questionmark(fn _ => let val Exp_bullet as Exp_bullet1=
Exp_bullet1 ()
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
 in (
 ifThenElse(Exp_bullet, 
                                     Exp_questionmark, 
                                     trueExp) 
) end
)
 in (LrTable.NT 113,(result,Exp_bullet1left,Exp_questionmark1right),
rest671) end
| (253,(_,(MlyValue.Exp_bullet Exp_bullet1,_,Exp_bullet1right))::_::(_
,(MlyValue.Exp_questionmark Exp_questionmark1,Exp_questionmark1left,_)
)::rest671) => let val result=MlyValue.Exp_questionmark(fn _ => let 
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
 in (
 ifThenElse(Exp_questionmark, 
                                     Exp_bullet, 
                                     trueExp) 
) end
)
 in (LrTable.NT 113,(result,Exp_questionmark1left,Exp_bullet1right),
rest671) end
| (254,(_,(MlyValue.Exp_questionmark Exp_questionmark2,_,
Exp_questionmark2right))::_::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,Exp_questionmark1left,_))::rest671) => let val 
result=MlyValue.Exp_questionmark(fn _ => let val Exp_questionmark1=
Exp_questionmark1 ()
val Exp_questionmark2=Exp_questionmark2 ()
 in (
 ifThenElse(Exp_questionmark1, 
                                     Exp_questionmark2, 
                                     trueExp) 
) end
)
 in (LrTable.NT 113,(result,Exp_questionmark1left,
Exp_questionmark2right),rest671) end
| (255,(_,(MlyValue.Exp_questionmark Exp_questionmark1,_,
Exp_questionmark1right))::_::(_,(MlyValue.Exp_bullet Exp_bullet1,
Exp_bullet1left,_))::rest671) => let val result=
MlyValue.Exp_questionmark(fn _ => let val Exp_bullet as Exp_bullet1=
Exp_bullet1 ()
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
 in (
 ifThenElse(Exp_bullet, 
                                     Exp_questionmark, 
                                     notExp(Exp_questionmark)) 
) end
)
 in (LrTable.NT 113,(result,Exp_bullet1left,Exp_questionmark1right),
rest671) end
| (256,(_,(MlyValue.Exp_bullet Exp_bullet1,_,Exp_bullet1right))::_::(_
,(MlyValue.Exp_questionmark Exp_questionmark1,Exp_questionmark1left,_)
)::rest671) => let val result=MlyValue.Exp_questionmark(fn _ => let 
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
 in (
 ifThenElse(Exp_questionmark, 
                                     Exp_bullet, 
                                     notExp(Exp_bullet)) 
) end
)
 in (LrTable.NT 113,(result,Exp_questionmark1left,Exp_bullet1right),
rest671) end
| (257,(_,(MlyValue.Exp_questionmark Exp_questionmark2,_,
Exp_questionmark2right))::_::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,Exp_questionmark1left,_))::rest671) => let val 
result=MlyValue.Exp_questionmark(fn _ => let val Exp_questionmark1=
Exp_questionmark1 ()
val Exp_questionmark2=Exp_questionmark2 ()
 in (
 ifThenElse(Exp_questionmark1, 
                                     Exp_questionmark2, 
                                     notExp(Exp_questionmark2)) 
) end
)
 in (LrTable.NT 113,(result,Exp_questionmark1left,
Exp_questionmark2right),rest671) end
| (258,(_,(MlyValue.Match_questionmark Match_questionmark1,_,
Match_questionmark1right))::_::(_,(MlyValue.Exp_bullet Exp_bullet1,
Exp_bullet1left,_))::rest671) => let val result=
MlyValue.Exp_questionmark(fn _ => let val Exp_bullet as Exp_bullet1=
Exp_bullet1 ()
val Match_questionmark as Match_questionmark1=Match_questionmark1 ()
 in ( raisesExp ( Exp_bullet, Match_questionmark ) ) end
)
 in (LrTable.NT 113,(result,Exp_bullet1left,Match_questionmark1right),
rest671) end
| (259,(_,(MlyValue.Match_bullet Match_bullet1,_,Match_bullet1right))
::_::(_,(MlyValue.Exp_questionmark Exp_questionmark1,
Exp_questionmark1left,_))::rest671) => let val result=
MlyValue.Exp_questionmark(fn _ => let val Exp_questionmark as 
Exp_questionmark1=Exp_questionmark1 ()
val Match_bullet as Match_bullet1=Match_bullet1 ()
 in ( raisesExp ( Exp_questionmark, Match_bullet ) ) end
)
 in (LrTable.NT 113,(result,Exp_questionmark1left,Match_bullet1right),
rest671) end
| (260,(_,(MlyValue.Match_questionmark Match_questionmark1,_,
Match_questionmark1right))::_::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,Exp_questionmark1left,_))::rest671) => let val 
result=MlyValue.Exp_questionmark(fn _ => let val Exp_questionmark as 
Exp_questionmark1=Exp_questionmark1 ()
val Match_questionmark as Match_questionmark1=Match_questionmark1 ()
 in ( raisesExp ( Exp_questionmark, Match_questionmark ) ) end
)
 in (LrTable.NT 113,(result,Exp_questionmark1left,
Match_questionmark1right),rest671) end
| (261,(_,(MlyValue.Pat Pat1,Patleft,Patright as Pat1right))::_::(_,(
MlyValue.Exp_questionmark Exp_questionmark1,Exp_questionmark1left,_))
::rest671) => let val result=MlyValue.Exp_questionmark(fn _ => let 
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val Pat as Pat1=Pat1 ()
 in (
 raisesExp ( Exp_questionmark, 
                                      MATCH(PP Patleft Patright,
                                            MRULE(PP Patleft Patright, 
                                                  Pat, 
                                                  trueExp), 
                                            None))
) end
)
 in (LrTable.NT 113,(result,Exp_questionmark1left,Pat1right),rest671)
 end
| (262,(_,(MlyValue.Exp_questionmark Exp_questionmark1,_,
Exp_questionmark1right))::_::(_,(MlyValue.Exp_bullet Exp_bullet1,_,_))
::(_,(_,WHILE1left,_))::rest671) => let val result=
MlyValue.Exp_questionmark(fn _ => let val Exp_bullet as Exp_bullet1=
Exp_bullet1 ()
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
 in ( whileExp(Exp_bullet, Exp_questionmark) ) end
)
 in (LrTable.NT 113,(result,WHILE1left,Exp_questionmark1right),rest671
) end
| (263,(_,(MlyValue.Exp_bullet Exp_bullet1,_,Exp_bullet1right))::_::(_
,(MlyValue.Exp_questionmark Exp_questionmark1,_,_))::(_,(_,WHILE1left,
_))::rest671) => let val result=MlyValue.Exp_questionmark(fn _ => let 
val Exp_questionmark as Exp_questionmark1=Exp_questionmark1 ()
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
 in ( whileExp(Exp_questionmark, Exp_bullet) ) end
)
 in (LrTable.NT 113,(result,WHILE1left,Exp_bullet1right),rest671) end
| (264,(_,(MlyValue.Exp_questionmark Exp_questionmark2,_,
Exp_questionmark2right))::_::(_,(MlyValue.Exp_questionmark 
Exp_questionmark1,_,_))::(_,(_,WHILE1left,_))::rest671) => let val 
result=MlyValue.Exp_questionmark(fn _ => let val Exp_questionmark1=
Exp_questionmark1 ()
val Exp_questionmark2=Exp_questionmark2 ()
 in ( whileExp(Exp_questionmark1, Exp_questionmark2) ) end
)
 in (LrTable.NT 113,(result,WHILE1left,Exp_questionmark2right),rest671
) end
| (265,(_,(MlyValue.BarMatch_optbullet BarMatch_optbullet1,_,
BarMatch_optbulletright as BarMatch_optbullet1right))::(_,(
MlyValue.MRulebullet MRulebullet1,MRulebulletleft as MRulebullet1left,
_))::rest671) => let val result=MlyValue.Match_bullet(fn _ => let val 
MRulebullet as MRulebullet1=MRulebullet1 ()
val BarMatch_optbullet as BarMatch_optbullet1=BarMatch_optbullet1 ()
 in (
 MATCH(PP MRulebulletleft BarMatch_optbulletright,
                                MRulebullet, BarMatch_optbullet
                               )
                         
) end
)
 in (LrTable.NT 104,(result,MRulebullet1left,BarMatch_optbullet1right)
,rest671) end
| (266,(_,(MlyValue.Match_bullet Match_bullet1,_,Match_bullet1right))
::(_,(_,BAR1left,_))::rest671) => let val result=
MlyValue.BarMatch_optbullet(fn _ => let val Match_bullet as 
Match_bullet1=Match_bullet1 ()
 in ( Some Match_bullet ) end
)
 in (LrTable.NT 82,(result,BAR1left,Match_bullet1right),rest671) end
| (267,rest671) => let val result=MlyValue.BarMatch_optbullet(fn _ => 
( None ))
 in (LrTable.NT 82,(result,defaultPos,defaultPos),rest671) end
| (268,(_,(MlyValue.Exp_bullet Exp_bullet1,_,Exp_bulletright as 
Exp_bullet1right))::_::(_,(MlyValue.Pat Pat1,Patleft as Pat1left,_))::
rest671) => let val result=MlyValue.MRulebullet(fn _ => let val Pat
 as Pat1=Pat1 ()
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
 in ( MRULE(PP Patleft Exp_bulletright, Pat, Exp_bullet) ) end
)
 in (LrTable.NT 83,(result,Pat1left,Exp_bullet1right),rest671) end
| (269,(_,(MlyValue.AndValBind_optbullet AndValBind_optbullet1,_,
AndValBind_optbulletright as AndValBind_optbullet1right))::(_,(
MlyValue.Exp_bullet Exp_bullet1,_,_))::_::(_,(MlyValue.Pat Pat1,
Patleft as Pat1left,_))::rest671) => let val result=
MlyValue.ValBindbullet(fn _ => let val Pat as Pat1=Pat1 ()
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
val AndValBind_optbullet as AndValBind_optbullet1=
AndValBind_optbullet1 ()
 in (
 PLAINvalbind(PP Patleft AndValBind_optbulletright,
                                       Pat, Exp_bullet, AndValBind_optbullet
                                      )
                        
) end
)
 in (LrTable.NT 84,(result,Pat1left,AndValBind_optbullet1right),
rest671) end
| (270,(_,(MlyValue.FnValBindbullet FnValBindbullet1,_,
FnValBindbulletright as FnValBindbullet1right))::(_,(_,RECleft as 
REC1left,_))::rest671) => let val result=MlyValue.ValBindbullet(fn _
 => let val FnValBindbullet as FnValBindbullet1=FnValBindbullet1 ()
 in (
 RECvalbind(PP RECleft FnValBindbulletright, 
                                     FnValBindbullet) 
) end
)
 in (LrTable.NT 84,(result,REC1left,FnValBindbullet1right),rest671)
 end
| (271,(_,(MlyValue.ValBindbullet ValBindbullet1,_,ValBindbullet1right
))::(_,(_,AND1left,_))::rest671) => let val result=
MlyValue.AndValBind_optbullet(fn _ => let val ValBindbullet as 
ValBindbullet1=ValBindbullet1 ()
 in ( Some ValBindbullet ) end
)
 in (LrTable.NT 85,(result,AND1left,ValBindbullet1right),rest671) end
| (272,rest671) => let val result=MlyValue.AndValBind_optbullet(fn _
 => ( None ))
 in (LrTable.NT 85,(result,defaultPos,defaultPos),rest671) end
| (273,(_,(MlyValue.AndFValBind_optbullet AndFValBind_optbullet1,_,
AndFValBind_optbulletright as AndFValBind_optbullet1right))::(_,(
MlyValue.FClausebullet FClausebullet1,FClausebulletleft as 
FClausebullet1left,_))::rest671) => let val result=
MlyValue.FValBindbullet(fn _ => let val FClausebullet as 
FClausebullet1=FClausebullet1 ()
val AndFValBind_optbullet as AndFValBind_optbullet1=
AndFValBind_optbullet1 ()
 in (
 FVALBIND(PP FClausebulletleft AndFValBind_optbulletright,
                                   FClausebullet, AndFValBind_optbullet
                                  )
                        
) end
)
 in (LrTable.NT 105,(result,FClausebullet1left,
AndFValBind_optbullet1right),rest671) end
| (274,(_,(MlyValue.FValBindbullet FValBindbullet1,_,
FValBindbullet1right))::(_,(_,AND1left,_))::rest671) => let val result
=MlyValue.AndFValBind_optbullet(fn _ => let val FValBindbullet as 
FValBindbullet1=FValBindbullet1 ()
 in ( Some FValBindbullet ) end
)
 in (LrTable.NT 106,(result,AND1left,FValBindbullet1right),rest671)
 end
| (275,rest671) => let val result=MlyValue.AndFValBind_optbullet(fn _
 => ( None ))
 in (LrTable.NT 106,(result,defaultPos,defaultPos),rest671) end
| (276,(_,(MlyValue.BarFClause_optbullet BarFClause_optbullet1,_,
BarFClause_optbulletright as BarFClause_optbullet1right))::(_,(
MlyValue.Exp_bullet Exp_bullet1,_,_))::_::(_,(MlyValue.ColonTy_opt 
ColonTy_opt1,_,_))::(_,(MlyValue.AtPat_seq1 AtPat_seq11,AtPat_seq1left
 as AtPat_seq11left,_))::rest671) => let val result=
MlyValue.FClausebullet(fn _ => let val AtPat_seq1 as AtPat_seq11=
AtPat_seq11 ()
val ColonTy_opt as ColonTy_opt1=ColonTy_opt1 ()
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
val BarFClause_optbullet as BarFClause_optbullet1=
BarFClause_optbullet1 ()
 in (
 FCLAUSE(PP AtPat_seq1left BarFClause_optbulletright,
                                  AtPat_seq1, ColonTy_opt,
                                  Exp_bullet, BarFClause_optbullet
                                 )
                        
) end
)
 in (LrTable.NT 107,(result,AtPat_seq11left,BarFClause_optbullet1right
),rest671) end
| (277,(_,(MlyValue.FClausebullet FClausebullet1,_,FClausebullet1right
))::(_,(_,BAR1left,_))::rest671) => let val result=
MlyValue.BarFClause_optbullet(fn _ => let val FClausebullet as 
FClausebullet1=FClausebullet1 ()
 in ( Some FClausebullet ) end
)
 in (LrTable.NT 108,(result,BAR1left,FClausebullet1right),rest671) end
| (278,rest671) => let val result=MlyValue.BarFClause_optbullet(fn _
 => ( None ))
 in (LrTable.NT 108,(result,defaultPos,defaultPos),rest671) end
| (279,(_,(MlyValue.FnValBindbullet FnValBindbullet1,_,
FnValBindbullet1right))::(_,(_,AND1left,_))::rest671) => let val 
result=MlyValue.AndFnValBind_optbullet(fn _ => let val FnValBindbullet
 as FnValBindbullet1=FnValBindbullet1 ()
 in ( Some FnValBindbullet ) end
)
 in (LrTable.NT 86,(result,AND1left,FnValBindbullet1right),rest671)
 end
| (280,rest671) => let val result=MlyValue.AndFnValBind_optbullet(fn _
 => ( None ))
 in (LrTable.NT 86,(result,defaultPos,defaultPos),rest671) end
| (281,(_,(MlyValue.AndFnValBind_optbullet AndFnValBind_optbullet1,_,
AndFnValBind_optbulletright as AndFnValBind_optbullet1right))::(_,(
MlyValue.Match_bullet Match_bullet1,_,Match_bulletright))::(_,(_,
FNleft,_))::_::(_,(MlyValue.Pat Pat1,Patleft as Pat1left,_))::rest671)
 => let val result=MlyValue.FnValBindbullet(fn _ => let val Pat as 
Pat1=Pat1 ()
val Match_bullet as Match_bullet1=Match_bullet1 ()
val AndFnValBind_optbullet as AndFnValBind_optbullet1=
AndFnValBind_optbullet1 ()
 in (
 PLAINvalbind(PP Patleft AndFnValBind_optbulletright,
                                       Pat,
                                       FNexp(PP FNleft Match_bulletright, Match_bullet),
                                       AndFnValBind_optbullet
                                      )
                        
) end
)
 in (LrTable.NT 87,(result,Pat1left,AndFnValBind_optbullet1right),
rest671) end
| (282,(_,(MlyValue.AndFnValBind_optbullet AndFnValBind_optbullet1,_,
AndFnValBind_optbulletright as AndFnValBind_optbullet1right))::(_,(
MlyValue.ColonTy_seq1 ColonTy_seq11,_,_))::(_,(_,_,RPARENright))::(_,(
MlyValue.Match_bullet Match_bullet1,_,Match_bulletright))::(_,(_,
FNleft,_))::(_,(_,LPARENleft,_))::_::(_,(MlyValue.Pat Pat1,Patleft as 
Pat1left,_))::rest671) => let val result=MlyValue.FnValBindbullet(fn _
 => let val Pat as Pat1=Pat1 ()
val Match_bullet as Match_bullet1=Match_bullet1 ()
val ColonTy_seq1 as ColonTy_seq11=ColonTy_seq11 ()
val AndFnValBind_optbullet as AndFnValBind_optbullet1=
AndFnValBind_optbullet1 ()
 in (
 let
                            val fnExp = FNexp(PP FNleft Match_bulletright, Match_bullet)

                            val parAtexp =
                              PARatexp(PP LPARENleft RPARENright, fnExp)

                            val atexpExp =
                              ATEXPexp(PP LPARENleft RPARENright, parAtexp)

                            fun attachTypes(e, nil) = e
                              | attachTypes(e, (ty, p) :: rest) =
                                  attachTypes(TYPEDexp(PP FNleft p, e, ty),
                                              rest
                                             )
                          in
                            PLAINvalbind(PP Patleft AndFnValBind_optbulletright,
                                         Pat,
                                         attachTypes(atexpExp, ColonTy_seq1),
                                         AndFnValBind_optbullet
                                        )
                          end
                        
) end
)
 in (LrTable.NT 87,(result,Pat1left,AndFnValBind_optbullet1right),
rest671) end
| (283,(_,(MlyValue.FnValBindbullet FnValBindbullet1,_,
FnValBindbulletright as FnValBindbullet1right))::(_,(_,RECleft as 
REC1left,_))::rest671) => let val result=MlyValue.FnValBindbullet(fn _
 => let val FnValBindbullet as FnValBindbullet1=FnValBindbullet1 ()
 in ( RECvalbind(PP RECleft FnValBindbulletright, FnValBindbullet) )
 end
)
 in (LrTable.NT 87,(result,REC1left,FnValBindbullet1right),rest671)
 end
| (284,(_,(MlyValue.AndTypBind_optbullet AndTypBind_optbullet1,_,
AndTypBind_optbulletright as AndTypBind_optbullet1right))::(_,(
MlyValue.Ty Ty1,_,_))::_::(_,(MlyValue.TypeIdent TypeIdent1,_,_))::(_,
(MlyValue.TyVarSeq TyVarSeq1,TyVarSeqleft as TyVarSeq1left,_))::
rest671) => let val result=MlyValue.TypBindbullet(fn _ => let val 
TyVarSeq as TyVarSeq1=TyVarSeq1 ()
val TypeIdent as TypeIdent1=TypeIdent1 ()
val Ty as Ty1=Ty1 ()
val AndTypBind_optbullet as AndTypBind_optbullet1=
AndTypBind_optbullet1 ()
 in (
 TYPBIND(PP TyVarSeqleft AndTypBind_optbulletright,
                                  TyVarSeq, mk_TyCon TypeIdent,
                                  Ty, AndTypBind_optbullet
                                 )
                        
) end
)
 in (LrTable.NT 109,(result,TyVarSeq1left,AndTypBind_optbullet1right),
rest671) end
| (285,(_,(MlyValue.TypBindbullet TypBindbullet1,_,TypBindbullet1right
))::(_,(_,AND1left,_))::rest671) => let val result=
MlyValue.AndTypBind_optbullet(fn _ => let val TypBindbullet as 
TypBindbullet1=TypBindbullet1 ()
 in ( Some TypBindbullet ) end
)
 in (LrTable.NT 88,(result,AND1left,TypBindbullet1right),rest671) end
| (286,rest671) => let val result=MlyValue.AndTypBind_optbullet(fn _
 => ( None ))
 in (LrTable.NT 88,(result,defaultPos,defaultPos),rest671) end
| (287,(_,(MlyValue.ValBindbullet ValBindbullet1,_,ValBindbulletright
 as ValBindbullet1right))::(_,(_,VALleft as VAL1left,_))::rest671) => 
let val result=MlyValue.OneDec_sans_LOCALbullet(fn _ => let val 
ValBindbullet as ValBindbullet1=ValBindbullet1 ()
 in ( VALdec(PP VALleft ValBindbulletright, ValBindbullet) ) end
)
 in (LrTable.NT 89,(result,VAL1left,ValBindbullet1right),rest671) end
| (288,(_,(MlyValue.TypBindbullet TypBindbullet1,_,TypBindbulletright
 as TypBindbullet1right))::(_,(_,TYPEleft as TYPE1left,_))::rest671)
 => let val result=MlyValue.OneDec_sans_LOCALbullet(fn _ => let val 
TypBindbullet as TypBindbullet1=TypBindbullet1 ()
 in (
 TYPEdec(PP TYPEleft 
                                             TypBindbulletright, 
                                          TypBindbullet) 
) end
)
 in (LrTable.NT 89,(result,TYPE1left,TypBindbullet1right),rest671) end
| (289,(_,(MlyValue.DatBind DatBind1,_,DatBindright as DatBind1right))
::(_,(_,DATATYPEleft as DATATYPE1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCALbullet(fn _ => let val DatBind as DatBind1=
DatBind1 ()
 in ( DATATYPEdec(PP DATATYPEleft DatBindright, DatBind) ) end
)
 in (LrTable.NT 89,(result,DATATYPE1left,DatBind1right),rest671) end
| (290,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Decbullet 
Decbullet1,_,_))::_::(_,(MlyValue.DatBind DatBind1,_,_))::(_,(_,
ABSTYPEleft as ABSTYPE1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCALbullet(fn _ => let val DatBind as DatBind1=
DatBind1 ()
val Decbullet as Decbullet1=Decbullet1 ()
 in ( ABSTYPEdec(PP ABSTYPEleft ENDright, DatBind, Decbullet) ) end
)
 in (LrTable.NT 89,(result,ABSTYPE1left,END1right),rest671) end
| (291,(_,(MlyValue.TypBindbullet TypBindbullet1,_,TypBindbulletright
 as TypBindbullet1right))::(_,(_,EQTYPEleft as EQTYPE1left,_))::
rest671) => let val result=MlyValue.OneDec_sans_LOCALbullet(fn _ => 
let val TypBindbullet as TypBindbullet1=TypBindbullet1 ()
 in (
 EQTYPEdec(PP EQTYPEleft 
                                               TypBindbulletright,
                                            TypBindbullet) 
) end
)
 in (LrTable.NT 89,(result,EQTYPE1left,TypBindbullet1right),rest671)
 end
| (292,(_,(MlyValue.ExBind ExBind1,_,ExBindright as ExBind1right))::(_
,(_,EXCEPTIONleft as EXCEPTION1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCALbullet(fn _ => let val ExBind as ExBind1=
ExBind1 ()
 in ( EXCEPTIONdec(PP EXCEPTIONleft ExBindright, ExBind) ) end
)
 in (LrTable.NT 89,(result,EXCEPTION1left,ExBind1right),rest671) end
| (293,(_,(MlyValue.LongIdent_seq1 LongIdent_seq11,_,
LongIdent_seq1right as LongIdent_seq11right))::(_,(_,OPENleft as 
OPEN1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCALbullet(fn _ => let val LongIdent_seq1 as 
LongIdent_seq11=LongIdent_seq11 ()
 in (
 OPENdec(PP OPENleft LongIdent_seq1right,
                                  wi_Convert mk_LongStrId LongIdent_seq1
                                 )
                        
) end
)
 in (LrTable.NT 89,(result,OPEN1left,LongIdent_seq11right),rest671)
 end
| (294,(_,(MlyValue.EqIdent_seq1 EqIdent_seq11,_,EqIdent_seq1right as 
EqIdent_seq11right))::(_,(MlyValue.DIGIT_opt DIGIT_opt1,_,_))::(_,(_,
INFIXleft as INFIX1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCALbullet(fn _ => let val DIGIT_opt as 
DIGIT_opt1=DIGIT_opt1 ()
val EqIdent_seq1 as EqIdent_seq11=EqIdent_seq11 ()
 in (
 INFIXdec(PP INFIXleft EqIdent_seq1right,
                                   DIGIT_opt, map mk_Id EqIdent_seq1
                                  )
                        
) end
)
 in (LrTable.NT 89,(result,INFIX1left,EqIdent_seq11right),rest671) end
| (295,(_,(MlyValue.EqIdent_seq1 EqIdent_seq11,_,EqIdent_seq1right as 
EqIdent_seq11right))::(_,(MlyValue.DIGIT_opt DIGIT_opt1,_,_))::(_,(_,
INFIXRleft as INFIXR1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCALbullet(fn _ => let val DIGIT_opt as 
DIGIT_opt1=DIGIT_opt1 ()
val EqIdent_seq1 as EqIdent_seq11=EqIdent_seq11 ()
 in (
 INFIXRdec(PP INFIXRleft EqIdent_seq1right,
                                    DIGIT_opt, map mk_Id EqIdent_seq1
                                   )
                        
) end
)
 in (LrTable.NT 89,(result,INFIXR1left,EqIdent_seq11right),rest671)
 end
| (296,(_,(MlyValue.EqIdent_seq1 EqIdent_seq11,_,EqIdent_seq1right as 
EqIdent_seq11right))::(_,(_,NONFIXleft as NONFIX1left,_))::rest671)
 => let val result=MlyValue.OneDec_sans_LOCALbullet(fn _ => let val 
EqIdent_seq1 as EqIdent_seq11=EqIdent_seq11 ()
 in (
 NONFIXdec(PP NONFIXleft EqIdent_seq1right,
                                    map mk_Id EqIdent_seq1
                                   )
                        
) end
)
 in (LrTable.NT 89,(result,NONFIX1left,EqIdent_seq11right),rest671)
 end
| (297,(_,(MlyValue.TypBindbullet TypBindbullet1,TypBindbulletleft,
TypBindbulletright as TypBindbullet1right))::_::(_,(MlyValue.DatBind 
DatBind1,DatBindleft,DatBindright))::(_,(_,DATATYPEleft as 
DATATYPE1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCALbullet(fn _ => let val DatBind as DatBind1=
DatBind1 ()
val TypBindbullet as TypBindbullet1=TypBindbullet1 ()
 in (
 let
                            val db = rewriteDatBind(DatBind, TypBindbullet)
                          in
                            SEQdec(PP DATATYPEleft TypBindbulletright,
                                   DATATYPEdec(PP DatBindleft DatBindright, db),
                                   TYPEdec(PP TypBindbulletleft 
                                              TypBindbulletright, 
                                           TypBindbullet)
                                  )
                          end
                        
) end
)
 in (LrTable.NT 89,(result,DATATYPE1left,TypBindbullet1right),rest671)
 end
| (298,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Decbullet 
Decbullet1,_,Decbulletright))::_::(_,(MlyValue.TypBindbullet 
TypBindbullet1,TypBindbulletleft,TypBindbulletright))::_::(_,(
MlyValue.DatBind DatBind1,_,_))::(_,(_,ABSTYPEleft as ABSTYPE1left,_))
::rest671) => let val result=MlyValue.OneDec_sans_LOCALbullet(fn _ => 
let val DatBind as DatBind1=DatBind1 ()
val TypBindbullet as TypBindbullet1=TypBindbullet1 ()
val Decbullet as Decbullet1=Decbullet1 ()
 in (
 let
                            val db = rewriteDatBind(DatBind, TypBindbullet)
                          in
                            ABSTYPEdec(PP ABSTYPEleft ENDright, db,
                                       SEQdec(PP TypBindbulletleft Decbulletright,
                                              TYPEdec(PP TypBindbulletleft
                                                         TypBindbulletright,
                                                      TypBindbullet
                                                     ),
                                              Decbullet
                                             )
                                      )
                          end
                        
) end
)
 in (LrTable.NT 89,(result,ABSTYPE1left,END1right),rest671) end
| (299,(_,(MlyValue.FValBindbullet FValBindbullet1,_,
FValBindbulletright as FValBindbullet1right))::(_,(_,FUNleft as 
FUN1left,_))::rest671) => let val result=
MlyValue.OneDec_sans_LOCALbullet(fn _ => let val FValBindbullet as 
FValBindbullet1=FValBindbullet1 ()
 in ( UNRES_FUNdec(PP FUNleft FValBindbulletright, FValBindbullet) )
 end
)
 in (LrTable.NT 89,(result,FUN1left,FValBindbullet1right),rest671) end
| (300,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Decbullet 
Decbullet2,_,_))::_::(_,(MlyValue.Decbullet Decbullet1,_,_))::(_,(_,
LOCALleft as LOCAL1left,_))::rest671) => let val result=
MlyValue.OneDecbullet(fn _ => let val Decbullet1=Decbullet1 ()
val Decbullet2=Decbullet2 ()
 in ( LOCALdec(PP LOCALleft ENDright, Decbullet1, Decbullet2) ) end
)
 in (LrTable.NT 90,(result,LOCAL1left,END1right),rest671) end
| (301,(_,(MlyValue.OneDec_sans_LOCALbullet OneDec_sans_LOCALbullet1,
OneDec_sans_LOCALbullet1left,OneDec_sans_LOCALbullet1right))::rest671)
 => let val result=MlyValue.OneDecbullet(fn _ => let val 
OneDec_sans_LOCALbullet as OneDec_sans_LOCALbullet1=
OneDec_sans_LOCALbullet1 ()
 in ( OneDec_sans_LOCALbullet ) end
)
 in (LrTable.NT 90,(result,OneDec_sans_LOCALbullet1left,
OneDec_sans_LOCALbullet1right),rest671) end
| (302,(_,(MlyValue.OneDecbullet OneDecbullet1,OneDecbullet1left,
OneDecbullet1right))::rest671) => let val result=
MlyValue.OneDec_or_SEMICOLONbullet(fn _ => let val OneDecbullet as 
OneDecbullet1=OneDecbullet1 ()
 in ( Some OneDecbullet ) end
)
 in (LrTable.NT 91,(result,OneDecbullet1left,OneDecbullet1right),
rest671) end
| (303,(_,(_,SEMICOLON1left,SEMICOLON1right))::rest671) => let val 
result=MlyValue.OneDec_or_SEMICOLONbullet(fn _ => ( None ))
 in (LrTable.NT 91,(result,SEMICOLON1left,SEMICOLON1right),rest671)
 end
| (304,(_,(MlyValue.OneDec_or_SEMICOLONbullet 
OneDec_or_SEMICOLONbullet1,_,OneDec_or_SEMICOLONbulletright as 
OneDec_or_SEMICOLONbullet1right))::(_,(MlyValue.NonEmptyDecbullet 
NonEmptyDecbullet1,NonEmptyDecbulletleft as NonEmptyDecbullet1left,_))
::rest671) => let val result=MlyValue.NonEmptyDecbullet(fn _ => let 
val NonEmptyDecbullet as NonEmptyDecbullet1=NonEmptyDecbullet1 ()
val OneDec_or_SEMICOLONbullet as OneDec_or_SEMICOLONbullet1=
OneDec_or_SEMICOLONbullet1 ()
 in (
 case OneDec_or_SEMICOLONbullet
                            of Some dec =>
                                 composeDec(PP NonEmptyDecbulletleft
                                               OneDec_or_SEMICOLONbulletright,
                                            NonEmptyDecbullet, dec
                                           )

                             | None =>
                                 NonEmptyDecbullet
                        
) end
)
 in (LrTable.NT 92,(result,NonEmptyDecbullet1left,
OneDec_or_SEMICOLONbullet1right),rest671) end
| (305,(_,(MlyValue.OneDec_or_SEMICOLONbullet 
OneDec_or_SEMICOLONbullet1,OneDec_or_SEMICOLONbullet1left,
OneDec_or_SEMICOLONbullet1right))::rest671) => let val result=
MlyValue.NonEmptyDecbullet(fn _ => let val OneDec_or_SEMICOLONbullet
 as OneDec_or_SEMICOLONbullet1=OneDec_or_SEMICOLONbullet1 ()
 in (
 case OneDec_or_SEMICOLONbullet
                            of Some dec => dec
                             | None => EMPTYdec(PP defaultPos defaultPos)
                        
) end
)
 in (LrTable.NT 92,(result,OneDec_or_SEMICOLONbullet1left,
OneDec_or_SEMICOLONbullet1right),rest671) end
| (306,(_,(MlyValue.NonEmptyDecbullet NonEmptyDecbullet1,
NonEmptyDecbullet1left,NonEmptyDecbullet1right))::rest671) => let val 
result=MlyValue.Decbullet(fn _ => let val NonEmptyDecbullet as 
NonEmptyDecbullet1=NonEmptyDecbullet1 ()
 in ( NonEmptyDecbullet ) end
)
 in (LrTable.NT 93,(result,NonEmptyDecbullet1left,
NonEmptyDecbullet1right),rest671) end
| (307,rest671) => let val result=MlyValue.Decbullet(fn _ => (
 EMPTYdec(PP defaultPos defaultPos) ))
 in (LrTable.NT 93,(result,defaultPos,defaultPos),rest671) end
| (308,(_,(MlyValue.AtExp_seq1bullet AtExp_seq1bullet1,_,
AtExp_seq1bullet1right))::(_,(MlyValue.AtExpbullet AtExpbullet1,
AtExpbullet1left,_))::rest671) => let val result=
MlyValue.AtExp_seq1bullet(fn _ => let val AtExpbullet as AtExpbullet1=
AtExpbullet1 ()
val AtExp_seq1bullet as AtExp_seq1bullet1=AtExp_seq1bullet1 ()
 in ( AtExpbullet :: AtExp_seq1bullet ) end
)
 in (LrTable.NT 95,(result,AtExpbullet1left,AtExp_seq1bullet1right),
rest671) end
| (309,(_,(MlyValue.AtExpbullet AtExpbullet1,AtExpbullet1left,
AtExpbullet1right))::rest671) => let val result=
MlyValue.AtExp_seq1bullet(fn _ => let val AtExpbullet as AtExpbullet1=
AtExpbullet1 ()
 in ( [AtExpbullet] ) end
)
 in (LrTable.NT 95,(result,AtExpbullet1left,AtExpbullet1right),rest671
) end
| (310,(_,(MlyValue.CommaExpRow_optbullet CommaExpRow_optbullet1,_,
CommaExpRow_optbulletright as CommaExpRow_optbullet1right))::(_,(
MlyValue.Exp_bullet Exp_bullet1,_,_))::_::(_,(MlyValue.Label Label1,
Labelleft as Label1left,_))::rest671) => let val result=
MlyValue.ExpRowbullet(fn _ => let val Label as Label1=Label1 ()
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
val CommaExpRow_optbullet as CommaExpRow_optbullet1=
CommaExpRow_optbullet1 ()
 in (
 EXPROW(PP Labelleft CommaExpRow_optbulletright,
                                 Label, Exp_bullet, CommaExpRow_optbullet
                                )
                        
) end
)
 in (LrTable.NT 96,(result,Label1left,CommaExpRow_optbullet1right),
rest671) end
| (311,(_,(MlyValue.ExpRowbullet ExpRowbullet1,ExpRowbullet1left,
ExpRowbullet1right))::rest671) => let val result=
MlyValue.ExpRow_optbullet(fn _ => let val ExpRowbullet as 
ExpRowbullet1=ExpRowbullet1 ()
 in ( Some ExpRowbullet ) end
)
 in (LrTable.NT 97,(result,ExpRowbullet1left,ExpRowbullet1right),
rest671) end
| (312,rest671) => let val result=MlyValue.ExpRow_optbullet(fn _ => (
 None ))
 in (LrTable.NT 97,(result,defaultPos,defaultPos),rest671) end
| (313,(_,(MlyValue.ExpRowbullet ExpRowbullet1,_,ExpRowbullet1right))
::(_,(_,COMMA1left,_))::rest671) => let val result=
MlyValue.CommaExpRow_optbullet(fn _ => let val ExpRowbullet as 
ExpRowbullet1=ExpRowbullet1 ()
 in ( Some ExpRowbullet ) end
)
 in (LrTable.NT 98,(result,COMMA1left,ExpRowbullet1right),rest671) end
| (314,rest671) => let val result=MlyValue.CommaExpRow_optbullet(fn _
 => ( None ))
 in (LrTable.NT 98,(result,defaultPos,defaultPos),rest671) end
| (315,(_,(MlyValue.ExpComma_seq1bullet ExpComma_seq1bullet1,
ExpComma_seq1bullet1left,ExpComma_seq1bullet1right))::rest671) => let 
val result=MlyValue.ExpComma_seq0bullet(fn _ => let val 
ExpComma_seq1bullet as ExpComma_seq1bullet1=ExpComma_seq1bullet1 ()
 in ( ExpComma_seq1bullet ) end
)
 in (LrTable.NT 99,(result,ExpComma_seq1bullet1left,
ExpComma_seq1bullet1right),rest671) end
| (316,rest671) => let val result=MlyValue.ExpComma_seq0bullet(fn _
 => ( nil ))
 in (LrTable.NT 99,(result,defaultPos,defaultPos),rest671) end
| (317,(_,(MlyValue.ExpComma_seq1bullet ExpComma_seq1bullet1,_,
ExpComma_seq1bullet1right))::_::(_,(MlyValue.Exp_bullet Exp_bullet1,
Exp_bullet1left,_))::rest671) => let val result=
MlyValue.ExpComma_seq1bullet(fn _ => let val Exp_bullet as Exp_bullet1
=Exp_bullet1 ()
val ExpComma_seq1bullet as ExpComma_seq1bullet1=ExpComma_seq1bullet1 
()
 in ( Exp_bullet :: ExpComma_seq1bullet ) end
)
 in (LrTable.NT 100,(result,Exp_bullet1left,ExpComma_seq1bullet1right)
,rest671) end
| (318,(_,(MlyValue.Exp_bullet Exp_bullet1,Exp_bullet1left,
Exp_bullet1right))::rest671) => let val result=
MlyValue.ExpComma_seq1bullet(fn _ => let val Exp_bullet as Exp_bullet1
=Exp_bullet1 ()
 in ( [Exp_bullet] ) end
)
 in (LrTable.NT 100,(result,Exp_bullet1left,Exp_bullet1right),rest671)
 end
| (319,(_,(MlyValue.ExpComma_seq1bullet ExpComma_seq1bullet1,_,
ExpComma_seq1bullet1right))::_::(_,(MlyValue.Exp_bullet Exp_bullet1,
Exp_bullet1left,_))::rest671) => let val result=
MlyValue.ExpComma_seq2bullet(fn _ => let val Exp_bullet as Exp_bullet1
=Exp_bullet1 ()
val ExpComma_seq1bullet as ExpComma_seq1bullet1=ExpComma_seq1bullet1 
()
 in ( Exp_bullet :: ExpComma_seq1bullet ) end
)
 in (LrTable.NT 101,(result,Exp_bullet1left,ExpComma_seq1bullet1right)
,rest671) end
| (320,(_,(MlyValue.ExpSemicolon_seq2bullet ExpSemicolon_seq2bullet1,_
,ExpSemicolon_seq2bullet1right))::_::(_,(MlyValue.Exp_bullet 
Exp_bullet1,Exp_bullet1left,_))::rest671) => let val result=
MlyValue.ExpSemicolon_seq2bullet(fn _ => let val Exp_bullet as 
Exp_bullet1=Exp_bullet1 ()
val ExpSemicolon_seq2bullet as ExpSemicolon_seq2bullet1=
ExpSemicolon_seq2bullet1 ()
 in ( Exp_bullet :: ExpSemicolon_seq2bullet) end
)
 in (LrTable.NT 102,(result,Exp_bullet1left,
ExpSemicolon_seq2bullet1right),rest671) end
| (321,(_,(MlyValue.Exp_bullet Exp_bullet2,_,Exp_bullet2right))::_::(_
,(MlyValue.Exp_bullet Exp_bullet1,Exp_bullet1left,_))::rest671) => 
let val result=MlyValue.ExpSemicolon_seq2bullet(fn _ => let val 
Exp_bullet1=Exp_bullet1 ()
val Exp_bullet2=Exp_bullet2 ()
 in ( [Exp_bullet1, Exp_bullet2] ) end
)
 in (LrTable.NT 102,(result,Exp_bullet1left,Exp_bullet2right),rest671)
 end
| (322,(_,(MlyValue.AtExp_seq1bullet AtExp_seq1bullet1,
AtExp_seq1bullet1left,AtExp_seq1bullet1right))::rest671) => let val 
result=MlyValue.Exp_bullet(fn _ => let val AtExp_seq1bullet as 
AtExp_seq1bullet1=AtExp_seq1bullet1 ()
 in ( UNRES_INFIXexp(i, AtExp_seq1bullet) ) end
)
 in (LrTable.NT 103,(result,AtExp_seq1bullet1left,
AtExp_seq1bullet1right),rest671) end
| (323,(_,(MlyValue.Ty Ty1,_,Tyright as Ty1right))::_::(_,(
MlyValue.Exp_bullet Exp_bullet1,Exp_bulletleft as Exp_bullet1left,_))
::rest671) => let val result=MlyValue.Exp_bullet(fn _ => let val 
Exp_bullet as Exp_bullet1=Exp_bullet1 ()
val Ty as Ty1=Ty1 ()
 in ( TYPEDexp(PP Exp_bulletleft Tyright, Exp_bullet, Ty) ) end
)
 in (LrTable.NT 103,(result,Exp_bullet1left,Ty1right),rest671) end
| (324,(_,(MlyValue.Match_bullet Match_bullet1,_,Match_bulletright as 
Match_bullet1right))::_::(_,(MlyValue.Exp_bullet Exp_bullet1,
Exp_bulletleft as Exp_bullet1left,_))::rest671) => let val result=
MlyValue.Exp_bullet(fn _ => let val Exp_bullet as Exp_bullet1=
Exp_bullet1 ()
val Match_bullet as Match_bullet1=Match_bullet1 ()
 in (
 HANDLEexp(PP Exp_bulletleft Match_bulletright, 
                          Exp_bullet, Match_bullet)
) end
)
 in (LrTable.NT 103,(result,Exp_bullet1left,Match_bullet1right),
rest671) end
| (325,(_,(MlyValue.Exp_bullet Exp_bullet1,_,Exp_bulletright as 
Exp_bullet1right))::(_,(_,RAISEleft as RAISE1left,_))::rest671) => 
let val result=MlyValue.Exp_bullet(fn _ => let val Exp_bullet as 
Exp_bullet1=Exp_bullet1 ()
 in (
 RAISEexp(PP RAISEleft 
                            Exp_bulletright, 
                         Exp_bullet)
) end
)
 in (LrTable.NT 103,(result,RAISE1left,Exp_bullet1right),rest671) end
| (326,(_,(MlyValue.Match_bullet Match_bullet1,_,Match_bulletright as 
Match_bullet1right))::(_,(_,FNleft as FN1left,_))::rest671) => let 
val result=MlyValue.Exp_bullet(fn _ => let val Match_bullet as 
Match_bullet1=Match_bullet1 ()
 in (
 FNexp(PP FNleft Match_bulletright, 
                      Match_bullet) 
) end
)
 in (LrTable.NT 103,(result,FN1left,Match_bullet1right),rest671) end
| (327,(_,(MlyValue.Match_bullet Match_bullet1,_,Match_bulletright as 
Match_bullet1right))::(_,(_,EXISTSleft as EXISTS1left,_))::rest671)
 => let val result=MlyValue.Exp_bullet(fn _ => let val Match_bullet
 as Match_bullet1=Match_bullet1 ()
 in (
 EXIST_QUANTexp(PP EXISTSleft Match_bulletright, 
                               Match_bullet) 
) end
)
 in (LrTable.NT 103,(result,EXISTS1left,Match_bullet1right),rest671)
 end
| (328,(_,(MlyValue.Match_bullet Match_bullet1,_,Match_bulletright as 
Match_bullet1right))::(_,(_,FORALLleft as FORALL1left,_))::rest671)
 => let val result=MlyValue.Exp_bullet(fn _ => let val Match_bullet
 as Match_bullet1=Match_bullet1 ()
 in (
 UNIV_QUANTexp(PP FORALLleft Match_bulletright, 
                               Match_bullet) 
) end
)
 in (LrTable.NT 103,(result,FORALL1left,Match_bullet1right),rest671)
 end
| (329,(_,(_,_,TERMINATESright as TERMINATES1right))::(_,(
MlyValue.Exp_bullet Exp_bullet1,Exp_bulletleft as Exp_bullet1left,_))
::rest671) => let val result=MlyValue.Exp_bullet(fn _ => let val 
Exp_bullet as Exp_bullet1=Exp_bullet1 ()
 in (
 CONVERexp(PP Exp_bulletleft TERMINATESright, 
                          Exp_bullet ) 
) end
)
 in (LrTable.NT 103,(result,Exp_bullet1left,TERMINATES1right),rest671)
 end
| (330,(_,(MlyValue.Exp_bullet Exp_bullet2,_,Exp_bullet2right))::_::(_
,(MlyValue.Exp_bullet Exp_bullet1,Exp_bullet1left,_))::rest671) => 
let val result=MlyValue.Exp_bullet(fn _ => let val Exp_bullet1=
Exp_bullet1 ()
val Exp_bullet2=Exp_bullet2 ()
 in (
 COMPARexp(PP Exp_bullet1left Exp_bullet2right, 
                          Exp_bullet1, Exp_bullet2) 
) end
)
 in (LrTable.NT 103,(result,Exp_bullet1left,Exp_bullet2right),rest671)
 end
| (331,(_,(MlyValue.Match_bullet Match_bullet1,_,Match_bullet1right))
::_::(_,(MlyValue.Exp_bullet Exp_bullet1,_,_))::(_,(_,CASE1left,_))::
rest671) => let val result=MlyValue.Exp_bullet(fn _ => let val 
Exp_bullet as Exp_bullet1=Exp_bullet1 ()
val Match_bullet as Match_bullet1=Match_bullet1 ()
 in ( caseExp(Exp_bullet, Match_bullet) ) end
)
 in (LrTable.NT 103,(result,CASE1left,Match_bullet1right),rest671) end
| (332,(_,(MlyValue.Exp_bullet Exp_bullet3,_,Exp_bullet3right))::_::(_
,(MlyValue.Exp_bullet Exp_bullet2,_,_))::_::(_,(MlyValue.Exp_bullet 
Exp_bullet1,_,_))::(_,(_,IF1left,_))::rest671) => let val result=
MlyValue.Exp_bullet(fn _ => let val Exp_bullet1=Exp_bullet1 ()
val Exp_bullet2=Exp_bullet2 ()
val Exp_bullet3=Exp_bullet3 ()
 in ( ifThenElse(Exp_bullet1, Exp_bullet2, Exp_bullet3) ) end
)
 in (LrTable.NT 103,(result,IF1left,Exp_bullet3right),rest671) end
| (333,(_,(MlyValue.Exp_bullet Exp_bullet2,_,Exp_bullet2right))::_::(_
,(MlyValue.Exp_bullet Exp_bullet1,Exp_bullet1left,_))::rest671) => 
let val result=MlyValue.Exp_bullet(fn _ => let val Exp_bullet1=
Exp_bullet1 ()
val Exp_bullet2=Exp_bullet2 ()
 in ( ifThenElse(Exp_bullet1, trueExp, Exp_bullet2) ) end
)
 in (LrTable.NT 103,(result,Exp_bullet1left,Exp_bullet2right),rest671)
 end
| (334,(_,(MlyValue.Exp_bullet Exp_bullet2,_,Exp_bullet2right))::_::(_
,(MlyValue.Exp_bullet Exp_bullet1,Exp_bullet1left,_))::rest671) => 
let val result=MlyValue.Exp_bullet(fn _ => let val Exp_bullet1=
Exp_bullet1 ()
val Exp_bullet2=Exp_bullet2 ()
 in ( ifThenElse(Exp_bullet1, Exp_bullet2, falseExp) ) end
)
 in (LrTable.NT 103,(result,Exp_bullet1left,Exp_bullet2right),rest671)
 end
| (335,(_,(MlyValue.Exp_bullet Exp_bullet2,_,Exp_bullet2right))::_::(_
,(MlyValue.Exp_bullet Exp_bullet1,Exp_bullet1left,_))::rest671) => 
let val result=MlyValue.Exp_bullet(fn _ => let val Exp_bullet1=
Exp_bullet1 ()
val Exp_bullet2=Exp_bullet2 ()
 in (
 ifThenElse(Exp_bullet1, Exp_bullet2,
                           trueExp) 
) end
)
 in (LrTable.NT 103,(result,Exp_bullet1left,Exp_bullet2right),rest671)
 end
| (336,(_,(MlyValue.Exp_bullet Exp_bullet2,_,Exp_bullet2right))::_::(_
,(MlyValue.Exp_bullet Exp_bullet1,Exp_bullet1left,_))::rest671) => 
let val result=MlyValue.Exp_bullet(fn _ => let val Exp_bullet1=
Exp_bullet1 ()
val Exp_bullet2=Exp_bullet2 ()
 in (
 ifThenElse(Exp_bullet1, Exp_bullet2,
                           notExp(Exp_bullet2)) 
) end
)
 in (LrTable.NT 103,(result,Exp_bullet1left,Exp_bullet2right),rest671)
 end
| (337,(_,(_,_,PROPER1right))::(_,(MlyValue.Exp_bullet Exp_bullet1,
Exp_bullet1left,_))::rest671) => let val result=MlyValue.Exp_bullet(
fn _ => let val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
 in ( properExp ( Exp_bullet ) ) end
)
 in (LrTable.NT 103,(result,Exp_bullet1left,PROPER1right),rest671) end
| (338,(_,(MlyValue.Match_bullet Match_bullet1,_,Match_bullet1right))
::_::(_,(MlyValue.Exp_bullet Exp_bullet1,Exp_bullet1left,_))::rest671)
 => let val result=MlyValue.Exp_bullet(fn _ => let val Exp_bullet as 
Exp_bullet1=Exp_bullet1 ()
val Match_bullet as Match_bullet1=Match_bullet1 ()
 in ( raisesExp ( Exp_bullet, Match_bullet ) ) end
)
 in (LrTable.NT 103,(result,Exp_bullet1left,Match_bullet1right),
rest671) end
| (339,(_,(MlyValue.Pat Pat1,Patleft,Patright as Pat1right))::_::(_,(
MlyValue.Exp_bullet Exp_bullet1,Exp_bullet1left,_))::rest671) => let 
val result=MlyValue.Exp_bullet(fn _ => let val Exp_bullet as 
Exp_bullet1=Exp_bullet1 ()
val Pat as Pat1=Pat1 ()
 in (
 raisesExp ( Exp_bullet, 
                            MATCH(PP Patleft Patright,
                            MRULE(PP Patleft Patright, Pat, trueExp), 
                            None))
) end
)
 in (LrTable.NT 103,(result,Exp_bullet1left,Pat1right),rest671) end
| (340,(_,(MlyValue.Exp_bullet Exp_bullet2,_,Exp_bullet2right))::_::(_
,(MlyValue.Exp_bullet Exp_bullet1,Exp_bullet1left,_))::rest671) => 
let val result=MlyValue.Exp_bullet(fn _ => let val Exp_bullet1=
Exp_bullet1 ()
val Exp_bullet2=Exp_bullet2 ()
 in (
 ifThenElse( (COMPARexp(PP Exp_bullet1left
                                          Exp_bullet2right, 
                                       Exp_bullet1, Exp_bullet2)),
                            falseExp, trueExp)
) end
)
 in (LrTable.NT 103,(result,Exp_bullet1left,Exp_bullet2right),rest671)
 end
| (341,(_,(MlyValue.Exp_bullet Exp_bullet2,_,Exp_bullet2right))::_::(_
,(MlyValue.Exp_bullet Exp_bullet1,_,_))::(_,(_,WHILE1left,_))::rest671
) => let val result=MlyValue.Exp_bullet(fn _ => let val Exp_bullet1=
Exp_bullet1 ()
val Exp_bullet2=Exp_bullet2 ()
 in ( whileExp(Exp_bullet1, Exp_bullet2) ) end
)
 in (LrTable.NT 103,(result,WHILE1left,Exp_bullet2right),rest671) end
| (342,(_,(MlyValue.SCon SCon1,SConleft as SCon1left,SConright as 
SCon1right))::rest671) => let val result=MlyValue.AtExpbullet(fn _ => 
let val SCon as SCon1=SCon1 ()
 in ( SCONatexp(PP SConleft SConright, SCon) ) end
)
 in (LrTable.NT 94,(result,SCon1left,SCon1right),rest671) end
| (343,(_,(MlyValue.LongOpEqIdent LongOpEqIdent1,LongOpEqIdentleft as 
LongOpEqIdent1left,LongOpEqIdentright as LongOpEqIdent1right))::
rest671) => let val result=MlyValue.AtExpbullet(fn _ => let val 
LongOpEqIdent as LongOpEqIdent1=LongOpEqIdent1 ()
 in (
 let
                            val OP_OPT(id, withOp) = LongOpEqIdent
                          in
                            IDENTatexp(PP LongOpEqIdentleft LongOpEqIdentright,
                                       OP_OPT(mk_LongId id, withOp)
                                      )
                          end
                        
) end
)
 in (LrTable.NT 94,(result,LongOpEqIdent1left,LongOpEqIdent1right),
rest671) end
| (344,(_,(_,_,RBRACEright as RBRACE1right))::(_,(
MlyValue.ExpRow_optbullet ExpRow_optbullet1,_,_))::(_,(_,LBRACEleft
 as LBRACE1left,_))::rest671) => let val result=MlyValue.AtExpbullet(
fn _ => let val ExpRow_optbullet as ExpRow_optbullet1=
ExpRow_optbullet1 ()
 in (
 RECORDatexp(PP LBRACEleft 
                                         RBRACEright, 
                                      ExpRow_optbullet) 
) end
)
 in (LrTable.NT 94,(result,LBRACE1left,RBRACE1right),rest671) end
| (345,(_,(_,_,ENDright as END1right))::(_,(MlyValue.Exp_bullet 
Exp_bullet1,_,_))::_::(_,(MlyValue.Decbullet Decbullet1,_,_))::(_,(_,
LETleft as LET1left,_))::rest671) => let val result=
MlyValue.AtExpbullet(fn _ => let val Decbullet as Decbullet1=
Decbullet1 ()
val Exp_bullet as Exp_bullet1=Exp_bullet1 ()
 in (
 LETatexp(PP LETleft 
                                      ENDright, 
                                      Decbullet, 
                                   Exp_bullet)
) end
)
 in (LrTable.NT 94,(result,LET1left,END1right),rest671) end
| (346,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.Exp_bullet 
Exp_bullet1,_,_))::(_,(_,LPARENleft as LPAREN1left,_))::rest671) => 
let val result=MlyValue.AtExpbullet(fn _ => let val Exp_bullet as 
Exp_bullet1=Exp_bullet1 ()
 in ( PARatexp(PP LPARENleft RPARENright, Exp_bullet) ) end
)
 in (LrTable.NT 94,(result,LPAREN1left,RPAREN1right),rest671) end
| (347,(_,(_,_,RPARENright as RPAREN1right))::(_,(_,LPARENleft as 
LPAREN1left,_))::rest671) => let val result=MlyValue.AtExpbullet(fn _
 => (
 RECORDatexp(PP LPARENleft
                                                 RPARENright, None) 
))
 in (LrTable.NT 94,(result,LPAREN1left,RPAREN1right),rest671) end
| (348,(_,(_,_,RPAREN1right))::(_,(MlyValue.ExpComma_seq2bullet 
ExpComma_seq2bullet1,_,_))::(_,(_,LPAREN1left,_))::rest671) => let 
val result=MlyValue.AtExpbullet(fn _ => let val ExpComma_seq2bullet
 as ExpComma_seq2bullet1=ExpComma_seq2bullet1 ()
 in ( tupleAtExp ExpComma_seq2bullet ) end
)
 in (LrTable.NT 94,(result,LPAREN1left,RPAREN1right),rest671) end
| (349,(_,(MlyValue.Label Label1,_,Label1right))::(_,(_,HASH1left,_))
::rest671) => let val result=MlyValue.AtExpbullet(fn _ => let val 
Label as Label1=Label1 ()
 in ( hash Label ) end
)
 in (LrTable.NT 94,(result,HASH1left,Label1right),rest671) end
| (350,(_,(_,_,RPARENright as RPAREN1right))::(_,(
MlyValue.ExpSemicolon_seq2bullet ExpSemicolon_seq2bullet1,_,_))::(_,(_
,LPARENleft as LPAREN1left,_))::rest671) => let val result=
MlyValue.AtExpbullet(fn _ => let val ExpSemicolon_seq2bullet as 
ExpSemicolon_seq2bullet1=ExpSemicolon_seq2bullet1 ()
 in (
 PARatexp(PP LPARENleft RPARENright,
                                   sequenceExp ExpSemicolon_seq2bullet)
) end
)
 in (LrTable.NT 94,(result,LPAREN1left,RPAREN1right),rest671) end
| (351,(_,(_,_,ENDright as END1right))::(_,(
MlyValue.ExpSemicolon_seq2bullet ExpSemicolon_seq2bullet1,_,_))::_::(_
,(MlyValue.Decbullet Decbullet1,_,_))::(_,(_,LETleft as LET1left,_))::
rest671) => let val result=MlyValue.AtExpbullet(fn _ => let val 
Decbullet as Decbullet1=Decbullet1 ()
val ExpSemicolon_seq2bullet as ExpSemicolon_seq2bullet1=
ExpSemicolon_seq2bullet1 ()
 in (
 LETatexp(PP LETleft ENDright,
                                   Decbullet, 
                                   sequenceExp ExpSemicolon_seq2bullet)
) end
)
 in (LrTable.NT 94,(result,LET1left,END1right),rest671) end
| (352,(_,(_,_,RBRACKET1right))::(_,(MlyValue.ExpComma_seq0bullet 
ExpComma_seq0bullet1,_,_))::(_,(_,LBRACKET1left,_))::rest671) => let 
val result=MlyValue.AtExpbullet(fn _ => let val ExpComma_seq0bullet
 as ExpComma_seq0bullet1=ExpComma_seq0bullet1 ()
 in ( listAtExp ExpComma_seq0bullet ) end
)
 in (LrTable.NT 94,(result,LBRACKET1left,RBRACKET1right),rest671) end
| (353,(_,(MlyValue.ColonTy_seq1 ColonTy_seq11,_,ColonTy_seq11right))
::(_,(MlyValue.Ty Ty1,_,Tyright))::(_,(_,COLON1left,_))::rest671) => 
let val result=MlyValue.ColonTy_seq1(fn _ => let val Ty as Ty1=Ty1 ()
val ColonTy_seq1 as ColonTy_seq11=ColonTy_seq11 ()
 in ( (Ty, Tyright) :: ColonTy_seq1 ) end
)
 in (LrTable.NT 64,(result,COLON1left,ColonTy_seq11right),rest671) end
| (354,(_,(MlyValue.Ty Ty1,_,Tyright as Ty1right))::(_,(_,COLON1left,_
))::rest671) => let val result=MlyValue.ColonTy_seq1(fn _ => let val 
Ty as Ty1=Ty1 ()
 in ( [(Ty, Tyright)] ) end
)
 in (LrTable.NT 64,(result,COLON1left,Ty1right),rest671) end
| (355,(_,(MlyValue.AndDatBind_opt AndDatBind_opt1,_,
AndDatBind_optright as AndDatBind_opt1right))::(_,(MlyValue.ConBind 
ConBind1,_,_))::_::(_,(MlyValue.TypeIdent TypeIdent1,_,_))::(_,(
MlyValue.TyVarSeq TyVarSeq1,TyVarSeqleft as TyVarSeq1left,_))::rest671
) => let val result=MlyValue.DatBind(fn _ => let val TyVarSeq as 
TyVarSeq1=TyVarSeq1 ()
val TypeIdent as TypeIdent1=TypeIdent1 ()
val ConBind as ConBind1=ConBind1 ()
val AndDatBind_opt as AndDatBind_opt1=AndDatBind_opt1 ()
 in (
 DATBIND(PP TyVarSeqleft AndDatBind_optright,
                                  TyVarSeq, mk_TyCon TypeIdent,
                                  ConBind, AndDatBind_opt
                                 )
                        
) end
)
 in (LrTable.NT 55,(result,TyVarSeq1left,AndDatBind_opt1right),rest671
) end
| (356,(_,(MlyValue.DatBind DatBind1,_,DatBind1right))::(_,(_,AND1left
,_))::rest671) => let val result=MlyValue.AndDatBind_opt(fn _ => let 
val DatBind as DatBind1=DatBind1 ()
 in ( Some DatBind ) end
)
 in (LrTable.NT 57,(result,AND1left,DatBind1right),rest671) end
| (357,rest671) => let val result=MlyValue.AndDatBind_opt(fn _ => (
 None ))
 in (LrTable.NT 57,(result,defaultPos,defaultPos),rest671) end
| (358,(_,(MlyValue.BarConBind_opt BarConBind_opt1,_,
BarConBind_optright as BarConBind_opt1right))::(_,(MlyValue.OfTy_opt 
OfTy_opt1,_,_))::(_,(MlyValue.OpIdent OpIdent1,OpIdentleft as 
OpIdent1left,_))::rest671) => let val result=MlyValue.ConBind(fn _ => 
let val OpIdent as OpIdent1=OpIdent1 ()
val OfTy_opt as OfTy_opt1=OfTy_opt1 ()
val BarConBind_opt as BarConBind_opt1=BarConBind_opt1 ()
 in (
 let
                            val OP_OPT(id, withOp) = OpIdent
                          in
                            CONBIND(PP OpIdentleft BarConBind_optright,
                                    OP_OPT(mk_Con id, withOp),
                                    OfTy_opt, BarConBind_opt
                                   )
                          end
                        
) end
)
 in (LrTable.NT 54,(result,OpIdent1left,BarConBind_opt1right),rest671)
 end
| (359,(_,(MlyValue.ConBind ConBind1,_,ConBind1right))::(_,(_,BAR1left
,_))::rest671) => let val result=MlyValue.BarConBind_opt(fn _ => let 
val ConBind as ConBind1=ConBind1 ()
 in ( Some ConBind ) end
)
 in (LrTable.NT 58,(result,BAR1left,ConBind1right),rest671) end
| (360,rest671) => let val result=MlyValue.BarConBind_opt(fn _ => (
 None ))
 in (LrTable.NT 58,(result,defaultPos,defaultPos),rest671) end
| (361,(_,(MlyValue.AndExBind_opt AndExBind_opt1,_,AndExBind_optright
 as AndExBind_opt1right))::(_,(MlyValue.OfTy_opt OfTy_opt1,_,_))::(_,(
MlyValue.OpIdent OpIdent1,OpIdentleft as OpIdent1left,_))::rest671)
 => let val result=MlyValue.ExBind(fn _ => let val OpIdent as OpIdent1
=OpIdent1 ()
val OfTy_opt as OfTy_opt1=OfTy_opt1 ()
val AndExBind_opt as AndExBind_opt1=AndExBind_opt1 ()
 in (
 let
                            val OP_OPT(id, withOp) = OpIdent
                          in
                            EXBIND(PP OpIdentleft AndExBind_optright,
                                   OP_OPT(mk_ExCon id, withOp),
                                   OfTy_opt, AndExBind_opt
                                  )
                          end
                        
) end
)
 in (LrTable.NT 53,(result,OpIdent1left,AndExBind_opt1right),rest671)
 end
| (362,(_,(MlyValue.AndExBind_opt AndExBind_opt1,_,AndExBind_optright
 as AndExBind_opt1right))::(_,(MlyValue.LongOpEqIdent LongOpEqIdent1,_
,_))::_::(_,(MlyValue.OpIdent OpIdent1,OpIdentleft as OpIdent1left,_))
::rest671) => let val result=MlyValue.ExBind(fn _ => let val OpIdent
 as OpIdent1=OpIdent1 ()
val LongOpEqIdent as LongOpEqIdent1=LongOpEqIdent1 ()
val AndExBind_opt as AndExBind_opt1=AndExBind_opt1 ()
 in (
 let
                            val OP_OPT(id1, withOp1) = OpIdent
                            val OP_OPT(id2, withOp2) = LongOpEqIdent
                          in
                            EXEQUAL(PP OpIdentleft AndExBind_optright,
                                    OP_OPT(mk_ExCon id1, withOp1),
                                    OP_OPT(mk_LongId id2, withOp2),
                                    AndExBind_opt
                                   )
                          end
                        
) end
)
 in (LrTable.NT 53,(result,OpIdent1left,AndExBind_opt1right),rest671)
 end
| (363,(_,(MlyValue.ExBind ExBind1,_,ExBind1right))::(_,(_,AND1left,_)
)::rest671) => let val result=MlyValue.AndExBind_opt(fn _ => let val 
ExBind as ExBind1=ExBind1 ()
 in ( Some ExBind ) end
)
 in (LrTable.NT 59,(result,AND1left,ExBind1right),rest671) end
| (364,rest671) => let val result=MlyValue.AndExBind_opt(fn _ => (
 None ))
 in (LrTable.NT 59,(result,defaultPos,defaultPos),rest671) end
| (365,(_,(MlyValue.AtPat_seq1 AtPat_seq11,_,AtPat_seq11right))::(_,(
MlyValue.AtPat AtPat1,AtPat1left,_))::rest671) => let val result=
MlyValue.AtPat_seq2(fn _ => let val AtPat as AtPat1=AtPat1 ()
val AtPat_seq1 as AtPat_seq11=AtPat_seq11 ()
 in ( AtPat :: AtPat_seq1 ) end
)
 in (LrTable.NT 71,(result,AtPat1left,AtPat_seq11right),rest671) end
| (366,(_,(MlyValue.AtPat_seq1 AtPat_seq11,_,AtPat_seq11right))::(_,(
MlyValue.AtPat AtPat1,AtPat1left,_))::rest671) => let val result=
MlyValue.AtPat_seq1(fn _ => let val AtPat as AtPat1=AtPat1 ()
val AtPat_seq1 as AtPat_seq11=AtPat_seq11 ()
 in ( AtPat :: AtPat_seq1 ) end
)
 in (LrTable.NT 72,(result,AtPat1left,AtPat_seq11right),rest671) end
| (367,(_,(MlyValue.AtPat AtPat1,AtPat1left,AtPat1right))::rest671)
 => let val result=MlyValue.AtPat_seq1(fn _ => let val AtPat as AtPat1
=AtPat1 ()
 in ( [AtPat] ) end
)
 in (LrTable.NT 72,(result,AtPat1left,AtPat1right),rest671) end
| (368,(_,(MlyValue.Ty Ty1,_,Ty1right))::(_,(_,COLON1left,_))::rest671
) => let val result=MlyValue.ColonTy_opt(fn _ => let val Ty as Ty1=Ty1
 ()
 in ( Some Ty ) end
)
 in (LrTable.NT 63,(result,COLON1left,Ty1right),rest671) end
| (369,rest671) => let val result=MlyValue.ColonTy_opt(fn _ => ( None 
))
 in (LrTable.NT 63,(result,defaultPos,defaultPos),rest671) end
| (370,(_,(MlyValue.Ty Ty1,_,Ty1right))::(_,(_,OF1left,_))::rest671)
 => let val result=MlyValue.OfTy_opt(fn _ => let val Ty as Ty1=Ty1 ()
 in ( Some Ty ) end
)
 in (LrTable.NT 67,(result,OF1left,Ty1right),rest671) end
| (371,rest671) => let val result=MlyValue.OfTy_opt(fn _ => ( None ))
 in (LrTable.NT 67,(result,defaultPos,defaultPos),rest671) end
| (372,(_,(_,UNDERBARleft as UNDERBAR1left,UNDERBARright as 
UNDERBAR1right))::rest671) => let val result=MlyValue.AtPat(fn _ => (
 WILDCARDatpat(PP UNDERBARleft UNDERBARright) ))
 in (LrTable.NT 52,(result,UNDERBAR1left,UNDERBAR1right),rest671) end
| (373,(_,(MlyValue.SCon SCon1,SConleft as SCon1left,SConright as 
SCon1right))::rest671) => let val result=MlyValue.AtPat(fn _ => let 
val SCon as SCon1=SCon1 ()
 in ( SCONatpat(PP SConleft SConright, SCon) ) end
)
 in (LrTable.NT 52,(result,SCon1left,SCon1right),rest671) end
| (374,(_,(MlyValue.LongOpIdent LongOpIdent1,LongOpIdentleft as 
LongOpIdent1left,LongOpIdentright as LongOpIdent1right))::rest671) => 
let val result=MlyValue.AtPat(fn _ => let val LongOpIdent as 
LongOpIdent1=LongOpIdent1 ()
 in (
 let
                            val OP_OPT(id, withOp) = LongOpIdent
                          in
                            LONGIDatpat(PP LongOpIdentleft LongOpIdentright,
                                        OP_OPT(mk_LongId id, withOp)
                                       )
                          end
                        
) end
)
 in (LrTable.NT 52,(result,LongOpIdent1left,LongOpIdent1right),rest671
) end
| (375,(_,(_,_,EQUALSright as EQUALS1right))::(_,(_,OPleft as OP1left,
_))::rest671) => let val result=MlyValue.AtPat(fn _ => (
 LONGIDatpat(PP OPleft EQUALSright,
                                      OP_OPT(mk_LongId ["="], true)
                                     )
                        
))
 in (LrTable.NT 52,(result,OP1left,EQUALS1right),rest671) end
| (376,(_,(_,_,RBRACEright as RBRACE1right))::(_,(MlyValue.PatRow_opt 
PatRow_opt1,_,_))::(_,(_,LBRACEleft as LBRACE1left,_))::rest671) => 
let val result=MlyValue.AtPat(fn _ => let val PatRow_opt as 
PatRow_opt1=PatRow_opt1 ()
 in ( RECORDatpat(PP LBRACEleft RBRACEright, PatRow_opt) ) end
)
 in (LrTable.NT 52,(result,LBRACE1left,RBRACE1right),rest671) end
| (377,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.Pat Pat1,_,
_))::(_,(_,LPARENleft as LPAREN1left,_))::rest671) => let val result=
MlyValue.AtPat(fn _ => let val Pat as Pat1=Pat1 ()
 in ( PARatpat(PP LPARENleft RPARENright, Pat) ) end
)
 in (LrTable.NT 52,(result,LPAREN1left,RPAREN1right),rest671) end
| (378,(_,(_,_,RPARENright as RPAREN1right))::(_,(_,LPARENleft as 
LPAREN1left,_))::rest671) => let val result=MlyValue.AtPat(fn _ => (
 RECORDatpat(PP LPARENleft RPARENright, None) ))
 in (LrTable.NT 52,(result,LPAREN1left,RPAREN1right),rest671) end
| (379,(_,(_,_,RPAREN1right))::(_,(MlyValue.PatComma_seq2 
PatComma_seq21,_,_))::(_,(_,LPAREN1left,_))::rest671) => let val 
result=MlyValue.AtPat(fn _ => let val PatComma_seq2 as PatComma_seq21=
PatComma_seq21 ()
 in ( tupleAtPat PatComma_seq2 ) end
)
 in (LrTable.NT 52,(result,LPAREN1left,RPAREN1right),rest671) end
| (380,(_,(_,_,RBRACKET1right))::(_,(MlyValue.PatComma_seq0 
PatComma_seq01,_,_))::(_,(_,LBRACKET1left,_))::rest671) => let val 
result=MlyValue.AtPat(fn _ => let val PatComma_seq0 as PatComma_seq01=
PatComma_seq01 ()
 in ( listAtPat PatComma_seq0 ) end
)
 in (LrTable.NT 52,(result,LBRACKET1left,RBRACKET1right),rest671) end
| (381,(_,(MlyValue.PatRow PatRow1,PatRow1left,PatRow1right))::rest671
) => let val result=MlyValue.PatRow_opt(fn _ => let val PatRow as 
PatRow1=PatRow1 ()
 in ( Some PatRow ) end
)
 in (LrTable.NT 60,(result,PatRow1left,PatRow1right),rest671) end
| (382,rest671) => let val result=MlyValue.PatRow_opt(fn _ => ( None )
)
 in (LrTable.NT 60,(result,defaultPos,defaultPos),rest671) end
| (383,(_,(_,DOTDOTDOTleft as DOTDOTDOT1left,DOTDOTDOTright as 
DOTDOTDOT1right))::rest671) => let val result=MlyValue.PatRow(fn _ => 
( C.DOTDOTDOT(PP DOTDOTDOTleft DOTDOTDOTright) ))
 in (LrTable.NT 51,(result,DOTDOTDOT1left,DOTDOTDOT1right),rest671)
 end
| (384,(_,(MlyValue.CommaPatRow_opt CommaPatRow_opt1,_,
CommaPatRow_optright as CommaPatRow_opt1right))::(_,(MlyValue.Pat Pat1
,_,_))::_::(_,(MlyValue.Label Label1,Labelleft as Label1left,_))::
rest671) => let val result=MlyValue.PatRow(fn _ => let val Label as 
Label1=Label1 ()
val Pat as Pat1=Pat1 ()
val CommaPatRow_opt as CommaPatRow_opt1=CommaPatRow_opt1 ()
 in (
 PATROW(PP Labelleft CommaPatRow_optright,
                                 Label, Pat, CommaPatRow_opt
                                )
                        
) end
)
 in (LrTable.NT 51,(result,Label1left,CommaPatRow_opt1right),rest671)
 end
| (385,(_,(MlyValue.CommaPatRow_opt CommaPatRow_opt1,_,
CommaPatRow_optright as CommaPatRow_opt1right))::(_,(
MlyValue.AsPat_opt AsPat_opt1,_,AsPat_optright))::(_,(
MlyValue.ColonTy_opt ColonTy_opt1,_,ColonTy_optright))::(_,(
MlyValue.Ident Ident1,Identleft as Ident1left,Identright))::rest671)
 => let val result=MlyValue.PatRow(fn _ => let val Ident as Ident1=
Ident1 ()
val ColonTy_opt as ColonTy_opt1=ColonTy_opt1 ()
val AsPat_opt as AsPat_opt1=AsPat_opt1 ()
val CommaPatRow_opt as CommaPatRow_opt1=CommaPatRow_opt1 ()
 in (
 PATROW(
                            PP Identleft CommaPatRow_optright,
                            mk_IdentLab Ident,
                            let
                              val i = PP Identleft Identright
                              val idPat =
                                ATPATpat(
                                  i,
                                  LONGIDatpat(i,
                                              OP_OPT(mk_LongId [Ident], false)
                                             )
                                )
                            in
                              case (ColonTy_opt, AsPat_opt)
                                of (_, Some pat) =>
                                     LAYEREDpat(PP Identleft AsPat_optright,
                                                OP_OPT(mk_Id Ident, false),
                                                ColonTy_opt, pat
                                               )

                                 | (Some ty, None) =>
                                     TYPEDpat(PP Identleft ColonTy_optright,
                                              idPat, ty
                                             )

                                 | (None, None) => idPat
                            end,
                            CommaPatRow_opt
                           )
                        
) end
)
 in (LrTable.NT 51,(result,Ident1left,CommaPatRow_opt1right),rest671)
 end
| (386,(_,(MlyValue.Pat Pat1,_,Pat1right))::(_,(_,AS1left,_))::rest671
) => let val result=MlyValue.AsPat_opt(fn _ => let val Pat as Pat1=
Pat1 ()
 in ( Some Pat ) end
)
 in (LrTable.NT 61,(result,AS1left,Pat1right),rest671) end
| (387,rest671) => let val result=MlyValue.AsPat_opt(fn _ => ( None ))
 in (LrTable.NT 61,(result,defaultPos,defaultPos),rest671) end
| (388,(_,(MlyValue.PatRow PatRow1,_,PatRow1right))::(_,(_,COMMA1left,
_))::rest671) => let val result=MlyValue.CommaPatRow_opt(fn _ => let 
val PatRow as PatRow1=PatRow1 ()
 in ( Some PatRow ) end
)
 in (LrTable.NT 62,(result,COMMA1left,PatRow1right),rest671) end
| (389,rest671) => let val result=MlyValue.CommaPatRow_opt(fn _ => (
 None ))
 in (LrTable.NT 62,(result,defaultPos,defaultPos),rest671) end
| (390,(_,(MlyValue.PatComma_seq1 PatComma_seq11,PatComma_seq11left,
PatComma_seq11right))::rest671) => let val result=
MlyValue.PatComma_seq0(fn _ => let val PatComma_seq1 as PatComma_seq11
=PatComma_seq11 ()
 in ( PatComma_seq1 ) end
)
 in (LrTable.NT 68,(result,PatComma_seq11left,PatComma_seq11right),
rest671) end
| (391,rest671) => let val result=MlyValue.PatComma_seq0(fn _ => (
 nil ))
 in (LrTable.NT 68,(result,defaultPos,defaultPos),rest671) end
| (392,(_,(MlyValue.PatComma_seq1 PatComma_seq11,_,PatComma_seq11right
))::_::(_,(MlyValue.Pat Pat1,Pat1left,_))::rest671) => let val result=
MlyValue.PatComma_seq1(fn _ => let val Pat as Pat1=Pat1 ()
val PatComma_seq1 as PatComma_seq11=PatComma_seq11 ()
 in ( Pat :: PatComma_seq1 ) end
)
 in (LrTable.NT 69,(result,Pat1left,PatComma_seq11right),rest671) end
| (393,(_,(MlyValue.Pat Pat1,Pat1left,Pat1right))::rest671) => let 
val result=MlyValue.PatComma_seq1(fn _ => let val Pat as Pat1=Pat1 ()
 in ( [Pat] ) end
)
 in (LrTable.NT 69,(result,Pat1left,Pat1right),rest671) end
| (394,(_,(MlyValue.PatComma_seq1 PatComma_seq11,_,PatComma_seq11right
))::_::(_,(MlyValue.Pat Pat1,Pat1left,_))::rest671) => let val result=
MlyValue.PatComma_seq2(fn _ => let val Pat as Pat1=Pat1 ()
val PatComma_seq1 as PatComma_seq11=PatComma_seq11 ()
 in ( Pat :: PatComma_seq1 ) end
)
 in (LrTable.NT 70,(result,Pat1left,PatComma_seq11right),rest671) end
| (395,(_,(MlyValue.AtPat AtPat1,AtPatleft as AtPat1left,AtPatright
 as AtPat1right))::rest671) => let val result=MlyValue.Pat(fn _ => 
let val AtPat as AtPat1=AtPat1 ()
 in ( ATPATpat(PP AtPatleft AtPatright, AtPat) ) end
)
 in (LrTable.NT 50,(result,AtPat1left,AtPat1right),rest671) end
| (396,(_,(MlyValue.AtPat_seq2 AtPat_seq21,AtPat_seq2left as 
AtPat_seq21left,AtPat_seq2right as AtPat_seq21right))::rest671) => 
let val result=MlyValue.Pat(fn _ => let val AtPat_seq2 as AtPat_seq21=
AtPat_seq21 ()
 in (
 UNRES_INFIXpat(PP AtPat_seq2left AtPat_seq2right,
                                         AtPat_seq2
                                        )
                        
) end
)
 in (LrTable.NT 50,(result,AtPat_seq21left,AtPat_seq21right),rest671)
 end
| (397,(_,(MlyValue.Ty Ty1,_,Tyright as Ty1right))::_::(_,(
MlyValue.Pat Pat1,Patleft as Pat1left,_))::rest671) => let val result=
MlyValue.Pat(fn _ => let val Pat as Pat1=Pat1 ()
val Ty as Ty1=Ty1 ()
 in ( TYPEDpat(PP Patleft Tyright, Pat, Ty) ) end
)
 in (LrTable.NT 50,(result,Pat1left,Ty1right),rest671) end
| (398,(_,(MlyValue.Pat Pat2,_,Pat2right))::_::(_,(MlyValue.Pat Pat1,
Pat1left,_))::rest671) => let val result=MlyValue.Pat(fn _ => let val 
Pat1=Pat1 ()
val Pat2=Pat2 ()
 in ( layeredPat(PP Pat1left Pat2right, Pat1, Pat2) ) end
)
 in (LrTable.NT 50,(result,Pat1left,Pat2right),rest671) end
| (399,(_,(MlyValue.Ty Ty1,_,Tyright as Ty1right))::_::(_,(
MlyValue.TupleTy TupleTy1,TupleTyleft as TupleTy1left,_))::rest671)
 => let val result=MlyValue.Ty(fn _ => let val TupleTy as TupleTy1=
TupleTy1 ()
val Ty as Ty1=Ty1 ()
 in (
 FNty(PP TupleTyleft Tyright,
                               case TupleTy
                                 of [t] => t
                                  | ts => tupleType ts,
                               Ty
                              )
                        
) end
)
 in (LrTable.NT 44,(result,TupleTy1left,Ty1right),rest671) end
| (400,(_,(MlyValue.TupleTy TupleTy1,TupleTy1left,TupleTy1right))::
rest671) => let val result=MlyValue.Ty(fn _ => let val TupleTy as 
TupleTy1=TupleTy1 ()
 in (
 case TupleTy
                            of [t] => t
                             | ts => tupleType ts
                        
) end
)
 in (LrTable.NT 44,(result,TupleTy1left,TupleTy1right),rest671) end
| (401,(_,(MlyValue.Ty_sans_STAR Ty_sans_STAR1,Ty_sans_STAR1left,
Ty_sans_STAR1right))::rest671) => let val result=MlyValue.TupleTy(fn _
 => let val Ty_sans_STAR as Ty_sans_STAR1=Ty_sans_STAR1 ()
 in ( [Ty_sans_STAR] ) end
)
 in (LrTable.NT 45,(result,Ty_sans_STAR1left,Ty_sans_STAR1right),
rest671) end
| (402,(_,(MlyValue.TupleTy TupleTy1,_,TupleTy1right))::_::(_,(
MlyValue.Ty_sans_STAR Ty_sans_STAR1,Ty_sans_STAR1left,_))::rest671)
 => let val result=MlyValue.TupleTy(fn _ => let val Ty_sans_STAR as 
Ty_sans_STAR1=Ty_sans_STAR1 ()
val TupleTy as TupleTy1=TupleTy1 ()
 in ( Ty_sans_STAR :: TupleTy ) end
)
 in (LrTable.NT 45,(result,Ty_sans_STAR1left,TupleTy1right),rest671)
 end
| (403,(_,(MlyValue.LongTypeIdent LongTypeIdent1,_,LongTypeIdentright
 as LongTypeIdent1right))::_::(_,(MlyValue.TyComma_seq2 TyComma_seq21,
_,_))::(_,(_,LPARENleft as LPAREN1left,_))::rest671) => let val result
=MlyValue.Ty_sans_STAR(fn _ => let val TyComma_seq2 as TyComma_seq21=
TyComma_seq21 ()
val LongTypeIdent as LongTypeIdent1=LongTypeIdent1 ()
 in (
 CONty(PP LPARENleft LongTypeIdentright,
                                TyComma_seq2, mk_LongTyCon LongTypeIdent
                               )
                        
) end
)
 in (LrTable.NT 46,(result,LPAREN1left,LongTypeIdent1right),rest671)
 end
| (404,(_,(MlyValue.LongTypeIdent LongTypeIdent1,_,LongTypeIdentright
 as LongTypeIdent1right))::(_,(MlyValue.Ty_sans_STAR Ty_sans_STAR1,
Ty_sans_STARleft as Ty_sans_STAR1left,_))::rest671) => let val result=
MlyValue.Ty_sans_STAR(fn _ => let val Ty_sans_STAR as Ty_sans_STAR1=
Ty_sans_STAR1 ()
val LongTypeIdent as LongTypeIdent1=LongTypeIdent1 ()
 in (
 CONty(PP Ty_sans_STARleft LongTypeIdentright,
                                [Ty_sans_STAR], mk_LongTyCon LongTypeIdent
                               )
                        
) end
)
 in (LrTable.NT 46,(result,Ty_sans_STAR1left,LongTypeIdent1right),
rest671) end
| (405,(_,(MlyValue.AtomicTy AtomicTy1,AtomicTy1left,AtomicTy1right))
::rest671) => let val result=MlyValue.Ty_sans_STAR(fn _ => let val 
AtomicTy as AtomicTy1=AtomicTy1 ()
 in ( AtomicTy ) end
)
 in (LrTable.NT 46,(result,AtomicTy1left,AtomicTy1right),rest671) end
| (406,(_,(MlyValue.TyComma_seq2 TyComma_seq21,_,TyComma_seq21right))
::_::(_,(MlyValue.Ty Ty1,Ty1left,_))::rest671) => let val result=
MlyValue.TyComma_seq2(fn _ => let val Ty as Ty1=Ty1 ()
val TyComma_seq2 as TyComma_seq21=TyComma_seq21 ()
 in ( Ty :: TyComma_seq2 ) end
)
 in (LrTable.NT 74,(result,Ty1left,TyComma_seq21right),rest671) end
| (407,(_,(MlyValue.Ty Ty2,_,Ty2right))::_::(_,(MlyValue.Ty Ty1,
Ty1left,_))::rest671) => let val result=MlyValue.TyComma_seq2(fn _ => 
let val Ty1=Ty1 ()
val Ty2=Ty2 ()
 in ( [Ty1, Ty2] ) end
)
 in (LrTable.NT 74,(result,Ty1left,Ty2right),rest671) end
| (408,(_,(MlyValue.LongTypeIdent LongTypeIdent1,LongTypeIdentleft as 
LongTypeIdent1left,LongTypeIdentright as LongTypeIdent1right))::
rest671) => let val result=MlyValue.AtomicTy(fn _ => let val 
LongTypeIdent as LongTypeIdent1=LongTypeIdent1 ()
 in (
 CONty(PP LongTypeIdentleft LongTypeIdentright,
                                nil, mk_LongTyCon LongTypeIdent
                               )
                        
) end
)
 in (LrTable.NT 47,(result,LongTypeIdent1left,LongTypeIdent1right),
rest671) end
| (409,(_,(MlyValue.TYVAR TYVAR1,TYVARleft as TYVAR1left,TYVARright
 as TYVAR1right))::rest671) => let val result=MlyValue.AtomicTy(fn _
 => let val TYVAR as TYVAR1=TYVAR1 ()
 in ( TYVARty(PP TYVARleft TYVARright, mk_TyVar TYVAR) ) end
)
 in (LrTable.NT 47,(result,TYVAR1left,TYVAR1right),rest671) end
| (410,(_,(_,_,RBRACEright as RBRACE1right))::(_,(MlyValue.TyRow_opt 
TyRow_opt1,_,_))::(_,(_,LBRACEleft as LBRACE1left,_))::rest671) => 
let val result=MlyValue.AtomicTy(fn _ => let val TyRow_opt as 
TyRow_opt1=TyRow_opt1 ()
 in ( RECORDty(PP LBRACEleft RBRACEright, TyRow_opt) ) end
)
 in (LrTable.NT 47,(result,LBRACE1left,RBRACE1right),rest671) end
| (411,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.Ty Ty1,_,_)
)::(_,(_,LPARENleft as LPAREN1left,_))::rest671) => let val result=
MlyValue.AtomicTy(fn _ => let val Ty as Ty1=Ty1 ()
 in ( PARty(PP LPARENleft RPARENright, Ty) ) end
)
 in (LrTable.NT 47,(result,LPAREN1left,RPAREN1right),rest671) end
| (412,(_,(MlyValue.TyRow TyRow1,TyRow1left,TyRow1right))::rest671)
 => let val result=MlyValue.TyRow_opt(fn _ => let val TyRow as TyRow1=
TyRow1 ()
 in ( Some TyRow ) end
)
 in (LrTable.NT 65,(result,TyRow1left,TyRow1right),rest671) end
| (413,rest671) => let val result=MlyValue.TyRow_opt(fn _ => ( None ))
 in (LrTable.NT 65,(result,defaultPos,defaultPos),rest671) end
| (414,(_,(MlyValue.CommaTyRow_opt CommaTyRow_opt1,_,
CommaTyRow_optright as CommaTyRow_opt1right))::(_,(MlyValue.Ty Ty1,_,_
))::_::(_,(MlyValue.Label Label1,Labelleft as Label1left,_))::rest671)
 => let val result=MlyValue.TyRow(fn _ => let val Label as Label1=
Label1 ()
val Ty as Ty1=Ty1 ()
val CommaTyRow_opt as CommaTyRow_opt1=CommaTyRow_opt1 ()
 in (
 TYROW(PP Labelleft CommaTyRow_optright,
                                Label, Ty, CommaTyRow_opt
                               )
                        
) end
)
 in (LrTable.NT 43,(result,Label1left,CommaTyRow_opt1right),rest671)
 end
| (415,(_,(MlyValue.TyRow TyRow1,_,TyRow1right))::(_,(_,COMMA1left,_))
::rest671) => let val result=MlyValue.CommaTyRow_opt(fn _ => let val 
TyRow as TyRow1=TyRow1 ()
 in ( Some TyRow ) end
)
 in (LrTable.NT 66,(result,COMMA1left,TyRow1right),rest671) end
| (416,rest671) => let val result=MlyValue.CommaTyRow_opt(fn _ => (
 None ))
 in (LrTable.NT 66,(result,defaultPos,defaultPos),rest671) end
| (417,(_,(MlyValue.Integer Integer1,Integer1left,Integer1right))::
rest671) => let val result=MlyValue.SCon(fn _ => let val Integer as 
Integer1=Integer1 ()
 in ( mk_IntSCon Integer ) end
)
 in (LrTable.NT 49,(result,Integer1left,Integer1right),rest671) end
| (418,(_,(MlyValue.STRING STRING1,STRING1left,STRING1right))::rest671
) => let val result=MlyValue.SCon(fn _ => let val STRING as STRING1=
STRING1 ()
 in ( mk_StringSCon STRING ) end
)
 in (LrTable.NT 49,(result,STRING1left,STRING1right),rest671) end
| (419,(_,(MlyValue.REAL REAL1,REAL1left,REAL1right))::rest671) => 
let val result=MlyValue.SCon(fn _ => let val REAL as REAL1=REAL1 ()
 in ( mk_RealSCon REAL ) end
)
 in (LrTable.NT 49,(result,REAL1left,REAL1right),rest671) end
| (420,(_,(MlyValue.TYVAR TYVAR1,TYVAR1left,TYVAR1right))::rest671)
 => let val result=MlyValue.TyVarSeq(fn _ => let val TYVAR as TYVAR1=
TYVAR1 ()
 in ( [mk_TyVar TYVAR] ) end
)
 in (LrTable.NT 48,(result,TYVAR1left,TYVAR1right),rest671) end
| (421,(_,(_,_,RPAREN1right))::(_,(MlyValue.TyVarComma_seq1 
TyVarComma_seq11,_,_))::(_,(_,LPAREN1left,_))::rest671) => let val 
result=MlyValue.TyVarSeq(fn _ => let val TyVarComma_seq1 as 
TyVarComma_seq11=TyVarComma_seq11 ()
 in ( TyVarComma_seq1 ) end
)
 in (LrTable.NT 48,(result,LPAREN1left,RPAREN1right),rest671) end
| (422,rest671) => let val result=MlyValue.TyVarSeq(fn _ => ( nil ))
 in (LrTable.NT 48,(result,defaultPos,defaultPos),rest671) end
| (423,(_,(MlyValue.TyVarComma_seq1 TyVarComma_seq11,_,
TyVarComma_seq11right))::_::(_,(MlyValue.TYVAR TYVAR1,TYVAR1left,_))::
rest671) => let val result=MlyValue.TyVarComma_seq1(fn _ => let val 
TYVAR as TYVAR1=TYVAR1 ()
val TyVarComma_seq1 as TyVarComma_seq11=TyVarComma_seq11 ()
 in ( mk_TyVar TYVAR :: TyVarComma_seq1 ) end
)
 in (LrTable.NT 73,(result,TYVAR1left,TyVarComma_seq11right),rest671)
 end
| (424,(_,(MlyValue.TYVAR TYVAR1,TYVAR1left,TYVAR1right))::rest671)
 => let val result=MlyValue.TyVarComma_seq1(fn _ => let val TYVAR as 
TYVAR1=TYVAR1 ()
 in ( [mk_TyVar TYVAR] ) end
)
 in (LrTable.NT 73,(result,TYVAR1left,TYVAR1right),rest671) end
| _ => raise (mlyAction i392)
end
val void = MlyValue.VOID
val extract = fn a => (fn MlyValue.TopDec x => x
| _ => let exception ParseInternal
	in raise ParseInternal end) a ()
end
end
structure Tokens : Topdec_TOKENS =
struct
type svalue = ParserData.svalue
type ('a,'b) token = ('a,'b) Token.token
fun EQTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 0,(
ParserData.MlyValue.VOID,p1,p2))
fun FUNCTOR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 1,(
ParserData.MlyValue.VOID,p1,p2))
fun INCLUDE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 2,(
ParserData.MlyValue.VOID,p1,p2))
fun SHARING (p1,p2) = Token.TOKEN (ParserData.LrTable.T 3,(
ParserData.MlyValue.VOID,p1,p2))
fun SIG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 4,(
ParserData.MlyValue.VOID,p1,p2))
fun SIGNATURE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 5,(
ParserData.MlyValue.VOID,p1,p2))
fun STRUCT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 6,(
ParserData.MlyValue.VOID,p1,p2))
fun STRUCTURE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 7,(
ParserData.MlyValue.VOID,p1,p2))
fun QUAL_ID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 8,(
ParserData.MlyValue.QUAL_ID (fn () => i),p1,p2))
fun QUAL_STAR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 9,(
ParserData.MlyValue.QUAL_STAR (fn () => i),p1,p2))
fun AXIOM (p1,p2) = Token.TOKEN (ParserData.LrTable.T 10,(
ParserData.MlyValue.VOID,p1,p2))
fun IMPLIES (p1,p2) = Token.TOKEN (ParserData.LrTable.T 11,(
ParserData.MlyValue.VOID,p1,p2))
fun IFF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 12,(
ParserData.MlyValue.VOID,p1,p2))
fun EXISTS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 13,(
ParserData.MlyValue.VOID,p1,p2))
fun FORALL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 14,(
ParserData.MlyValue.VOID,p1,p2))
fun PROPER (p1,p2) = Token.TOKEN (ParserData.LrTable.T 15,(
ParserData.MlyValue.VOID,p1,p2))
fun RAISES (p1,p2) = Token.TOKEN (ParserData.LrTable.T 16,(
ParserData.MlyValue.VOID,p1,p2))
fun TERMINATES (p1,p2) = Token.TOKEN (ParserData.LrTable.T 17,(
ParserData.MlyValue.VOID,p1,p2))
fun ABSTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 18,(
ParserData.MlyValue.VOID,p1,p2))
fun AND (p1,p2) = Token.TOKEN (ParserData.LrTable.T 19,(
ParserData.MlyValue.VOID,p1,p2))
fun ANDALSO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 20,(
ParserData.MlyValue.VOID,p1,p2))
fun AS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 21,(
ParserData.MlyValue.VOID,p1,p2))
fun CASE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 22,(
ParserData.MlyValue.VOID,p1,p2))
fun DO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 23,(
ParserData.MlyValue.VOID,p1,p2))
fun DATATYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 24,(
ParserData.MlyValue.VOID,p1,p2))
fun ELSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 25,(
ParserData.MlyValue.VOID,p1,p2))
fun END (p1,p2) = Token.TOKEN (ParserData.LrTable.T 26,(
ParserData.MlyValue.VOID,p1,p2))
fun EXCEPTION (p1,p2) = Token.TOKEN (ParserData.LrTable.T 27,(
ParserData.MlyValue.VOID,p1,p2))
fun FN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 28,(
ParserData.MlyValue.VOID,p1,p2))
fun FUN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 29,(
ParserData.MlyValue.VOID,p1,p2))
fun HANDLE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 30,(
ParserData.MlyValue.VOID,p1,p2))
fun IF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 31,(
ParserData.MlyValue.VOID,p1,p2))
fun IN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 32,(
ParserData.MlyValue.VOID,p1,p2))
fun INFIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 33,(
ParserData.MlyValue.VOID,p1,p2))
fun INFIXR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 34,(
ParserData.MlyValue.VOID,p1,p2))
fun LET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 35,(
ParserData.MlyValue.VOID,p1,p2))
fun LOCAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 36,(
ParserData.MlyValue.VOID,p1,p2))
fun NONFIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 37,(
ParserData.MlyValue.VOID,p1,p2))
fun OF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 38,(
ParserData.MlyValue.VOID,p1,p2))
fun OP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 39,(
ParserData.MlyValue.VOID,p1,p2))
fun OPEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 40,(
ParserData.MlyValue.VOID,p1,p2))
fun ORELSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 41,(
ParserData.MlyValue.VOID,p1,p2))
fun RAISE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 42,(
ParserData.MlyValue.VOID,p1,p2))
fun REC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 43,(
ParserData.MlyValue.VOID,p1,p2))
fun THEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 44,(
ParserData.MlyValue.VOID,p1,p2))
fun TYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 45,(
ParserData.MlyValue.VOID,p1,p2))
fun VAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 46,(
ParserData.MlyValue.VOID,p1,p2))
fun WITH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 47,(
ParserData.MlyValue.VOID,p1,p2))
fun WITHTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 48,(
ParserData.MlyValue.VOID,p1,p2))
fun WHILE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 49,(
ParserData.MlyValue.VOID,p1,p2))
fun LPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 50,(
ParserData.MlyValue.VOID,p1,p2))
fun RPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 51,(
ParserData.MlyValue.VOID,p1,p2))
fun LBRACKET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 52,(
ParserData.MlyValue.VOID,p1,p2))
fun RBRACKET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 53,(
ParserData.MlyValue.VOID,p1,p2))
fun LBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 54,(
ParserData.MlyValue.VOID,p1,p2))
fun RBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 55,(
ParserData.MlyValue.VOID,p1,p2))
fun COMMA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 56,(
ParserData.MlyValue.VOID,p1,p2))
fun COLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 57,(
ParserData.MlyValue.VOID,p1,p2))
fun SEMICOLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 58,(
ParserData.MlyValue.VOID,p1,p2))
fun DOTDOTDOT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 59,(
ParserData.MlyValue.VOID,p1,p2))
fun UNDERBAR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 60,(
ParserData.MlyValue.VOID,p1,p2))
fun BAR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 61,(
ParserData.MlyValue.VOID,p1,p2))
fun DARROW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 62,(
ParserData.MlyValue.VOID,p1,p2))
fun ARROW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 63,(
ParserData.MlyValue.VOID,p1,p2))
fun HASH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 64,(
ParserData.MlyValue.VOID,p1,p2))
fun QUESTIONMARK (p1,p2) = Token.TOKEN (ParserData.LrTable.T 65,(
ParserData.MlyValue.VOID,p1,p2))
fun EQUALEQUAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 66,(
ParserData.MlyValue.VOID,p1,p2))
fun EQUALSLASHEQUAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 67,(
ParserData.MlyValue.VOID,p1,p2))
fun EQUALS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 68,(
ParserData.MlyValue.VOID,p1,p2))
fun STAR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 69,(
ParserData.MlyValue.VOID,p1,p2))
fun POSINT2 (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 70,(
ParserData.MlyValue.POSINT2 (fn () => i),p1,p2))
fun NEGINT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 71,(
ParserData.MlyValue.NEGINT (fn () => i),p1,p2))
fun REAL (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 72,(
ParserData.MlyValue.REAL (fn () => i),p1,p2))
fun STRING (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 73,(
ParserData.MlyValue.STRING (fn () => i),p1,p2))
fun ID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 74,(
ParserData.MlyValue.ID (fn () => i),p1,p2))
fun TYVAR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 75,(
ParserData.MlyValue.TYVAR (fn () => i),p1,p2))
fun DIGIT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 76,(
ParserData.MlyValue.DIGIT (fn () => i),p1,p2))
fun EOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 77,(
ParserData.MlyValue.VOID,p1,p2))
end
end
