(* Contains functions to assist the analysis of derived forms, patch up the
   holes resulting from ambiguities in the SML grammar, and generally assist
   in the building of the parse tree. *)

(*
$File: Parsing/GRAMMAR_UTILS.sml $
$Date: 1992/04/07 14:58:30 $
$Revision: 1.10 $
$Locker:  $
*)

(*$GRAMMAR_UTILS: DEC_GRAMMAR TOPDEC_GRAMMAR*)
signature GRAMMAR_UTILS =
  sig
    structure M: TOPDEC_GRAMMAR
    structure C: DEC_GRAMMAR
      sharing type M.dec = C.dec
	  and type M.con = C.con
	  and type M.excon = C.excon
	  and type M.tycon = C.tycon
	  and type M.tyvar = C.tyvar
	  and type M.id = C.id
	  and type M.ty = C.ty
	  and type M.info = C.info
	  and type M.longstrid = C.longstrid
	  and type M.longtycon = C.longtycon
	  and type M.WithInfo = C.WithInfo
(* alx *)
          and type M.exp = C.exp
          and type M.info = C.info
(* alx *)

   (* We can get syntax errors while analysing layered patterns (this is
      during the activity of the parser; we aren't post-passing yet). *)
    type pos
    exception LAYERPAT_ERROR of (pos * pos) Option
				(* We may not have position information... *)

(* alx#1.40*)
(* the type of warning when imperative features in axiom *)
    val imperativeWarning : string
(* alx#1.40#end*)
    val topdecOfExp: C.exp -> M.topdec
    val composeStrDec: C.info * M.strdec * M.strdec -> M.strdec
(* alx#1.38*)
    val Dec2StrDec: C.info * C.dec -> M.strdec
(* alx#1.38#end*)
    val composeSpec: C.info * M.spec * M.spec -> M.spec
    val inventStrId: unit -> M.strid
(*alx#1.22
alx#1.19
    val functSigExp: M.psigexp * M.strid -> M.psigexp
alx#1.19#end
alx#1.22#end commented out*)
(*alx#1.24 *)
(*arkady#*)
(*    val functPSigExp: M.spec * M.strid -> M.psigexp
*)
    val functPSigExp: M.spec * M.strid * C.info -> M.psigexp
(*end of arkady#*)
(*alx#1.24#end*)
(*alx#1.25 *)
    val specAsSig: C.info * M.spec -> M.psigexp
(*alx#1.25#end*)
(*arkady#*)
(*    val convertFunctorBody: M.strid * M.strexp -> M.strexp
*)
    val convertFunctorBody: M.strid * M.strexp * C.info -> M.strexp
(*end of arkady#*)
    val composeDec: C.info * C.dec * C.dec -> C.dec
    val tupleAtExp: C.exp list -> C.atexp
    val caseExp: C.exp * C.match -> C.exp
    val sequenceExp: C.exp list -> C.exp
    val inventId: unit -> C.id
    val atexpOfIdent: C.id -> C.atexp
    val expOfIdent: C.id -> C.exp
    val patOfIdent: C.id * bool -> C.pat
    val patOfAtpat: C.atpat -> C.pat
    val expOfAtexp: C.atexp -> C.exp
    val listAtExp: C.exp list -> C.atexp
    val hash: C.lab -> C.atexp
    val trueExp: C.exp
    val falseExp: C.exp
    val ifThenElse: C.exp * C.exp * C.exp -> C.exp
(* mikon#last *)
    val notExp: C.exp -> C.exp
(* alx#1.7 *)
    val raisesExp: C.exp * C.match -> C.exp
    val properExp: C.exp -> C.exp
(* alx#1.7#end *)
    val whileExp: C.exp * C.exp -> C.exp
    val rewriteDatBind: C.datbind * C.typbind -> C.datbind
    val tupleAtPat: C.pat list -> C.atpat
    val listAtPat: C.pat list -> C.atpat
    val layeredPat: C.info * C.pat * C.pat -> C.pat
    val tupleType: C.ty list -> C.ty

   (* The following all come from the appropriate modules, but they're here
      for convenience and brevity. *)

    val mk_Con: string -> C.con
    val mk_ExCon: string -> C.excon
    val mk_IdentLab: string -> C.lab
    val mk_IntegerLab: int -> C.lab
    val mk_Id: string -> C.id
    val mk_LongId: string list -> C.longid
    val mk_FunId: string -> M.funid
    val mk_StrId: string -> M.strid
    val mk_SigId: string -> M.sigid
(*alx#1.23 *)
(*arkady#*)
(*    val mk_PSigId: string -> M.psigexp
*)
    val mk_PSigId: string * C.info -> M.psigexp
(*end of arkady#*)
(*alx#1.23#end*)
    val mk_LongStrId: string list -> M.longstrid
    val mk_TyVar: string -> C.tyvar
    val mk_TyCon: string -> C.tycon
    val mk_LongTyCon: string list -> M.longtycon
    val mk_IntSCon: int -> C.scon
    val mk_StringSCon: string -> C.scon
    val mk_RealSCon: real -> C.scon

    val i: C.info			(* MEMO: This is empty information:
					   We should nuke it soon. *)

    val PP : pos -> pos -> C.info	(* `PP L R' generates position
					   information. *)

    val wi_Convert: ('a -> 'b) -> 'a C.WithInfo list -> 'b C.WithInfo list
					(* Conversion of "with-info" tagged
					   lists (of identifiers etc.) *)
  end;