(* Dynamic values and enviroments - Definition v3 page 46 *)

(*
$File: Interpreter/CoreDynObject.sml $
$Date: 1992/08/19 14:49:32 $
$Revision: 1.5 $
$Locker:  $
*)

(*$CoreDynObject:
	LAB CON SPECIAL_VALUE VAR EXCON EXNAME STORE STRID BASIC_VALUE
	FINMAP SORTED_FINMAP PRETTYPRINT CRASH CORE_DYNOBJECT
 *)

functor CoreDynObject(structure Lab: LAB
		      structure Con: CON
		      structure SpecialValue: SPECIAL_VALUE
		      structure Var: VAR
		      structure Excon: EXCON
(* leszczyk#1.4 *)
		        sharing type Var.id = Excon.id
			sharing type Con.id = Var.id
(* end leszczyk#1.4 *)
		      structure ExName: EXNAME

		      structure StrId: STRID
			sharing type Var.strid = Excon.strid = StrId.strid

		      structure Grammar: sig type match end
		      structure BasicValue: BASIC_VALUE

		      structure FinMap: FINMAP
		      structure SortedFinMap: SORTED_FINMAP
		      
		      structure PP: PRETTYPRINT
			sharing type FinMap.StringTree
				     = SortedFinMap.StringTree
				     = PP.StringTree

		      structure Crash: CRASH
		     ): CORE_DYNOBJECT =
  struct
   (* Copying of arguments to result structure *)

    structure Con     = Con
    structure Lab     = Lab
    structure Var     = Var
    structure Excon   = Excon
    structure ExName  = ExName
    structure Grammar = Grammar

    type SVal   = SpecialValue.SVal
    type scon   = SpecialValue.scon
    type BasVal = BasicValue.BasVal
(* leszczyk#1.4 *)
    type id = Var.id
(* end leszczyk#1.4 *)
    type strid = StrId.strid
    type longstrid = StrId.longstrid

    type ('a, 'b) map = ('a, 'b) SortedFinMap.map
				(* We export the sorted map type because
				   datatype Val is in our signature. *)

    infix plus
    val op plus = FinMap.plus

    type StringTree = PP.StringTree

    type Address = unit ref

    datatype Val = Sval       of SVal
		 | BASval     of BasVal
		 | CON0val    of Con.con
		 | CON1val    of Con.con * Val
		 | RECORDval  of (Lab.lab, Val) SortedFinMap.map
		 | EXNAME0val of ExName.ExName
		 | EXNAME1val of ExName.ExName * Val
		 | CLOSUREval of Closure
		 | ADDRval    of Address
(* leszczyk#1.5 *)
		 | INCOMPLETEval
(* end leszczyk#1.5 *)

	(* These are abstract to the outside world: *)
	 and Closure  = CLOSURE  of Grammar.match * Env * VarEnv
(* leszczyk#1.4 *)
	 and Env      = ENV      of StrEnv * VarEnv
	 and VarEnv   = VARENV   of (id, Val) FinMap.map
(* end leszczyk#1.4 *)
(* leszczyk#1.4
	 and ExConEnv = EXCONENV of (Excon.excon, ExName.ExName) FinMap.map
 end leszczyk#1.4 & commented out *)
	 and StrEnv   = STRENV   of (strid, Env) FinMap.map

    val unit = RECORDval SortedFinMap.empty
    val exAbsName = ExName.new "Abs"
    val exNegName = ExName.new "Neg"
    val exSumName = ExName.new "Sum"
    val exDiffName = ExName.new "Diff"
    val exProdName = ExName.new "Prod"
(* leszczyk#1.5 *)
    val exNoCodeName = ExName.new "NoCode"
(* end leszczyk#1.5 *)

    (* Exported, so APPLY can raise these predefined exceptions --- for
       the overloaded predefined variables *)
    val exAbs = EXNAME0val exAbsName
    val exNeg = EXNAME0val exNegName
    val exSum = EXNAME0val exSumName
    val exDiff = EXNAME0val exDiffName
    val exProd = EXNAME0val exProdName
(* leszczyk#1.5 *)
    val exNoCode = EXNAME0val exNoCodeName
(* end leszczyk#1.5 *)

   (* We can't make Store() an independent functor easily because Address
      and Val are interrelated. *)

    structure Store: STORE =
      struct
	type Address = Address
	type Val = Val

	val store = ref(FinMap.empty: (Address, Val) FinMap.map)

	val unique = ref
	fun add(addr, v) = (store := FinMap.add(addr, v, !store); unit)

	fun retrieve addr =
	  case FinMap.lookup (!store) addr
	    of Some v => v
	     | None => Crash.impossible "CoreDynObject.Store.retrieve"
      end

    fun pair(v1, v2) =
      let
	val m0 = SortedFinMap.empty
	val m1 = SortedFinMap.add (Lab.<) (Lab.mk_IntegerLab 1, v1, m0)
	val m2 = SortedFinMap.add (Lab.<) (Lab.mk_IntegerLab 2, v2, m1)
      in
	RECORDval m2
      end

    fun mustFind (fname, pr) (m, x) =
      case FinMap.lookup m x
	of Some y => y
	 | None => Crash.impossible("CoreDynObject." ^ fname ^ "(" ^ pr x ^ ")")


    fun mkSValSCon sc = SpecialValue.mkSValSCon sc

    val mkClosure = CLOSURE
    fun unClosure(CLOSURE c) = c

   (* for environments *)

   (* Empty enviroments *)

    val emptySE = STRENV FinMap.empty

    val emptyVE = VARENV FinMap.empty

(* leszczyk#1.4
    val emptyEE = EXCONENV FinMap.empty
 end leszczyk#1.4 & commented out *)

   (* for variable environments *)

    fun singleVE(v, value) = VARENV(FinMap.singleton(v, value))

(* leszczyk#1.4
    fun singleEE(e, name)  = EXCONENV(FinMap.singleton(e, name))
 end leszczyk#1.4 & commented out *)

    fun VE_plus_VE(VARENV m1, VARENV m2) = VARENV(m1 plus m2)

(* leszczyk#1.4 *)
    local 
	val primVE      = singleVE(Var.var_PRIM, BASval BasicValue.PRIM)
	val absVE       = singleVE(Var.var_ABS,  BASval BasicValue.ABS)
	val negVE       = singleVE(Var.var_NEG,  BASval BasicValue.NEG)
	val sumVE      = singleVE(Var.var_PLUS, BASval BasicValue.SUM)
	val diffVE     = singleVE(Var.var_MINUS, BASval BasicValue.DIFF)
	val prodVE       = singleVE(Var.var_MUL, BASval BasicValue.PROD)
	val lessVE      = singleVE(Var.var_LESS, BASval BasicValue.LESS)
	val greaterVE   = singleVE(Var.var_GREATER, BASval BasicValue.GREATER)
	val lesseqVE    = singleVE(Var.var_LESSEQ, BASval BasicValue.LESSEQ)
        val greatereqVE = singleVE(Var.var_GREATEREQ, BASval BasicValue.GREATEREQ)
        val absEE   = singleVE(Excon.ex_ABS, exAbs)
        val negEE   = singleVE(Excon.ex_NEG, exNeg)
        val sumEE   = singleVE(Excon.ex_SUM, exSum)
        val diffEE  = singleVE(Excon.ex_DIFF, exDiff)
        val prodEE  = singleVE(Excon.ex_PROD, exProd)
(* leszczyk#1.5 *)
	val nocodeEE = singleVE(Excon.ex_NOCODE, exNoCode)
(* end leszczyk#1.5 *)
        fun joinVE [] = emptyVE
	  | joinVE (VE :: rest) = VE_plus_VE(VE, joinVE rest)
    in
      val initialVE = joinVE [primVE, absVE, negVE, sumVE, diffVE, prodVE,
			      lessVE, greaterVE, lesseqVE, greatereqVE,
(* leszczyk#1.5 *)
			      absEE, negEE, sumEE, prodEE, nocodeEE]
(* end leszczyk#1.5 *)
    end
(* end leszczyk#1.4 *)

(* leszczyk#1.4
    fun EE_plus_EE(EXCONENV m1, EXCONENV m2) = EXCONENV(m1 plus m2)
 end leszczyk#1.4 & commented out *)

    fun domVE(VARENV m) = FinMap.dom m

    fun trimVE(VARENV m, f) = VARENV(FinMap.filter (fn (x, _) => f x) m)

    val mkEnv = ENV

(* leszczyk#1.4 *)
    val emptyE = ENV(emptySE, emptyVE)

    val initialE = ENV(emptySE, initialVE)

    fun VE_in_E VE = ENV(emptySE, VE)

    fun VE_of_E(ENV(_, VE)) = VE
(* end leszczyk#1.4 *)

(* leszczyk#1.4
    fun EE_in_E EE = ENV(emptySE, emptyVE, EE)

    fun EE_of_E(ENV(_, _, EE)) = EE

    fun domEE(EXCONENV m) = FinMap.dom m

    fun trimEE(EXCONENV m, f) = EXCONENV(FinMap.filter (fn (x, _) => f x) m)
 end leszczyk#1.4 & commented out *)

    val singleSE = STRENV o FinMap.singleton

    fun SE_plus_SE(STRENV m1, STRENV m2) = STRENV(m1 plus m2)

(* leszczyk#1.4 *)
    fun SE_in_E SE = ENV(SE, emptyVE)

    fun SE_of_E(ENV(SE, _)) = SE

    fun E_plus_SE(ENV(SE1, VE), SE2) =
      ENV(SE_plus_SE(SE1, SE2), VE)

    fun E_plus_E(ENV(SE1, VE1), ENV(SE2, VE2)) =
      ENV(SE_plus_SE(SE1, SE2), VE_plus_VE(VE1, VE2))
(* end leszczyk#1.4 *)

    fun domSE(STRENV m) = FinMap.dom m

    fun trimSE(STRENV m, f) = STRENV(FinMap.filter (fn (x, _) => f x) m)

    fun mapSE(STRENV m, f) = STRENV(FinMap.ComposeMap f m)

   (* Unfolding of recursive closures *)

    fun Rec(VE as VARENV m) =
      let
	fun unfold(CLOSUREval(CLOSURE(match, E', VE''))) =
	      CLOSUREval(CLOSURE(match, E', VE))

	  | unfold v = v
      in
	VARENV(FinMap.composemap unfold m)
      end

    (******** Lookup functions ********)

(* leszczyk#1.4 *)
    fun lookup_StrId(ENV(STRENV m, _), strid) =
      mustFind ("lookup_StrId", StrId.pr_StrId) (m, strid)

    fun lookup_Var(ENV(_, VARENV m), var) =
      mustFind ("lookup_Var", Var.pr_var o Var.mkVar)
               (m, (Var.unVar var))

    fun lookup_Excon(ENV(_, VARENV m), excon) =
      mustFind ("lookup_Excon", Excon.pr_excon o Excon.mk_excon)
               (m, (Excon.un_excon excon))


   (* Generic function to traverse a path of strid's in a qualified ID. *)

    local
      fun pathLookup(E, (strids, id: 'a), f: Env * 'a -> 'b): 'b =
	case strids
	  of nil => f(E, id)

	   | (this :: rest) =>
	       pathLookup(lookup_StrId(E, this), (rest, id), f)
    in
      fun lookup_LongStrId(E, longstrid) =
	pathLookup(E, StrId.explode_longstrid longstrid, lookup_StrId)

      fun lookup_LongVar(E, longvar) =
	pathLookup(E, Var.decompose longvar, lookup_Var)

      fun lookup_LongExcon(E, longexcon) =
	pathLookup(E, Excon.decompose longexcon, lookup_Excon)
    end
(* end leszczyk#1.4 *)

   (* exception packets. *)

    datatype Pack = EXNAME0pack of ExName.ExName
		  | EXNAME1pack of ExName.ExName * Val

    exception EXCEPTION of Pack

   (* printing. *)

    val layoutLab = PP.layoutAtom Lab.pr_Lab
(* leszczyk#1.4 *)
    val layoutId = PP.layoutAtom Var.pr_var o Var.mkVar
(* end leszczyk#1.4 *)
    val layoutStrId = PP.layoutAtom StrId.pr_StrId
(* leszczyk#1.4
    val layoutExcon = PP.layoutAtom Excon.pr_excon
 end leszczyk#1.4 & commented out *)
    val layoutExName = PP.layoutAtom ExName.pr_ExName

    fun layoutVal(Sval sval) = PP.layoutAtom SpecialValue.pr_SVal sval
      | layoutVal(BASval bv) = PP.LEAF "fn"
      | layoutVal(CON0val c) = PP.layoutAtom Con.pr_con c

      | layoutVal(CON1val(c, v)) =
	  PP.NODE{start="", finish=")", indent=1,
		  children=[PP.layoutAtom Con.pr_con c, layoutVal v],
		  childsep=PP.LEFT "("
		 }

      | layoutVal(CLOSUREval _) = PP.LEAF "fn"

      | layoutVal(EXNAME0val exname) =
	  layoutExName exname

      | layoutVal(EXNAME1val(exname, v)) =
	  PP.NODE{start=ExName.pr_ExName exname ^ "(", finish=")", indent=3,
		  children=[layoutVal v], childsep=PP.NONE
		 }

     (* For records, we'll see if they look like tuples. Be careful of
        {1=x} records which are not treated this way. *)

      | layoutVal(RECORDval m) =
	  if SortedFinMap.matches (fn (i, lab) => Lab.is_LabN(lab, i+1)) m
	  then
	    case SortedFinMap.rangeSORTED m
	      of [x] =>
		   PP.NODE{start="{1=", finish="}",
			   indent=1, childsep=PP.NONE,
			   children=[layoutVal x]
			  }

	       | xs =>
		   PP.NODE{start="(", finish=")", indent=1,
			   childsep=PP.RIGHT ", ", children=map layoutVal xs
			  }
	  else
	    SortedFinMap.layoutMap {start="{", eq="=", sep=", ", finish="}"}
				   layoutLab layoutVal m

      | layoutVal(ADDRval addr) =
	  PP.NODE{start="(ref ", finish=")", indent=3, childsep=PP.NONE,
		  children=[layoutVal(Store.retrieve addr)]
		 }
(* leszczyk#1.5 *)
      | layoutVal(INCOMPLETEval) = PP.LEAF "Incomplete"
(* end leszczyk#1.5 *)

    local
      fun f (layoutL, layoutR) map =
	FinMap.layoutMap {start="{", eq=" -> ", sep=", ", finish="}"}
			 layoutL layoutR map
    in
      fun layoutStrEnv(STRENV strMap) = f (layoutStrId, layoutEnv) strMap

(* leszczyk#1.4 *)
      and layoutEnv(ENV(SE, VARENV varMap)) =
	PP.NODE{start="(ENV: ", finish=")", indent=3, childsep=PP.RIGHT "; ",
		children=[layoutStrEnv SE,
			  f (layoutId, layoutVal) varMap
			 ]
	       }
(* end leszczyk#1.4 *)
    end
  end;
