(* Dynamic values and enviroments - Definition v3 page 46 *)

(*
$File: Interpreter/CORE_DYNOBJECT.sml $
$Date: 1992/08/19 14:49:31 $
$Revision: 1.4 $
$Locker:  $
*)

(*$CORE_DYNOBJECT: STORE*)

signature CORE_DYNOBJECT =
  sig
    structure Con
      : sig
	  type longcon and strid
	  eqtype con
(* leszczyk#1.2 *)
	  type id
	  val mk_con : id -> con
(* end leszczyk#1.2 *)
(* leszczyk#1.6 *)
	  val un_con : con -> id
(* end leszczyk#1.6 *)
	  val con_FALSE: con
	  val con_TRUE: con
	  val con_NIL: con
	  val con_CONS: con
	  val con_REF: con
	  val decompose: longcon -> strid list * con
	end

    structure Lab
      : sig
	  eqtype lab
	  val mk_IntegerLab: int -> lab
	  val < : lab * lab -> bool
	end

    structure Var
      : sig
          type id and var and longvar and strid
	  val mkVar: id -> var
(* leszczyk#1.1 *)
	  val unVar: var -> id
	  val pr_var : var -> string
(* end leszczyk#1.1 *)
	  val decompose: longvar -> strid list * var
	end

    structure Excon
      : sig
(* leszczyk#1.4 *)
	  type id
(* end leszczyk#1.4 *)
	  type excon and longexcon
	  val pr_excon: excon -> string
(* leszczyk#1.3 *)
	  val mk_excon: id -> excon
(* end leszczyk#1.3 *)
(* leszczyk#1.4 *)
	  val un_excon: excon -> id
(* end leszczyk#1.4 *)
	end

    structure ExName
      : sig
	  eqtype ExName
	  val new: string -> ExName
	  val pr_ExName: ExName -> string
	end

    structure Grammar
      : sig
	  type match
	end

(* leszczyk#1.4 *)
    type id
(* end leszczyk#1.4 *)
    type strid
    type longstrid

   (* Special values (constants): *)

    type scon and SVal
    val mkSValSCon: scon -> SVal

   (* We choose to keep the environments abstract: *)

    type Env
    type StrEnv
    type VarEnv
(* leszczyk#1.4
    type ExConEnv
 end leszczyk#1.4 & commented out *)
    type Closure

   (* Values (now concrete): *)

    type BasVal
    type ('a, 'b) map

    structure Store: STORE

    datatype Val = Sval       of SVal
		 | BASval     of BasVal
		 | CON0val    of Con.con
		 | CON1val    of Con.con * Val
		 | RECORDval  of (Lab.lab, Val) map (* a SortedFinMap.map *)
		 | EXNAME0val of ExName.ExName
		 | EXNAME1val of ExName.ExName * Val
		 | CLOSUREval of Closure
		 | ADDRval    of Store.Address
(* leszczyk#1.5 *)
		 | INCOMPLETEval
(* end leszczyk#1.5 *)

    sharing type Val = Store.Val

   (* Shorthand: *)
    val unit: Val
    val pair: Val * Val -> Val
    val exAbs: Val
    val exNeg: Val
    val exSum: Val
    val exDiff: Val
    val exProd: Val


   (* Structure environments (for the modules tie-in). *)

(* leszczyk#1.2 *)
    val emptySE : StrEnv
(* end leszczyk#1.2 *)
    val singleSE: strid * Env -> StrEnv
    val SE_plus_SE: StrEnv * StrEnv -> StrEnv
    val SE_in_E: StrEnv -> Env
    val SE_of_E: Env -> StrEnv
    val domSE: StrEnv -> strid EqSet.Set
    val trimSE: StrEnv * (strid -> bool) -> StrEnv
    val mapSE: StrEnv * (strid * Env -> Env) -> StrEnv

   (* Variable environments *)

    val emptyVE: VarEnv
(* leszczyk#1.4 *)
    val singleVE: id * Val -> VarEnv
(* end leszczyk#1.4 *)
    val VE_plus_VE: VarEnv * VarEnv -> VarEnv
(* leszczyk#1.4 *)
    val domVE: VarEnv -> id EqSet.Set
    val trimVE: VarEnv * (id -> bool) -> VarEnv
(* end leszczyk#1.4 *)

   (* Exception environments *)
(* leszczyk#1.4
    val emptyEE: ExConEnv
    val singleEE: Excon.excon * ExName.ExName -> ExConEnv
    val EE_plus_EE: ExConEnv * ExConEnv -> ExConEnv
    val domEE: ExConEnv -> Excon.excon EqSet.Set
    val trimEE: ExConEnv * (Excon.excon -> bool) -> ExConEnv
 end leszczyk#1.4 commented out *)
   (* Environments *)

    val emptyE: Env
(* leszczyk#1.4 *)
    val mkEnv: StrEnv * VarEnv -> Env
(* end leszczyk#1.4 *)
					(* Needed in ModuleDynObject.Cut. *)
    val E_plus_E: Env * Env -> Env
    val VE_in_E: VarEnv -> Env
    val VE_of_E: Env -> VarEnv
(* leszczyk#1.4
    val EE_in_E: ExConEnv -> Env
    val EE_of_E: Env -> ExConEnv
 end leszczyk#1.4 commented out *)
    val E_plus_SE: Env * StrEnv -> Env

    val initialE: Env

   (* Closures *)

    val mkClosure: Grammar.match * Env * VarEnv -> Closure
    val unClosure: Closure -> Grammar.match * Env * VarEnv

   (* Other operations *)

    val Rec : VarEnv -> VarEnv	(* for the unfolding of recursive closures *)

   (* Lookup functions *)

    val lookup_Var: Env * Var.var -> Val	(* Needed for printing. *)
    val lookup_LongVar: Env * Var.longvar -> Val
(* leszczyk#1.4 *)
    val lookup_LongExcon: Env * Excon.longexcon -> Val
(* end leszczyk#1.4 *)
    val lookup_StrId: Env * strid -> Env
					(* used for interface building. *)
    val lookup_LongStrId: Env * longstrid -> Env

   (* Exception packets
      Includes a single exception to model all exceptions.
      Needs to be here, since APPLY can raise exceptions from
      the pervasives. *)

    datatype Pack = EXNAME0pack of ExName.ExName
		  | EXNAME1pack of ExName.ExName * Val

    exception EXCEPTION of Pack

   (* Printing *)

    type StringTree
    val layoutVal: Val -> StringTree
    val layoutStrEnv: StrEnv -> StringTree
    val layoutEnv: Env -> StringTree
  end;




