(* Information attached to parsetree before elaboration *)

(*
$File: Common/PreGrammarInfo.sml $
$Date: 1995/12/16 19:21:30 $
$Revision: 1.0 $
$Locker: mikon $
*)


(*$PreGrammarInfo:
	SOURCE_INFO DF_INFO CRASH PRETTYPRINT PRE_GRAMMAR_INFO
 *)

functor PreGrammarInfo
    ( structure SourceInfo: SOURCE_INFO
      structure DFInfo: DF_INFO
	  
      structure PP: PRETTYPRINT
      sharing type SourceInfo.StringTree = DFInfo.StringTree = PP.StringTree 
	  
      structure Crash: CRASH ) : PRE_GRAMMAR_INFO =
  
struct

    type SourceInfo      = SourceInfo.info
     and DFInfo          = DFInfo.info

    datatype PreElabGrammarInfo =
      PRE_ELAB_GRAMMAR_INFO of {sourceInfo: SourceInfo Option,
				dfInfo: DFInfo Option
			       }

    val emptyPreElabGrammarInfo =
      PRE_ELAB_GRAMMAR_INFO{sourceInfo=None, dfInfo=None}

    fun addPreElabSourceInfo (PRE_ELAB_GRAMMAR_INFO{sourceInfo=None, dfInfo}) i=
	  PRE_ELAB_GRAMMAR_INFO{sourceInfo=Some i, dfInfo=dfInfo}

      | addPreElabSourceInfo _ _ = Crash.impossible "addPreElabSourceInfo"


    fun addPreElabDFInfo (PRE_ELAB_GRAMMAR_INFO{sourceInfo, dfInfo=None}) i =
	  PRE_ELAB_GRAMMAR_INFO{sourceInfo=sourceInfo, dfInfo=Some i}

      | addPreElabDFInfo _ _ = Crash.impossible "addPreElabDFInfo"


    fun getPreElabSourceInfo(PRE_ELAB_GRAMMAR_INFO{sourceInfo=i, ...}) = i

    fun getPreElabDFInfo(PRE_ELAB_GRAMMAR_INFO{dfInfo=i, ...}) = i

    type StringTree = SourceInfo.StringTree
    val layoutSourceInfo = SourceInfo.layoutInfo
    val layoutDFInfo = DFInfo.layoutInfo

    fun perhaps layout (Some info) = layout info
      | perhaps _ None = PP.LEAF "NONE"

    fun layoutPreElabGrammarInfo(PRE_ELAB_GRAMMAR_INFO{sourceInfo, dfInfo}) =
      PP.NODE{start="PreElabGrammarInfo{",
	      finish="}",
	      indent=3,
	      children=[perhaps layoutSourceInfo sourceInfo,
			perhaps layoutDFInfo dfInfo
		       ],
	      childsep=PP.RIGHT "; "
	     }

end;
