(*
$File: Common/PPTopdecGrammar.sml $
$Date: 1992/04/07 14:56:51 $
$Revision: 1.9 $
$Locker: birkedal $
*)

(*$PPTopdecGrammar:
	TOPDEC_GRAMMAR STRID FUNID SIGID CON EXCON TYCON
	PRETTYPRINT PPDECGRAMMAR PPTOPDECGRAMMAR
 *)
functor PPTopdecGrammar(structure TopdecGrammar: TOPDEC_GRAMMAR

			structure StrId: STRID
			  sharing type StrId.strid = TopdecGrammar.strid
			      and type StrId.longstrid = TopdecGrammar.longstrid

			structure FunId: FUNID
			  sharing type FunId.funid = TopdecGrammar.funid

			structure SigId: SIGID
			  sharing type SigId.sigid = TopdecGrammar.sigid

			structure Id: sig type id ; val pr_id : id -> string end
			  sharing type TopdecGrammar.id = Id.id

		        structure Con: CON
			  sharing type TopdecGrammar.con = Con.con

			structure Excon: EXCON
			  sharing type TopdecGrammar.excon = Excon.excon

			structure TyCon: TYCON
			  sharing type TopdecGrammar.tycon = TyCon.tycon
			      and type TopdecGrammar.longtycon = TyCon.longtycon

			structure PP: PRETTYPRINT

			structure PPDecGrammar: PPDECGRAMMAR
			  sharing
			      type PPDecGrammar.G.dec = TopdecGrammar.dec
			  and type PPDecGrammar.G.ty = TopdecGrammar.ty
			  and type PPDecGrammar.G.tyvar = TopdecGrammar.tyvar
(* mju #1.6 *)
			  and type PPDecGrammar.G.exp = TopdecGrammar.exp
(* end mju #1.6 *)
			  and type PPDecGrammar.StringTree = PP.StringTree
		       ): PPTOPDECGRAMMAR =
  struct
    structure G = TopdecGrammar
    open G

    type StringTree = PP.StringTree
    val INDENT = 3			(* standard indentation level. *)

    fun makeList (f: 'a -> 'a Option) (x: 'a) =
      x :: (case f x
	      of Some y => makeList f y
	       | None => nil
	   )

    fun layoutStrexp strexp =
      case strexp
	of STRUCTstrexp(_, strdec) =>
	     PP.NODE{start="struct ", finish=" end", indent=INDENT,
		     children=[layoutStrdec strdec], childsep=PP.NONE
		    }

	 | LONGSTRIDstrexp(_, longstrid) =>
	     PP.layoutAtom StrId.pr_LongStrId longstrid

	 | APPstrexp(_, funid, strexp) =>
	     PP.NODE{start=FunId.pr_FunId funid ^ "(", finish=")",
		     indent=INDENT,
		     children=[layoutStrexp strexp], childsep=PP.NONE
		    }

	 | LETstrexp(_, strdec, strexp) =>
	     PP.NODE{start="let ", finish=" end", indent=INDENT,
		     children=[layoutStrdec strdec, layoutStrexp strexp],
		     childsep=PP.LEFT " in "
		    }

    and layoutStrdec strdec =
      case strdec
	of DECstrdec(_, dec) =>
	     PPDecGrammar.layoutDec dec

(* mju#1.3 *)
	 | AXIOMstrdec(_, ax) =>
	     PP.NODE{start="axiom ", finish="", indent=INDENT,
		     children=[layoutAx ax], childsep=PP.NONE
	   	    }
(* end mju#1.3 *)

	 | STRUCTUREstrdec(_, strbind) =>
	     PP.NODE{start="structure ", finish="", indent=INDENT,
		     children=[layoutStrbind strbind], childsep=PP.NONE
		    }

	 | LOCALstrdec(_, strdec, strdec') =>
	     PP.NODE{start="local ", finish=" end", indent=INDENT,
		     children=[layoutStrdec strdec, layoutStrdec strdec'],
		     childsep=PP.LEFT " in "
		    }

(* mju#1.3 *) 
	 | SEQstrdec(_, strdec, strdec') =>
	     PP.NODE{start="", finish="", indent=0,
		     children=[layoutStrdec strdec, layoutStrdec strdec'],
		     childsep=PP.RIGHT "; "
		    }

	 | EMPTYstrdec _ =>
	     PP.LEAF ""

    and layoutAx ax =
      let
	val axs = makeList (fn AXIOMax(_, _, opt) => opt) ax

	fun layout1(AXIOMax(_, axexp, _)) =
	  PP.NODE{start="", finish="", indent=0,
		  children=[layoutAxexp axexp], 
		  childsep=PP.NONE
		 }
      in
	PP.NODE{start="", finish="", indent=0,
		children=map layout1 axs,
		childsep=PP.LEFT " and "
	       }
      end

    and layoutAxexp axexp = 
      case axexp 
	of AXIOM_EXPaxexp(_, exp) =>
	     PPDecGrammar.layoutExp exp

    and layoutStrbind strbind =
      let
	val strbinds = makeList (fn STRBIND(_, _, opt) => opt) strbind

	fun layout1(STRBIND(_, sglstrbind, _)) =
	  PP.NODE{start="", finish="", indent=0,
		  children=[layoutSglstrbind sglstrbind],
		  childsep=PP.NONE
		 }
      in
	PP.NODE{start="", finish="", indent=0,
		children=map layout1 strbinds,
		childsep=PP.LEFT " and "
	       }
      end

    and layoutSglstrbind sglstrbind =
      case sglstrbind 
        of SINGLEsglstrbind(_, strid, psigexp, strexp) =>
	     let
	       val lhs = 
	         PP.NODE{start="", finish="", indent=0,
		         children=[PP.layoutAtom StrId.pr_StrId strid,
				   layoutPsigexp psigexp],
		         childsep=PP.LEFT " : "
		        }
	       val rhs = layoutStrexp strexp
	     in
	       PP.NODE{start="", finish="", indent=0,
		       children=[lhs, rhs],
		       childsep=PP.RIGHT " = "
	              }
	     end

	 | UNDEFsglstrbind(_, strid, psigexp) =>
	     let
	       val lhs = 
	         PP.NODE{start="", finish="", indent=0,
		         children=[PP.layoutAtom StrId.pr_StrId strid,
				   layoutPsigexp psigexp],
		         childsep=PP.LEFT " : "
		        }
	       val rhs = PP.LEAF "? "
	     in
	       PP.NODE{start="", finish="", indent=0,
		       children=[lhs, rhs],
		       childsep=PP.RIGHT " = "
		      }
	     end

	 | UNGUARDsglstrbind(_, strid, strexp) =>
	     let
	       val lhs = PP.layoutAtom StrId.pr_StrId strid
	       val rhs = layoutStrexp strexp
	     in
	       PP.NODE{start="", finish="", indent=0,
		       children=[lhs, rhs],
		       childsep=PP.RIGHT " = "
		      }
	     end
(* end mju#1.3 *)

    and layoutSigexp sigexp =
      case sigexp
	of SIGsigexp(_, spec) =>
	     PP.NODE{start="sig ", finish=" end", indent=INDENT,
		     children=[layoutSpec spec], childsep=PP.NONE
		    }

	 | SIGIDsigexp(_, sigid) =>
	     PP.layoutAtom SigId.pr_SigId sigid

    and layoutPsigexp(PRINCIPpsigexp(_, sigexp)) = layoutSigexp sigexp

    and layoutSigdec sigdec =
      case sigdec
	of SIGNATUREsigdec(_, sigbind) =>
	     PP.NODE{start="signature ", finish="", indent=INDENT,
		     children=[layoutSigbind sigbind], childsep=PP.NONE
		    }
(* mju#1.3 *)
	 | SEQsigdec(_, sigdec, sigdec') =>
	     PP.NODE{start="", finish="", indent=0,
		     children=[layoutSigdec sigdec, layoutSigdec sigdec'],
		     childsep=PP.RIGHT "; "
		    }

	 | EMPTYsigdec _ => PP.LEAF ""

    and layoutSigbind sigbind =
      let
	val sigbinds = makeList (fn SIGBIND(_, _, _, opt) => opt) sigbind

	fun layout1(SIGBIND(_, sigid, psigexp, _)) =
	  PP.NODE{start="", finish="", indent=0,
		  children=[PP.layoutAtom SigId.pr_SigId sigid,
			    layoutPsigexp psigexp
			   ],
		  childsep=PP.RIGHT " = "
		 }
      in
	PP.NODE{start="", finish="", indent=0,
		children=map layout1 sigbinds,
		childsep=PP.LEFT " and "
	       }
      end
(* end mju#1.3 *)

    and layoutSpec spec =
      case spec
	of VALspec(_, valdesc) =>
	     PP.NODE{start="val ", finish="", indent=INDENT,
		     children=[layoutValdesc valdesc], childsep=PP.NONE
		    }

	 | TYPEspec(_, typdesc) =>
	     PP.NODE{start="type ", finish="", indent=INDENT,
		     children=[layoutTypdesc typdesc], childsep=PP.NONE
		    }

	 | EQTYPEspec(_, typdesc) =>
	     PP.NODE{start="eqtype ", finish="", indent=INDENT,
		     children=[layoutTypdesc typdesc], childsep=PP.NONE
		    }

	 | DATATYPEspec(_, datdesc) =>
	     PP.NODE{start="datatype ", finish="", indent=INDENT,
		     children=[layoutDatdesc datdesc], childsep=PP.NONE
		    }

	 | EXCEPTIONspec(_, exdesc) =>
	     PP.NODE{start="exception ", finish="", indent=INDENT,
		     children=[layoutExdesc exdesc], childsep=PP.NONE
		    }

(* mju#1.3 *)
	 | AXIOMspec(_, axdesc) =>
	     PP.NODE{start="axiom ", finish="", indent=INDENT,
		     children=[layoutAxdesc axdesc], childsep=PP.NONE
		    }
(* end mju#1.3 *)

	 | STRUCTUREspec(_, strdesc) =>
	     PP.NODE{start="structure ", finish="", indent=INDENT,
		     children=[layoutStrdesc strdesc], childsep=PP.NONE
		    }

	 | SHARINGspec(_, shareq) =>
	     PP.NODE{start="sharing ", finish="", indent=INDENT,
		     children=[layoutShareq shareq], childsep=PP.NONE
		    }

	 | LOCALspec(_, spec, spec') =>
	     PP.NODE{start="local ", finish=" end", indent=INDENT,
		     children=[layoutSpec spec, layoutSpec spec'],
		     childsep=PP.LEFT " in "
		    }

	 | OPENspec(_, list) =>
	     PP.NODE{start="open ", finish="", indent=5,
		     children=map (fn WITH_INFO(_, id) =>
				     PP.LEAF(StrId.pr_LongStrId id)
				  ) list,
		     childsep=PP.RIGHT " "
		    }

	 | INCLUDEspec(_, list) =>
	     PP.NODE{start="include ", finish="", indent=8,
		     children=map (fn WITH_INFO(_, id) =>
				     PP.LEAF(SigId.pr_SigId id)
				  ) list,
		     childsep=PP.RIGHT " "
		    }

(* mju#1.3 *)
	 | SEQspec(_, spec, spec') =>
	     PP.NODE{start="", finish="", indent=0,
		     children=[layoutSpec spec, layoutSpec spec'],
		     childsep=PP.RIGHT "; "
		    }

	 | EMPTYspec _ =>
	     PP.LEAF ""
(* end mju#1.3 *)
(* robmar#2 
         | AXIOM1spec(_, _) =>
	     PP.NODE{start="axiom", finish="", indent=0,
                     children=[],
                     childsep=PP.NONE
                    }
   commented out by mju#1.3 *)

    and layoutValdesc valdesc =
      let
	val valdescs = makeList (fn VALDESC(_, _, _, opt) => opt) valdesc

	fun layout1(VALDESC(_, id, ty, _)) =
	  PP.NODE{start="", finish="", indent=0,
		  children=[PP.layoutAtom Id.pr_id id,
			    PPDecGrammar.layoutTy ty
			   ],
		  childsep=PP.LEFT " : "
		 }
      in
	PP.NODE{start="", finish="", indent=0,
		children=map layout1 valdescs,
		childsep=PP.LEFT " and "
	       }
      end

    and layoutTypdesc typdesc =
      let
	val typdescs = makeList (fn TYPDESC(_, _, _, opt) => opt) typdesc

	fun layout1(TYPDESC(_, tyvarseq, tycon, _)) =
	  PP.NODE{start="", finish="", indent=0,
		  children=(case PPDecGrammar.layoutTyvarseq tyvarseq
			      of Some t => [t]
			       | None => nil
			   ) @ [PP.layoutAtom TyCon.pr_TyCon tycon],
		  childsep=PP.RIGHT " "
		 }
      in
	PP.NODE{start="", finish="", indent=0,
		children=map layout1 typdescs,
		childsep=PP.LEFT " and "
	       }
      end

    and layoutDatdesc datdesc =
      let
	val datdescs = makeList (fn DATDESC(_, _, _, _, opt) => opt) datdesc

	fun layoutCondesc condesc =
	  let
	    val condescs = makeList (fn CONDESC(_, _, _, opt) => opt) condesc

	    fun layout1(CONDESC(_, con, ty_opt, _)) =
	      PP.NODE{start="", finish="", indent=0,
		      children=
		        PP.layoutAtom Con.pr_con con
			:: (case ty_opt of Some ty => [PPDecGrammar.layoutTy ty]
			      		 | None => nil
			   ),
		      childsep=PP.LEFT " of "
		     }
	  in
	    PP.NODE{start="", finish="", indent=0,
		    children=map layout1 condescs,
		    childsep=PP.LEFT " | "
		   }
	  end

	fun layoutBind(tyvarseq, tycon) =
	  PP.NODE{start="", finish="", indent=0,
		  children=(case PPDecGrammar.layoutTyvarseq tyvarseq
			      of Some t => [t]
			       | None => nil
			   ) @ [PP.layoutAtom TyCon.pr_TyCon tycon],
		  childsep=PP.RIGHT " "
		 }

	fun layout1(DATDESC(_, tyvarseq, tycon, condesc, _)) =
	  PP.NODE{start="", finish="", indent=0,
		  children=[layoutBind(tyvarseq, tycon), layoutCondesc condesc],
		  childsep=PP.RIGHT " = "
		 }
      in
	PP.NODE{start="", finish="", indent=0,
		children=map layout1 datdescs,
		childsep=PP.LEFT " and "
	       }
      end

    and layoutExdesc exdesc =
      let
	val exdescs = makeList (fn EXDESC(_, _, _, opt) => opt) exdesc

	fun layout1(EXDESC(_, excon, ty_opt, _)) =
	  PP.NODE{start="", finish="", indent=0,
		  children=
		    PP.layoutAtom Excon.pr_excon excon
		    :: (case ty_opt of Some ty => [PPDecGrammar.layoutTy ty]
				     | None => nil
		       ),
		  childsep=PP.LEFT " of "
		 }
      in
	PP.NODE{start="", finish="", indent=0,
		children=map layout1 exdescs,
		childsep=PP.LEFT " and "
	       }
      end

(* mju#1.3 *)
    and layoutAxdesc axdesc =
      let
	val axdescs = makeList (fn AXDESC(_, _, opt) => opt) axdesc

	fun layout1(AXDESC(_, specexp, _)) =
	  PP.NODE{start="", finish="", indent=0,
		  children=[layoutSpecexp specexp], 
		  childsep=PP.NONE
		 }
      in
	PP.NODE{start="", finish="", indent=0,
		children=map layout1 axdescs,
		childsep=PP.LEFT " and "
	       }
      end

    and layoutSpecexp specexp =
      case specexp of 
	SPECEXP(_, strdec, axexp) =>
	  PP.NODE{start="let ", finish=" end", indent=INDENT,
		  children=[layoutStrdec strdec, layoutAxexp axexp],
		  childsep=PP.LEFT " in "
		 }
(* end mju#1.3 *)

    and layoutStrdesc strdesc =
      let
	val strdescs = makeList (fn STRDESC(_, _, _, opt) => opt) strdesc

	fun layout1(STRDESC(_, strid, sigexp, _)) =
	  PP.NODE{start="", finish="", indent=0,
		  children=[PP.layoutAtom StrId.pr_StrId strid,
			    layoutSigexp sigexp
			   ],
		  childsep=PP.LEFT " : "
		 }
      in
	PP.NODE{start="", finish="", indent=0,
		children=map layout1 strdescs,
		childsep=PP.LEFT " and "
	       }
      end

    and layoutShareq shareq =
      case shareq
	of STRUCTUREshareq(_, list) =>
	     PP.NODE{start="", finish="", indent=0,
		     children=map (fn WITH_INFO(_, id) =>
				        PP.LEAF(StrId.pr_LongStrId id)
				  ) list,
		     childsep=PP.LEFT " = "
		    }

	 | TYPEshareq(_, list) =>
	     PP.NODE{start="type ", finish="", indent=0,
		     children=map (fn WITH_INFO(_, id) =>
					PP.LEAF(TyCon.pr_LongTyCon id)
				  ) list,
		     childsep=PP.LEFT " = "
		    }

	 | ANDshareq(_, shareq, shareq') =>
	     PP.NODE{start="", finish="", indent=0,
		     children=[layoutShareq shareq, layoutShareq shareq'],
		     childsep=PP.LEFT " and "
		    }

    and layoutFundec fundec =
      case fundec
	of FUNCTORfundec(_, funbind) =>
	     PP.NODE{start="functor ", finish="", indent=INDENT,
		     children=[layoutFunbind funbind], childsep=PP.NONE
		    }

(* mju#1.3 *)
	 | SEQfundec(_, fundec, fundec') =>
	     PP.NODE{start="", finish="", indent=0,
		     children=[layoutFundec fundec, layoutFundec fundec'],
		     childsep=PP.RIGHT "; "
		    }

	 | EMPTYfundec _ => PP.LEAF ""

    and layoutFunbind funbind =
      let
	val funbinds =
	  makeList (fn FUNBINDfunbind(_, _, _, _, _, _, opt) => opt
		     | UNDEFfunbind(_, _, _, _, _, opt) => opt) funbind

	fun extractRelevant funbind =
	  case funbind
	    of FUNBINDfunbind(_, funid, strid, psigexp1, psigexp2, strexp, _) =>
		 (funid, strid, psigexp1, psigexp2, Some strexp)
	     | UNDEFfunbind(_, funid, strid, psigexp1, psigexp2, _) =>
		 (funid, strid, psigexp1, psigexp2, None)

	and layout1 funbind =
	  let
	    val (funid, strid, psigexp1, psigexp2, strexp_opt) = extractRelevant funbind
	  in
	    let
	      val dec =
	        PP.NODE{start=FunId.pr_FunId funid ^ "(", finish=")",
		        indent=INDENT,
		        children=[PP.layoutAtom StrId.pr_StrId strid,
				  layoutPsigexp psigexp1
			         ],
		        childsep=PP.LEFT " : "
		       }
	      val lhs = PP.NODE{start="", finish="", indent=0,
			        children=[dec, layoutPsigexp psigexp2],
			        childsep=PP.LEFT " : "
			       }
	    in
	      PP.NODE{start="", finish="", indent=0,
		      children=[lhs,
				case strexp_opt
				  of Some strexp => layoutStrexp strexp
				   | None => PP.LEAF "? "
			       ],
		      childsep=PP.RIGHT " = "
		     }
	    end
	  end

      in
	PP.NODE{start="", finish="", indent=0,
		children=map layout1 funbinds,
		childsep=PP.LEFT " and "
	       }
      end
(* end mju#1.3 *)

    fun layoutTopdec topdec =
      case topdec
	of STRtopdec(_, strdec) => layoutStrdec strdec
	 | SIGtopdec(_, sigdec) => layoutSigdec sigdec
	 | FUNtopdec(_, fundec) => layoutFundec fundec
  end;
