
(*$ObligTopdec:
	OBLIGTOPDEC DEC_GRAMMAR TOPDEC_GRAMMAR BASIS REPORT STRID SIGID FUNID
	PPTOPDECGRAMMAR PRETTYPRINT ObligationsEnv GRAMMAR_INFO
	SOURCE_INFO TYCON VAR CON EXCON RESIDENT
 *)

functor ObligTopdec(structure DecGrammar: DEC_GRAMMAR
                    structure TopdecGrammar: TOPDEC_GRAMMAR
                      sharing type TopdecGrammar.dec   = DecGrammar.dec
                          and type TopdecGrammar.ty    = DecGrammar.ty
                          and type TopdecGrammar.exp   = DecGrammar.exp
                          and type TopdecGrammar.tyvar = DecGrammar.tyvar
                          and type TopdecGrammar.longstrid
                                                       =
                                                        DecGrammar.longstrid
                          and type TopdecGrammar.longtycon
                                                       =
                                                        DecGrammar.longtycon
                          and type TopdecGrammar.WithInfo
                                                       =
                                                        DecGrammar.WithInfo
                    structure GrammarInfo: GRAMMAR_INFO
                      sharing type GrammarInfo.PostElabGrammarInfo
                                     = TopdecGrammar.info
                    structure StrId: STRID
                      sharing type StrId.longstrid = TopdecGrammar.longstrid
                          and type StrId.strid     = TopdecGrammar.strid
                    structure SigId: SIGID
                      sharing type SigId.sigid = TopdecGrammar.sigid
                    structure FunId: FUNID
                      sharing type FunId.funid = TopdecGrammar.funid
                    structure TyCon: TYCON
                      sharing type TyCon.longtycon = TopdecGrammar.longtycon
                          and type TyCon.strid     = StrId.strid
                    structure ResIdent: RESIDENT
                      sharing type ResIdent.longid = DecGrammar.longid
                    structure Var: VAR
                      sharing type Var.longvar = ResIdent.longvar
                          and type Var.strid = StrId.strid
                    structure Con: CON
                      sharing type Con.longcon = ResIdent.longcon
                          and type Con.strid = StrId.strid
                    structure Excon: EXCON
                      sharing type Excon.longexcon = ResIdent.longexcon
                          and type Excon.strid = StrId.strid
                    structure SourceInfo: SOURCE_INFO
                      sharing type SourceInfo.info = GrammarInfo.SourceInfo
                    structure FinMap: FINMAP
                   ): OBLIGTOPDEC  =
  struct
    type topdec = TopdecGrammar.topdec

    structure ObligationsEnv =
        ObligationsEnv (structure StrId = StrId
                        structure SigId = SigId
                        structure FunId = FunId
                        structure GrammarInfo = GrammarInfo
                        structure SourceInfo  = SourceInfo
                        structure FinMap = FinMap
                       )


    (* shorter names*)
    structure D = DecGrammar
    structure G = TopdecGrammar
    structure ObEnv = ObligationsEnv
    structure R = ResIdent

    fun isEmptyInfo i =
         case GrammarInfo.getPostElabSourceInfo i of
           None => true
         | Some (si) => false

(***************************************************************************)
(*topoblig_topdec***********************************************************)
(***************************************************************************)
    fun topoblig_topdec print (OE: ObEnv.ObligsEnv, topdec: topdec)
          : ObEnv.ObligsEnv * ObEnv.TopObligations =
      case topdec of
        G.STRtopdec(i, strdec) =>
        let
          val (SIE, OBLIGS) = topoblig_strdec (OE, strdec)
        in
          (ObEnv.OE_plus_SIE (OE, SIE), OBLIGS)
        end
      | G.SIGtopdec(i, sigdec) =>
        let
          val GIE = oblig_sigdec (OE, sigdec)
          val _ = ObEnv.output_SigInfoEnv print GIE
        in
          (ObEnv.OE_plus_GIE (OE, GIE), ObEnv.emptyTopObligs)
        end
      | G.FUNtopdec(i, fundec) =>
        let
          val (FIE, OBLIGS) = topoblig_fundec (OE, fundec)
        in
          (ObEnv.OE_plus_FIE (OE, FIE), OBLIGS)
        end

(*topoblig_strdec***********************************************************)
    and topoblig_strdec (OE: ObEnv.ObligsEnv, strdec: G.strdec): 
                                     ObEnv.StrInfoEnv * ObEnv.TopObligations=
      case strdec of
	G.DECstrdec(i, dec) =>
	let
	  val SIE = oblig_dec (OE, dec)
	in
	  (SIE, ObEnv.emptyTopObligs)
	end
	  
      | G.AXIOMstrdec(i, ax) =>
        (ObEnv.emptySIE, ObEnv.emptyTopObligs)

      | G.STRUCTUREstrdec(i, strbind) =>
        let
	  val (SIE, OBLIGS) = topoblig_strbind (OE, strbind)
	in
	  (SIE, OBLIGS)
	end

      | G.LOCALstrdec(i, strdec1, strdec2) =>
	let
	  val (SIE , obligs) = oblig_strdec (OE, strdec1)
	  val (SIE', OBLIGS) = 
                       topoblig_strdec (ObEnv.OE_plus_SIE (OE, SIE), strdec2)
	in
	  (SIE', ObEnv.additional_obligs (obligs, OBLIGS))
        end

      | G.EMPTYstrdec i =>
	(ObEnv.emptySIE, ObEnv.emptyTopObligs)

      | G.SEQstrdec(i, strdec1, strdec2) =>
	let
	  val (SIE , OBLIGS ) = topoblig_strdec (OE, strdec1)
	  val (SIE', OBLIGS') = 
	                 topoblig_strdec (ObEnv.OE_plus_SIE (OE, SIE), strdec2)
	in
	  (ObEnv.SIE_plus_SIE (SIE, SIE'), 
	   ObEnv.conc_topobligs (OBLIGS, OBLIGS'))
	end

(*topoblig_strbind**********************************************************)
    and topoblig_strbind (OE: ObEnv.ObligsEnv, strbind: G.strbind):
                             ObEnv.StrInfoEnv * ObEnv.TopObligations =
      case strbind of
        G.STRBIND(i, sglstrbind, strbind_opt) =>
	let
          val (SIE , OBLIGS ) = topoblig_sglstrbind (OE, sglstrbind)
	  val (SIE', OBLIGS') = 
	         case strbind_opt of
	           None => (ObEnv.emptySIE, ObEnv.emptyTopObligs)
	         | Some strbind => 
                         topoblig_strbind (ObEnv.OE_plus_SIE (OE, SIE), strbind)
        in
         (ObEnv.SIE_plus_SIE (SIE, SIE'), 
          ObEnv.conc_topobligs (OBLIGS, OBLIGS'))
	end


(*topoblig_sglstrbind*******************************************************)
    and topoblig_sglstrbind (OE: ObEnv.ObligsEnv, sglstrbind: G.sglstrbind):
                                 ObEnv.StrInfoEnv * ObEnv.TopObligations =
      case sglstrbind of 
        G.SINGLEsglstrbind(i, strid, psigexp, strexp) =>
        let
          val GB = oblig_psigexp (OE, psigexp)
          val (str_body, ext_str_SIE, str_SIE, str_obligs) =
                                                     oblig_strexp (OE, strexp)
          val wrapped_str_body = ObEnv.wrapped (str_body, ext_str_SIE)
          val (sig_body, ext_sig_SIE, sig_SIE) = ObEnv.unmkGB GB
          val wrapped_sig_body = ObEnv.wrapped (sig_body, ext_sig_SIE)
          val gen_obligs = ObEnv.generate_obligs (str_SIE, sig_SIE)
          val obligs = ObEnv.singleObligs (wrapped_str_body, wrapped_sig_body)
          val obligs = ObEnv.conc_obligs (obligs, gen_obligs)
          val obligs = ObEnv.conc_obligs (obligs, str_obligs)
          val SIE = ObEnv.singleSIE (strid, GB)
          val OBLIGS = ObEnv.singleTopObligs ("structure", 
                                              StrId.pr_StrId strid, 
                                              obligs)
        in
          (SIE, OBLIGS)
        end

      | G.UNDEFsglstrbind(i, strid, psigexp) =>
        let
          val GB = oblig_psigexp (OE, psigexp)
          val SIE = ObEnv.singleSIE (strid, GB)
          val OBLIGS = ObEnv.singleTopObligs ("structure", 
                                              StrId.pr_StrId strid, 
                                              ObEnv.emptyObligs)
        in
          (SIE, OBLIGS)
        end

      | G.UNGUARDsglstrbind(i, strid, strexp) =>
        let
          val (str_body, ext_str_SIE, str_SIE, str_obligs) =
                                                     oblig_strexp (OE, strexp)
          val GB = ObEnv.mkGB (str_body, ext_str_SIE, str_SIE)
          val SIE = ObEnv.singleSIE (strid, GB)
          val OBLIGS = ObEnv.singleTopObligs ("structure", 
                                              StrId.pr_StrId strid, 
                                              str_obligs)
        in
          (SIE, OBLIGS)
        end

(*topoblig_fundec***********************************************************)
    and topoblig_fundec (OE: ObEnv.ObligsEnv, fundec: G.fundec):
                                    ObEnv.FunInfoEnv * ObEnv.TopObligations =
      case fundec of
	G.FUNCTORfundec(i, funbind) =>
        let
          val (FIE, OBLIGS) = topoblig_funbind (OE, funbind)
        in
          (FIE, OBLIGS)
        end

      | G.EMPTYfundec i =>
	  (ObEnv.emptyFIE, ObEnv.emptyTopObligs)

      | G.SEQfundec(i, fundec1, fundec2) =>
	let
	  val (FIE , OBLIGS ) = topoblig_fundec (OE, fundec1)
	  val (FIE', OBLIGS') = 
	                topoblig_fundec (ObEnv.OE_plus_FIE (OE, FIE), fundec2)
	in
	  (ObEnv.FIE_plus_FIE (FIE, FIE'), 
	   ObEnv.conc_topobligs (OBLIGS, OBLIGS'))
	end

(*topoblig_funbind**********************************************************)
    and topoblig_funbind (OE: ObEnv.ObligsEnv, funbind: G.funbind):
                                    ObEnv.FunInfoEnv * ObEnv.TopObligations =
      case funbind of
	G.FUNBINDfunbind(i, funid, strid, psigexp, psigexp', strexp, funbind_opt) =>
         let
           val (psigexp', derived_form) = 
                 case psigexp' of
                   G.PRINCIPpsigexp (inf, G.SIGsigexp (_, G.LOCALspec(_, G.OPENspec (i', _), spec))) =>
                      (if isEmptyInfo i' then G.PRINCIPpsigexp (inf, G.SIGsigexp (inf, spec))
                       else psigexp', true)
                 | other => (psigexp', false)
           
           val strexp = case strexp of  (*see: (TopdecGramamr.sml#"FunBind:") and (GrammarUtils.sml#"convertFunctorBody")*)
                          G.LETstrexp(_, G.DECstrdec (i', _), strexp') =>
                              if isEmptyInfo i' then strexp'
                              else strexp
                        | other => strexp
           
           val spec = if derived_form then
                        let
                          val G.PRINCIPpsigexp (_, G.SIGsigexp (_, spec)) = psigexp
                        in
                          spec
                        end
                      else
                        let
                          val G.PRINCIPpsigexp (_, sigexp) = psigexp
                        in
                          G.STRUCTUREspec (i, G.STRDESC (i, strid, sigexp, None))
                        end

           val spec_SIE = oblig_spec (OE, spec)
           val GB = oblig_psigexp (ObEnv.OE_plus_SIE (OE, spec_SIE), psigexp')
           val (str_body, ext_str_SIE, str_SIE, str_obligs) =
                       oblig_strexp (ObEnv.OE_plus_SIE (OE, spec_SIE), strexp)
           val wrapped_str_body = ObEnv.wrapped (str_body, ext_str_SIE)
           val (sig_body, ext_sig_SIE, sig_SIE) = ObEnv.unmkGB GB
           val wrapped_sig_body = ObEnv.wrapped (sig_body, ext_sig_SIE)
           val gen_obligs = ObEnv.generate_obligs (str_SIE, sig_SIE)
           val obligs = ObEnv.singleObligs (wrapped_str_body, wrapped_sig_body)
           val obligs = ObEnv.conc_obligs (obligs, gen_obligs)
           val obligs = ObEnv.conc_obligs (obligs, str_obligs)
           val FIE = ObEnv.singleFIE (funid, spec_SIE, GB)
           val OBLIGS = ObEnv.singleTopObligs ("functor",
                                               FunId.pr_FunId funid,
                                               obligs)
           val (FIE', OBLIGS') = case funbind_opt of
                                   None => (ObEnv.emptyFIE, ObEnv.emptyTopObligs)
                                 | Some funbind => topoblig_funbind (OE, funbind)
         in
           (ObEnv.FIE_plus_FIE (FIE, FIE'), 
            ObEnv.conc_topobligs (OBLIGS, OBLIGS'))
	 end

      | G.UNDEFfunbind(i, funid, strid, psigexp, psigexp', funbind_opt) =>
         let
           val (psigexp', derived_form) = 
                 case psigexp' of
                   G.PRINCIPpsigexp (inf, G.SIGsigexp (_, G.LOCALspec(_, G.OPENspec (i', _), spec))) =>
                      (if isEmptyInfo i' then G.PRINCIPpsigexp (inf, G.SIGsigexp (inf, spec))
                       else psigexp', true)
                 | other => (psigexp', false)
           
           val spec = if derived_form then
                        let
                          val G.PRINCIPpsigexp (_, G.SIGsigexp (_, spec)) = psigexp
                        in
                          spec
                        end
                      else
                        let
                          val G.PRINCIPpsigexp (_, sigexp) = psigexp
                        in
                          G.STRUCTUREspec (i, G.STRDESC (i, strid, sigexp, None))
                        end

           val spec_SIE = oblig_spec (OE, spec)
           val GB = oblig_psigexp (ObEnv.OE_plus_SIE (OE, spec_SIE), psigexp')
           val FIE = ObEnv.singleFIE (funid, spec_SIE, GB)
           val OBLIGS = ObEnv.singleTopObligs ("functor",
                                               FunId.pr_FunId funid,
                                               ObEnv.emptyObligs)
           val (FIE', OBLIGS') = case funbind_opt of
                                   None => (ObEnv.emptyFIE, ObEnv.emptyTopObligs)
                                 | Some funbind => topoblig_funbind (OE, funbind)
         in
           (ObEnv.FIE_plus_FIE (FIE, FIE'), 
            ObEnv.conc_topobligs (OBLIGS, OBLIGS'))
	 end

(***************************************************************************)
(*oblig_topdec**************************************************************)
(***************************************************************************)

    and oblig_topdec (OE: ObEnv.ObligsEnv, topdec: topdec)
          : ObEnv.ObligsEnv * ObEnv.Obligations =
      case topdec of
        G.STRtopdec(i, strdec) =>
        let
          val (SIE, obligs) = oblig_strdec (OE, strdec)
        in
          (ObEnv.OE_plus_SIE (OE, SIE), obligs)
        end
      | G.SIGtopdec(i, sigdec) =>
        let
          val GIE = oblig_sigdec (OE, sigdec)
        in
          (ObEnv.OE_plus_GIE (OE, GIE), ObEnv.emptyObligs)
        end
      | G.FUNtopdec(i, fundec) =>
        let
          val (FIE, obligs) = oblig_fundec (OE, fundec)
        in
          (ObEnv.OE_plus_FIE (OE, FIE), obligs)
        end

(*oblig_sigdec**************************************************************)
    and oblig_sigdec (OE: ObEnv.ObligsEnv, sigdec: G.sigdec): 
                                            ObEnv.SigInfoEnv =
       case sigdec of
	G.SIGNATUREsigdec(i, sigbind) =>
	  oblig_sigbind (OE, sigbind)

      | G.EMPTYsigdec i =>
	  ObEnv.emptyGIE

      | G.SEQsigdec(i, sigdec1, sigdec2) =>
	  let
	    val GIE  = oblig_sigdec (OE, sigdec1)
	    val GIE' = oblig_sigdec (ObEnv.OE_plus_GIE (OE, GIE), sigdec2)
	  in
	    ObEnv.GIE_plus_GIE (GIE, GIE')
	  end

(*oblig_sigbind**************************************************************)
    and oblig_sigbind (OE: ObEnv.ObligsEnv, sigbind: G.sigbind): 
                                            ObEnv.SigInfoEnv =
      case sigbind of
	G.SIGBIND(i, sigid, psigexp, sigbind_opt) =>
         let
           val GB  = oblig_psigexp (OE, psigexp)
           val GIE = case sigbind_opt of
                       None => ObEnv.emptyGIE
                     | Some sigbind => oblig_sigbind (OE, sigbind)
         in
           ObEnv.GIE_plus_GIE (ObEnv.singleGIE (sigid, GB), GIE)
         end
	
(*oblig_psigexp**************************************************************)
    and oblig_psigexp (OE: ObEnv.ObligsEnv, psigexp: G.psigexp): 
                                         ObEnv.SigBody =
      let
        val G.PRINCIPpsigexp (i, sigexp) = psigexp
      in
        oblig_sigexp (OE, sigexp)
      end

(*oblig_sigexp***************************************************************)
    and oblig_sigexp (OE: ObEnv.ObligsEnv, sigexp: G.sigexp):
                                         ObEnv.SigBody =
       case sigexp of
	 G.SIGsigexp(i, spec) =>
	 let
	   val SIE = oblig_spec (OE, spec)
	   val ext_SIE = external_structures_sig (OE, spec)
         in
           ObEnv.mkGB (ObEnv.BodyOfSig (i), ext_SIE, SIE)
         end

       | G.SIGIDsigexp(i, sigid) =>
         let
           val SIE = ObEnv.SIE_of_OE (OE, ObEnv.SIG(sigid))
         in
           ObEnv.mkGB (ObEnv.BodyOfSigId (sigid), ObEnv.emptySIE, SIE)
         end

(*oblig_spec*****************************************************************)
    and oblig_spec (OE: ObEnv.ObligsEnv, spec: G.spec): 
                                           ObEnv.StrInfoEnv = 
      case spec of
        G.STRUCTUREspec (i, strdesc) =>
         let
           val SIE = oblig_strdesc (OE, strdesc)
         in
           SIE
         end
      | G.LOCALspec (i, spec1, spec2) =>
        let
          val SIE  = oblig_spec (OE, spec1)
          val SIE' = oblig_spec (ObEnv.OE_plus_SIE (OE, SIE), spec2)
        in
          SIE'
        end
      | G.INCLUDEspec(i, list) =>
	  let
            fun process ([]) = ObEnv.emptySIE
              | process (G.WITH_INFO(i, sigid) :: rest) =
                let
                  val SIE  = ObEnv.SIE_of_OE (OE, ObEnv.SIG(sigid))
                  val SIE' = process rest
                in
                  ObEnv.SIE_plus_SIE (SIE, SIE')
                end
	  in
	    process list
	  end
      | G.SEQspec (i, spec1, spec2) =>
        let
          val SIE  = oblig_spec (OE, spec1)
          val SIE' = oblig_spec (ObEnv.OE_plus_SIE (OE, SIE), spec2)
        in
          ObEnv.SIE_plus_SIE (SIE, SIE')
        end
      | other =>
          ObEnv.emptySIE

(*oblig_strdesc**************************************************************)
    and oblig_strdesc (OE: ObEnv.ObligsEnv, strdesc: G.strdesc): 
                                               ObEnv.StrInfoEnv =
      case strdesc of
        G.STRDESC (i, strid, sigexp, strdesc_opt) =>
        let
          val GB = oblig_sigexp (OE, sigexp)
          val SIE = case strdesc_opt of
                      None => ObEnv.emptySIE
                    | Some strdesc => oblig_strdesc (OE, strdesc)
        in
          ObEnv.SIE_plus_SIE (ObEnv.singleSIE (strid, GB), SIE)
        end


(*oblig_strexp***************************************************************)
    and oblig_strexp (OE: ObEnv.ObligsEnv, strexp: G.strexp):
       ObEnv.Body * ObEnv.StrInfoEnv * ObEnv.StrInfoEnv * ObEnv.Obligations =
      (* str_body,  ext_str_SIE,       str_SIE,           str_obligs *)
      case strexp of
	G.STRUCTstrexp(i, strdec) =>
        let
          val (str_SIE, str_obligs) = oblig_strdec (OE, strdec)
          val ext_str_SIE = 
             external_structures_str (ObEnv.OE_plus_SIE (OE, str_SIE), strdec)
          val str_body = ObEnv.BodyOfStruct (i)
        in
          (str_body, ext_str_SIE, str_SIE, str_obligs)
        end

      | G.LONGSTRIDstrexp(i, lstrid) =>
        let
          val (sig_body, ext_sig_SIE, sig_SIE) = 
                      ObEnv.unmkGB (ObEnv.Spec_of_OE (OE, ObEnv.LSTR(lstrid)))
        in
          (sig_body, ext_sig_SIE, sig_SIE, ObEnv.emptyObligs)
        end

      | G.APPstrexp(i, funid, strexp) =>
        let
          val (str_body, ext_str_SIE, str_SIE, str_obligs) = 
                                                     oblig_strexp (OE, strexp)
          val par_SIE = ObEnv.Param_of_OE (OE, funid)
          val gen_obligs = ObEnv.generate_obligs (str_SIE, par_SIE)
          val (sig_body, ext_sig_SIE, sig_SIE) = 
                        ObEnv.unmkGB (ObEnv.Spec_of_OE (OE, ObEnv.FUN(funid)))
          val cut_str_SIE = ObEnv.cut_domain (str_SIE, ObEnv.domSIE par_SIE)
          val obligs = ObEnv.conc_obligs (gen_obligs, str_obligs)
        in
          (sig_body, ObEnv.SIE_plus_SIE (ext_sig_SIE, cut_str_SIE), 
           sig_SIE, obligs)
        end

      | G.LETstrexp(i, strdec, strexp) =>
        raise ObEnv.OGEN_IMPOSSIBLE "LET in strexp!!! I do not generate proof obligations for this expression."

(*oblig_strdec**************************************************************)
    and oblig_strdec (OE: ObEnv.ObligsEnv, strdec: G.strdec): 
                                         ObEnv.StrInfoEnv * ObEnv.Obligations=
      case strdec of
	G.DECstrdec(i, dec) =>
	let
	  val SIE = oblig_dec (OE, dec)
	in
	  (SIE, ObEnv.emptyObligs)
	end
	  
      | G.AXIOMstrdec(i, ax) =>
        (ObEnv.emptySIE, ObEnv.emptyObligs)

      | G.STRUCTUREstrdec(i, strbind) =>
        let
	  val (SIE, obligs) = oblig_strbind (OE, strbind)
	in
	  (SIE, obligs)
	end

      | G.LOCALstrdec(i, strdec1, strdec2) =>
	let
	  val (SIE , obligs ) = oblig_strdec (OE, strdec1)
	  val (SIE', obligs') = 
                           oblig_strdec (ObEnv.OE_plus_SIE (OE, SIE), strdec2)
	in
	  (SIE', ObEnv.conc_obligs (obligs, obligs'))
        end

      | G.EMPTYstrdec i =>
	(ObEnv.emptySIE, ObEnv.emptyObligs)

      | G.SEQstrdec(i, strdec1, strdec2) =>
	let
	  val (SIE , obligs ) = oblig_strdec (OE, strdec1)
	  val (SIE', obligs') = 
	                 oblig_strdec (ObEnv.OE_plus_SIE (OE, SIE), strdec2)
	in
	  (ObEnv.SIE_plus_SIE (SIE, SIE'), ObEnv.conc_obligs (obligs, obligs'))
	end


(*oblig_dec******************************************************************)
    and oblig_dec (OE: ObEnv.ObligsEnv, dec: G.dec):
                                 ObEnv.StrInfoEnv =
      case dec of
        D.ABSTYPEdec(i, datb, dec) =>
        let
          val SIE = oblig_dec (OE, dec)
        in
          SIE
        end

      | D.LOCALdec(i, dec1, dec2) =>
        let
          val SIE  = oblig_dec (OE, dec1)
          val SIE' = oblig_dec (ObEnv.OE_plus_SIE (OE, SIE), dec2)
        in
          SIE'
        end
        
      | D.OPENdec(i, longstrid_WithInfo_list) =>
        let
          fun process ([]) = ObEnv.emptySIE
            | process (D.WITH_INFO(i, longstrid) :: rest) =
              let
                val SIE  = ObEnv.SIE_of_OE (OE, ObEnv.LSTR(longstrid))
                val SIE' = process (rest)
              in
                ObEnv.SIE_plus_SIE (SIE, SIE')
              end
        in
          process longstrid_WithInfo_list
        end

      | D.SEQdec(i, dec1, dec2) =>
        let
          val SIE  = oblig_dec (OE, dec1)
          val SIE' = oblig_dec (ObEnv.OE_plus_SIE (OE, SIE), dec2)
        in
          ObEnv.SIE_plus_SIE (SIE, SIE')
        end
        
      | others =>
        ObEnv.emptySIE


(*oblig_strbind**************************************************************)
    and oblig_strbind (OE: ObEnv.ObligsEnv, strbind: G.strbind):
                             ObEnv.StrInfoEnv * ObEnv.Obligations =
      case strbind of
        G.STRBIND(i, sglstrbind, strbind_opt) =>
	let
          val (SIE , obligs ) = oblig_sglstrbind (OE, sglstrbind)
	  val (SIE', obligs') = 
	         case strbind_opt of
	           None => (ObEnv.emptySIE, ObEnv.emptyObligs)
	         | Some strbind => 
                         oblig_strbind (ObEnv.OE_plus_SIE (OE, SIE), strbind)
        in
         (ObEnv.SIE_plus_SIE (SIE, SIE'), ObEnv.conc_obligs (obligs, obligs'))
	end


(*oblig_sglstrbind***********************************************************)
    and oblig_sglstrbind (OE: ObEnv.ObligsEnv, sglstrbind: G.sglstrbind):
                                 ObEnv.StrInfoEnv * ObEnv.Obligations =
      case sglstrbind of 
        G.SINGLEsglstrbind(i, strid, psigexp, strexp) =>
        let
          val GB = oblig_psigexp (OE, psigexp)
          val (str_body, ext_str_SIE, str_SIE, str_obligs) =
                                                     oblig_strexp (OE, strexp)
          val wrapped_str_body = ObEnv.wrapped (str_body, ext_str_SIE)
          val (sig_body, ext_sig_SIE, sig_SIE) = ObEnv.unmkGB GB
          val wrapped_sig_body = ObEnv.wrapped (sig_body, ext_sig_SIE)
          val gen_obligs = ObEnv.generate_obligs (str_SIE, sig_SIE)
          val obligs = ObEnv.singleObligs (wrapped_str_body, wrapped_sig_body)
          val obligs = ObEnv.conc_obligs (obligs, gen_obligs)
          val obligs = ObEnv.conc_obligs (obligs, str_obligs)
          val SIE = ObEnv.singleSIE (strid, GB)
        in
          (SIE, obligs)
        end

      | G.UNDEFsglstrbind(i, strid, psigexp) =>
        let
          val GB = oblig_psigexp (OE, psigexp)
          val SIE = ObEnv.singleSIE (strid, GB)
        in
          (SIE, ObEnv.emptyObligs)
        end

      | G.UNGUARDsglstrbind(i, strid, strexp) =>
        let
          val (str_body, ext_str_SIE, str_SIE, str_obligs) =
                                                     oblig_strexp (OE, strexp)
          val GB = ObEnv.mkGB (str_body, ext_str_SIE, str_SIE)
          val SIE = ObEnv.singleSIE (strid, GB)
        in
          (SIE, str_obligs)
        end

(*oblig_fundec***************************************************************)
    and oblig_fundec (OE: ObEnv.ObligsEnv, fundec: G.fundec):
                                       ObEnv.FunInfoEnv * ObEnv.Obligations =
      case fundec of
	G.FUNCTORfundec(i, funbind) =>
        let
          val (FIE, obligs) = oblig_funbind (OE, funbind)
        in
          (FIE, obligs)
        end

      | G.EMPTYfundec i =>
	  (ObEnv.emptyFIE, ObEnv.emptyObligs)

      | G.SEQfundec(i, fundec1, fundec2) =>
	let
	  val (FIE , obligs ) = oblig_fundec (OE, fundec1)
	  val (FIE', obligs') = 
	                   oblig_fundec (ObEnv.OE_plus_FIE (OE, FIE), fundec2)
	in
	  (ObEnv.FIE_plus_FIE (FIE, FIE'), ObEnv.conc_obligs (obligs, obligs'))
	end

(*oblig_funbind**************************************************************)
    and oblig_funbind (OE: ObEnv.ObligsEnv, funbind: G.funbind):
                                       ObEnv.FunInfoEnv * ObEnv.Obligations =
      case funbind of
	G.FUNBINDfunbind(i, funid, strid, psigexp, psigexp', strexp, funbind_opt) =>
         let
           val (psigexp', derived_form) = 
                 case psigexp' of
                   G.PRINCIPpsigexp (inf, G.SIGsigexp (_, G.LOCALspec(_, G.OPENspec (i', _), spec))) =>
                      (if isEmptyInfo i' then G.PRINCIPpsigexp (inf, G.SIGsigexp (inf, spec))
                       else psigexp', true)
                 | other => (psigexp', false)
           
           val strexp = case strexp of  (*see: (TopdecGramamr.sml#"FunBind:") and (GrammarUtils.sml#"convertFunctorBody")*)
                          G.LETstrexp(_, G.DECstrdec (i', _), strexp') =>
                              if isEmptyInfo i' then strexp'
                              else strexp
                        | other => strexp
           
           val spec = if derived_form then
                        let
                          val G.PRINCIPpsigexp (_, G.SIGsigexp (_, spec)) = psigexp
                        in
                          spec
                        end
                      else
                        let
                          val G.PRINCIPpsigexp (_, sigexp) = psigexp
                        in
                          G.STRUCTUREspec (i, G.STRDESC (i, strid, sigexp, None))
                        end

           val spec_SIE = oblig_spec (OE, spec)
           val GB = oblig_psigexp (ObEnv.OE_plus_SIE (OE, spec_SIE), psigexp')
           val (str_body, ext_str_SIE, str_SIE, str_obligs) =
                       oblig_strexp (ObEnv.OE_plus_SIE (OE, spec_SIE), strexp)
           val wrapped_str_body = ObEnv.wrapped (str_body, ext_str_SIE)
           val (sig_body, ext_sig_SIE, sig_SIE) = ObEnv.unmkGB GB
           val wrapped_sig_body = ObEnv.wrapped (sig_body, ext_sig_SIE)
           val gen_obligs = ObEnv.generate_obligs (str_SIE, sig_SIE)
           val obligs = ObEnv.singleObligs (wrapped_str_body, wrapped_sig_body)
           val obligs = ObEnv.conc_obligs (obligs, gen_obligs)
           val obligs = ObEnv.conc_obligs (obligs, str_obligs)
           val FIE = ObEnv.singleFIE (funid, spec_SIE, GB)
           val (FIE', obligs') = case funbind_opt of
                                   None => (ObEnv.emptyFIE, ObEnv.emptyObligs)
                                 | Some funbind => oblig_funbind (OE, funbind)
         in
           (ObEnv.FIE_plus_FIE (FIE, FIE'), ObEnv.conc_obligs (obligs, obligs'))
	 end

      | G.UNDEFfunbind(i, funid, strid, psigexp, psigexp', funbind_opt) =>
         let
           val (psigexp', derived_form) = 
                 case psigexp' of
                   G.PRINCIPpsigexp (inf, G.SIGsigexp (_, G.LOCALspec(_, G.OPENspec (i', _), spec))) =>
                      (if isEmptyInfo i' then G.PRINCIPpsigexp (inf, G.SIGsigexp (inf, spec))
                       else psigexp', true)
                 | other => (psigexp', false)
           
           val spec = if derived_form then
                        let
                          val G.PRINCIPpsigexp (_, G.SIGsigexp (_, spec)) = psigexp
                        in
                          spec
                        end
                      else
                        let
                          val G.PRINCIPpsigexp (_, sigexp) = psigexp
                        in
                          G.STRUCTUREspec (i, G.STRDESC (i, strid, sigexp, None))
                        end

           val spec_SIE = oblig_spec (OE, spec)
           val GB = oblig_psigexp (ObEnv.OE_plus_SIE (OE, spec_SIE), psigexp')
           val FIE = ObEnv.singleFIE (funid, spec_SIE, GB)
           val (FIE', obligs') = case funbind_opt of
                                   None => (ObEnv.emptyFIE, ObEnv.emptyObligs)
                                 | Some funbind => oblig_funbind (OE, funbind)
         in
           (ObEnv.FIE_plus_FIE (FIE, FIE'), obligs')
	 end

(***************************************************************************)
(*external_structures*******************************************************)
(***************************************************************************)

    and build_SIE (OE, []) = ObEnv.emptySIE
      | build_SIE (OE, [strid]) =
              ObEnv.singleSIE (strid, ObEnv.Spec_of_OE (OE, ObEnv.STR(strid)))
      | build_SIE (OE, strid::rest) =
                         ObEnv.SIE_plus_SIE (build_SIE (OE, [strid]),
                                             build_SIE (OE, rest))


    and get_strid (G.WITH_INFO (i, longstrid)) =
             let
               val (l, s) = StrId.explode_longstrid longstrid
             in
               hd (l @ [s])
             end

    and external_structures_sig (OE: ObEnv.ObligsEnv, spec: G.spec):
                                                           ObEnv.StrInfoEnv =
      let
        fun ext_spec (OE, G.SHARINGspec (i, shareq)) = ext_shareq (shareq)
          | ext_spec (OE, G.STRUCTUREspec (i, strdesc)) = ext_strdesc (strdesc)
(*          | ext_spec (OE, G.LOCALspec (i, spec, spec))*)
          | ext_spec (OE, G.INCLUDEspec (i, sigids)) =
              (List.foldL (get_sigids OE) EqSet.empty sigids, EqSet.empty)
          | ext_spec (OE, G.SEQspec (i, spec1, spec2)) =
             let
               val (d,  u)  = ext_spec (OE, spec1)
               val (d', u') = ext_spec (OE, spec2)
             in
               (EqSet.union d d', EqSet.union u u')
             end
          | ext_spec (_, _) = (EqSet.empty, EqSet.empty)

        and ext_shareq (G.STRUCTUREshareq (i, longstrids)) =
              (EqSet.empty, EqSet.fromList (map get_strid longstrids))
          | ext_shareq (G.TYPEshareq (i, longtycons)) =
              (EqSet.empty, List.foldL (get_strid') EqSet.empty longtycons)
          | ext_shareq (G.ANDshareq (i, shareq1, shareq2)) =
             let
               val (d,  u)  = ext_shareq (shareq1)
               val (d', u') = ext_shareq (shareq2)
             in
               (EqSet.union d d', EqSet.union u u')
             end
        
        and get_strid' (G.WITH_INFO (i, longtycon)) set =
             let
               val (l, ty) = TyCon.explode_LongTyCon longtycon
             in
               if l = [] then
                 set
               else
                 EqSet.insert (hd l) set
             end
             
        and get_sigids OE (G.WITH_INFO (i, sigid)) set =
             let
               val decl_set = ObEnv.domSIE (ObEnv.SIE_of_OE (OE, ObEnv.SIG sigid))
             in
               EqSet.union set decl_set
             end
             
        and ext_strdesc (G.STRDESC (i, strid, sigexp, strdesc_opt)) =
             let
               val (s, s') = case strdesc_opt of
                               None => (EqSet.empty, EqSet.empty)
                             | Some (strdesc) => ext_strdesc strdesc
             in
               (EqSet.union (EqSet.singleton strid) s, EqSet.empty)
             end

        val (dclrd, usd) = ext_spec (OE, spec)
        val exts = EqSet.difference usd dclrd
      in
        build_SIE (OE, EqSet.list exts)
      end


    and external_structures_str (OE: ObEnv.ObligsEnv, strdec: G.strdec):
                                                          ObEnv.StrInfoEnv =
      let
        fun decompose longid =
          let
            val strids =
                  case longid of
                    R.LONGVAR longvar => #1 (Var.decompose longvar)
                  | R.LONGCON longcon => #1 (Con.decompose longcon)
                  | R.LONGEXCON longexcon => #1 (Excon.decompose longexcon)
          in
            (strids, nil)
          end
      
        and ext_strdec strdec d =
          case strdec of
            G.DECstrdec (i, dec) => ext_dec dec d
          | G.AXIOMstrdec (i, ax) => ext_ax ax d
          | G.STRUCTUREstrdec (i, strbind) => ext_strbind strbind d
          | G.LOCALstrdec (i, strdec1, strdec2) =>
             let
               val (dd,  ext)  = ext_strdec strdec1 d
               val (dd', ext') = ext_strdec strdec2 dd
             in
               (dd', EqSet.union ext ext')
             end
          | G.SEQstrdec (i, strdec1, strdec2) =>
             let
               val (dd,  ext)  = ext_strdec strdec1 d
               val (dd', ext') = ext_strdec strdec2 dd
             in
               (dd', EqSet.union ext ext')
             end
          | others => (d, EqSet.empty)

        and ext_ax ax d =
          case ax of 
            G.AXIOMax (i, axexp, ax_opt) =>
            let
              val (dd , ext ) = ext_axexp axexp d
              val (dd', ext') = case ax_opt of
                                  None => (dd, EqSet.empty)
                                | Some ax => ext_ax ax dd
            in
              (dd', EqSet.union ext ext')
            end
        
        and ext_axexp axexp d =
          case axexp of
            G.AXIOM_EXPaxexp (i, exp) => ext_exp exp d

        and ext_strbind strbind d =
          case strbind of
            G.STRBIND (i, sglstrbind, strbind_opt) =>
             let
               val (dd , ext ) = ext_sglstrbind sglstrbind d
               val (dd', ext') = 
                              case strbind_opt of
                                None => (dd, EqSet.empty)
                              | Some (strbind) => ext_strbind strbind dd
             in
               (dd', EqSet.union ext ext')
             end
          | others => (d, EqSet.empty)

        and ext_sglstrbind sglstrbind d =
          case sglstrbind of
            G.SINGLEsglstrbind (i, strid, psigexp, strexp) =>
               let
                 val (dd, ext) = ext_strexp strexp d
               in
                 (EqSet.union dd (EqSet.singleton strid), ext)
               end
          | G.UNDEFsglstrbind (i, strid, psigexp) =>
               (EqSet.union d (EqSet.singleton strid), EqSet.empty)
          | G.UNGUARDsglstrbind (i, strid, strexp) =>
               let
                 val (dd, ext) = ext_strexp strexp d
               in
                 (EqSet.union dd (EqSet.singleton strid), ext)
               end

        and ext_strexp strexp d =
          case strexp of
            G.STRUCTstrexp (i, strdec) => ext_strdec strdec d
          | G.LONGSTRIDstrexp (i, lstrid) =>
             let
               val (strids, strid) = StrId.explode_longstrid lstrid
               val s = hd (strids@[strid])
               val s = if EqSet.member s d then 
                         EqSet.empty 
                       else 
                         EqSet.singleton s
             in
               (d, s)
             end
          | G.APPstrexp (i, funid, strexp) => ext_strexp strexp d
          | others => (d, EqSet.empty)

        and ext_dec dec d =
          case dec of
	    D.VALdec(i, valb) => ext_valbind valb d
          | D.TYPEdec(i, typb) => ext_typbind typb d
	  | D.DATATYPEdec(i, datb) => ext_datbind datb d
	  | D.ABSTYPEdec(i, datb, dec') => 
	     let
	       val (dd , ext ) = ext_datbind datb d
	       val (dd', ext') = ext_dec dec' dd
	     in
	       (dd', EqSet.union ext ext')
	     end
          | D.EQTYPEdec(i, typb) => ext_typbind typb d
	  | D.EXCEPTIONdec(i, exb) => ext_exbind exb d
	  | D.LOCALdec(i, dec', dec'') =>
		  let
		    val (dd , ext ) = ext_dec dec'  d
		    val (dd', ext') = ext_dec dec'' dd
		  in
		    (dd', EqSet.union ext ext')
		  end
          | D.OPENdec(i, longstrids) =>
              (d, EqSet.fromList (map get_strid longstrids))
	  | D.SEQdec(i, dec', dec'') =>
		  let
		    val (dd , ext ) = ext_dec dec'  d
		    val (dd', ext') = ext_dec dec'' dd
		  in
		    (dd', EqSet.union ext ext')
		  end
	  | others => (d, EqSet.empty)
	  
	and ext_atexp atexp d =
	  case atexp of
	    D.IDENTatexp (i, D.OP_OPT (longid, b)) =>
	      let
	        val (strids, id) = decompose longid
	      in
	        if strids = nil then
	          (d, EqSet.empty)
	        else
	          if EqSet.member (hd strids) d then
	            (d, EqSet.empty)
	          else
	            (d, EqSet.singleton (hd strids))
	      end
	  | D.RECORDatexp (i, exprow_opt) =>
	     (case exprow_opt of
	        None => (d, EqSet.empty)
	      | Some exprow => ext_exprow exprow d)
	  | D.LETatexp (i, dec, exp) =>
	      let
	        val (dd , ext ) = ext_dec dec d
	        val (dd', ext') = ext_exp exp dd
	      in
	        (dd', EqSet.union ext ext')
	      end
	  | D.PARatexp (i, exp) => ext_exp exp d
	  | others => (d, EqSet.empty)
	  
	and ext_exprow exprow d =
	  case exprow of
	    D.EXPROW (i, lab, exp, exprow_opt) =>
	      let
	        val (dd , ext ) = ext_exp exp d
	        val (dd', ext') = case exprow_opt of
	                            None => (dd, EqSet.empty)
	                          | Some exprow => ext_exprow exprow dd
	      in
	        (dd', EqSet.union ext ext')
	      end
	  | others => (d, EqSet.empty)

        and ext_exp exp d =
          case exp of
            D.ATEXPexp (i, atexp) => ext_atexp atexp d
          | D.APPexp (i, exp, atexp) => 
            let
              val (dd , ext ) = ext_exp exp d
              val (dd', ext') = ext_atexp atexp dd
            in
              (dd', EqSet.union ext ext')
            end
          | D.TYPEDexp (i, exp, ty) =>
            let
              val (dd , ext ) = ext_exp exp d
              val (dd', ext') = ext_ty ty dd
            in
              (dd', EqSet.union ext ext')
            end
          | D.COMPARexp (i, exp1, exp2) =>
            let
              val (dd , ext ) = ext_exp exp1 d
              val (dd', ext') = ext_exp exp2 dd
            in
              (dd', EqSet.union ext ext')
            end
          | D.EXIST_QUANTexp (i, match) => ext_match match d
          | D.UNIV_QUANTexp (i, match) => ext_match match d
          | D.CONVERexp (i, exp) => ext_exp exp d
          | D.HANDLEexp (i, exp, match) =>
            let
              val (dd , ext ) = ext_exp exp d
              val (dd', ext') = ext_match match dd
            in
              (dd', EqSet.union ext ext')
            end
          | D.RAISEexp (i, exp) => ext_exp exp d
          | D.FNexp (i, match) => ext_match match d
          | others => (d, EqSet.empty)
          
        and ext_match match d =
          case match of
            D.MATCH (i, mrule, match_opt) =>
            let
              val (dd , ext ) = ext_mrule mrule d
              val (dd', ext') = case match_opt of
                                  None => (dd, EqSet.empty)
                                | Some match => ext_match match dd
            in
              (dd', EqSet.union ext ext')
            end
          | others => (d, EqSet.empty)

        and ext_mrule mrule d =
          case mrule of
            D.MRULE (i, pat, exp) =>
            let
              val (dd , ext ) = ext_pat pat d
              val (dd', ext') = ext_exp exp dd
            in
              (dd', EqSet.union ext ext')
            end
          | others => (d, EqSet.empty)
          
        and ext_valbind valbind d =
          case valbind of
            D.PLAINvalbind (i, pat, exp, valb_opt) =>
            let
              val (dd  , ext  ) = ext_pat pat d
              val (dd' , ext' ) = ext_exp exp dd
              val (dd'', ext'') = case valb_opt of
                                    None => (dd', EqSet.empty)
                                  | Some valb => ext_valbind valb dd'
            in
              (dd'', EqSet.union (EqSet.union ext ext') ext'')
            end
          | D.RECvalbind (i, valbind) => ext_valbind valbind d
          
        and ext_typbind typb d =
          case typb of
            D.TYPBIND (i, _, _, ty, typb_opt) =>
            let
              val (dd , ext ) = ext_ty ty d
              val (dd', ext') = case typb_opt of
                                  None => (dd, EqSet.empty)
                                | Some typb => ext_typbind typb dd
            in
              (dd', EqSet.union ext ext')
            end
          | D.QUEST_TYPBIND (i, _, _, typb_opt) =>
            case typb_opt of
              None => (d, EqSet.empty)
            | Some typb => ext_typbind typb d

        and ext_datbind datb d =
          case datb of
            D.DATBIND (i, _, _, conb, datb_opt) =>
            let
              val (dd , ext ) = ext_conbind conb d
              val (dd', ext') = case datb_opt of
                                  None => (dd, EqSet.empty)
                                | Some datb => ext_datbind datb dd
            in
              (dd', EqSet.union ext ext')
            end

        and ext_conbind conb d =
          case conb of
            D.CONBIND (i, _, ty_opt, conb_opt) =>
            let
              val (dd , ext ) = case ty_opt of
                                  None => (d, EqSet.empty)
                                | Some ty => ext_ty ty d
              val (dd', ext') = case conb_opt of
                                  None => (dd, EqSet.empty)
                                | Some conb => ext_conbind conb dd
            in
              (dd', EqSet.union ext ext')
            end

        and ext_exbind exb d =
          case exb of
            D.EXBIND (i, _, ty_opt, exb_opt) =>
            let
              val (dd , ext ) = case ty_opt of
                                  None => (d, EqSet.empty)
                                | Some ty => ext_ty ty d
              val (dd', ext') = case exb_opt of
                                  None => (dd, EqSet.empty)
                                | Some exb => ext_exbind exb dd
            in
              (dd', EqSet.union ext ext')
            end
          | D.EXEQUAL (i, _, D.OP_OPT (longid, b), exb_opt) =>
            let
              val (dd , ext ) = case (decompose longid) of
                                  (nil, id) => (d, EqSet.empty)
                                | (ids, id) => if EqSet.member (hd ids) d then
                                                 (d, EqSet.empty)
                                               else
                                                 (d, EqSet.singleton (hd ids))
              val (dd', ext') = case exb_opt of
                                  None => (dd, EqSet.empty)
                                | Some exb => ext_exbind exb dd
            in
              (dd', EqSet.union ext ext')
            end

        and ext_atpat atpat d =
          case atpat of
            D.LONGIDatpat (i, D.OP_OPT (longid, b)) =>
              (case (decompose longid) of
                 (nil, _) => (d, EqSet.empty)
               | (ids, _) => if EqSet.member (hd ids) d then
                               (d, EqSet.empty)
                             else
                               (d, EqSet.singleton (hd ids)))
          | D.RECORDatpat (i, patrow_opt) => (case patrow_opt of
                                                None => (d, EqSet.empty)
                                              | Some patrow => ext_patrow patrow d)
          | D.PARatpat (i, pat) => ext_pat pat d
          | others => (d, EqSet.empty)

        and ext_patrow patrow d =
          case patrow of
            D.PATROW (i, _, pat, patrow_opt) =>
            let
              val (dd , ext ) = ext_pat pat d
              val (dd', ext') = case patrow_opt of
                                  None => (dd, EqSet.empty)
                                | Some patrow => ext_patrow patrow dd
            in
              (dd', EqSet.union ext ext')
            end
          | others => (d, EqSet.empty)
          
        and ext_pat pat d =
          case pat of
            D.ATPATpat (i, atpat) => ext_atpat atpat d
          | D.CONSpat (i, D.OP_OPT (longid, b), atpat) =>
            let
              val (dd , ext ) = case (decompose longid) of
                                  (nil, id) => (d, EqSet.empty)
                                | (ids, id) => if EqSet.member (hd ids) d then
                                                 (d, EqSet.empty)
                                               else
                                                 (d, EqSet.singleton (hd ids))
              val (dd', ext') = ext_atpat atpat dd
            in
              (dd', EqSet.union ext ext')
            end
          | D.TYPEDpat (i, pat, ty) =>
            let
              val (dd , ext ) = ext_pat pat d
              val (dd', ext') = ext_ty ty dd
            in
              (dd', EqSet.union ext ext')
            end
          | D.LAYEREDpat (i, _, ty_opt, pat) =>
            let
              val (dd , ext ) = case ty_opt of
                                  None => (d, EqSet.empty)
                                | Some ty => ext_ty ty d
              val (dd', ext') = ext_pat pat dd
            in
              (dd', EqSet.union ext ext')
            end
          | others => (d, EqSet.empty)
          
        and ext_ty ty d =
          case ty of
            D.RECORDty (i, tyrow_opt) => (case tyrow_opt of
                                            None => (d, EqSet.empty)
                                          | Some tyrow => ext_tyrow tyrow d)
          | D.CONty (i, tys, longtycon) =>
            let
              fun xxx ([], s) = s
                | xxx (ty::rest, (dd, ext)) =
                  let
                    val (dd', ext') = ext_ty ty dd
                  in
                    xxx (rest, (dd', EqSet.union ext ext'))
                  end
              val (dd , ext ) = xxx (tys, (d, EqSet.empty))
              val (dd', ext') = case (TyCon.explode_LongTyCon longtycon) of
                                  (nil, _) => (dd, EqSet.empty)
                                | (ids, _) => if EqSet.member (hd ids) dd then
                                                (dd, EqSet.empty)
                                              else
                                                (dd, EqSet.singleton (hd ids))
            in
              (dd', EqSet.union ext ext')
            end
          | D.FNty (i, ty1, ty2) =>
            let
              val (dd , ext ) = ext_ty ty1 d
              val (dd', ext') = ext_ty ty2 dd
            in
              (dd', EqSet.union ext ext')
            end
          | D.PARty (i, ty) => ext_ty ty d
          | others => (d, EqSet.empty)
          
        and ext_tyrow tyrow d =
          case tyrow of
            D.TYROW (i, _, ty, tyrow_opt) =>
            let
              val (dd , ext ) = ext_ty ty d
              val (dd', ext') = case tyrow_opt of
                                  None => (dd, EqSet.empty)
                                | Some tyrow => ext_tyrow tyrow dd
            in
              (dd', EqSet.union ext ext')
            end
                       


        val (dclrd, exts) = ext_strdec strdec EqSet.empty
      in
        build_SIE (OE, EqSet.list exts)
      end

end;
