(*
$File: Common/OBLIGATIONS_ENV.sml $
$Date: 1998/07/11 15:10:28 $
$Revision: 1.10 $
$Locker: arkady $
*)

(*$OBLIGATIONS_ENV*)
signature OBLIGATIONS_ENV =
  sig
    exception OGEN_IMPOSSIBLE of string

    type source_info
    type src_id

    type sigid
     and strid
     and longstrid
     and funid
    
    datatype ID = SIG of sigid | FUN of funid | STR of strid | LSTR of longstrid

    datatype Body = SIGBDY of src_id | SIGIDBDY of string | STRUCTBDY of src_id

    val BodyOfSig    : source_info -> Body
    val BodyOfSigId  : sigid  -> Body
    val BodyOfStruct : source_info -> Body

    type ObligsEnv
    val emptyOE: ObligsEnv
    val OE_plus_OE: ObligsEnv * ObligsEnv -> ObligsEnv

    type SigInfo
     and StrInfo
     and FunInfo

    type SigInfoEnv
     and StrInfoEnv
     and FunInfoEnv

    val OE_plus_GIE: ObligsEnv * SigInfoEnv -> ObligsEnv
    val OE_plus_SIE: ObligsEnv * StrInfoEnv -> ObligsEnv
    val OE_plus_FIE: ObligsEnv * FunInfoEnv -> ObligsEnv

    val lookup_sigid: ObligsEnv * sigid -> SigInfo
    val lookup_strid: ObligsEnv * strid -> StrInfo
    val lookup_funid: ObligsEnv * funid -> FunInfo
    val lookup_longstrid: ObligsEnv * longstrid -> StrInfo

    type SigBody
    val mkGB: Body * StrInfoEnv * StrInfoEnv -> SigBody
    val unmkGB: SigBody -> Body * StrInfoEnv * StrInfoEnv

    val domGIE       : SigInfoEnv -> sigid EqSet.Set
    and emptyGIE     : SigInfoEnv
    and singleGIE    : sigid * SigBody -> SigInfoEnv
    and GIE_plus_GIE : SigInfoEnv * SigInfoEnv -> SigInfoEnv

    val domSIE       : StrInfoEnv -> strid EqSet.Set
    and emptySIE     : StrInfoEnv
    and singleSIE    : strid * SigBody -> StrInfoEnv
    and SIE_plus_SIE : StrInfoEnv * StrInfoEnv -> StrInfoEnv
    and cut_domain   : StrInfoEnv * strid EqSet.Set -> StrInfoEnv

    val domFIE       : FunInfoEnv -> funid EqSet.Set
    and emptyFIE     : FunInfoEnv
    and singleFIE    : funid * StrInfoEnv * SigBody -> FunInfoEnv
    and FIE_plus_FIE : FunInfoEnv * FunInfoEnv -> FunInfoEnv

    val Spec_of_OE:  ObligsEnv * ID -> SigBody
    val Param_of_OE: ObligsEnv * funid -> StrInfoEnv
    val SIE_of_OE:   ObligsEnv * ID -> StrInfoEnv

    type wrapped_body
    val wrapped: Body * StrInfoEnv -> wrapped_body

    type Obligations
    val emptyObligs: Obligations
    val singleObligs: wrapped_body * wrapped_body -> Obligations
    val conc_obligs: Obligations * Obligations -> Obligations
    
    val generate_obligs: StrInfoEnv * StrInfoEnv -> Obligations

    type TopObligations
    val singleTopObligs: string * string * Obligations -> TopObligations
    val emptyTopObligs: TopObligations
    val conc_topobligs: TopObligations * TopObligations -> TopObligations
    val additional_obligs: Obligations * TopObligations -> TopObligations

    val output_TopObligations: (string -> unit) -> TopObligations -> unit
    val output_Obligations: (string -> unit) -> Obligations -> unit
    val output_SigInfoEnv: (string -> unit) -> SigInfoEnv -> unit

end;

