(* Information attached to parsetree *)

(*
$File: Common/GrammarInfo.sml $
$Date: 1995/12/16 19:25:34 $
$Revision: 1.20 $
$Locker: mikon $
*)

(*$GrammarInfo:
	ERROR_INFO TYPE_INFO OVERLOADING_INFO CRASH PRETTYPRINT PRE_GRAMMAR_INFO GRAMMAR_INFO TRACE
 *)

functor GrammarInfo
    ( structure ErrorInfo: ERROR_INFO
      structure TypeInfo: TYPE_INFO
      structure OverloadingInfo: OVERLOADING_INFO
      structure PreGrammarInfo: PRE_GRAMMAR_INFO
      structure Trace : TRACE
	  
      structure PP: PRETTYPRINT
      sharing type PreGrammarInfo.StringTree = TypeInfo.StringTree
	  = OverloadingInfo.StringTree = PP.StringTree 

      structure Crash: CRASH ) : GRAMMAR_INFO =

struct

    open PreGrammarInfo

    type ErrorInfo       = ErrorInfo.info
     and TypeInfo        = TypeInfo.info
     and OverloadingInfo = OverloadingInfo.info
   
    type Trace = Trace.Trace

    datatype PostElabGrammarInfo =
      POST_ELAB_GRAMMAR_INFO of {preElabGrammarInfo: PreElabGrammarInfo,
				 errorInfo: ErrorInfo Option,
				 typeInfo: TypeInfo Option,
				 overloadingInfo: OverloadingInfo Option,
                                 trace : Trace Option
				}

    fun convertGrammarInfo preElabGrammarInfo =
      POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo=preElabGrammarInfo,
			     errorInfo=None, typeInfo=None, overloadingInfo=None, trace=None
			    }

    val emptyPostElabGrammarInfo =
      convertGrammarInfo emptyPreElabGrammarInfo

    fun addPostElabErrorInfo (POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo,
						     errorInfo=None, typeInfo, overloadingInfo, trace
						    }) i =
	  POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo=preElabGrammarInfo,
				 errorInfo=Some i, typeInfo=typeInfo, 
                                 overloadingInfo=overloadingInfo, trace = trace
				}

      | addPostElabErrorInfo _ _ = Crash.impossible "addPostElabErrorInfo"

    fun addPostElabTypeInfo (POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo,
						    errorInfo, typeInfo=None, overloadingInfo, trace
						   }) i =
	  POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo=preElabGrammarInfo,
				 errorInfo=errorInfo, typeInfo=Some i, 
				 overloadingInfo=overloadingInfo, trace = trace
				}

      | addPostElabTypeInfo _ _ = Crash.impossible "addPostElabTypeInfo"

    fun addPostElabOverloadingInfo (POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo,
					 errorInfo, typeInfo, overloadingInfo, trace}) i =
          POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo=preElabGrammarInfo,
				 errorInfo=errorInfo, typeInfo=typeInfo, 
                                 overloadingInfo= Some i, trace=trace}

    fun addPostElabTrace (POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo,
						 errorInfo, typeInfo, overloadingInfo, trace}) t =
          POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo=preElabGrammarInfo,
				 errorInfo=errorInfo, typeInfo=typeInfo, 
                                 overloadingInfo=overloadingInfo, trace = Some t}

    fun getPostElabSourceInfo(POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo, ...}) =
      getPreElabSourceInfo preElabGrammarInfo

    fun getPostElabDFInfo(POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo, ...}) =
      getPreElabDFInfo preElabGrammarInfo

    fun getPostElabErrorInfo(POST_ELAB_GRAMMAR_INFO{errorInfo=i, ...}) = i

    fun getPostElabTypeInfo(POST_ELAB_GRAMMAR_INFO{typeInfo=i, ...}) = i

    fun getPostElabOverloadingInfo(POST_ELAB_GRAMMAR_INFO{overloadingInfo=i, ...}) = i

    fun getPostElabTrace(POST_ELAB_GRAMMAR_INFO{trace=t, ...}) = t

    fun removePostElabOverloadingInfo(POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo, 
			   errorInfo, typeInfo, overloadingInfo, trace}) : PostElabGrammarInfo =
      POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo = preElabGrammarInfo,
			     errorInfo = errorInfo,
			     overloadingInfo = None,
			     typeInfo = typeInfo,
			     trace = trace}

    val layoutErrorInfo = fn _ => PP.LEAF "<ErrorInfo>"
    val layoutTypeInfo = TypeInfo.layoutInfo
    val layoutOverloadingInfo = OverloadingInfo.layoutInfo

    fun perhaps layout (Some info) = layout info
      | perhaps _ None = PP.LEAF "NONE"

    fun layoutPostElabGrammarInfo(
	  POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo, errorInfo, typeInfo, overloadingInfo, trace}
	) =
      PP.NODE{start="PostElabGrammarInfo{",
	      finish="}",
	      indent=3,
	      children=[layoutPreElabGrammarInfo preElabGrammarInfo,
			perhaps layoutErrorInfo errorInfo,
			perhaps layoutTypeInfo typeInfo,
			perhaps layoutOverloadingInfo overloadingInfo
		       ],
	      childsep=PP.RIGHT "; "
	     }

end;
