(*
$File: Common/ErrorTraverse.sml $
$Date: 1992/04/07 14:55:32 $
$Revision: 1.3 $
$Locker: birkedal $
*)

(*$ErrorTraverse:
	TOPDEC_GRAMMAR DEC_GRAMMAR GRAMMAR_INFO SOURCE_INFO ERROR_INFO
	REPORT CRASH ERROR_TRAVERSE
*)

(* Topdec error traversal.
   NICK, 16/Jan/92. *)

functor ErrorTraverse(structure TopdecGrammar: TOPDEC_GRAMMAR

		      structure DecGrammar: DEC_GRAMMAR
			sharing type TopdecGrammar.dec = DecGrammar.dec
(* mikon#7 *)
                            and type TopdecGrammar.exp = DecGrammar.exp

			    and type TopdecGrammar.ty = DecGrammar.ty
			    and type TopdecGrammar.WithInfo
				     = DecGrammar.WithInfo

		      structure GrammarInfo: GRAMMAR_INFO
			sharing type TopdecGrammar.info
			 	     = DecGrammar.info
				     = GrammarInfo.PostElabGrammarInfo

		      structure SourceInfo: SOURCE_INFO
			sharing type SourceInfo.info = GrammarInfo.SourceInfo

		      structure ErrorInfo: ERROR_INFO
			sharing type ErrorInfo.info = GrammarInfo.ErrorInfo

		      structure Report: REPORT
			sharing type SourceInfo.Report
				     = ErrorInfo.Report
				     = Report.Report

		      structure Crash: CRASH
		     ): ERROR_TRAVERSE =
  struct
    open TopdecGrammar DecGrammar

   (* Simple-minded first attempt: walk over a topdec, accumulating any
      error nodes we encounter. *)

    val ok = Report.null
    infix //
    val op // = Report.//

   (* Yup, side-effect time; this is the best way to take note when an
      error has been spotted. *)

    local
      val b = ref false
    in
      fun spot() = (b := true)
      fun spotted() = !b
      fun reset() = (b := false)
    end

    fun check i =
      case GrammarInfo.getPostElabErrorInfo i
	of Some ei =>
	     (spot();
	      case GrammarInfo.getPostElabSourceInfo i
		of Some si =>
		     SourceInfo.report si
		     // ErrorInfo.reportInfo ei

		 | None =>
		     Report.line "(position unknown)"
		     // ErrorInfo.reportInfo ei
	     )

	 | None =>
	     Report.null

    fun walk_opt _ None = ok
      | walk_opt walk (Some obj) = walk obj

    fun walk_IdInfoList list =
      case list
	of nil => ok
	 | WITH_INFO(i, _) :: rest => check i // walk_IdInfoList rest


    fun walk_Topdec topdec =
      case topdec
	of STRtopdec(i, strdec) =>
	     check i // walk_Strdec strdec

	 | SIGtopdec(i, sigdec) =>
	     check i // walk_Sigdec sigdec

	 | FUNtopdec(i, fundec) =>
	     check i // walk_Fundec fundec

   (* MODULES: *)
    and walk_Strdec strdec =
      case strdec
	of DECstrdec(i, dec) =>
	     check i // walk_Dec dec

(* mju#1.4 *)
	 | AXIOMstrdec(i, ax) =>
	     check i // walk_Ax ax 
(* end mju#1.4 *)

	 | STRUCTUREstrdec(i, strbind) =>
	     check i // walk_Strbind strbind

	 | LOCALstrdec(i, strdec1, strdec2) =>
	     check i // walk_Strdec strdec1 // walk_Strdec strdec2

(* mju#1.4 *)
	 | SEQstrdec(i, strdec1, strdec2) =>
	     check i // walk_Strdec strdec1 // walk_Strdec strdec2

	 | EMPTYstrdec i =>
	     check i

    and walk_Ax ax =
      case ax
	of AXIOMax(i, axexp, ax_opt) =>
	     check i // walk_Axexp axexp // walk_opt walk_Ax ax_opt

    and walk_Axexp axexp =
      case axexp
	of AXIOM_EXPaxexp(i, exp) =>
	     check i // walk_Exp exp

    and walk_Strbind strbind =
      case strbind 
	of STRBIND(i, sglstrbind, strbind_opt) =>
	     check i // walk_Sglstrbind sglstrbind // walk_opt walk_Strbind strbind_opt

    and walk_Sglstrbind sglstrbind =
      case sglstrbind
	of SINGLEsglstrbind(i, _, psigexp, strexp) =>
	     check i // walk_Psigexp psigexp // walk_Strexp strexp

	 | UNDEFsglstrbind(i, _, psigexp) =>
	     check i // walk_Psigexp psigexp

	 | UNGUARDsglstrbind(i, _, strexp) =>
	     check i // walk_Strexp strexp
(* end mju#1.4 *)

    and walk_Sigexp sigexp =
      case sigexp
	of SIGsigexp(i, spec) =>
	     check i // walk_Spec spec

	 | SIGIDsigexp(i, _) =>
	     check i

(* mju#1.4 *)
    and walk_Psigexp psigexp =
      case psigexp
	of PRINCIPpsigexp(i, sigexp) =>
	     check i // walk_Sigexp sigexp 
(* end mju#1.4 *)

    and walk_Strexp strexp =
      case strexp
	of STRUCTstrexp(i, strdec) =>
	     check i // walk_Strdec strdec

	 | LONGSTRIDstrexp(i, _) =>
	     check i

	 | APPstrexp(i, _, strexp) =>
	     check i // walk_Strexp strexp

	 | LETstrexp(i, strdec, strexp) =>
	     check i // walk_Strdec strdec // walk_Strexp strexp

    and walk_Sigdec sigdec =
      case sigdec
	of SIGNATUREsigdec(i, sigbind) =>
	     check i // walk_Sigbind sigbind

(* mju#1.4 *)
	 | SEQsigdec(i, sigdec1, sigdec2) =>
	     check i // walk_Sigdec sigdec1 // walk_Sigdec sigdec2

	 | EMPTYsigdec i =>
	     check i

    and walk_Sigbind sigbind =
      case sigbind
	of SIGBIND(i, _, psigexp, sigbind_opt) =>
	     check i
	     // walk_Psigexp psigexp
	     // walk_opt walk_Sigbind sigbind_opt
(* end mju#1.4 *)

    and walk_Fundec fundec =
       case fundec
	 of FUNCTORfundec(i, funbind) =>
	      check i // walk_Funbind funbind

(* mju#1.4 *)
	  | SEQfundec(i, fundec1, fundec2) =>
	      check i // walk_Fundec fundec1 // walk_Fundec fundec2

	  | EMPTYfundec i =>
	      check i
(* end mju#1.4 *)

    and walk_Funbind funbind =
      case funbind
(* mju#1.4 *)
	of FUNBINDfunbind(i, _, _, psigexp1, psigexp2, strexp, funbind_opt) =>
	     check i
	     // walk_Psigexp psigexp1
	     // walk_Psigexp psigexp2
	     // walk_Strexp strexp
	     // walk_opt walk_Funbind funbind_opt
	 | UNDEFfunbind(i, _, _, psigexp1, psigexp2, funbind_opt) =>
	     check i
	     // walk_Psigexp psigexp1
	     // walk_Psigexp psigexp2
	     // walk_opt walk_Funbind funbind_opt
(* end mju#1.4 *)

    and walk_Spec spec =
      case spec
	of VALspec(i, valdesc) =>       check i // walk_Valdesc valdesc
	 | TYPEspec(i, typdesc) =>      check i // walk_Typdesc typdesc
	 | EQTYPEspec(i, typdesc) =>    check i // walk_Typdesc typdesc
	 | DATATYPEspec(i, datdesc) =>  check i // walk_Datdesc datdesc
	 | EXCEPTIONspec(i, exdesc) =>  check i // walk_Exdesc exdesc
(* mju#1.4 *)
	 | AXIOMspec(i, axdesc) => 	check i // walk_Axdesc axdesc
(* end mju#1.4 *)
	 | STRUCTUREspec(i, strdesc) => check i // walk_Strdesc strdesc
	 | SHARINGspec(i, shareq) =>    check i // walk_Shareq shareq

	 | LOCALspec(i, spec1, spec2) =>
	     check i // walk_Spec spec1 // walk_Spec spec2

	 | OPENspec(i, list) =>    check i // walk_IdInfoList list
	 | INCLUDEspec(i, list) => check i // walk_IdInfoList list
(* mju#1.4 *)
	 | SEQspec(i, spec1, spec2) =>
	     check i // walk_Spec spec1 // walk_Spec spec2
	 | EMPTYspec i =>       check i
(* end mju#1.4 *)
(* mikon#7 
         | AXIOM1spec(i, exp) => check i // walk_Exp exp
   commented out by mju#1.4 *)

    and walk_Valdesc valdesc =
      case valdesc
	of VALDESC(i, _, ty, valdesc_opt) =>
	     check i // walk_Ty ty // walk_opt walk_Valdesc valdesc_opt

    and walk_Typdesc typdesc =
      case typdesc
	of TYPDESC(i, _, _, typdesc_opt) =>
	  check i // walk_opt walk_Typdesc typdesc_opt

    and walk_Datdesc datdesc =
      case datdesc
	of DATDESC(i, _, _, condesc, datdesc_opt) =>
	     check i
	     // walk_Condesc condesc
	     // walk_opt walk_Datdesc datdesc_opt

    and walk_Condesc condesc =
      case condesc
	of CONDESC(i, _, ty_opt, condesc_opt) =>
	     check i
	     // walk_opt walk_Ty ty_opt
	     // walk_opt walk_Condesc condesc_opt

    and walk_Exdesc exdesc =
      case exdesc
	of EXDESC(i, _, ty_opt, exdesc_opt) =>
	     check i
	     // walk_opt walk_Ty ty_opt
	     // walk_opt walk_Exdesc exdesc_opt

(* mju#1.4 *)
    and walk_Axdesc axdesc =
      case axdesc 
	of AXDESC(i, specexp, axdesc_opt) =>
	     check i 
	     // walk_Specexp specexp
	     // walk_opt walk_Axdesc axdesc_opt

    and walk_Specexp specexp =
      case specexp 
	of SPECEXP(i, strdec, axexp) =>
	     check i // walk_Strdec strdec // walk_Axexp axexp
(* end mju#1.4 *)

    and walk_Strdesc strdesc =
      case strdesc
	of STRDESC(i, _, sigexp, strdesc_opt) =>
	     check i
	     // walk_Sigexp sigexp
	     // walk_opt walk_Strdesc strdesc_opt

    and walk_Shareq shareq =
      case shareq
	of STRUCTUREshareq(i, list) => check i // walk_IdInfoList list
	 | TYPEshareq(i, list) =>      check i // walk_IdInfoList list

	 | ANDshareq(i, shareq1, shareq2) =>
	     check i // walk_Shareq shareq1 // walk_Shareq shareq2

   (* CORE: *)
    and walk_Dec dec =
      case dec
	of VALdec(i, valbind) =>
	     check i // walk_Valbind valbind

	 | UNRES_FUNdec _ =>
	     Crash.impossible "ErrorTraverse.walk_Dec(UNRES_FUN)"

	 | TYPEdec(i, typbind) =>
	     check i // walk_Typbind typbind

	 | DATATYPEdec(i, datbind) =>
	     check i // walk_Datbind datbind

         | ABSTYPEdec(i, datbind, dec) =>
	     check i // walk_Datbind datbind // walk_Dec dec

(* mju#1.4 *)
	 | EQTYPEdec(i, typbind) =>
	     check i // walk_Typbind typbind
(* end mju#1.4 *)

	 | EXCEPTIONdec(i, exbind) =>
	     check i // walk_Exbind exbind

(* mikon#7
         | AXIOMdec(i, ax) =>
             check i // walk_Ax ax
   commented out by mju#1.4 *)

	 | LOCALdec(i, dec1, dec2) =>
	     check i // walk_Dec dec1 // walk_Dec dec2

         | OPENdec(i, list) =>
	     check i // walk_IdInfoList list

         | SEQdec(i, dec1, dec2) =>
	     check i // walk_Dec dec1 // walk_Dec dec2

	 | INFIXdec(i, _, _) =>  check i
	 | INFIXRdec(i, _, _) => check i
	 | NONFIXdec(i, _) =>    check i
	 | EMPTYdec i =>         check i

    and walk_Valbind valbind =
      case valbind
	of PLAINvalbind(i, pat, exp, valbind_opt) =>
	     check i
	     // walk_Pat pat
	     // walk_Exp exp
	     // walk_opt walk_Valbind valbind_opt

	 | RECvalbind(i, valbind) =>
	     check i // walk_Valbind valbind

    and walk_Typbind typbind =
      case typbind
	of TYPBIND(i, _, _, ty, typbind_opt) =>
	     check i // walk_Ty ty // walk_opt walk_Typbind typbind_opt

(* mju#1.4 *)
	 | QUEST_TYPBIND(i, _, _, typbind_opt) =>
	     check i // walk_opt walk_Typbind typbind_opt
(* end mju#1.4 *) 

    and walk_Datbind datbind =
      case datbind
	of DATBIND(i, _, _, conbind, datbind_opt) =>
	     check i
	     // walk_Conbind conbind
	     // walk_opt walk_Datbind datbind_opt

    and walk_Conbind conbind =
      case conbind
	of CONBIND(i, _, ty_opt, conbind_opt) =>
	     check i
	     // walk_opt walk_Ty ty_opt
	     // walk_opt walk_Conbind conbind_opt

    and walk_Exbind exbind =
      case exbind
	of EXBIND(i, _, ty_opt, exbind_opt) =>
	     check i
	     // walk_opt walk_Ty ty_opt
	     // walk_opt walk_Exbind exbind_opt

	 | EXEQUAL(i, _, _, exbind_opt) =>
	     check i // walk_opt walk_Exbind exbind_opt

(* mikon#7
    and walk_Ax (AX(i, exp)) =
      check i // walk_Exp exp 
   commented out by mju#1.4 *)

    and walk_Pat pat =
      case pat
	of ATPATpat(i, atpat) =>
	     check i // walk_Atpat atpat

	 | CONSpat(i, _, atpat) =>
	     check i // walk_Atpat atpat

	 | TYPEDpat(i, pat, ty) =>
	     check i // walk_Pat pat // walk_Ty ty

	 | LAYEREDpat(i, _, ty_opt, pat) =>
	     check i // walk_opt walk_Ty ty_opt // walk_Pat pat

	 | UNRES_INFIXpat _ =>
	     Crash.impossible "ErrorTraverse.walk_Pat(UNRES_INFIX)"

    and walk_Atpat atpat =
      case atpat
	of WILDCARDatpat i =>   check i
	 | SCONatpat(i, _) =>   check i
	 | LONGIDatpat(i, _) => check i

	 | RECORDatpat(i, patrow_opt) =>
	     check i // walk_opt walk_Patrow patrow_opt

	 | PARatpat(i, pat) =>
	     check i // walk_Pat pat

    and walk_Patrow patrow =
      case patrow
	of DOTDOTDOT i =>
	     check i

	 | PATROW(i, _, pat, patrow_opt) =>
	     check i // walk_Pat pat // walk_opt walk_Patrow patrow_opt

    and walk_Exp exp =
      case exp
	of ATEXPexp(i, atexp) =>
	     check i // walk_Atexp atexp

	 | APPexp(i, exp', atexp) =>
	     check i // walk_Exp exp' // walk_Atexp atexp

	 | TYPEDexp(i, exp', ty) =>
	     check i // walk_Exp exp' // walk_Ty ty

(* mju#1.4 *)
	 | COMPARexp(i, exp1, exp2) =>
	     check i // walk_Exp exp1 // walk_Exp exp2

	 | EXIST_QUANTexp(i, match) =>
	     check i // walk_Match match

	 | UNIV_QUANTexp(i, match) =>
	     check i // walk_Match match

	 | CONVERexp(i, exp') =>
	     check i // walk_Exp exp'
(* end mju#1.4 *) 

	 | HANDLEexp(i, exp', match) =>
	     check i // walk_Exp exp' // walk_Match match

	 | RAISEexp(i, exp') =>
	     check i // walk_Exp exp'

	 | FNexp(i, match) =>
	     check i // walk_Match match

	 | UNRES_INFIXexp _ =>
	     Crash.impossible "ErrorTraverse.walk_Exp(UNRES_INFIX)"

    and walk_Atexp atexp =
      case atexp
	of SCONatexp(i, _) =>  check i
	 | IDENTatexp(i, _) => check i

	 | RECORDatexp(i, exprow_opt) =>
	     check i // walk_opt walk_Exprow exprow_opt

	 | LETatexp(i, dec, exp) =>
	     check i // walk_Dec dec // walk_Exp exp

	 | PARatexp(i, exp) =>
	     check i // walk_Exp exp

(* mju#1.4 *)
	 | UNDEFatexp i =>
	     check i 
(* end mju#1.4 *)

    and walk_Exprow exprow =
      case exprow
	of EXPROW(i, _, exp, exprow_opt) =>
	     check i // walk_Exp exp // walk_opt walk_Exprow exprow_opt

    and walk_Match match =
      case match
	of MATCH(i, mrule, match_opt) =>
	     check i // walk_Mrule mrule // walk_opt walk_Match match_opt

    and walk_Mrule mrule =
      case mrule
	of MRULE(i, pat, exp) =>
	     check i // walk_Pat pat // walk_Exp exp

    and walk_Ty ty =
      case ty
	of TYVARty(i, _) =>
	     check i

	 | RECORDty(i, tyrow_opt) =>
	     check i // walk_opt walk_Tyrow tyrow_opt

	 | CONty(i, tys, _) =>
	     check i // List.foldR (fn a => fn b => walk_Ty a // b) ok tys

         | FNty(i, ty1, ty2) =>
	     check i // walk_Ty ty1 // walk_Ty ty2

	 | PARty(i, ty) =>
	     check i // walk_Ty ty

    and walk_Tyrow tyrow =
      case tyrow
	of TYROW(i, _, ty, tyrow_opt) =>
	     check i // walk_Ty ty // walk_opt walk_Tyrow tyrow_opt


    type Report = Report.Report

    datatype result = SUCCESS
      		    | FAILURE of Report

    fun traverse topdec =
      let
	val _ = reset()
	val report = walk_Topdec topdec
      in
	case spotted()
	  of true => FAILURE report
	   | false => SUCCESS
      end
  end;
