(* Error information *)

(*
$File: Common/ERROR_INFO.sml $
$Date: 1993/03/05 14:38:15 $
$Revision: 1.22 $
$Locker: birkedal $
*)

(*$ERROR_INFO*)

signature ERROR_INFO =
  sig
    type Type and TyName and TypeFcn
    eqtype id and lab and tycon and excon and con and TyVar
    type longid and longtycon 
    type sigid and strid and longstrid 
    eqtype funid
    

    datatype Tail = TYCON of tycon	(* Tail end for Covers errors. *)
      		  | STRID of strid

    datatype RepeatedId = ID_RID of id      (* Repeated identifier, syntax *)
			| LAB_RID of lab    (* errors *)
			| TYCON_RID of tycon
			| EXCON_RID of excon
			| CON_RID of con
			| TYVAR_RID of TyVar
			| STRID_RID of strid
			| SIGID_RID of sigid
			| FUNID_RID of funid

    datatype info =
     (* Core errors: *)
	UNIFICATION of Type * Type
      | LOOKUP_LONGID of longid
      | LOOKUP_LONGTYCON of longtycon
      | NOTCONSTYPE of Type
      | QUALIFIED_ID of longid
      | FREE_TYVARS of TyVar list
      | WRONG_ARITY of {expected: int, actual: int}
      | NOTRESOLVED
      | NOTIMPERATIVE of Type
      | FLEX_REC_NOT_RESOLVED 
      | REPEATED_IDS of RepeatedId list
      | TYVARS_NOT_IN_TYVARSEQ of TyVar list
(* mju#1.6 *)
      | SHOULD_ADMIT_EQ of TypeFcn list
      | LOCAL_TYNAMES
(* endmju#1.6 *)

     (* General module errors: *)
      | LOOKUP_SIGID of sigid
      | LOOKUP_LONGSTRID of longstrid
      | LOOKUP_FUNID of funid
      | ASSEMBLY_COVER of strid list * Tail
      | NOTTYPEEXPLICIT
      | NOTWELLFORMEDSIG
      | NOTEQPRINCIPAL of longtycon list
      | EXDESC_SIDECONDITION
(* mju#1.6 *)
      | AXEXP_SHOULD_BE_BOOL
      | UNGUARD_EXPLICIT_TV_IN_AXEXP
(* endmju#1.6 *)

     (* Signature matching errors: *)
      | S_RIGIDSTRCLASH of longstrid Option
      | MISSINGSTR  of longstrid
      | MISSINGTYPE of longtycon
      | S_CONFLICTINGARITY of longtycon * (TyName * TypeFcn)
      | CONFLICTINGEQUALITY of longtycon * (TyName * TypeFcn)
      | MISSINGVAR of strid list * id
      | MISSINGEXC of strid list * excon
      | S_RIGIDTYCLASH of longtycon
      | S_CONFLICTING_DOMCE of longtycon
      | NOTYENRICHMENT of strid list * id
      | EXCNOTEQUAL of strid list * excon * (Type * Type)

     (* Module unification errors: *)
      | U_RIGIDSTRCLASH of longstrid * longstrid
      | CYCLE of longstrid
      | U_RIGIDTYCLASH of longtycon * longtycon
      | TYPESTRILLFORMEDNESS of longtycon * longtycon
      | U_CONFLICTING_DOMCE of longtycon * longtycon
      | U_CONFLICTINGARITY of longtycon * longtycon
      | RIGIDTYFUNEQERROR of longtycon * longtycon

    type Report
    val reportInfo: info -> Report
  end;
